/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai.internal.client;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiFimCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModelResponse;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiModerationResponse;
import dev.langchain4j.model.mistralai.internal.client.DefaultMistralAiClient;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClientBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;

public abstract class MistralAiClient {
    public abstract MistralAiChatCompletionResponse chatCompletion(MistralAiChatCompletionRequest var1);

    public abstract void streamingChatCompletion(MistralAiChatCompletionRequest var1, StreamingResponseHandler<AiMessage> var2);

    public abstract MistralAiEmbeddingResponse embedding(MistralAiEmbeddingRequest var1);

    public abstract MistralAiModerationResponse moderation(MistralAiModerationRequest var1);

    public abstract MistralAiModelResponse listModels();

    public abstract MistralAiChatCompletionResponse fimCompletion(MistralAiFimCompletionRequest var1);

    public abstract void streamingFimCompletion(MistralAiFimCompletionRequest var1, StreamingResponseHandler<String> var2);

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(MistralAiClientBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            MistralAiClientBuilderFactory factory2 = (MistralAiClientBuilderFactory)iterator.next();
            return (Builder)factory2.get();
        }
        return DefaultMistralAiClient.builder();
    }

    public static abstract class Builder<T extends MistralAiClient, B extends Builder<T, B>> {
        public String baseUrl;
        public String apiKey;
        public Duration timeout;
        public Boolean logRequests;
        public Boolean logResponses;

        public abstract T build();

        public B baseUrl(String baseUrl) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("baseUrl cannot be null or empty");
            }
            this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
            return (B)this;
        }

        public B apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("MistralAI API Key must be defined. It can be generated here: https://console.mistral.ai/user/api-keys");
            }
            this.apiKey = apiKey;
            return (B)this;
        }

        public B timeout(Duration timeout2) {
            if (timeout2 == null) {
                throw new IllegalArgumentException("callTimeout cannot be null");
            }
            this.timeout = timeout2;
            return (B)this;
        }

        public B logRequests() {
            return this.logRequests(true);
        }

        public B logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses() {
            return this.logResponses(true);
        }

        public B logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return (B)this;
        }
    }
}

