/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.ideSettings;

import com.intellij.clouds.docker.gateway.DockerGatewayBundle;
import com.intellij.clouds.docker.gateway.utils.UtilsKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.settings.json.JsonSettingsModel;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0015*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0015\u0010\u001b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0015\u0010\u001e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0015\u0010\u001f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0015\u0010 \u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J#\u0010!\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u0018\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "MESSAGE_BOOL_VALUE_EXPECTED", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "MESSAGE_INT_VALUE_EXPECTED", "MESSAGE_STRING_VALUE_EXPECTED", "MESSAGE_STRING_LIST_EXPECTED", "MESSAGE_STRING_MAP_EXPECTED", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "findSettingsSection", "Lcom/intellij/json/psi/JsonProperty;", "file", "Lcom/intellij/psi/PsiFile;", "findProperty", "Lcom/intellij/psi/PsiElement;", "name", "validateValue", "literal", "Lcom/intellij/json/psi/JsonLiteral;", "validateBooleanValue", "validateIntegerValue", "validateStingValue", "validateEnumValue", "variants", "", "Lcom/intellij/ide/settings/json/JsonSettingsModel$VariantInfo;", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerIdeSettingsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerIdeSettingsInspection.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1#2:129\n1563#3:130\n1634#3,3:131\n*S KotlinDebug\n*F\n+ 1 DevcontainerIdeSettingsInspection.kt\ncom/intellij/clouds/docker/gateway/ideSettings/DevcontainerIdeSettingsInspection\n*L\n123#1:130\n123#1:131,3\n*E\n"})
public final class DevcontainerIdeSettingsInspection
extends LocalInspectionTool {
    @NotNull
    private final String MESSAGE_BOOL_VALUE_EXPECTED;
    @NotNull
    private final String MESSAGE_INT_VALUE_EXPECTED;
    @NotNull
    private final String MESSAGE_STRING_VALUE_EXPECTED;
    @NotNull
    private final String MESSAGE_STRING_LIST_EXPECTED;
    @NotNull
    private final String MESSAGE_STRING_MAP_EXPECTED;

    public DevcontainerIdeSettingsInspection() {
        String string = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.bool.value.expected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.MESSAGE_BOOL_VALUE_EXPECTED = string;
        String string2 = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.int.value.expected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.MESSAGE_INT_VALUE_EXPECTED = string2;
        String string3 = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.string.value.expected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.MESSAGE_STRING_VALUE_EXPECTED = string3;
        String string4 = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.string.list.expected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.MESSAGE_STRING_LIST_EXPECTED = string4;
        String string5 = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.string.map.expected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        this.MESSAGE_STRING_MAP_EXPECTED = string5;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (UtilsKt.isDevcontainerFile(psiFile)) {
            PsiFile psiFile2 = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
            JsonProperty settingsProperty = this.findSettingsSection(psiFile2);
            return (PsiElementVisitor)new JsonElementVisitor(holder, settingsProperty, this){
                final /* synthetic */ ProblemsHolder $holder;
                final /* synthetic */ JsonProperty $settingsProperty;
                final /* synthetic */ DevcontainerIdeSettingsInspection this$0;
                {
                    this.$holder = $holder;
                    this.$settingsProperty = $settingsProperty;
                    this.this$0 = $receiver;
                }

                public void visitStringLiteral(JsonStringLiteral sl) {
                    Intrinsics.checkNotNullParameter((Object)sl, (String)"sl");
                    if (DevcontainerIdeSettingsInspection.access$buildVisitor$isInSettings(this.$settingsProperty, (JsonLiteral)sl)) {
                        if (sl.isPropertyName()) {
                            if (!JsonSettingsModel.Companion.getInstance().getPropertyMap().containsKey(sl.getValue())) {
                                Object[] objectArray = new Object[]{sl.getValue()};
                                this.$holder.problem((PsiElement)sl, DockerGatewayBundle.message("devcontainer.inspection.message.unknown.setting", objectArray)).register();
                            }
                        } else {
                            DevcontainerIdeSettingsInspection.access$buildVisitor$checkAndRegisterProblem(this.this$0, this.$holder, (JsonLiteral)sl);
                        }
                    }
                }

                public void visitBooleanLiteral(JsonBooleanLiteral bl) {
                    Intrinsics.checkNotNullParameter((Object)bl, (String)"bl");
                    if (DevcontainerIdeSettingsInspection.access$buildVisitor$isInSettings(this.$settingsProperty, (JsonLiteral)bl)) {
                        DevcontainerIdeSettingsInspection.access$buildVisitor$checkAndRegisterProblem(this.this$0, this.$holder, (JsonLiteral)bl);
                    }
                }

                public void visitNumberLiteral(JsonNumberLiteral nl) {
                    Intrinsics.checkNotNullParameter((Object)nl, (String)"nl");
                    if (DevcontainerIdeSettingsInspection.access$buildVisitor$isInSettings(this.$settingsProperty, (JsonLiteral)nl)) {
                        DevcontainerIdeSettingsInspection.access$buildVisitor$checkAndRegisterProblem(this.this$0, this.$holder, (JsonLiteral)nl);
                    }
                }
            };
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
        return psiElementVisitor;
    }

    private final JsonProperty findSettingsSection(PsiFile file) {
        JsonProperty jsonProperty = this.findProperty((PsiElement)file, "customizations");
        return jsonProperty != null && (jsonProperty = this.findProperty((PsiElement)jsonProperty, "jetbrains")) != null ? this.findProperty((PsiElement)jsonProperty, "settings") : null;
    }

    private final JsonProperty findProperty(PsiElement $this$findProperty, String name) {
        PsiElement psiElement;
        block5: {
            PsiElement[] psiElementArray;
            Object object;
            int n;
            block4: {
                PsiElement[] psiElementArray2 = $this$findProperty.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                Object[] objectArray = psiElementArray2;
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = objectArray[i];
                    PsiElement it = (PsiElement)object2;
                    boolean bl = false;
                    if (!(it instanceof JsonObject)) continue;
                    object = object2;
                    break block4;
                }
                object = null;
            }
            if ((psiElementArray = (PsiElement[])object) != null && (psiElementArray = psiElementArray.getChildren()) != null) {
                PsiElement[] psiElementArray3 = psiElementArray;
                int n2 = psiElementArray3.length;
                for (n = 0; n < n2; ++n) {
                    PsiElement psiElement2;
                    PsiElement it = psiElement2 = psiElementArray3[n];
                    boolean bl = false;
                    JsonProperty jsonProperty = it instanceof JsonProperty ? (JsonProperty)it : null;
                    if (!Intrinsics.areEqual((Object)(jsonProperty != null ? jsonProperty.getName() : null), (Object)name)) continue;
                    psiElement = psiElement2;
                    break block5;
                }
                psiElement = null;
            } else {
                psiElement = null;
            }
        }
        PsiElement psiElement3 = psiElement;
        return psiElement3 instanceof JsonProperty ? (JsonProperty)psiElement3 : null;
    }

    private final String validateValue(JsonLiteral literal) {
        PsiElement psiElement = literal.getParent();
        JsonProperty jsonProperty = psiElement instanceof JsonProperty ? (JsonProperty)psiElement : null;
        if (jsonProperty != null) {
            JsonProperty property = jsonProperty;
            boolean bl = false;
            JsonSettingsModel.PropertyDescriptor propertyDescriptor = (JsonSettingsModel.PropertyDescriptor)JsonSettingsModel.Companion.getInstance().getPropertyMap().get(property.getName());
            if (propertyDescriptor != null) {
                JsonSettingsModel.PropertyDescriptor descriptor = propertyDescriptor;
                boolean bl2 = false;
                return switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getType().ordinal()]) {
                    case 1 -> this.validateBooleanValue(literal);
                    case 2 -> this.validateIntegerValue(literal);
                    case 3 -> this.validateStingValue(literal);
                    case 4 -> this.validateEnumValue(literal, descriptor.getVariants());
                    case 5 -> this.MESSAGE_STRING_LIST_EXPECTED;
                    case 6 -> this.MESSAGE_STRING_LIST_EXPECTED;
                    case 7 -> this.MESSAGE_STRING_MAP_EXPECTED;
                    case 8 -> "";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }
        return "";
    }

    private final String validateBooleanValue(JsonLiteral literal) {
        JsonLiteral jsonLiteral = literal;
        if (jsonLiteral instanceof JsonStringLiteral) {
            String it = ((JsonStringLiteral)literal).getValue();
            boolean bl = false;
            if (StringsKt.equals((String)it, (String)"true", (boolean)true) || StringsKt.equals((String)it, (String)"false", (boolean)true)) {
                return "";
            }
        } else if (jsonLiteral instanceof JsonBooleanLiteral) {
            return "";
        }
        return this.MESSAGE_BOOL_VALUE_EXPECTED;
    }

    private final String validateIntegerValue(JsonLiteral literal) {
        JsonLiteral jsonLiteral = literal;
        if (jsonLiteral instanceof JsonStringLiteral) {
            String it = ((JsonStringLiteral)literal).getValue();
            boolean bl = false;
            try {
                String string = ((JsonStringLiteral)literal).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                Integer.parseInt(string);
                return "";
            }
            catch (NumberFormatException nfe) {
                return this.MESSAGE_INT_VALUE_EXPECTED;
            }
        }
        if (jsonLiteral instanceof JsonNumberLiteral) {
            return "";
        }
        return this.MESSAGE_INT_VALUE_EXPECTED;
    }

    private final String validateStingValue(JsonLiteral literal) {
        return literal instanceof JsonStringLiteral ? "" : this.MESSAGE_STRING_VALUE_EXPECTED;
    }

    /*
     * WARNING - void declaration
     */
    private final String validateEnumValue(JsonLiteral literal, List<JsonSettingsModel.VariantInfo> variants) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = variants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonSettingsModel.VariantInfo variantInfo = (JsonSettingsModel.VariantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        List valueList = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (literal instanceof JsonStringLiteral && valueList.contains(((JsonStringLiteral)literal).getValue())) {
            return "";
        }
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)valueList, (CharSequence)", ", null, null, (int)0, null, DevcontainerIdeSettingsInspection::validateEnumValue$lambda$7, (int)30, null)};
        String string = DockerGatewayBundle.message("devcontainer.ide.settings.inspection.enum.value.expected", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final boolean buildVisitor$isInSettings(JsonProperty settingsProperty, JsonLiteral l) {
        PsiElement psiElement = l.getParent();
        return (psiElement != null && (psiElement = psiElement.getParent()) != null ? psiElement.getParent() : null) == settingsProperty;
    }

    private static final void buildVisitor$checkAndRegisterProblem(DevcontainerIdeSettingsInspection this$0, ProblemsHolder $holder, JsonLiteral l) {
        String message = this$0.validateValue(l);
        if (message != "") {
            $holder.problem((PsiElement)l, message).register();
        }
    }

    private static final CharSequence validateEnumValue$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    public static final /* synthetic */ boolean access$buildVisitor$isInSettings(JsonProperty settingsProperty, JsonLiteral l) {
        return DevcontainerIdeSettingsInspection.buildVisitor$isInSettings(settingsProperty, l);
    }

    public static final /* synthetic */ void access$buildVisitor$checkAndRegisterProblem(DevcontainerIdeSettingsInspection this$0, ProblemsHolder $holder, JsonLiteral l) {
        DevcontainerIdeSettingsInspection.buildVisitor$checkAndRegisterProblem(this$0, $holder, l);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonSettingsModel.PropertyType.values().length];
            try {
                nArray[JsonSettingsModel.PropertyType.Boolean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.String.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.Enum.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.StringList.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.StringSet.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.StringMap.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSettingsModel.PropertyType.Unsupported.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

