/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.DirectoryCoverageViewExtension;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.coverage.WipCoverageAnnotator;
import com.intellij.javascript.debugger.coverage.WipCoverageEnabledConfiguration;
import com.intellij.javascript.debugger.coverage.WipCoverageEngine;
import com.intellij.javascript.debugger.coverage.WipCoverageEngineKt;
import com.intellij.javascript.debugger.coverage.WipCoverageSuite;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ui.ColumnInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J:\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001dH\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\u001dH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0,2\u0006\u0010)\u001a\u00020\u001dH\u0016J(\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\u0006\u00102\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 H\u0016J\r\u00103\u001a\u00070\r\u00a2\u0006\u0002\b4H\u0016J\u0010\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020 H\u0016\u00a8\u0006;"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageEngine;", "Lcom/intellij/coverage/CoverageEngine;", "<init>", "()V", "isApplicableTo", "", "conf", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "createCoverageEnabledConfiguration", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "createCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "runner", "Lcom/intellij/coverage/CoverageRunner;", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timestamp", "", "config", "createEmptyCoverageSuite", "coverageRunner", "getCoverageAnnotator", "Lcom/intellij/coverage/CoverageAnnotator;", "coverageEditorHighlightingApplicableTo", "psiFile", "Lcom/intellij/psi/PsiFile;", "acceptedByFilters", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "recompileProjectAndRerunAction", "module", "Lcom/intellij/openapi/module/Module;", "chooseSuiteAction", "Ljava/lang/Runnable;", "getQualifiedName", "outputFile", "Ljava/io/File;", "sourceFile", "getQName", "getQualifiedNames", "", "includeUntouchedFileInCoverage", "qualifiedName", "collectSrcLinesForUntouchedFile", "", "", "classFile", "getPresentableText", "Lorg/jetbrains/annotations/Nls;", "coverageProjectViewStatisticsApplicableTo", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCoverageViewExtension", "Lcom/intellij/coverage/view/CoverageViewExtension;", "suiteBundle", "intellij.javascript.debugger"})
public final class WipCoverageEngine
extends CoverageEngine {
    public boolean isApplicableTo(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return conf instanceof JavaScriptDebugConfiguration;
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> conf) {
        Intrinsics.checkNotNullParameter(conf, (String)"conf");
        return new WipCoverageEnabledConfiguration(conf);
    }

    @NotNull
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        return (CoverageSuite)new WipCoverageSuite(name, project, runner, fileProvider, timestamp, this);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp, @NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config instanceof WipCoverageEnabledConfiguration) {
            return (CoverageSuite)new WipCoverageSuite(name, project, runner, fileProvider, timestamp, this);
        }
        return null;
    }

    @NotNull
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
        return (CoverageSuite)new WipCoverageSuite(this);
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (CoverageAnnotator)WipCoverageAnnotator.Companion.getInstance(project);
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof JSFile || psiFile instanceof XmlFile || psiFile instanceof StylesheetFile;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return true;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)chooseSuiteAction, (String)"chooseSuiteAction");
        return false;
    }

    @Nullable
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.getQName(sourceFile);
    }

    private final String getQName(PsiFile sourceFile) {
        VirtualFile virtualFile = sourceFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return file.getPath();
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        String qName;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        String string = qName = this.getQName(sourceFile);
        return string != null ? SetsKt.setOf((Object)string) : SetsKt.emptySet();
    }

    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return false;
    }

    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        return null;
    }

    @NotNull
    public String getPresentableText() {
        return "JavaScriptWipCoverage";
    }

    public boolean coverageProjectViewStatisticsApplicableTo(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return !fileOrDir.isDirectory();
    }

    @NotNull
    public CoverageViewExtension createCoverageViewExtension(@NotNull Project project, @NotNull CoverageSuitesBundle suiteBundle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suiteBundle, (String)"suiteBundle");
        CoverageAnnotator coverageAnnotator = this.getCoverageAnnotator(project);
        return (CoverageViewExtension)new DirectoryCoverageViewExtension(project, suiteBundle, coverageAnnotator){
            final /* synthetic */ Project $project;
            final /* synthetic */ CoverageSuitesBundle $suiteBundle;
            {
                this.$project = $project;
                this.$suiteBundle = $suiteBundle;
                super($project, $super_call_param$1, $suiteBundle);
            }

            public ColumnInfo<NodeDescriptor<?>, String>[] createColumnInfos() {
                PercentageCoverageColumnInfo percentage = new PercentageCoverageColumnInfo(1, JSDebuggerBundle.message("js.coverage.columns.covered", new Object[0]), this.mySuitesBundle);
                ColumnInfo[] columnInfoArray = JSDebuggerBundle.message("js.coverage.columns.file", new Object[0]);
                ColumnInfo<NodeDescriptor<?>, String> files2 = new ColumnInfo<NodeDescriptor<?>, String>((String)columnInfoArray){

                    public String valueOf(NodeDescriptor<?> item) {
                        return String.valueOf(item);
                    }

                    public Comparator<NodeDescriptor<?>> getComparator() {
                        AlphaComparator alphaComparator = AlphaComparator.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)alphaComparator, (String)"getInstance(...)");
                        return (Comparator)alphaComparator;
                    }
                };
                columnInfoArray = new ColumnInfo[]{files2, percentage};
                return columnInfoArray;
            }

            /*
             * WARNING - void declaration
             */
            public List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode<?> node) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(node, (String)"node");
                List list = super.getChildrenNodes(node);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenNodes(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    AbstractTreeNode child = (AbstractTreeNode)element$iv$iv;
                    boolean bl = false;
                    if (!(!StringUtil.equals((CharSequence)child.getName(), (CharSequence)".idea"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public AbstractTreeNode<?> createRootNode() {
                Object object = ReadAction.compute(() -> createCoverageViewExtension.1.createRootNode$lambda$1(this.$project, this.$suiteBundle, this));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                return (AbstractTreeNode)object;
            }

            private static final CoverageListRootNode createRootNode$lambda$1(Project $project, CoverageSuitesBundle $suiteBundle, createCoverageViewExtension.1 this$0) {
                VirtualFile rootDir = WipCoverageEngineKt.access$findRootDir($project, $suiteBundle);
                if (rootDir == null) {
                    rootDir = this$0.myProject.getBaseDir();
                }
                PsiManager psiManager = PsiManager.getInstance((Project)this$0.myProject);
                VirtualFile virtualFile = rootDir;
                Intrinsics.checkNotNull((Object)virtualFile);
                PsiDirectory psiRootDir = psiManager.findDirectory(virtualFile);
                Project project = this$0.myProject;
                PsiDirectory psiDirectory = psiRootDir;
                Intrinsics.checkNotNull((Object)psiDirectory);
                return new CoverageListRootNode(project, (PsiNamedElement)psiDirectory, this$0.mySuitesBundle);
            }
        };
    }
}

