from _typeshed import SupportsItems
from collections.abc import Callable, Iterable, Iterator
from typing import Any, Literal, NamedTuple, TypeVar, overload
from typing_extensions import Self, TypeAlias

_T = TypeVar("_T")
_ListOrTuple: TypeAlias = list[_T] | tuple[_T, ...]
_ParsedAccept: TypeAlias = tuple[str, float, list[tuple[str, str]], list[str | tuple[str, str]]]

class AcceptOffer(NamedTuple):
    type: str
    subtype: str
    params: tuple[tuple[str, str], ...]

class Accept:
    @classmethod
    def parse(cls, value: str) -> Iterator[_ParsedAccept]: ...
    @classmethod
    def parse_offer(cls, offer: str | AcceptOffer) -> AcceptOffer: ...

class AcceptValidHeader(Accept):
    @property
    def header_value(self) -> str: ...
    @property
    def parsed(self) -> list[_ParsedAccept] | None: ...
    def __init__(self, header_value: str) -> None: ...
    def copy(self) -> Self: ...
    @overload
    def __add__(self, other: str | None) -> Self: ...
    @overload
    def __add__(self, other: AcceptNoHeader | AcceptValidHeader | AcceptInvalidHeader) -> Self: ...
    @overload
    def __add__(self, other: SupportsItems[str, float | tuple[float, str]]) -> Self: ...
    @overload
    def __add__(self, other: _ListOrTuple[str | tuple[str, float, str] | list[Any]]) -> Self: ...
    def __bool__(self) -> Literal[True]: ...
    def __contains__(self, offer: str) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __radd__(self, other: str | None) -> Self: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float | tuple[float, str]]) -> Self: ...
    @overload
    def __radd__(self, other: _ListOrTuple[str | tuple[str, float, str] | list[Any]]) -> Self: ...
    def accept_html(self) -> bool: ...
    @property
    def accepts_html(self) -> bool: ...
    def acceptable_offers(self, offers: Iterable[str | AcceptOffer]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str | tuple[str, float] | list[Any]], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str | tuple[str, float] | list[Any]], default_match: str) -> str: ...
    def quality(self, offer: str) -> float | None: ...

class _AcceptInvalidOrNoHeader(Accept):
    @property
    def parsed(self) -> None: ...
    def copy(self) -> Self: ...
    @overload
    def __add__(self, other: None) -> AcceptNoHeader: ...
    @overload
    def __add__(self, other: str) -> AcceptValidHeader | AcceptNoHeader: ...
    @overload
    def __add__(self, other: AcceptValidHeader) -> AcceptValidHeader: ...
    @overload
    def __add__(self, other: AcceptNoHeader | AcceptInvalidHeader) -> AcceptNoHeader: ...
    @overload
    def __add__(self, other: SupportsItems[str, float | tuple[float, str]]) -> AcceptValidHeader | AcceptNoHeader: ...
    @overload
    def __add__(self, other: _ListOrTuple[str | tuple[str, float, str] | list[Any]]) -> AcceptValidHeader | AcceptNoHeader: ...
    @overload
    def __radd__(self, other: None) -> AcceptNoHeader: ...
    @overload
    def __radd__(self, other: str) -> AcceptValidHeader | AcceptNoHeader: ...
    @overload
    def __radd__(self, other: AcceptValidHeader) -> AcceptValidHeader: ...
    @overload
    def __radd__(self, other: AcceptNoHeader | AcceptInvalidHeader) -> AcceptNoHeader: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float | tuple[float, str]]) -> AcceptValidHeader | AcceptNoHeader: ...
    @overload
    def __radd__(self, other: _ListOrTuple[str | tuple[str, float, str] | list[Any]]) -> AcceptValidHeader | AcceptNoHeader: ...
    def __bool__(self) -> Literal[False]: ...
    def __contains__(self, offer: str) -> Literal[True]: ...
    def __iter__(self) -> Iterator[str]: ...
    def accept_html(self) -> bool: ...
    @property
    def accepts_html(self) -> bool: ...
    def acceptable_offers(self, offers: Iterable[str | AcceptOffer]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str | tuple[str, float] | list[Any]], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str | tuple[str, float] | list[Any]], default_match: str) -> str: ...
    def quality(self, offer: str) -> float: ...

class AcceptNoHeader(_AcceptInvalidOrNoHeader):
    @property
    def header_value(self) -> None: ...
    def __init__(self) -> None: ...

class AcceptInvalidHeader(_AcceptInvalidOrNoHeader):
    @property
    def header_value(self) -> str: ...
    def __init__(self, header_value: str) -> None: ...

@overload
def create_accept_header(header_value: None) -> AcceptNoHeader: ...
@overload
def create_accept_header(header_value: str) -> AcceptValidHeader | AcceptInvalidHeader: ...

class _AcceptProperty:
    @overload
    def __get__(self, obj: None, type: type | None = ..., /) -> property: ...
    @overload
    def __get__(self, obj: Any, type: type | None = ..., /) -> AcceptNoHeader | AcceptValidHeader | AcceptInvalidHeader: ...
    @overload
    def __set__(self, obj: Any, value: str | None, /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: AcceptNoHeader | AcceptValidHeader | AcceptInvalidHeader, /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: SupportsItems[str, float | tuple[float, str]], /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: _ListOrTuple[str | tuple[str, float, str] | list[Any]], /) -> None: ...
    def __delete__(self, obj: Any, /) -> None: ...

def accept_property() -> _AcceptProperty: ...

class AcceptCharset:
    @classmethod
    def parse(cls, value: str) -> Iterator[tuple[str, float]]: ...

class AcceptCharsetValidHeader(AcceptCharset):
    @property
    def header_value(self) -> str: ...
    @property
    def parsed(self) -> list[tuple[str, float]]: ...
    def __init__(self, header_value: str) -> None: ...
    def copy(self) -> Self: ...
    @overload
    def __add__(self, other: str | None) -> Self: ...
    @overload
    def __add__(self, other: AcceptCharsetValidHeader | AcceptCharsetNoHeader | AcceptCharsetInvalidHeader) -> Self: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __add__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def __bool__(self) -> Literal[True]: ...
    def __contains__(self, offer: str) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __radd__(self, other: str | None) -> Self: ...
    @overload
    def __radd__(self, other: AcceptCharsetValidHeader | AcceptCharsetNoHeader | AcceptCharsetInvalidHeader) -> Self: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __radd__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def acceptable_offers(self, offers: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    def quality(self, offer: str) -> float | None: ...

class _AcceptCharsetInvalidOrNoHeader(AcceptCharset):
    @property
    def parsed(self) -> None: ...
    def __bool__(self) -> Literal[False]: ...
    def __contains__(self, offer: str) -> Literal[True]: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __add__(self, other: None) -> AcceptCharsetNoHeader: ...
    @overload
    def __add__(self, other: str) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    @overload
    def __add__(self, other: AcceptCharsetValidHeader) -> AcceptCharsetValidHeader: ...
    @overload
    def __add__(self, other: AcceptCharsetNoHeader | AcceptCharsetInvalidHeader) -> AcceptCharsetNoHeader: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    @overload
    def __add__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    @overload
    def __radd__(self, other: None) -> AcceptCharsetNoHeader: ...
    @overload
    def __radd__(self, other: str) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    @overload
    def __radd__(self, other: AcceptCharsetValidHeader) -> AcceptCharsetValidHeader: ...
    @overload
    def __radd__(self, other: AcceptCharsetNoHeader | AcceptCharsetInvalidHeader) -> AcceptCharsetNoHeader: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    @overload
    def __radd__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptCharsetValidHeader | AcceptCharsetNoHeader: ...
    def copy(self) -> Self: ...
    def acceptable_offers(self, offers: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    def quality(self, offer: str) -> float | None: ...

class AcceptCharsetNoHeader(_AcceptCharsetInvalidOrNoHeader):
    @property
    def header_value(self) -> None: ...
    def __init__(self) -> None: ...

class AcceptCharsetInvalidHeader(_AcceptCharsetInvalidOrNoHeader):
    @property
    def header_value(self) -> str: ...
    def __init__(self, header_value: str) -> None: ...

@overload
def create_accept_charset_header(header_value: None) -> AcceptCharsetNoHeader: ...
@overload
def create_accept_charset_header(header_value: str) -> AcceptCharsetValidHeader | AcceptCharsetInvalidHeader: ...

class _AcceptCharsetProperty:
    @overload
    def __get__(self, obj: None, type: type | None = ..., /) -> property: ...
    @overload
    def __get__(
        self, obj: Any, type: type | None = ..., /
    ) -> AcceptCharsetNoHeader | AcceptCharsetValidHeader | AcceptCharsetInvalidHeader: ...
    @overload
    def __set__(self, obj: Any, value: str | None, /) -> None: ...
    @overload
    def __set__(
        self, obj: Any, value: AcceptCharsetNoHeader | AcceptCharsetValidHeader | AcceptCharsetInvalidHeader, /
    ) -> None: ...
    @overload
    def __set__(self, obj: Any, value: SupportsItems[str, float], /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: _ListOrTuple[str | tuple[str, float] | list[Any]], /) -> None: ...
    def __delete__(self, obj: Any, /) -> None: ...

def accept_charset_property() -> _AcceptCharsetProperty: ...

class AcceptEncoding:
    @classmethod
    def parse(cls, value: str) -> Iterator[tuple[str, float]]: ...

class AcceptEncodingValidHeader(AcceptEncoding):
    @property
    def header_value(self) -> str: ...
    @property
    def parsed(self) -> list[tuple[str, float]]: ...
    def __init__(self, header_value: str) -> None: ...
    def copy(self) -> Self: ...
    @overload
    def __add__(self, other: str | None) -> Self: ...
    @overload
    def __add__(self, other: AcceptEncodingValidHeader | AcceptEncodingNoHeader | AcceptEncodingInvalidHeader) -> Self: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __add__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def __bool__(self) -> Literal[True]: ...
    def __contains__(self, offer: str) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __radd__(self, other: str | None) -> Self: ...
    @overload
    def __radd__(self, other: AcceptEncodingValidHeader | AcceptEncodingNoHeader | AcceptEncodingInvalidHeader) -> Self: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __radd__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def acceptable_offers(self, offers: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    def quality(self, offer: str) -> float | None: ...

class _AcceptEncodingInvalidOrNoHeader(AcceptEncoding):
    @property
    def parsed(self) -> None: ...
    def __bool__(self) -> Literal[False]: ...
    def __contains__(self, offer: str) -> Literal[True]: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __add__(self, other: None) -> AcceptEncodingNoHeader: ...
    @overload
    def __add__(self, other: str) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    @overload
    def __add__(self, other: AcceptEncodingValidHeader) -> AcceptEncodingValidHeader: ...
    @overload
    def __add__(self, other: AcceptEncodingNoHeader | AcceptEncodingInvalidHeader) -> AcceptEncodingNoHeader: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    @overload
    def __add__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    @overload
    def __radd__(self, other: None) -> AcceptEncodingNoHeader: ...
    @overload
    def __radd__(self, other: str) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    @overload
    def __radd__(self, other: AcceptEncodingValidHeader) -> AcceptEncodingValidHeader: ...
    @overload
    def __radd__(self, other: AcceptEncodingNoHeader | AcceptEncodingInvalidHeader) -> AcceptEncodingNoHeader: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    @overload
    def __radd__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptEncodingValidHeader | AcceptEncodingNoHeader: ...
    def copy(self) -> Self: ...
    def acceptable_offers(self, offers: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    def quality(self, offer: str) -> float | None: ...

class AcceptEncodingNoHeader(_AcceptEncodingInvalidOrNoHeader):
    @property
    def header_value(self) -> None: ...
    def __init__(self) -> None: ...

class AcceptEncodingInvalidHeader(_AcceptEncodingInvalidOrNoHeader):
    @property
    def header_value(self) -> str: ...
    def __init__(self, header_value: str) -> None: ...

@overload
def create_accept_encoding_header(header_value: None) -> AcceptEncodingNoHeader: ...
@overload
def create_accept_encoding_header(header_value: str) -> AcceptEncodingValidHeader | AcceptEncodingInvalidHeader: ...

class _AcceptEncodingProperty:
    @overload
    def __get__(self, obj: None, type: type | None = ..., /) -> property: ...
    @overload
    def __get__(
        self, obj: Any, type: type | None = ..., /
    ) -> AcceptEncodingNoHeader | AcceptEncodingValidHeader | AcceptEncodingInvalidHeader: ...
    @overload
    def __set__(self, obj: Any, value: str | None, /) -> None: ...
    @overload
    def __set__(
        self, obj: Any, value: AcceptEncodingNoHeader | AcceptEncodingValidHeader | AcceptEncodingInvalidHeader, /
    ) -> None: ...
    @overload
    def __set__(self, obj: Any, value: SupportsItems[str, float], /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: _ListOrTuple[str | tuple[str, float] | list[Any]], /) -> None: ...
    def __delete__(self, obj: Any, /) -> None: ...

def accept_encoding_property() -> _AcceptEncodingProperty: ...

class AcceptLanguage:
    @classmethod
    def parse(cls, value: str) -> Iterator[tuple[str, float]]: ...

class AcceptLanguageValidHeader(AcceptLanguage):
    @property
    def header_value(self) -> str: ...
    @property
    def parsed(self) -> list[tuple[str, float]]: ...
    def __init__(self, header_value: str) -> None: ...
    def copy(self) -> Self: ...
    @overload
    def __add__(self, other: str | None) -> Self: ...
    @overload
    def __add__(self, other: AcceptLanguageValidHeader | AcceptLanguageNoHeader | AcceptLanguageInvalidHeader) -> Self: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __add__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def __bool__(self) -> Literal[True]: ...
    def __contains__(self, offer: str) -> bool: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __radd__(self, other: str | None) -> Self: ...
    @overload
    def __radd__(self, other: AcceptLanguageValidHeader | AcceptLanguageNoHeader | AcceptLanguageInvalidHeader) -> Self: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> Self: ...
    @overload
    def __radd__(self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]) -> Self: ...
    def basic_filtering(self, language_tags: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    @overload
    def lookup(
        self,
        language_tags: Iterable[str],
        default_range: str | None = None,
        default_tag: str = ...,
        default: str | Callable[[], str | None] | None = None,
    ) -> str | None: ...
    @overload
    def lookup(
        self,
        language_tags: Iterable[str],
        default_range: str | None = None,
        default_tag: str | None = None,
        default: str | Callable[[], str | None] = ...,
    ) -> str | None: ...
    def quality(self, offer: str) -> float | None: ...

class _AcceptLanguageInvalidOrNoHeader(AcceptLanguage):
    @property
    def parsed(self) -> None: ...
    def __bool__(self) -> Literal[False]: ...
    def __contains__(self, offer: str) -> Literal[True]: ...
    def __iter__(self) -> Iterator[str]: ...
    @overload
    def __add__(self, other: None) -> AcceptLanguageNoHeader: ...
    @overload
    def __add__(self, other: str) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    @overload
    def __add__(self, other: AcceptLanguageValidHeader) -> AcceptLanguageValidHeader: ...
    @overload
    def __add__(self, other: AcceptLanguageNoHeader | AcceptLanguageInvalidHeader) -> AcceptLanguageNoHeader: ...
    @overload
    def __add__(self, other: SupportsItems[str, float]) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    @overload
    def __add__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    @overload
    def __radd__(self, other: None) -> AcceptLanguageNoHeader: ...
    @overload
    def __radd__(self, other: str) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    @overload
    def __radd__(self, other: AcceptLanguageValidHeader) -> AcceptLanguageValidHeader: ...
    @overload
    def __radd__(self, other: AcceptLanguageNoHeader | AcceptLanguageInvalidHeader) -> AcceptLanguageNoHeader: ...
    @overload
    def __radd__(self, other: SupportsItems[str, float]) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    @overload
    def __radd__(
        self, other: _ListOrTuple[str | tuple[str, float] | list[Any]]
    ) -> AcceptLanguageValidHeader | AcceptLanguageNoHeader: ...
    def copy(self) -> Self: ...
    def basic_filtering(self, language_tags: Iterable[str]) -> list[tuple[str, float]]: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: None = None) -> str | None: ...
    @overload
    def best_match(self, offers: Iterable[str], default_match: str) -> str: ...
    @overload
    def lookup(
        self,
        language_tags: Iterable[str],
        default_range: str | None = None,
        default_tag: str = ...,
        default: str | Callable[[], str | None] | None = None,
    ) -> str | None: ...
    @overload
    def lookup(
        self,
        language_tags: Iterable[str],
        default_range: str | None = None,
        default_tag: str | None = None,
        default: str | Callable[[], str | None] = ...,
    ) -> str | None: ...
    def quality(self, offer: str) -> float | None: ...

class AcceptLanguageNoHeader(_AcceptLanguageInvalidOrNoHeader):
    def __init__(self) -> None: ...
    @property
    def header_value(self) -> None: ...

class AcceptLanguageInvalidHeader(_AcceptLanguageInvalidOrNoHeader):
    def __init__(self, header_value: str) -> None: ...
    @property
    def header_value(self) -> str: ...

@overload
def create_accept_language_header(header_value: None) -> AcceptLanguageNoHeader: ...
@overload
def create_accept_language_header(header_value: str) -> AcceptLanguageValidHeader | AcceptLanguageInvalidHeader: ...

class _AcceptLanguageProperty:
    @overload
    def __get__(self, obj: None, type: type | None = ..., /) -> property: ...
    @overload
    def __get__(
        self, obj: Any, type: type | None = ..., /
    ) -> AcceptLanguageNoHeader | AcceptLanguageValidHeader | AcceptLanguageInvalidHeader: ...
    @overload
    def __set__(self, obj: Any, value: str | None, /) -> None: ...
    @overload
    def __set__(
        self, obj: Any, value: AcceptLanguageNoHeader | AcceptLanguageValidHeader | AcceptLanguageInvalidHeader, /
    ) -> None: ...
    @overload
    def __set__(self, obj: Any, value: SupportsItems[str, float], /) -> None: ...
    @overload
    def __set__(self, obj: Any, value: _ListOrTuple[str | tuple[str, float] | list[Any]], /) -> None: ...
    def __delete__(self, obj: Any, /) -> None: ...

def accept_language_property() -> _AcceptLanguageProperty: ...
