var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { Parser as AsyncapiParser, fromURL, } from '@asyncapi/parser';
import { OpenAPISchemaParser } from '@asyncapi/openapi-schema-parser';
import { ProtoBuffSchemaParser } from '@asyncapi/protobuf-schema-parser';
import { AvroSchemaParser } from '@asyncapi/avro-schema-parser';
import { VALIDATION_ERRORS_TYPE } from '../constants';
var asyncapiParser = new AsyncapiParser();
asyncapiParser.registerSchemaParser(OpenAPISchemaParser());
asyncapiParser.registerSchemaParser(AvroSchemaParser());
asyncapiParser.registerSchemaParser(ProtoBuffSchemaParser());
var Parser = (function () {
    function Parser() {
    }
    Parser.parse = function (content, parserOptions) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, document_1, diagnostics, err_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 2, , 3]);
                        return [4, asyncapiParser.parse(content, parserOptions)];
                    case 1:
                        _a = _b.sent(), document_1 = _a.document, diagnostics = _a.diagnostics;
                        if (document_1 === undefined) {
                            throw this.convertDiagnosticToErrorObject(diagnostics, [0]);
                        }
                        return [2, { asyncapi: document_1 }];
                    case 2:
                        err_1 = _b.sent();
                        return [2, this.handleError(err_1)];
                    case 3: return [2];
                }
            });
        });
    };
    Parser.parseFromUrl = function (arg, parserOptions) {
        return __awaiter(this, void 0, void 0, function () {
            var fromResult, _a, document_2, diagnostics, err_2;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 2, , 3]);
                        fromResult = fromURL(asyncapiParser, arg.url, arg.requestOptions);
                        return [4, fromResult.parse(parserOptions)];
                    case 1:
                        _a = _b.sent(), document_2 = _a.document, diagnostics = _a.diagnostics;
                        if (document_2 == undefined) {
                            throw this.convertDiagnosticToErrorObject(diagnostics, [0]);
                        }
                        return [2, { asyncapi: document_2, error: undefined }];
                    case 2:
                        err_2 = _b.sent();
                        return [2, this.handleError(err_2)];
                    case 3: return [2];
                }
            });
        });
    };
    Parser.convertDiagnosticToErrorObject = function (diagnostics, severities) {
        var error = {
            title: 'There are errors in your Asyncapi document',
            type: 'VALIDATION_ERRORS_TYPE',
            validationErrors: [],
        };
        diagnostics.forEach(function (diagnostic) {
            var _a;
            if (severities.includes(diagnostic.severity)) {
                var tempObj = {
                    title: diagnostic.message,
                    location: {
                        jsonPointer: '/' + diagnostic.path.join('/'),
                        startLine: diagnostic.range.start.line,
                        startColumn: diagnostic.range.start.character,
                        startOffset: 1,
                        endLine: diagnostic.range.end.line,
                        endColumn: diagnostic.range.end.character,
                        endOffset: 0,
                    },
                };
                (_a = error.validationErrors) === null || _a === void 0 ? void 0 : _a.push(tempObj);
            }
        });
        return error;
    };
    Parser.handleError = function (err) {
        if (err.type === VALIDATION_ERRORS_TYPE) {
            return {
                error: err,
            };
        }
        return { error: err };
    };
    return Parser;
}());
export { Parser };
//# sourceMappingURL=parser.js.map