package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVulBatch invokes the aegis.DeleteVulBatch API synchronously
// api document: https://help.aliyun.com/api/aegis/deletevulbatch.html
func (client *Client) DeleteVulBatch(request *DeleteVulBatchRequest) (response *DeleteVulBatchResponse, err error) {
	response = CreateDeleteVulBatchResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVulBatchWithChan invokes the aegis.DeleteVulBatch API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletevulbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVulBatchWithChan(request *DeleteVulBatchRequest) (<-chan *DeleteVulBatchResponse, <-chan error) {
	responseChan := make(chan *DeleteVulBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVulBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVulBatchWithCallback invokes the aegis.DeleteVulBatch API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletevulbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVulBatchWithCallback(request *DeleteVulBatchRequest, callback func(response *DeleteVulBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVulBatchResponse
		var err error
		defer close(result)
		response, err = client.DeleteVulBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVulBatchRequest is the request struct for api DeleteVulBatch
type DeleteVulBatchRequest struct {
	*requests.RpcRequest
	BatchName string `position:"Query" name:"BatchName"`
	SourceIp  string `position:"Query" name:"SourceIp"`
	Resource  string `position:"Query" name:"Resource"`
}

// DeleteVulBatchResponse is the response struct for api DeleteVulBatch
type DeleteVulBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVulBatchRequest creates a request to invoke DeleteVulBatch API
func CreateDeleteVulBatchRequest() (request *DeleteVulBatchRequest) {
	request = &DeleteVulBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DeleteVulBatch", "vipaegis", "openAPI")
	return
}

// CreateDeleteVulBatchResponse creates a response to parse from DeleteVulBatch response
func CreateDeleteVulBatchResponse() (response *DeleteVulBatchResponse) {
	response = &DeleteVulBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
