package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHistoryDeployVersion invokes the edas.ListHistoryDeployVersion API synchronously
func (client *Client) ListHistoryDeployVersion(request *ListHistoryDeployVersionRequest) (response *ListHistoryDeployVersionResponse, err error) {
	response = CreateListHistoryDeployVersionResponse()
	err = client.DoAction(request, response)
	return
}

// ListHistoryDeployVersionWithChan invokes the edas.ListHistoryDeployVersion API asynchronously
func (client *Client) ListHistoryDeployVersionWithChan(request *ListHistoryDeployVersionRequest) (<-chan *ListHistoryDeployVersionResponse, <-chan error) {
	responseChan := make(chan *ListHistoryDeployVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHistoryDeployVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHistoryDeployVersionWithCallback invokes the edas.ListHistoryDeployVersion API asynchronously
func (client *Client) ListHistoryDeployVersionWithCallback(request *ListHistoryDeployVersionRequest, callback func(response *ListHistoryDeployVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHistoryDeployVersionResponse
		var err error
		defer close(result)
		response, err = client.ListHistoryDeployVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHistoryDeployVersionRequest is the request struct for api ListHistoryDeployVersion
type ListHistoryDeployVersionRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// ListHistoryDeployVersionResponse is the response struct for api ListHistoryDeployVersion
type ListHistoryDeployVersionResponse struct {
	*responses.BaseResponse
	Code               int                `json:"Code" xml:"Code"`
	Message            string             `json:"Message" xml:"Message"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	PackageVersionList PackageVersionList `json:"PackageVersionList" xml:"PackageVersionList"`
}

// CreateListHistoryDeployVersionRequest creates a request to invoke ListHistoryDeployVersion API
func CreateListHistoryDeployVersionRequest() (request *ListHistoryDeployVersionRequest) {
	request = &ListHistoryDeployVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListHistoryDeployVersion", "/pop/v5/app/deploy_history_version_list", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListHistoryDeployVersionResponse creates a response to parse from ListHistoryDeployVersion response
func CreateListHistoryDeployVersionResponse() (response *ListHistoryDeployVersionResponse) {
	response = &ListHistoryDeployVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
