package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagByPage invokes the oam.ListTagByPage API synchronously
// api document: https://help.aliyun.com/api/oam/listtagbypage.html
func (client *Client) ListTagByPage(request *ListTagByPageRequest) (response *ListTagByPageResponse, err error) {
	response = CreateListTagByPageResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagByPageWithChan invokes the oam.ListTagByPage API asynchronously
// api document: https://help.aliyun.com/api/oam/listtagbypage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagByPageWithChan(request *ListTagByPageRequest) (<-chan *ListTagByPageResponse, <-chan error) {
	responseChan := make(chan *ListTagByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagByPageWithCallback invokes the oam.ListTagByPage API asynchronously
// api document: https://help.aliyun.com/api/oam/listtagbypage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagByPageWithCallback(request *ListTagByPageRequest, callback func(response *ListTagByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagByPageResponse
		var err error
		defer close(result)
		response, err = client.ListTagByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagByPageRequest is the request struct for api ListTagByPage
type ListTagByPageRequest struct {
	*requests.RpcRequest
	Name      string           `position:"Query" name:"Name"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
	UserId    string           `position:"Query" name:"UserId"`
}

// ListTagByPageResponse is the response struct for api ListTagByPage
type ListTagByPageResponse struct {
	*responses.BaseResponse
	Code      string              `json:"Code" xml:"Code"`
	Message   string              `json:"Message" xml:"Message"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo            `json:"PageInfo" xml:"PageInfo"`
	Data      DataInListTagByPage `json:"Data" xml:"Data"`
}

// CreateListTagByPageRequest creates a request to invoke ListTagByPage API
func CreateListTagByPageRequest() (request *ListTagByPageRequest) {
	request = &ListTagByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListTagByPage", "", "")
	request.Method = requests.POST
	return
}

// CreateListTagByPageResponse creates a response to parse from ListTagByPage response
func CreateListTagByPageResponse() (response *ListTagByPageResponse) {
	response = &ListTagByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
