package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStatisticReport invokes the opensearch.ListStatisticReport API synchronously
func (client *Client) ListStatisticReport(request *ListStatisticReportRequest) (response *ListStatisticReportResponse, err error) {
	response = CreateListStatisticReportResponse()
	err = client.DoAction(request, response)
	return
}

// ListStatisticReportWithChan invokes the opensearch.ListStatisticReport API asynchronously
func (client *Client) ListStatisticReportWithChan(request *ListStatisticReportRequest) (<-chan *ListStatisticReportResponse, <-chan error) {
	responseChan := make(chan *ListStatisticReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStatisticReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStatisticReportWithCallback invokes the opensearch.ListStatisticReport API asynchronously
func (client *Client) ListStatisticReportWithCallback(request *ListStatisticReportRequest, callback func(response *ListStatisticReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStatisticReportResponse
		var err error
		defer close(result)
		response, err = client.ListStatisticReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStatisticReportRequest is the request struct for api ListStatisticReport
type ListStatisticReportRequest struct {
	*requests.RoaRequest
	Columns          string           `position:"Query" name:"columns"`
	Query            string           `position:"Query" name:"query"`
	PageSize         requests.Integer `position:"Query" name:"pageSize"`
	ModuleName       string           `position:"Path" name:"moduleName"`
	EndTime          requests.Integer `position:"Query" name:"endTime"`
	StartTime        requests.Integer `position:"Query" name:"startTime"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
	PageNumber       requests.Integer `position:"Query" name:"pageNumber"`
}

// ListStatisticReportResponse is the response struct for api ListStatisticReport
type ListStatisticReportResponse struct {
	*responses.BaseResponse
	RequestId  string                   `json:"requestId" xml:"requestId"`
	TotalCount int64                    `json:"totalCount" xml:"totalCount"`
	Result     []map[string]interface{} `json:"result" xml:"result"`
}

// CreateListStatisticReportRequest creates a request to invoke ListStatisticReport API
func CreateListStatisticReportRequest() (request *ListStatisticReportRequest) {
	request = &ListStatisticReportRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListStatisticReport", "/v4/openapi/app-groups/[appGroupIdentity]/statistic-report/[moduleName]", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListStatisticReportResponse creates a response to parse from ListStatisticReport response
func CreateListStatisticReportResponse() (response *ListStatisticReportResponse) {
	response = &ListStatisticReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
