package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRedisLogConfig invokes the r_kvstore.DescribeRedisLogConfig API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeredislogconfig.html
func (client *Client) DescribeRedisLogConfig(request *DescribeRedisLogConfigRequest) (response *DescribeRedisLogConfigResponse, err error) {
	response = CreateDescribeRedisLogConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRedisLogConfigWithChan invokes the r_kvstore.DescribeRedisLogConfig API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeredislogconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRedisLogConfigWithChan(request *DescribeRedisLogConfigRequest) (<-chan *DescribeRedisLogConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeRedisLogConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRedisLogConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRedisLogConfigWithCallback invokes the r_kvstore.DescribeRedisLogConfig API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeredislogconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRedisLogConfigWithCallback(request *DescribeRedisLogConfigRequest, callback func(response *DescribeRedisLogConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRedisLogConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeRedisLogConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRedisLogConfigRequest is the request struct for api DescribeRedisLogConfig
type DescribeRedisLogConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeRedisLogConfigResponse is the response struct for api DescribeRedisLogConfig
type DescribeRedisLogConfigResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	IsEtlMetaExist             int    `json:"IsEtlMetaExist" xml:"IsEtlMetaExist"`
	IsUserProjectLogstoreExist int    `json:"IsUserProjectLogstoreExist" xml:"IsUserProjectLogstoreExist"`
	UserProjectName            int    `json:"UserProjectName" xml:"UserProjectName"`
	UserLogstoreName           string `json:"UserLogstoreName" xml:"UserLogstoreName"`
}

// CreateDescribeRedisLogConfigRequest creates a request to invoke DescribeRedisLogConfig API
func CreateDescribeRedisLogConfigRequest() (request *DescribeRedisLogConfigRequest) {
	request = &DescribeRedisLogConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeRedisLogConfig", "redisa", "openAPI")
	return
}

// CreateDescribeRedisLogConfigResponse creates a response to parse from DescribeRedisLogConfig response
func CreateDescribeRedisLogConfigResponse() (response *DescribeRedisLogConfigResponse) {
	response = &DescribeRedisLogConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
