package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWorkitem invokes the rdc.UpdateWorkitem API synchronously
// api document: https://help.aliyun.com/api/rdc/updateworkitem.html
func (client *Client) UpdateWorkitem(request *UpdateWorkitemRequest) (response *UpdateWorkitemResponse, err error) {
	response = CreateUpdateWorkitemResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWorkitemWithChan invokes the rdc.UpdateWorkitem API asynchronously
// api document: https://help.aliyun.com/api/rdc/updateworkitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkitemWithChan(request *UpdateWorkitemRequest) (<-chan *UpdateWorkitemResponse, <-chan error) {
	responseChan := make(chan *UpdateWorkitemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWorkitem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWorkitemWithCallback invokes the rdc.UpdateWorkitem API asynchronously
// api document: https://help.aliyun.com/api/rdc/updateworkitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWorkitemWithCallback(request *UpdateWorkitemRequest, callback func(response *UpdateWorkitemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWorkitemResponse
		var err error
		defer close(result)
		response, err = client.UpdateWorkitem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWorkitemRequest is the request struct for api UpdateWorkitem
type UpdateWorkitemRequest struct {
	*requests.RpcRequest
	IssueId        requests.Integer `position:"Body" name:"IssueId"`
	Subject        string           `position:"Body" name:"Subject"`
	Modifier       string           `position:"Body" name:"Modifier"`
	SeriousLevel   string           `position:"Body" name:"SeriousLevel"`
	AKProjectId    requests.Integer `position:"Body" name:"AKProjectId"`
	Description    string           `position:"Body" name:"Description"`
	Stamp          string           `position:"Body" name:"Stamp"`
	TemplateId     requests.Integer `position:"Body" name:"TemplateId"`
	Priority       string           `position:"Body" name:"Priority"`
	AssignedTo     string           `position:"Body" name:"AssignedTo"`
	SprintId       requests.Integer `position:"Body" name:"SprintId"`
	IgnoreCheck    requests.Boolean `position:"Body" name:"IgnoreCheck"`
	Cfs            string           `position:"Body" name:"Cfs"`
	CorpIdentifier string           `position:"Query" name:"CorpIdentifier"`
	Verifier       string           `position:"Body" name:"Verifier"`
	CfList         string           `position:"Body" name:"CfList"`
	Status         string           `position:"Body" name:"Status"`
}

// UpdateWorkitemResponse is the response struct for api UpdateWorkitem
type UpdateWorkitemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateWorkitemRequest creates a request to invoke UpdateWorkitem API
func CreateUpdateWorkitemRequest() (request *UpdateWorkitemRequest) {
	request = &UpdateWorkitemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "UpdateWorkitem", "rdc", "openAPI")
	return
}

// CreateUpdateWorkitemResponse creates a response to parse from UpdateWorkitem response
func CreateUpdateWorkitemResponse() (response *UpdateWorkitemResponse) {
	response = &UpdateWorkitemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
