package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStartApplications invokes the sae.BatchStartApplications API synchronously
func (client *Client) BatchStartApplications(request *BatchStartApplicationsRequest) (response *BatchStartApplicationsResponse, err error) {
	response = CreateBatchStartApplicationsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStartApplicationsWithChan invokes the sae.BatchStartApplications API asynchronously
func (client *Client) BatchStartApplicationsWithChan(request *BatchStartApplicationsRequest) (<-chan *BatchStartApplicationsResponse, <-chan error) {
	responseChan := make(chan *BatchStartApplicationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStartApplications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStartApplicationsWithCallback invokes the sae.BatchStartApplications API asynchronously
func (client *Client) BatchStartApplicationsWithCallback(request *BatchStartApplicationsRequest, callback func(response *BatchStartApplicationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStartApplicationsResponse
		var err error
		defer close(result)
		response, err = client.BatchStartApplications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStartApplicationsRequest is the request struct for api BatchStartApplications
type BatchStartApplicationsRequest struct {
	*requests.RoaRequest
	AppIds      string `position:"Query" name:"AppIds"`
	NamespaceId string `position:"Query" name:"NamespaceId"`
}

// BatchStartApplicationsResponse is the response struct for api BatchStartApplications
type BatchStartApplicationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBatchStartApplicationsRequest creates a request to invoke BatchStartApplications API
func CreateBatchStartApplicationsRequest() (request *BatchStartApplicationsRequest) {
	request = &BatchStartApplicationsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "BatchStartApplications", "/pop/v1/sam/app/batchStartApplications", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateBatchStartApplicationsResponse creates a response to parse from BatchStartApplications response
func CreateBatchStartApplicationsResponse() (response *BatchStartApplicationsResponse) {
	response = &BatchStartApplicationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
