package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApp invokes the sls.DeleteApp API synchronously
func (client *Client) DeleteApp(request *DeleteAppRequest) (response *DeleteAppResponse, err error) {
	response = CreateDeleteAppResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAppWithChan invokes the sls.DeleteApp API asynchronously
func (client *Client) DeleteAppWithChan(request *DeleteAppRequest) (<-chan *DeleteAppResponse, <-chan error) {
	responseChan := make(chan *DeleteAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAppWithCallback invokes the sls.DeleteApp API asynchronously
func (client *Client) DeleteAppWithCallback(request *DeleteAppRequest, callback func(response *DeleteAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAppResponse
		var err error
		defer close(result)
		response, err = client.DeleteApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAppRequest is the request struct for api DeleteApp
type DeleteAppRequest struct {
	*requests.RpcRequest
	AppName  string `position:"Query" name:"AppName"`
	ClientIp string `position:"Query" name:"ClientIp"`
}

// DeleteAppResponse is the response struct for api DeleteApp
type DeleteAppResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAppRequest creates a request to invoke DeleteApp API
func CreateDeleteAppRequest() (request *DeleteAppRequest) {
	request = &DeleteAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "DeleteApp", "sls", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAppResponse creates a response to parse from DeleteApp response
func CreateDeleteAppResponse() (response *DeleteAppResponse) {
	response = &DeleteAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
