package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagManagementPort invokes the smartag.DescribeSagManagementPort API synchronously
func (client *Client) DescribeSagManagementPort(request *DescribeSagManagementPortRequest) (response *DescribeSagManagementPortResponse, err error) {
	response = CreateDescribeSagManagementPortResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagManagementPortWithChan invokes the smartag.DescribeSagManagementPort API asynchronously
func (client *Client) DescribeSagManagementPortWithChan(request *DescribeSagManagementPortRequest) (<-chan *DescribeSagManagementPortResponse, <-chan error) {
	responseChan := make(chan *DescribeSagManagementPortResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagManagementPort(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagManagementPortWithCallback invokes the smartag.DescribeSagManagementPort API asynchronously
func (client *Client) DescribeSagManagementPortWithCallback(request *DescribeSagManagementPortRequest, callback func(response *DescribeSagManagementPortResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagManagementPortResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagManagementPort(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagManagementPortRequest is the request struct for api DescribeSagManagementPort
type DescribeSagManagementPortRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSagManagementPortResponse is the response struct for api DescribeSagManagementPort
type DescribeSagManagementPortResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Gateway    string      `json:"Gateway" xml:"Gateway"`
	IP         string      `json:"IP" xml:"IP"`
	Mask       string      `json:"Mask" xml:"Mask"`
	TaskStates []TaskState `json:"TaskStates" xml:"TaskStates"`
}

// CreateDescribeSagManagementPortRequest creates a request to invoke DescribeSagManagementPort API
func CreateDescribeSagManagementPortRequest() (request *DescribeSagManagementPortRequest) {
	request = &DescribeSagManagementPortRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagManagementPort", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagManagementPortResponse creates a response to parse from DescribeSagManagementPort response
func CreateDescribeSagManagementPortResponse() (response *DescribeSagManagementPortResponse) {
	response = &DescribeSagManagementPortResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
