/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.TemporalNowBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalNowBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalNow> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalNowBuiltins();

    protected TemporalNowBuiltins() {
        super(TemporalConstants.NOW, TemporalNow.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalNow builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalNowBuiltinsFactory.TemporalNowTimeZoneNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(0).createArgumentNodes(context));
            }
            case 1: {
                return TemporalNowBuiltinsFactory.TemporalNowInstantNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateTimeNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return TemporalNowBuiltinsFactory.TemporalNowZonedDateTimeNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return TemporalNowBuiltinsFactory.TemporalNowZonedDateTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateNodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 7: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainDateISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: {
                return TemporalNowBuiltinsFactory.TemporalNowPlainTimeISONodeGen.create(context, builtin, TemporalNowBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalNow implements BuiltinEnum<TemporalNow>
    {
        timeZone(0),
        instant(0),
        plainDateTime(1),
        plainDateTimeISO(0),
        zonedDateTime(1),
        zonedDateTimeISO(0),
        plainDate(1),
        plainDateISO(0),
        plainTimeISO(0);

        private final int length;

        private TemporalNow(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class TemporalNowTimeZoneNode
    extends JSBuiltinNode {
        protected TemporalNowTimeZoneNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalTimeZoneObject timeZone() {
            return TemporalUtil.systemTimeZone(this.getContext(), this.getRealm());
        }
    }

    public static abstract class TemporalNowInstantNode
    extends JSBuiltinNode {
        protected TemporalNowInstantNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalInstantObject instant() {
            return TemporalUtil.systemInstant(this.getContext(), this.getRealm());
        }
    }

    public static abstract class TemporalNowPlainDateTimeNode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateTimeObject plainDateTime(Object calendar, Object temporalTimeZoneLike, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            return TemporalUtil.systemDateTime(temporalTimeZoneLike, calendar, this.getContext(), this.getRealm(), toTemporalCalendar, toTemporalTimeZone);
        }
    }

    public static abstract class TemporalNowPlainDateTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateTimeObject plainDateTimeISO(Object temporalTimeZoneLike, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject iso8601Calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            return TemporalUtil.systemDateTime(temporalTimeZoneLike, iso8601Calendar, this.getContext(), realm, toTemporalCalendar, toTemporalTimeZone);
        }
    }

    public static abstract class TemporalNowZonedDateTimeNode
    extends JSBuiltinNode {
        protected TemporalNowZonedDateTimeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalZonedDateTimeObject zonedDateTime(Object calendar, Object temporalTimeZoneLike, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            return TemporalUtil.systemZonedDateTime(temporalTimeZoneLike, calendar, this.getContext(), this.getRealm(), toTemporalCalendar, toTemporalTimeZone);
        }
    }

    public static abstract class TemporalNowZonedDateTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowZonedDateTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalZonedDateTimeObject zonedDateTimeISO(Object temporalTimeZoneLike, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject iso8601Calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            return TemporalUtil.systemZonedDateTime(temporalTimeZoneLike, iso8601Calendar, this.getContext(), realm, toTemporalCalendar, toTemporalTimeZone);
        }
    }

    public static abstract class TemporalNowPlainDateNode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateObject plainDate(Object calendar, Object temporalTimeZoneLike, @Cached InlinedBranchProfile errorBranch, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSTemporalPlainDateTimeObject dateTime = TemporalUtil.systemDateTime(temporalTimeZoneLike, calendar, this.getContext(), this.getRealm(), toTemporalCalendar, toTemporalTimeZone);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getCalendar(), this, errorBranch);
        }
    }

    public static abstract class TemporalNowPlainDateISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainDateISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainDateObject plainDateISO(Object temporalTimeZoneLike, @Cached InlinedBranchProfile errorBranch, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject dateTime = TemporalUtil.systemDateTime(temporalTimeZoneLike, calendar, this.getContext(), realm, toTemporalCalendar, toTemporalTimeZone);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), dateTime.getCalendar(), this, errorBranch);
        }
    }

    public static abstract class TemporalNowPlainTimeISONode
    extends JSBuiltinNode {
        protected TemporalNowPlainTimeISONode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSTemporalPlainTimeObject plainTimeISO(Object temporalTimeZoneLike, @Cached InlinedBranchProfile errorBranch, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached ToTemporalTimeZoneNode toTemporalTimeZone) {
            JSRealm realm = this.getRealm();
            JSTemporalCalendarObject calendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject dateTime = TemporalUtil.systemDateTime(temporalTimeZoneLike, calendar, this.getContext(), realm, toTemporalCalendar, toTemporalTimeZone);
            return JSTemporalPlainTime.create(this.getContext(), this.getRealm(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getMillisecond(), dateTime.getMicrosecond(), dateTime.getNanosecond(), this, errorBranch);
        }
    }
}

