/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.MetaDataUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.sql.SQLException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final Dbms myDbms;
    private final JdbcHelper myJdbcHelper;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final IntSet myPositions;
    private String myPrevName;

    public TableColumnIt(@Nullable RemoteResultSet rs, @NotNull Dbms dbms, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (dbms == null) {
            TableColumnIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            TableColumnIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.myPositions = new IntOpenHashSet();
        this.myDbms = dbms;
        this.mySchema = schema;
        this.myJdbcHelper = DbImplUtilCore.getJdbcHelper(this.myDbms);
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableColumn createStorage() {
        return new DatabaseMetaDataWrapper.TableColumn(new DatabaseMetaDataWrapper.Table(this.mySchema, ""));
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() {
        DatabaseMetaDataWrapper.TableColumn res = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Objects.equals(this.mySchema.schema, schema)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (!Objects.equals(this.myPrevName, table)) {
                this.myPositions.clear();
                this.myPrevName = table;
            }
            res.table.name = table;
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            if (StringUtil.isEmpty((String)res.name)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res.typeName = StringUtil.notNullize((String)this.myRs.getString("TYPE_NAME", 6));
            res.typeSuffix = null;
            res.length = this.myRs.getInt("COLUMN_SIZE", 7, 0);
            res.scale = this.myRs.getInt("DECIMAL_DIGITS", 9, 0);
            this.myJdbcHelper.adjustType((JdbcHelper.Type)res);
            res.nullable = this.myRs.getInt("NULLABLE", 11, 0) != 0;
            res.def = this.myRs.getString("COLUMN_DEF", 13);
            res.position = this.myRs.getInt("ORDINAL_POSITION", 17, 1);
            if (res.position == -1) {
                res.position = 0;
            }
            while (this.myPositions.contains(res.position)) {
                ++res.position;
            }
            this.myPositions.add(res.position);
            res.comment = this.myRs.getString("REMARKS", 12);
            res.autoIncrement = this.myRs.getBoolean("IS_AUTOINCREMENT", 23);
            if (this.myDbms.isTransactSql() && this.myRs.getString("IS_AUTOINCREMENT", 23) == null) {
                res.autoIncrement = res.typeName != null && res.typeName.endsWith(" identity");
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "schema";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableColumnIt";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        public Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            return new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Objects.equals(tableName, item.table.name);
                }
            };
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableColumnIt$Grouping", "<init>"));
        }
    }
}

