/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import org.jetbrains.annotations.Contract;

public abstract class Naming {
    private static final Set<Character> symbolsToEscapeOnExport = ImmutableSet.of((Object)Character.valueOf('.'), (Object)Character.valueOf(','), (Object)Character.valueOf('|'), (Object)Character.valueOf('~'), (Object)Character.valueOf(':'), (Object)Character.valueOf(';'), (Object[])new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\\')});

    @Contract(value="!null->!null;null->null", pure=true)
    public static String exportName(String name2) {
        if (name2 == null) {
            return null;
        }
        int n = name2.length();
        StringBuilder b = new StringBuilder(n * 2);
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = name2.charAt(i2);
            if (c2 <= ' ' || symbolsToEscapeOnExport.contains(Character.valueOf(c2))) {
                b.append('\\').append('u');
                String hex = StringUtil.toUpperCase((String)Integer.toHexString(c2));
                int h = hex.length();
                b.append("0".repeat(4 - h));
                b.append(hex);
                continue;
            }
            b.append(c2);
        }
        return b.toString();
    }

    @Contract(value="!null->!null;null->null", pure=true)
    public static String importName(String escapedName) {
        if (escapedName == null) {
            return null;
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)escapedName.trim());
    }
}

