/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redis;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.redis.RedisDialect;
import com.intellij.sql.dialects.redis.RedisTypes;

public class RedisGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean parseFixedSequence(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser lengthParser, GeneratedParserUtilBase.Parser elementParser) {
        return RedisGeneratedParserUtil.parseFixedSequence(builder, level, lengthParser, elementParser, null);
    }

    public static boolean parseFixedSequenceWithWeights(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser lengthParser, GeneratedParserUtilBase.Parser elementParser, GeneratedParserUtilBase.Parser weightParser) {
        return RedisGeneratedParserUtil.parseFixedSequence(builder, level, lengthParser, elementParser, weightParser);
    }

    private static boolean parseFixedSequence(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser lengthParser, GeneratedParserUtilBase.Parser elementParser, GeneratedParserUtilBase.Parser weightParser) {
        int i2;
        String lengthTokenText = builder.getTokenText();
        if (lengthTokenText == null) {
            return false;
        }
        int length = StringUtil.parseInt((String)lengthTokenText, (int)0);
        lengthParser.parse(builder, level);
        for (i2 = 0; i2 < length; ++i2) {
            if (elementParser.parse(builder, level)) continue;
            return false;
        }
        if (weightParser == null) {
            return true;
        }
        RedisGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)RedisTypes.REDIS_WEIGHTS.toString());
        if (!RedisGeneratedParserUtil.consumeToken((PsiBuilder)builder, (IElementType)RedisTypes.REDIS_WEIGHTS)) {
            return true;
        }
        for (i2 = 0; i2 < length; ++i2) {
            if (weightParser.parse(builder, level)) continue;
            return false;
        }
        return true;
    }

    public static boolean parseSequenceAheadLength(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser elementParser, int aheadLength) {
        while (!RedisGeneratedParserUtil.isEndOfStatement(builder.lookAhead(aheadLength))) {
            if (elementParser.parse(builder, level)) continue;
            return false;
        }
        return true;
    }

    public static boolean parseDualSequence(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser firstElementParser, GeneratedParserUtilBase.Parser secondElementParser) {
        int length = 0;
        IElementType tokenType = builder.getTokenType();
        while (!RedisGeneratedParserUtil.isEndOfStatement(tokenType)) {
            tokenType = builder.lookAhead(++length);
        }
        int firstElementsLength = length + 1 >> 1;
        if (firstElementsLength == 0) {
            return false;
        }
        for (int i2 = 0; i2 < firstElementsLength; ++i2) {
            if (firstElementParser.parse(builder, level)) continue;
            return false;
        }
        int secondElementsLength = length >> 1;
        if (secondElementsLength == 0) {
            return false;
        }
        for (int i3 = 0; i3 < secondElementsLength; ++i3) {
            if (secondElementParser.parse(builder, level)) continue;
            return false;
        }
        return length % 2 == 0;
    }

    private static boolean isEndOfStatement(IElementType tokenType) {
        return tokenType == null || RedisDialect.INSTANCE.getStatementSeparators().contains(tokenType);
    }
}

