/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.symbols;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.symbols.DasPsiSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasScope;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.DasSymbolPointer;
import com.intellij.sql.symbols.virtual.DasVirtualParameterSymbol;
import com.intellij.sql.symbols.virtual.DasVirtualVariableSymbol;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DasSymbolUtil {
    private DasSymbolUtil() {
    }

    @Nullable
    public static DasSymbol getSymbolByPsi(@Nullable PsiElement element) {
        if (element instanceof DasSymbol) {
            return (DasSymbol)element;
        }
        if (element instanceof SqlReferenceExpression) {
            return DasSymbolUtil.getInlineSymbol(((SqlReferenceExpression)element).getReference());
        }
        return null;
    }

    @NotNull
    public static DasSymbol getInlineSymbol(@NotNull SqlReference reference, boolean unresolved) {
        if (reference == null) {
            DasSymbolUtil.$$$reportNull$$$0(0);
        }
        return new DasInlineSymbol(reference, unresolved);
    }

    @NotNull
    public static DasSymbol getInlineSymbol(@NotNull SqlReference reference) {
        if (reference == null) {
            DasSymbolUtil.$$$reportNull$$$0(1);
        }
        return DasSymbolUtil.getInlineSymbol(reference, false);
    }

    public static boolean isUnresolved(@Nullable DasSymbol symbol) {
        return symbol instanceof DasInlineSymbol && ((DasInlineSymbol)symbol).isUnresolved();
    }

    @Nullable
    public static DasSymbol getSymbol(@Nullable ResolveResult resolve2) {
        return resolve2 instanceof SqlResolveResult ? ((SqlResolveResult)resolve2).getTargetSymbol() : null;
    }

    @Nullable
    public static PsiElement getSinglePsiSource(@Nullable DasSymbol symbol) {
        return symbol != null ? (PsiElement)symbol.getPsiDeclarations().single() : null;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static DasSymbol wrapObjectToSymbol(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            DasSymbolUtil.$$$reportNull$$$0(2);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof DasSymbol) {
            return (DasSymbol)((Object)object);
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static DasSymbol wrapObjectToSymbol(@Nullable DasObject object, @NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            DasSymbolUtil.$$$reportNull$$$0(3);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof DasSymbol) {
            return (DasSymbol)((Object)object);
        }
        for (DbDataSource dataSource : processor.getDataSources()) {
            Object result2 = dataSource.mapper().fun((Object)object);
            if (!(result2 instanceof DasSymbol)) continue;
            return (DasSymbol)result2;
        }
        return new DasPsiWrappingSymbol(object, processor.getPlace().getProject());
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialect(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(4);
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)ObjectUtils.notNull((Object)SqlLanguageDialect.EP.forDbms(symbol.getDbms()), (Object)SqlDialectImplUtilCore.getDefaultSqlDialect());
        if (sqlLanguageDialectEx == null) {
            DasSymbolUtil.$$$reportNull$$$0(5);
        }
        return sqlLanguageDialectEx;
    }

    public static DasVirtualVariableSymbol createSimpleVariable(@NotNull SqlElement context, @NotNull String name2, final @NotNull DasType dasType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            DasSymbolUtil.$$$reportNull$$$0(7);
        }
        if (dasType == null) {
            DasSymbolUtil.$$$reportNull$$$0(8);
        }
        return new DasVirtualVariableSymbol(context, name2){

            @Override
            @NotNull
            public DasType getDasType() {
                DasType dasType2 = dasType;
                if (dasType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dasType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$1", "getDasType"));
            }
        };
    }

    public static DasVirtualParameterSymbol createDelegatingParameter(@NotNull SqlElement context, @NotNull DasRoutine routine2, @NotNull String name2, @NotNull ArgumentDirection direction, short position, final @NotNull DasTypedObject delegate, final boolean useAsPsiDeclaration) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(9);
        }
        if (routine2 == null) {
            DasSymbolUtil.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            DasSymbolUtil.$$$reportNull$$$0(11);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(12);
        }
        if (delegate == null) {
            DasSymbolUtil.$$$reportNull$$$0(13);
        }
        return new DasVirtualParameterSymbol(context, routine2, name2, direction, position){

            @Override
            @NotNull
            public DasType getDasType() {
                DasType dasType = delegate.getDasType();
                if (dasType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dasType;
            }

            @Override
            public boolean isNotNull() {
                return delegate.isNotNull();
            }

            @Override
            @Nullable
            public String getDefault() {
                return delegate.getDefault();
            }

            @Override
            public boolean isQuoted() {
                return DbSqlUtilCore.isQuoted(delegate);
            }

            @Override
            @NotNull
            public JBIterable<? extends PsiElement> getPsiDeclarations() {
                JBIterable jBIterable = useAsPsiDeclaration && delegate instanceof PsiElement ? JBIterable.of((Object)((PsiElement)delegate)) : JBIterable.empty();
                if (jBIterable == null) {
                    2.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/symbols/DasSymbolUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPsiDeclarations";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static DasVirtualParameterSymbol createSimpleParameter(@NotNull SqlElement context, @NotNull DasRoutine routine2, @NotNull String name2, @NotNull ArgumentDirection direction, short position, final @NotNull DasType dasType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(14);
        }
        if (routine2 == null) {
            DasSymbolUtil.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            DasSymbolUtil.$$$reportNull$$$0(16);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(17);
        }
        if (dasType == null) {
            DasSymbolUtil.$$$reportNull$$$0(18);
        }
        return new DasVirtualParameterSymbol(context, routine2, name2, direction, position){

            @Override
            @NotNull
            public DasType getDasType() {
                DasType dasType2 = dasType;
                if (dasType2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dasType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$3", "getDasType"));
            }
        };
    }

    @Nullable
    public static DasSymbol getOrResolveSymbol(@Nullable PsiElement element) {
        if (element instanceof DasSymbol) {
            return (DasSymbol)element;
        }
        if (element instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)element).resolveSymbol();
        }
        return null;
    }

    @Nullable
    public static Icon getIcon(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(19);
        }
        if (symbol instanceof PsiPresentableMetaData) {
            return ((PsiPresentableMetaData)symbol).getIcon();
        }
        if (symbol instanceof PsiElement) {
            return ((PsiElement)symbol).getIcon(0);
        }
        DasObject dasObject = symbol.getDasObject();
        return dasObject != null ? DbPresentationCore.getIcon(dasObject) : DbPresentationCore.getIcon(symbol.getKind());
    }

    @Nls
    @NotNull
    public static String getTypeName(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(20);
        }
        String string = DbPresentationCore.getPresentableName(symbol.getKind(), symbol.getDbms());
        if (string == null) {
            DasSymbolUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static DasSymbolPointer createPointer(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(22);
        }
        if (symbol instanceof DasPsiSymbol) {
            SmartPsiElementPointer psiPointer = SmartPointerManager.createPointer((PsiElement)((DasPsiSymbol)symbol));
            DasSymbolPointer dasSymbolPointer = () -> (DasSymbol)psiPointer.getElement();
            if (dasSymbolPointer == null) {
                DasSymbolUtil.$$$reportNull$$$0(23);
            }
            return dasSymbolPointer;
        }
        DasSymbolPointer dasSymbolPointer = () -> symbol;
        if (dasSymbolPointer == null) {
            DasSymbolUtil.$$$reportNull$$$0(24);
        }
        return dasSymbolPointer;
    }

    public static boolean processScope(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull DasScope<? extends DasObject> scope) {
        String name2;
        if (processor == null) {
            DasSymbolUtil.$$$reportNull$$$0(25);
        }
        if (state == null) {
            DasSymbolUtil.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            DasSymbolUtil.$$$reportNull$$$0(27);
        }
        Collection<? extends DasObject> candidates = (name2 = processor.getReferenceName()) != null ? scope.getElementsByName(name2) : scope.getAllElements();
        for (DasObject dasObject : candidates) {
            DasSymbol funSymbol = DasSymbolUtil.wrapObjectToSymbol(dasObject, processor);
            if (processor.execute(funSymbol, state)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 21, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 5: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInlineSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 5: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDelegatingParameter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleParameter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 21, 23, 24 -> new IllegalStateException(string);
        };
    }
}

