/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerRunCliParser;
import com.intellij.docker.agent.cli.model.DockerRunCliParserBase;
import com.intellij.docker.agent.cli.model.handler.CapabilityHandler;
import com.intellij.docker.agent.fix.FixedBindParser;
import com.intellij.docker.agent.impl.CreateContainerCmdConfig;
import com.intellij.docker.agent.settings.DockerDeviceRequest;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002mnB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\u0005\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u00100\u001a\f01R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0002062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u0002082\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u00109\u001a\f0:R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010=\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030>2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00020D2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020(2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00020K2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00020K2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00020K2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u0002062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u0002062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001a\u0010Q\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030R2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00020/2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001c\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020^0R2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00020b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00020d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020\u0002062\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00020j2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006o"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser;", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "<init>", "()V", "parse", "", "cmd", "optionsLine", "", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "([Ljava/lang/String;)Lcom/github/dockerjava/api/command/CreateContainerCmd;", "name", "Lcom/intellij/docker/agent/cli/model/CliParserBase$SingleValueHandler;", "option", "Lorg/apache/commons/cli/Option;", "hostname", "user", "memory", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MemoryOptionHandler;", "memorySwap", "memorySwappiness", "shmSize", "mount", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$MountOptionHandler;", "tmpfs", "kernelMemory", "memoryReservation", "cpusetCpus", "cpuShares", "Lcom/intellij/docker/agent/cli/model/CliParserBase$IntegerOptionHandler;", "cpuPeriod", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LongOptionHandler;", "cpuQuota", "cpusetMems", "cpus", "Lcom/intellij/docker/agent/cli/model/CliParserBase$DoubleOptionHandler;", "blkioWeight", "oomKillDisable", "Lcom/intellij/docker/agent/cli/model/CliParserBase$BooleanOptionHandler;", "attach", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$AttachOptionHandler;", "detach", "tty", "interactive", "env", "Lcom/intellij/docker/agent/cli/model/CliParserBase$ListHandler;", "envFile", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$EnvFileListHandler;", "entrypoint", "workingDir", "expose", "addHost", "Lcom/intellij/docker/agent/cli/model/CliParserBase$StringListHandler;", "label", "Lcom/intellij/docker/agent/cli/model/CliParserBase$LabelListHandler;", "labelFile", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$LabelFileListHandler;", "securityOpt", "volume", "link", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$LinkOptionHandler;", "lxcConf", "logDriver", "logOpt", "macAddress", "publish", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$PortBindingOptionHandler;", "publishAll", "privileged", "readOnlyRootfs", "healthCmd", "noHealthcheck", "healthInterval", "Lcom/intellij/docker/agent/cli/model/CliParserBase$DurationHandler;", "healthRetries", "healthStartPeriod", "healthTimeout", "dns", "dnsSearch", "volumesFrom", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "cidfile", "platform", "capAdd", "capDrop", "cpuRealtimeRuntime", "restart", "network", "networkAlias", "ip", "ip6", "device", "Lcom/github/dockerjava/api/model/Device;", "runtime", "rm", "ipc", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$IPCOptionHandler;", "ulimit", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$UlimitOptionHandler;", "deviceCgroupRuleHandler", "groupAdd", "cgroupParent", "sysctl", "gpus", "Lcom/intellij/docker/agent/cli/model/DockerRunCliParserBase$GpuDeviceRequestHandler;", "init", "userns", "ExposeHandler", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,692:1\n1104#2,3:693\n37#3:696\n36#3,3:697\n37#3:732\n36#3,3:733\n106#4:700\n78#4,29:701\n216#5,2:730\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser\n*L\n94#1:693,3\n346#1:696\n346#1:697,3\n593#1:732\n593#1:733,3\n348#1:700\n348#1:701,29\n400#1:730,2\n*E\n"})
public final class DockerRunCliParser
extends DockerRunCliParserBase<CreateContainerCmd> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void parse(@NotNull CreateContainerCmd cmd, @NotNull String[] optionsLine) throws ApiTaskException {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)optionsLine, (String)"optionsLine");
        try {
            super.doParse(cmd, optionsLine, false);
        }
        catch (ParseException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new ApiTaskException(e);
        }
    }

    @NotNull
    public final CreateContainerCmd parse(@NotNull String[] optionsLine) throws ApiTaskException {
        Intrinsics.checkNotNullParameter((Object)optionsLine, (String)"optionsLine");
        try {
            CreateContainerCmdConfig command = new CreateContainerCmdConfig();
            super.doParse(command, optionsLine, false);
            return (CreateContainerCmd)command;
        }
        catch (ParseException e) {
            throw new ApiTaskException((Exception)((Object)e));
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new ApiTaskException(e);
        }
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> name(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.name$lambda$0(name.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> hostname(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.hostname$lambda$1(hostname.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> user(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.user$lambda$2(user.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memory$lambda$4(DockerRunCliParser::memory$lambda$3, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwap$lambda$6(DockerRunCliParser::memorySwap$lambda$5, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwappiness(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memorySwappiness$lambda$8(DockerRunCliParser::memorySwappiness$lambda$7, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.shmSize$lambda$10(DockerRunCliParser::shmSize$lambda$9, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd> mount(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.MountOptionHandler<CreateContainerCmd>(option, DockerRunCliParser::mount$lambda$11);
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> tmpfs(@Nullable Option option) {
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.tmpfs$lambda$14(DockerRunCliParser::tmpfs$lambda$13, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.kernelMemory$lambda$16(DockerRunCliParser::kernelMemory$lambda$15, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MemoryOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.memoryReservation$lambda$18(DockerRunCliParser::memoryReservation$lambda$17, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetCpus$lambda$20(DockerRunCliParser::cpusetCpus$lambda$19, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuShares$lambda$22(DockerRunCliParser::cpuShares$lambda$21, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuPeriod(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuPeriod$lambda$24(DockerRunCliParser::cpuPeriod$lambda$23, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuQuota(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuQuota$lambda$26(DockerRunCliParser::cpuQuota$lambda$25, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpusetMems$lambda$28(DockerRunCliParser::cpusetMems$lambda$27, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.DoubleOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cpus$lambda$30(DockerRunCliParser::cpus$lambda$29, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.blkioWeight$lambda$32(DockerRunCliParser::blkioWeight$lambda$31, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.oomKillDisable$lambda$34(DockerRunCliParser::oomKillDisable$lambda$33, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.AttachOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$35(attach.1.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$36(attach.2.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> DockerRunCliParser.attach$lambda$37(attach.3.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                block0: {
                    CreateContainerCmd createContainerCmd;
                    if (!value || (createContainerCmd = ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(false))) == null || (createContainerCmd = createContainerCmd.withAttachStdout(Boolean.valueOf(false))) == null) break block0;
                    createContainerCmd.withAttachStderr(Boolean.valueOf(false));
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.tty$lambda$38(tty.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(Boolean.valueOf(value));
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(value));
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> env(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, String>(option, String.class, arg_0 -> DockerRunCliParser.env$lambda$39((Function1)new Function1<String, String>((Object)Companion){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
            }
        }, arg_0), (arg_0, arg_1) -> DockerRunCliParser.env$lambda$40((Function2)new Function2<CreateContainerCmd, String[], Unit>((Object)Companion){

            public final void invoke(CreateContainerCmd p0, String[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment((Companion)this.receiver, p0, p1);
            }
        }, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.EnvFileListHandler envFile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.EnvFileListHandler(this, option){
            final /* synthetic */ Option $option;
            {
                this.$option = $option;
                super($receiver, $option);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleEnvFile(String optionValue, File file) {
                Intrinsics.checkNotNullParameter((Object)optionValue, (String)"optionValue");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String[] envVars = null;
                try {
                    String[] stringArray;
                    AutoCloseable autoCloseable = Files.lines(file.toPath());
                    Throwable throwable = null;
                    try {
                        Stream lines = (Stream)autoCloseable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)lines);
                        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)lines), envFile.1::handleEnvFile$lambda$3$lambda$1), envFile.1::handleEnvFile$lambda$3$lambda$2), (Function1)((Function1)new Function1<String, String>((Object)DockerRunCliParser.Companion){

                            public final String invoke(String p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                return com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendSystemValueIfFound((Companion)this.receiver, p0);
                            }
                        })));
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        stringArray = thisCollection$iv.toArray(new String[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    envVars = stringArray;
                }
                catch (IOException e) {
                    throw new CliParserBase.IllegalOptionException(this.$option, optionValue, e);
                }
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$appendToCmdEnvironment(DockerRunCliParser.Companion, (CreateContainerCmd)CMD, envVars);
            }

            private static final String handleEnvFile$lambda$3$lambda$1(String obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                String $this$trim$iv = obj;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }

            private static final boolean handleEnvFile$lambda$3$lambda$2(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return !(((CharSequence)text).length() == 0) && !StringsKt.startsWith$default((String)text, (String)"#", (boolean)false, (int)2, null);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.entrypoint$lambda$42(DockerRunCliParser::entrypoint$lambda$41, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.workingDir$lambda$43(workingDir.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> expose(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new ExposeHandler(option);
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> addHost(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.addHost$lambda$45(DockerRunCliParser::addHost$lambda$44, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.LabelListHandler<CreateContainerCmd> label(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.LabelListHandlerImpl<Object>(option, arg_0 -> DockerRunCliParser.label$lambda$46(label.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.label$lambda$47(label.2.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.LabelFileListHandler labelFile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.LabelFileListHandler(this, option){

            protected void handleLabelsFile(String optionValue, File file) {
                Intrinsics.checkNotNullParameter((Object)optionValue, (String)"optionValue");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Map map2 = ((CreateContainerCmd)this.getCmd()).getLabels();
                if (map2 == null) {
                    map2 = MapsKt.emptyMap();
                }
                Map prevLabels = map2;
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Map<String, String> parsedLabels = this.parseLabels(path);
                ((CreateContainerCmd)this.getCmd()).withLabels(MapsKt.plus((Map)prevLabels, parsedLabels));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Map<String, String> parseLabels(Path path) {
                try {
                    Map map2;
                    AutoCloseable autoCloseable = Files.lines(path);
                    Throwable throwable = null;
                    try {
                        Stream lines = (Stream)autoCloseable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)lines);
                        map2 = MapsKt.toMap((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)lines), labelFile.1::parseLabels$lambda$6$lambda$2), labelFile.1::parseLabels$lambda$6$lambda$3), arg_0 -> labelFile.1.parseLabels$lambda$6$lambda$5(path, arg_0)));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                    return map2;
                }
                catch (IOException iOException) {
                    throw new CliParserBase.IllegalOptionException("Failed to read label file at '" + path + "'");
                }
            }

            private static final Pair<String, String> parseLabels$toPair(List<String> elements) {
                String string;
                int it;
                String string2;
                int n = 0;
                List<String> list = elements;
                if (n < list.size()) {
                    string2 = list.get(n);
                } else {
                    it = n;
                    boolean bl = false;
                    string2 = "";
                }
                list = elements;
                n = 1;
                if (n < list.size()) {
                    string = list.get(n);
                } else {
                    it = n;
                    String string3 = string2;
                    boolean bl = false;
                    string = "";
                    string2 = string3;
                }
                return TuplesKt.to((Object)string2, (Object)string);
            }

            private static final boolean parseLabels$lambda$6$lambda$2(String it) {
                Intrinsics.checkNotNull((Object)it);
                return StringsKt.contains$default((CharSequence)it, (CharSequence)"=", (boolean)false, (int)2, null);
            }

            private static final Pair parseLabels$lambda$6$lambda$3(String it) {
                Intrinsics.checkNotNull((Object)it);
                String[] stringArray = new String[]{"="};
                return labelFile.1.parseLabels$toPair(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (String[])stringArray, (boolean)false, (int)2, (int)2, null));
            }

            private static final boolean parseLabels$lambda$6$lambda$5(Path $path, Pair pair) {
                boolean hasWhitespace;
                boolean isComment;
                boolean keyIsNotSet;
                boolean isEmptyLine;
                String value;
                String key;
                block3: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
                    key = (String)pair.component1();
                    value = (String)pair.component2();
                    isEmptyLine = ((CharSequence)key).length() == 0 && ((CharSequence)value).length() == 0;
                    keyIsNotSet = ((CharSequence)key).length() == 0 && ((CharSequence)value).length() > 0;
                    isComment = StringsKt.startsWith$default((String)key, (String)"#", (boolean)false, (int)2, null);
                    CharSequence $this$any$iv = key;
                    boolean $i$f$any = false;
                    for (int i = 0; i < $this$any$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$any$iv.charAt(i);
                        boolean bl2 = false;
                        if (!CharsKt.isWhitespace((char)it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = hasWhitespace = false;
                }
                if (keyIsNotSet) {
                    throw new CliParserBase.IllegalOptionException("Failed to read label file '" + $path.getFileName() + "': key cannot be empty for the value = '" + value + "'");
                }
                if (hasWhitespace) {
                    throw new CliParserBase.IllegalOptionException("Failed to read label file '" + $path.getFileName() + "': key '" + ((Object)StringsKt.trimEnd((CharSequence)key)).toString() + "' contains whitespaces");
                }
                return isComment || isEmptyLine;
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> securityOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.securityOpt$lambda$49(DockerRunCliParser::securityOpt$lambda$48, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> volume(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                List volumes = new ArrayList<E>();
                List binds = new ArrayList<E>();
                for (String value : values) {
                    boolean bl;
                    if (!StringsKt.contains$default((CharSequence)value, (CharSequence)":", (boolean)false, (int)2, null)) {
                        bl = volumes.add(new Volume(value));
                        continue;
                    }
                    Bind bind = FixedBindParser.parse(value);
                    Intrinsics.checkNotNullExpressionValue((Object)bind, (String)"parse(...)");
                    bl = binds.add(bind);
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withBinds(binds);
                }
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        BiConsumer<CreateContainerCmd, List<Link>> biConsumer = DockerRunCliParser::link$lambda$50;
        return new DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, biConsumer){

            protected Link createLink(String name2, String alias) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                return new Link(name2, alias);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> lxcConf(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, LxcConf>(option, LxcConf.class, arg_0 -> DockerRunCliParser.lxcConf$lambda$53(option, arg_0), (arg_0, arg_1) -> DockerRunCliParser.lxcConf$lambda$55(DockerRunCliParser::lxcConf$lambda$54, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Collection $this$toTypedArray$iv = (Collection)logDriver.EntriesMappings.entries$0;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                for (LogConfig.LoggingType loggingType : thisCollection$iv.toArray(new LogConfig.LoggingType[0])) {
                    if (!Intrinsics.areEqual((Object)loggingType.getType(), (Object)value)) continue;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).setType(loggingType);
                    return;
                }
                throw new CliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> logOpt(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            /*
             * WARNING - void declaration
             */
            protected void handleValueList(String[] values) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                for (String value : values) {
                    int endIndex$iv$iv;
                    int startIndex$iv$iv;
                    CharSequence $this$trim$iv$iv;
                    void $this$toTypedArray$iv;
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    LogConfig logConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$getOrCreateLogConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    Map logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<K, V>();
                        logConfig.setConfig(logOptions);
                    }
                    Object object = value;
                    Object object2 = new Regex("=");
                    int n = 2;
                    object = object2.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    if (parts.length == 2) {
                        object = logOptions;
                        String $this$trim$iv = parts[0];
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv2 = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv2 = 0;
                        int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        object2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                        String $this$trim$iv2 = parts[1];
                        boolean $i$f$trim3 = false;
                        $this$trim$iv$iv = $this$trim$iv2;
                        boolean $i$f$trim4 = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv2 = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                    } else {
                        throw new CliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    object.put(object2, string);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.macAddress$lambda$56(macAddress.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd> publish(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.PortBindingOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publish$lambda$59(DockerRunCliParser::publish$lambda$58, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.publishAll$lambda$61(DockerRunCliParser::publishAll$lambda$60, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.privileged$lambda$63(DockerRunCliParser::privileged$lambda$62, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> readOnlyRootfs(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.readOnlyRootfs$lambda$65(DockerRunCliParser::readOnlyRootfs$lambda$64, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> healthCmd(@Nullable Option option) {
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.healthCmd$lambda$67(DockerRunCliParser::healthCmd$lambda$66, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> noHealthcheck(@Nullable Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.noHealthcheck$lambda$69(DockerRunCliParser::noHealthcheck$lambda$68, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.DurationHandler<CreateContainerCmd> healthInterval(@Nullable Option option) {
        return new CliParserBase.DurationHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.healthInterval$lambda$71(DockerRunCliParser::healthInterval$lambda$70, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> healthRetries(@Nullable Option option) {
        return new CliParserBase.IntegerOptionHandler<Object>(option, (BiConsumer<Object, Integer>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.healthRetries$lambda$73(DockerRunCliParser::healthRetries$lambda$72, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.DurationHandler<CreateContainerCmd> healthStartPeriod(@Nullable Option option) {
        return new CliParserBase.DurationHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.healthStartPeriod$lambda$75(DockerRunCliParser::healthStartPeriod$lambda$74, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.DurationHandler<CreateContainerCmd> healthTimeout(@Nullable Option option) {
        return new CliParserBase.DurationHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.healthTimeout$lambda$77(DockerRunCliParser::healthTimeout$lambda$76, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dns(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dns$lambda$79(DockerRunCliParser::dns$lambda$78, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.dnsSearch$lambda$81(DockerRunCliParser::dnsSearch$lambda$80, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, VolumesFrom>(option, VolumesFrom.class, arg_0 -> DockerRunCliParser.volumesFrom$lambda$82(volumesFrom.1.INSTANCE, arg_0), (arg_0, arg_1) -> DockerRunCliParser.volumesFrom$lambda$84(DockerRunCliParser::volumesFrom$lambda$83, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cidfile$lambda$86(DockerRunCliParser::cidfile$lambda$85, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> platform(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.platform$lambda$87(platform.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> capAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CapabilityHandler(option, DockerRunCliParser::capAdd$lambda$88);
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> capDrop(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CapabilityHandler(option, DockerRunCliParser::capDrop$lambda$89);
    }

    @Override
    @NotNull
    protected CliParserBase.LongOptionHandler<CreateContainerCmd> cpuRealtimeRuntime(@Nullable Option option) {
        return new CliParserBase.LongOptionHandler<Object>(option, (BiConsumer<Object, Long>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> DockerRunCliParser.cpuRealtimeRuntime$lambda$91(DockerRunCliParser::cpuRealtimeRuntime$lambda$90, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> restart(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.restart$lambda$93(DockerRunCliParser::restart$lambda$92, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> network(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (StringsKt.equals((String)"none", (String)value, (boolean)true)) {
                    v0 = ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(Boolean.valueOf(true));
                } else {
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    v0 = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withNetworkMode(value);
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.ListHandler<CreateContainerCmd> networkAlias(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.networkAlias$lambda$95(DockerRunCliParser::networkAlias$lambda$94, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip$lambda$96(ip.1.INSTANCE, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip6(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ip6$lambda$97(ip6.1.INSTANCE, arg_0, arg_1));
    }

    @NotNull
    protected CliParserBase.MappedListHandler<CreateContainerCmd, Device> device(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.MappedListHandler<Object, Device>(option, Device.class, arg_0 -> DockerRunCliParser.device$lambda$99(DockerRunCliParser::device$lambda$98, arg_0), (arg_0, arg_1) -> DockerRunCliParser.device$lambda$101(DockerRunCliParser::device$lambda$100, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> runtime(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.runtime$lambda$103(DockerRunCliParser::runtime$lambda$102, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withAutoRemove(Boolean.valueOf(value));
            }
        };
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.IPCOptionHandler<CreateContainerCmd> ipc(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.IPCOptionHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.ipc$lambda$105(DockerRunCliParser::ipc$lambda$104, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd> ulimit(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.UlimitOptionHandler<CreateContainerCmd>(option){

            private final Ulimit toApiLimit(DockerRunCliParserBase.UlimitOptionHandler.CliUlimit limit) {
                return new Ulimit(limit.getName(), limit.getSoft(), limit.getHard());
            }

            /*
             * WARNING - void declaration
             */
            protected void handleUlimits(List<DockerRunCliParserBase.UlimitOptionHandler.CliUlimit> limits) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(limits, (String)"limits");
                Iterable $this$map$iv = limits;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    DockerRunCliParserBase.UlimitOptionHandler.CliUlimit cliUlimit = (DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.toApiLimit((DockerRunCliParserBase.UlimitOptionHandler.CliUlimit)p0));
                }
                List apiLimits = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withUlimits(apiLimits);
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> deviceCgroupRuleHandler(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.deviceCgroupRuleHandler$lambda$107(DockerRunCliParser::deviceCgroupRuleHandler$lambda$106, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.StringListHandler<CreateContainerCmd> groupAdd(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.StringListHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.groupAdd$lambda$109(DockerRunCliParser::groupAdd$lambda$108, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cgroupParent(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.cgroupParent$lambda$111(DockerRunCliParser::cgroupParent$lambda$110, arg_0, arg_1));
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> sysctl(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.sysctl$lambda$113((arg_0, arg_1) -> DockerRunCliParser.sysctl$lambda$112(option, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @NotNull
    protected DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd> gpus(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new DockerRunCliParserBase.GpuDeviceRequestHandler<CreateContainerCmd>(option){

            protected void handleDeviceRequest(String value, DockerDeviceRequest dto) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                    CMD CMD = this.getCmd();
                    Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                    HostConfig hostConfig = com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD);
                    if (hostConfig.getDeviceRequests() == null) {
                        hostConfig.withDeviceRequests((List)new ArrayList<E>());
                    }
                    List list = hostConfig.getDeviceRequests();
                    if (list == null) break block1;
                    list.add(new DeviceRequest().withDriver(dto.getDriver()).withCount(Integer.valueOf(dto.getCount())).withCapabilities(dto.getCapabilities()).withOptions(dto.getOptions()).withDeviceIds(dto.getDeviceIds()));
                }
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> init(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                CMD CMD = this.getCmd();
                Intrinsics.checkNotNullExpressionValue(CMD, (String)"getCmd(...)");
                com.intellij.docker.agent.cli.model.DockerRunCliParser$Companion.access$findOrCreateHostConfig(DockerRunCliParser.Companion, (CreateContainerCmd)CMD).withInit(Boolean.valueOf(true));
            }
        };
    }

    @Override
    @NotNull
    protected CliParserBase.SingleValueHandler<CreateContainerCmd> userns(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return new CliParserBase.EachValueHandler<Object>(option, (arg_0, arg_1) -> DockerRunCliParser.userns$lambda$115(DockerRunCliParser::userns$lambda$114, arg_0, arg_1));
    }

    private static final void name$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void hostname$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void user$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memory$lambda$3(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemory(value);
        return Unit.INSTANCE;
    }

    private static final void memory$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memorySwap$lambda$5(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemorySwap(value);
        return Unit.INSTANCE;
    }

    private static final void memorySwap$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memorySwappiness$lambda$7(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemorySwappiness(value);
        return Unit.INSTANCE;
    }

    private static final void memorySwappiness$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit shmSize$lambda$9(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withShmSize(size);
        return Unit.INSTANCE;
    }

    private static final void shmSize$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void mount$lambda$11(CreateContainerCmd cmd, List mounts) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMounts(mounts);
    }

    private static final Unit tmpfs$lambda$13(CreateContainerCmd cmd, String text) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        HostConfig host = DockerRunCliParser.Companion.findOrCreateHostConfig(cmd);
        Map map2 = host.getTmpFs();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map tmpfs = map2;
        CharSequence $this$count$iv = text;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == ':')) continue;
            ++count$iv;
        }
        Pair entry = switch (count$iv) {
            case 0 -> TuplesKt.to((Object)text, (Object)"");
            case 1 -> TuplesKt.to((Object)StringsKt.substringBefore$default((String)text, (char)':', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)text, (char)':', null, (int)2, null));
            default -> throw new CliParserBase.IllegalOptionException("'--tmpfs' has too many colons");
        };
        host.withTmpFs(MapsKt.plus((Map)tmpfs, (Pair)entry));
        return Unit.INSTANCE;
    }

    private static final void tmpfs$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit kernelMemory$lambda$15(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withKernelMemory(size);
        return Unit.INSTANCE;
    }

    private static final void kernelMemory$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit memoryReservation$lambda$17(CreateContainerCmd cmd, Long size) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withMemoryReservation(size);
        return Unit.INSTANCE;
    }

    private static final void memoryReservation$lambda$18(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpusetCpus$lambda$19(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpusetCpus(value);
        return Unit.INSTANCE;
    }

    private static final void cpusetCpus$lambda$20(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuShares$lambda$21(CreateContainerCmd cmd, Integer value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuShares(value);
        return Unit.INSTANCE;
    }

    private static final void cpuShares$lambda$22(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuPeriod$lambda$23(CreateContainerCmd cmd, Long value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuPeriod(value);
        return Unit.INSTANCE;
    }

    private static final void cpuPeriod$lambda$24(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpuQuota$lambda$25(CreateContainerCmd cmd, Long quota) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuQuota(quota);
        return Unit.INSTANCE;
    }

    private static final void cpuQuota$lambda$26(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpusetMems$lambda$27(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpusetMems(value);
        return Unit.INSTANCE;
    }

    private static final void cpusetMems$lambda$28(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit cpus$lambda$29(CreateContainerCmd cmd, double ratio) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        if (ratio < 0.0) {
            throw new CliParserBase.IllegalOptionException("'--cpus' value should not be negative");
        }
        int DEFAULT_PERIOD = 100000;
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuPeriod(Long.valueOf(DEFAULT_PERIOD)).withCpuQuota(Long.valueOf((int)(ratio * (double)DEFAULT_PERIOD)));
        return Unit.INSTANCE;
    }

    private static final void cpus$lambda$30(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit blkioWeight$lambda$31(CreateContainerCmd cmd, Integer value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withBlkioWeight(value);
        return Unit.INSTANCE;
    }

    private static final void blkioWeight$lambda$32(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit oomKillDisable$lambda$33(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withOomKillDisable(value);
        return Unit.INSTANCE;
    }

    private static final void oomKillDisable$lambda$34(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$35(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$36(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void attach$lambda$37(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void tty$lambda$38(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final String env$lambda$39(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void env$lambda$40(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit entrypoint$lambda$41(CreateContainerCmd obj, String entrypoint) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String[] stringArray = new String[]{entrypoint};
        obj.withEntrypoint(stringArray);
        return Unit.INSTANCE;
    }

    private static final void entrypoint$lambda$42(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void workingDir$lambda$43(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addHost$lambda$44(CreateContainerCmd cmd, String[] values) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withExtraHosts(Arrays.copyOf(values, values.length));
        return Unit.INSTANCE;
    }

    private static final void addHost$lambda$45(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Map label$lambda$46(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final void label$lambda$47(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit securityOpt$lambda$48(CreateContainerCmd cmd, String[] values) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withSecurityOpts((List)new ArrayList(CollectionsKt.listOf((Object[])Arrays.copyOf(values, values.length))));
        return Unit.INSTANCE;
    }

    private static final void securityOpt$lambda$49(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void link$lambda$50(CreateContainerCmd cmd, List value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withLinks(value);
    }

    private static final LxcConf lxcConf$lambda$53(Option $option, String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        CharSequence charSequence = source;
        Regex regex = new Regex("=");
        int n = 2;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length == 2) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv = parts[0];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = parts[1];
            String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string3 = string;
            return new LxcConf(string3, string2);
        }
        throw new CliParserBase.IllegalOptionException($option, source);
    }

    private static final Unit lxcConf$lambda$54(CreateContainerCmd cmd, LxcConf[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withLxcConf(value);
        return Unit.INSTANCE;
    }

    private static final void lxcConf$lambda$55(Function2 $tmp0, Object p0, LxcConf[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void macAddress$lambda$56(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit publish$lambda$58(CreateContainerCmd cmd, DockerPortSpec[] specs) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        Ports ports = new Ports();
        for (DockerPortSpec nextSpec : specs) {
            Map<ExposedPort, Ports.Binding> bindings;
            Map<ExposedPort, Ports.Binding> $this$forEach$iv = bindings = nextSpec.toNativeMap(ExposeHandler.Companion.getNewExposedPort(), Ports.Binding::new);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ExposedPort, Ports.Binding>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ExposedPort, Ports.Binding> element$iv;
                Map.Entry<ExposedPort, Ports.Binding> entry = element$iv = iterator.next();
                boolean bl = false;
                ExposedPort port = entry.getKey();
                Ports.Binding binding = entry.getValue();
                ports.bind(port, binding);
            }
        }
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPortBindings(ports);
        return Unit.INSTANCE;
    }

    private static final void publish$lambda$59(Function2 $tmp0, Object p0, DockerPortSpec[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit publishAll$lambda$60(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPublishAllPorts(value);
        return Unit.INSTANCE;
    }

    private static final void publishAll$lambda$61(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit privileged$lambda$62(CreateContainerCmd cmd, Boolean value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withPrivileged(value);
        return Unit.INSTANCE;
    }

    private static final void privileged$lambda$63(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit readOnlyRootfs$lambda$64(CreateContainerCmd cmd, Boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withReadonlyRootfs(enabled);
        return Unit.INSTANCE;
    }

    private static final void readOnlyRootfs$lambda$65(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit healthCmd$lambda$66(CreateContainerCmd cmd, String text) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object[] objectArray = new String[]{"CMD-SHELL", text};
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withTest(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final void healthCmd$lambda$67(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit noHealthcheck$lambda$68(CreateContainerCmd cmd, Boolean bl) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withTest(CollectionsKt.listOf((Object)"NONE"));
        return Unit.INSTANCE;
    }

    private static final void noHealthcheck$lambda$69(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit healthInterval$lambda$70(CreateContainerCmd cmd, Long nanos) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withInterval(nanos);
        return Unit.INSTANCE;
    }

    private static final void healthInterval$lambda$71(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit healthRetries$lambda$72(CreateContainerCmd cmd, Integer integer) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withRetries(integer);
        return Unit.INSTANCE;
    }

    private static final void healthRetries$lambda$73(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit healthStartPeriod$lambda$74(CreateContainerCmd cmd, Long nanos) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withStartPeriod(nanos);
        return Unit.INSTANCE;
    }

    private static final void healthStartPeriod$lambda$75(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit healthTimeout$lambda$76(CreateContainerCmd cmd, Long nanos) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHealthcheck(cmd).withTimeout(nanos);
        return Unit.INSTANCE;
    }

    private static final void healthTimeout$lambda$77(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit dns$lambda$78(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDns(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void dns$lambda$79(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit dnsSearch$lambda$80(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDnsSearch(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void dnsSearch$lambda$81(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final VolumesFrom volumesFrom$lambda$82(Function1 $tmp0, Object p0) {
        return (VolumesFrom)$tmp0.invoke(p0);
    }

    private static final Unit volumesFrom$lambda$83(CreateContainerCmd cmd, VolumesFrom[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withVolumesFrom(Arrays.copyOf(value, value.length));
        return Unit.INSTANCE;
    }

    private static final void volumesFrom$lambda$84(Function2 $tmp0, Object p0, VolumesFrom[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit cidfile$lambda$85(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withContainerIDFile(value);
        return Unit.INSTANCE;
    }

    private static final void cidfile$lambda$86(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void platform$lambda$87(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit capAdd$lambda$88(CreateContainerCmd cmd, Capability[] cap) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCapAdd(Arrays.copyOf(cap, cap.length));
        return Unit.INSTANCE;
    }

    private static final Unit capDrop$lambda$89(CreateContainerCmd cmd, Capability[] cap) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCapDrop(Arrays.copyOf(cap, cap.length));
        return Unit.INSTANCE;
    }

    private static final Unit cpuRealtimeRuntime$lambda$90(CreateContainerCmd cmd, long microseconds) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCpuRealtimeRuntime(Long.valueOf(microseconds));
        return Unit.INSTANCE;
    }

    private static final void cpuRealtimeRuntime$lambda$91(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit restart$lambda$92(CreateContainerCmd cmd, String restart) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withRestartPolicy(RestartPolicy.parse((String)restart));
        return Unit.INSTANCE;
    }

    private static final void restart$lambda$93(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit networkAlias$lambda$94(CreateContainerCmd obj, String[] aliases) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)aliases, (String)"aliases");
        obj.withAliases(Arrays.copyOf(aliases, aliases.length));
        return Unit.INSTANCE;
    }

    private static final void networkAlias$lambda$95(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final void ip$lambda$96(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void ip6$lambda$97(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Device device$lambda$98(String deviceStr) {
        Intrinsics.checkNotNullParameter((Object)deviceStr, (String)"deviceStr");
        return Device.parse((String)deviceStr);
    }

    private static final Device device$lambda$99(Function1 $tmp0, Object p0) {
        return (Device)$tmp0.invoke(p0);
    }

    private static final Unit device$lambda$100(CreateContainerCmd cmd, Device[] devices) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)devices, (String)"devices");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withDevices(Arrays.copyOf(devices, devices.length));
        return Unit.INSTANCE;
    }

    private static final void device$lambda$101(Function2 $tmp0, Object p0, Device[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit runtime$lambda$102(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withRuntime(value);
        return Unit.INSTANCE;
    }

    private static final void runtime$lambda$103(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit ipc$lambda$104(CreateContainerCmd cmd, String ipcMode) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withIpcMode(ipcMode);
        return Unit.INSTANCE;
    }

    private static final void ipc$lambda$105(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit deviceCgroupRuleHandler$lambda$106(CreateContainerCmd cmd, String value) {
        List list;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        HostConfig config = DockerRunCliParser.Companion.findOrCreateHostConfig(cmd);
        Object[] objectArray = new String[]{value};
        List newRules = CollectionsKt.plus((Collection)CollectionsKt.mutableListOf((Object[])objectArray), (Iterable)((list = config.getDeviceCgroupRules()) != null && (list = CollectionsKt.filterNotNull((Iterable)list)) != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList()));
        config.withDeviceCgroupRules(newRules);
        return Unit.INSTANCE;
    }

    private static final void deviceCgroupRuleHandler$lambda$107(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit groupAdd$lambda$108(CreateContainerCmd cmd, String[] value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withGroupAdd(CollectionsKt.listOf((Object[])Arrays.copyOf(value, value.length)));
        return Unit.INSTANCE;
    }

    private static final void groupAdd$lambda$109(Function2 $tmp0, Object p0, String[] p1) {
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit cgroupParent$lambda$110(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withCgroupParent(value);
        return Unit.INSTANCE;
    }

    private static final void cgroupParent$lambda$111(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit sysctl$lambda$112(Option $option, CreateContainerCmd cmd, String keyValuePair) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        CharSequence charSequence = keyValuePair;
        if (charSequence == null || charSequence.length() == 0) {
            throw new CliParserBase.IllegalOptionException($option, keyValuePair);
        }
        Object object = keyValuePair;
        Regex regex = new Regex("=");
        int n = 2;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length != 2) {
            throw new CliParserBase.IllegalOptionException($option, keyValuePair);
        }
        HostConfig hostConfig = DockerRunCliParser.Companion.findOrCreateHostConfig(cmd);
        Map allSysctls = hostConfig.getSysctls();
        if (allSysctls == null) {
            allSysctls = new HashMap();
            hostConfig.withSysctls(allSysctls);
        }
        allSysctls.put(parts[0], parts[1]);
        return Unit.INSTANCE;
    }

    private static final void sysctl$lambda$113(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit userns$lambda$114(CreateContainerCmd cmd, String value) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        DockerRunCliParser.Companion.findOrCreateHostConfig(cmd).withUsernsMode(value);
        return Unit.INSTANCE;
    }

    private static final void userns$lambda$115(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion;", "", "<init>", "()V", "appendSystemValueIfFound", "", "varDeclaration", "appendToCmdEnvironment", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "env", "", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[Ljava/lang/String;)V", "getOrCreateLogConfig", "Lcom/github/dockerjava/api/model/LogConfig;", "findOrCreateHealthcheck", "Lcom/github/dockerjava/api/model/HealthCheck;", "findOrCreateHostConfig", "Lcom/github/dockerjava/api/model/HostConfig;", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n+ 2 ValueTransfer.kt\ncom/intellij/docker/agent/ValueTransfer$CombiningListTransfer$Companion\n*L\n1#1,692:1\n48#2,4:693\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$Companion\n*L\n654#1:693,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String appendSystemValueIfFound(String varDeclaration) {
            Object object;
            if (!StringsKt.contains$default((CharSequence)varDeclaration, (CharSequence)"=", (boolean)false, (int)2, null)) {
                String localSystemValue;
                String string = InternalUtilsKt.nullize(System.getenv(varDeclaration));
                if (string == null) {
                    string = InternalUtilsKt.nullize(System.getProperty(varDeclaration));
                }
                object = (localSystemValue = string) != null ? varDeclaration + "=" + localSystemValue : varDeclaration;
            } else {
                object = varDeclaration;
            }
            return object;
        }

        private final void appendToCmdEnvironment(CreateContainerCmd cmd, String[] env2) {
            ValueTransfer.CombiningListTransfer.Companion this_$iv = ValueTransfer.CombiningListTransfer.Companion;
            boolean $i$f$mergeArrays = false;
            new ValueTransfer.CombiningListTransfer((Function1)new Function1<String[], List<? extends String>>(env2){
                final /* synthetic */ String[] $env$inlined;
                {
                    this.$env$inlined = stringArray;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final List invoke(Object it) {
                    String[] it2 = (String[])it;
                    boolean bl = false;
                    Object[] objectArray = this.$env$inlined;
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function1)new Function1<CreateContainerCmd, List<? extends String>>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final List invoke(Object it) {
                    CreateContainerCmd p0 = (CreateContainerCmd)it;
                    boolean bl = false;
                    Object[] objectArray = p0.getEnv();
                    return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
                }
            }, (Function2)new Function2<CreateContainerCmd, List<? extends String>, Object>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object invoke(Object trg, List list) {
                    void array;
                    Intrinsics.checkNotNullParameter((Object)list, (String)"list");
                    Collection $this$toTypedArray$iv = list;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    CreateContainerCmd target2 = (CreateContainerCmd)trg;
                    boolean bl = false;
                    CreateContainerCmd createContainerCmd = target2.withEnv((String[])Arrays.copyOf(array, ((void)array).length));
                    Intrinsics.checkNotNullExpressionValue((Object)createContainerCmd, (String)"withEnv(...)");
                    return createContainerCmd;
                }
            }).transferFromTo(env2, cmd);
        }

        private final LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
            HostConfig hostConfig = this.findOrCreateHostConfig(cmd);
            LogConfig result2 = hostConfig.getLogConfig();
            if (result2 == null) {
                result2 = new LogConfig();
            }
            hostConfig.withLogConfig(result2);
            return result2;
        }

        private final HealthCheck findOrCreateHealthcheck(CreateContainerCmd cmd) {
            HealthCheck result2 = cmd.getHealthcheck();
            if (result2 == null) {
                result2 = new HealthCheck();
                cmd.withHealthcheck(result2);
            }
            return result2;
        }

        private final HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
            HostConfig result2 = cmd.getHostConfig();
            if (result2 == null) {
                result2 = new HostConfig();
                cmd.withHostConfig(result2);
            }
            return result2;
        }

        public static final /* synthetic */ String access$appendSystemValueIfFound(Companion $this, String varDeclaration) {
            return $this.appendSystemValueIfFound(varDeclaration);
        }

        public static final /* synthetic */ void access$appendToCmdEnvironment(Companion $this, CreateContainerCmd cmd, String[] env2) {
            $this.appendToCmdEnvironment(cmd, env2);
        }

        public static final /* synthetic */ LogConfig access$getOrCreateLogConfig(Companion $this, CreateContainerCmd cmd) {
            return $this.getOrCreateLogConfig(cmd);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \t2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler;", "Lcom/intellij/docker/agent/cli/model/CliParserBase$MappedListHandler;", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "option", "Lorg/apache/commons/cli/Option;", "<init>", "(Lorg/apache/commons/cli/Option;)V", "Companion", "intellij.clouds.docker.agent"})
    private static final class ExposeHandler
    extends CliParserBase.MappedListHandler<CreateContainerCmd, ExposedPort[]> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final BiFunction<String, Integer, ExposedPort> newExposedPort = ExposeHandler::newExposedPort$lambda$1;

        public ExposeHandler(@NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            super(option, ExposedPort[].class, arg_0 -> ExposeHandler._init_$lambda$0(option, arg_0), (arg_0, arg_1) -> Companion.access$applyToCmd(Companion, arg_0, arg_1));
        }

        private static final ExposedPort[] _init_$lambda$0(Option $option, String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return ExposeHandler.Companion.parseFromString($option, text);
        }

        private static final ExposedPort newExposedPort$lambda$1(String protocol, int port) {
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            String string = protocol.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return new ExposedPort(port, InternetProtocol.valueOf((String)string));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011R#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion;", "", "<init>", "()V", "parseFromString", "", "Lcom/github/dockerjava/api/model/ExposedPort;", "option", "Lorg/apache/commons/cli/Option;", "text", "", "(Lorg/apache/commons/cli/Option;Ljava/lang/String;)[Lcom/github/dockerjava/api/model/ExposedPort;", "applyToCmd", "", "cmd", "Lcom/github/dockerjava/api/command/CreateContainerCmd;", "parsedArray", "(Lcom/github/dockerjava/api/command/CreateContainerCmd;[[Lcom/github/dockerjava/api/model/ExposedPort;)V", "newExposedPort", "Ljava/util/function/BiFunction;", "", "getNewExposedPort", "()Ljava/util/function/BiFunction;", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\nDockerRunCliParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,692:1\n37#2:693\n36#2,3:694\n37#2:703\n36#2,3:704\n10135#3:697\n10557#3,5:698\n*S KotlinDebug\n*F\n+ 1 DockerRunCliParser.kt\ncom/intellij/docker/agent/cli/model/DockerRunCliParser$ExposeHandler$Companion\n*L\n231#1:693\n231#1:694,3\n239#1:703\n239#1:704,3\n239#1:697\n239#1:698,5\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final ExposedPort[] parseFromString(Option option, String text) {
                try {
                    Collection $this$toTypedArray$iv = DockerPortSpec.ContainerPortsSpec.Companion.fromString(text).toNativeList(this.getNewExposedPort());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new ExposedPort[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new CliParserBase.IllegalOptionException(option, text, e);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void applyToCmd(CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                void $this$toTypedArray$iv;
                void $this$flatMapTo$iv$iv;
                Object $this$flatMap$iv = (Object[])parsedArray;
                boolean $i$f$flatMap = false;
                Object[] objectArray = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                    Object[] it = (ExposedPort[])element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ArraysKt.toList((Object[])it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ExposedPort[] flattenedPorts = thisCollection$iv.toArray(new ExposedPort[0]);
                cmd.withExposedPorts(Arrays.copyOf(flattenedPorts, flattenedPorts.length));
            }

            @NotNull
            public final BiFunction<String, Integer, ExposedPort> getNewExposedPort() {
                return newExposedPort;
            }

            public static final /* synthetic */ void access$applyToCmd(Companion $this, CreateContainerCmd cmd, ExposedPort[][] parsedArray) {
                $this.applyToCmd(cmd, parsedArray);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

