/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BootstrapClassLoaderUtil {
    private BootstrapClassLoaderUtil() {
    }

    @NotNull
    public static Collection<Path> getProductClassPath() throws IOException {
        Path distDir = Path.of(PathManager.getHomePath(), new String[0]);
        Path libDir = distDir.resolve("lib");
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>();
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty("java.class.path"), classpath);
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRootPath = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRootPath != null);
        Path selfRoot = Path.of(selfRootPath, new String[0]);
        classpath.add(selfRoot);
        BootstrapClassLoaderUtil.addLibraries(classpath, libDir, selfRoot);
        BootstrapClassLoaderUtil.addLibraries(classpath, libDir.resolve("ant/lib"), null);
        LinkedHashSet<Path> linkedHashSet = classpath;
        if (linkedHashSet == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private static void addLibraries(@NotNull Collection<Path> classPath, @NotNull Path fromDir, @Nullable Path selfRoot) throws IOException {
        if (classPath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(1);
        }
        if (fromDir == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(2);
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(fromDir);){
            for (Path file : dirStream) {
                String path2 = file.toString();
                int lastDotIndex = path2.length() - 4;
                if (lastDotIndex <= 0 || path2.charAt(lastDotIndex) != '.' || !path2.regionMatches(true, lastDotIndex + 1, "jar", 0, 3) && !path2.regionMatches(true, lastDotIndex + 1, "zip", 0, 3) || selfRoot != null && selfRoot.equals(file)) continue;
                classPath.add(file);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static void parseClassPathString(@Nullable String pathString, @NotNull Collection<? super Path> classpath) {
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(3);
        }
        if (pathString == null || pathString.isEmpty()) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ",", false);
        while (tokenizer.hasMoreTokens()) {
            classpath.add(Path.of(tokenizer.nextToken(), new String[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/gateway/impl/BootstrapClassLoaderUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductClassPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/gateway/impl/BootstrapClassLoaderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addLibraries";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseClassPathString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

