/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.unsupported.UnsupportedKt;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.CompositeFigureLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.FigureLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Style;
import org.jetbrains.letsPlot.core.plot.builder.subPlots.CompositeFigureSvgComponent;
import org.jetbrains.letsPlot.core.plot.builder.subPlots.CompositeFigureSvgRoot;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BY\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016JX\u0010 \u001a\u00020!2N\u0010\"\u001aJ\u0012\u001f\u0012\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00030\u0003\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020)0(\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020)0#H\u0016J\u0010\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/core/util/CompositeFigureBuildInfo;", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "elements", "", "layout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/CompositeFigureLayout;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "title", "", "subtitle", "caption", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "computationMessages", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/CompositeFigureLayout;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Ljava/util/List;)V", "_layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/FigureLayoutInfo;", "getBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getComputationMessages", "()Ljava/util/List;", "containsLiveMap", "", "getContainsLiveMap", "()Z", "isComposite", "layoutInfo", "getLayoutInfo", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/FigureLayoutInfo;", "createSvgRoot", "Lorg/jetbrains/letsPlot/core/plot/builder/subPlots/CompositeFigureSvgRoot;", "injectLiveMapProvider", "", "f", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "Lkotlin/ParameterName;", "name", "tiles", "", "", "spec", "layoutedByGeomBounds", "geomBounds", "layoutedByOuterSize", "withBounds", "withPreferredSize", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nCompositeFigureBuildInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeFigureBuildInfo.kt\norg/jetbrains/letsPlot/core/util/CompositeFigureBuildInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1747#2,3:132\n1855#2,2:135\n1549#2:138\n1620#2,3:139\n1549#2:142\n1620#2,3:143\n2730#2,7:146\n1#3:137\n*S KotlinDebug\n*F\n+ 1 CompositeFigureBuildInfo.kt\norg/jetbrains/letsPlot/core/util/CompositeFigureBuildInfo\n*L\n38#1:132,3\n44#1:135,2\n51#1:138\n51#1:139,3\n98#1:142\n98#1:143,3\n99#1:146,7\n*E\n"})
public final class CompositeFigureBuildInfo
implements FigureBuildInfo {
    @NotNull
    private final List<FigureBuildInfo> elements;
    @NotNull
    private final CompositeFigureLayout layout;
    @NotNull
    private final DoubleRectangle bounds;
    @Nullable
    private final String title;
    @Nullable
    private final String subtitle;
    @Nullable
    private final String caption;
    @NotNull
    private final Theme theme;
    @NotNull
    private final List<String> computationMessages;
    private final boolean isComposite;
    private FigureLayoutInfo _layoutInfo;

    public CompositeFigureBuildInfo(@NotNull List<? extends FigureBuildInfo> elements, @NotNull CompositeFigureLayout layout, @NotNull DoubleRectangle bounds, @Nullable String title, @Nullable String subtitle, @Nullable String caption, @NotNull Theme theme2, @NotNull List<String> computationMessages) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
        Intrinsics.checkNotNullParameter(computationMessages, (String)"computationMessages");
        this.elements = elements;
        this.layout = layout;
        this.bounds = bounds;
        this.title = title;
        this.subtitle = subtitle;
        this.caption = caption;
        this.theme = theme2;
        this.computationMessages = computationMessages;
        this.isComposite = true;
    }

    @Override
    @NotNull
    public DoubleRectangle getBounds() {
        return this.bounds;
    }

    @Override
    @NotNull
    public List<String> getComputationMessages() {
        return this.computationMessages;
    }

    @Override
    public boolean isComposite() {
        return this.isComposite;
    }

    @Override
    @NotNull
    public FigureLayoutInfo getLayoutInfo() {
        FigureLayoutInfo figureLayoutInfo = this._layoutInfo;
        if (figureLayoutInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_layoutInfo");
            figureLayoutInfo = null;
        }
        return figureLayoutInfo;
    }

    @Override
    public boolean getContainsLiveMap() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)this.elements);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FigureBuildInfo it = (FigureBuildInfo)element$iv;
                    boolean bl2 = false;
                    if (!it.getContainsLiveMap()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void injectLiveMapProvider(@NotNull Function2<? super List<? extends List<? extends GeomLayer>>, ? super Map<String, ? extends Object>, ? extends Object> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)this.elements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FigureBuildInfo it = (FigureBuildInfo)element$iv;
            boolean bl = false;
            it.injectLiveMapProvider(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeFigureSvgRoot createSvgRoot() {
        void $this$mapTo$iv$iv;
        if (!(this._layoutInfo != null)) {
            boolean $i$a$-check-CompositeFigureBuildInfo$createSvgRoot$22 = false;
            String $i$a$-check-CompositeFigureBuildInfo$createSvgRoot$22 = "Composite figure is not layouted.";
            throw new IllegalStateException($i$a$-check-CompositeFigureBuildInfo$createSvgRoot$22.toString());
        }
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)this.elements);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FigureBuildInfo figureBuildInfo = (FigureBuildInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createSvgRoot());
        }
        List elementSvgRoots = (List)destination$iv$iv;
        DoubleVector overalSize = this.getLayoutInfo().getFigureSize();
        DoubleRectangle elementsAreaBounds = this.getLayoutInfo().getGeomAreaBounds();
        CompositeFigureSvgComponent svgComponent2 = new CompositeFigureSvgComponent(elementSvgRoots, overalSize, elementsAreaBounds, this.title, this.subtitle, this.caption, this.theme, Style.INSTANCE.fromTheme(this.theme, false));
        return new CompositeFigureSvgRoot(svgComponent2, this.getBounds());
    }

    @Override
    @NotNull
    public CompositeFigureBuildInfo withBounds(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return Intrinsics.areEqual((Object)bounds, (Object)this.getBounds()) ? this : new CompositeFigureBuildInfo(this.elements, this.layout, bounds, this.title, this.subtitle, this.caption, this.theme, this.getComputationMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeFigureBuildInfo layoutedByOuterSize() {
        CompositeFigureBuildInfo compositeFigureBuildInfo;
        DoubleRectangle doubleRectangle;
        Object v0;
        void $this$reduceOrNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        PlotTheme plotTheme = this.theme.plot();
        DoubleRectangle contextBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.getBounds().getDimension());
        DoubleRectangle withoutMargins = plotTheme.layoutMargins().shrinkRect(contextBounds);
        DoubleRectangle withoutTitles = PlotLayoutUtil.INSTANCE.boundsWithoutTitleAndCaption(withoutMargins, this.title, this.subtitle, this.caption, this.theme);
        DoubleRectangle elementsAreaBounds = plotTheme.plotInset().shrinkRect(withoutTitles);
        List<FigureBuildInfo> layoutedElements = this.layout.doLayout(elementsAreaBounds, this.elements);
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)layoutedElements);
        boolean $i$f$map = false;
        void var11_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FigureBuildInfo figureBuildInfo = (FigureBuildInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBounds());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void el;
                DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
                DoubleRectangle acc = (DoubleRectangle)accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.union((DoubleRectangle)el);
            }
            v0 = accumulator$iv;
        }
        if ((doubleRectangle = (DoubleRectangle)v0) == null) {
            doubleRectangle = contextBounds;
        }
        DoubleRectangle layoutedElementsAreaBounds = doubleRectangle;
        CompositeFigureBuildInfo $this$layoutedByOuterSize_u24lambda_u246 = compositeFigureBuildInfo = new CompositeFigureBuildInfo(layoutedElements, this.layout, this.getBounds(), this.title, this.subtitle, this.caption, this.theme, this.getComputationMessages());
        boolean bl = false;
        $this$layoutedByOuterSize_u24lambda_u246._layoutInfo = new FigureLayoutInfo(contextBounds.getDimension(), layoutedElementsAreaBounds);
        return compositeFigureBuildInfo;
    }

    @Override
    @NotNull
    public CompositeFigureBuildInfo layoutedByGeomBounds(@NotNull DoubleRectangle geomBounds) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        UnsupportedKt.UNSUPPORTED("Composite figure does not support layouting by \"geometry bounds\".");
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public FigureBuildInfo withPreferredSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return new CompositeFigureBuildInfo(this.elements, this.layout, new DoubleRectangle(DoubleVector.Companion.getZERO(), size2), this.title, this.subtitle, this.caption, this.theme, this.getComputationMessages());
    }
}

