/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialog;
import com.intellij.database.cli.dump.DumpConfigurationsHolder;
import com.intellij.database.cli.restore.RestoreConfigurationsHolder;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseCliAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DatabaseCliAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseCliAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        LocalDataSource dataSource = DatabaseCliAction.getDataSource(e);
        CliConfigurationPack configurations = dataSource == null ? null : this.getConfigurations(dataSource);
        List selected = DatabaseCliAction.getSelectedElements(e.getDataContext()).toList();
        CliConfigurationPack filtered = configurations == null ? null : configurations.filtered(selected);
        boolean enabled = project != null && configurations != null && DatabaseCliAction.isHostAndPortExists(dataSource) && !filtered.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(this.getText(filtered, (DasDataSource)dataSource, true));
        }
    }

    @NlsActions.ActionText
    @NotNull
    protected abstract String getText(String var1);

    @Nullable
    public abstract CliConfigurationPack getConfigurations(@NotNull LocalDataSource var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalDataSource dataSource;
        if (e == null) {
            DatabaseCliAction.$$$reportNull$$$0(2);
        }
        if ((dataSource = DatabaseCliAction.getDataSource(e)) == null) {
            return;
        }
        List selected = DatabaseCliAction.getSelectedElements(e.getDataContext()).toList();
        CliConfigurationPack configurations = Objects.requireNonNull(this.getConfigurations(dataSource)).filtered(selected);
        Project project = Objects.requireNonNull(e.getProject());
        String dialogTitle = this.getText(configurations, (DasDataSource)dataSource, false);
        CliDialog dialog = new CliDialog(project, dataSource, selected, configurations, dialogTitle);
        dialog.show();
    }

    @NlsContexts.DialogTitle
    @NotNull
    private String getText(@NotNull CliConfigurationPack configurations, @NotNull DasDataSource system, boolean action) {
        if (configurations == null) {
            DatabaseCliAction.$$$reportNull$$$0(3);
        }
        if (system == null) {
            DatabaseCliAction.$$$reportNull$$$0(4);
        }
        String string = this.getOneConfigurationText(configurations, action) + (action ? "" : String.format(" (%s)", system.getName()));
        if (string == null) {
            DatabaseCliAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsActions.ActionText
    @NotNull
    private String getOneConfigurationText(@NotNull CliConfigurationPack configurations, boolean action) {
        if (configurations == null) {
            DatabaseCliAction.$$$reportNull$$$0(6);
        }
        String text = StringUtil.join(configurations.getConfigurations(), c2 -> action ? "'" + StringUtil.escapeMnemonics((String)c2.getName()) + "'" : c2.getName(), (String)"/");
        String string = this.getText(text);
        if (string == null) {
            DatabaseCliAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DatabaseCliAction.$$$reportNull$$$0(8);
        }
        JBIterable<DbElement> jBIterable = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
        if (jBIterable == null) {
            DatabaseCliAction.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        String url;
        if (source == null) {
            DatabaseCliAction.$$$reportNull$$$0(10);
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        String string = url = config == null ? null : config.getUrl();
        if (url == null || driver == null) {
            return false;
        }
        List parsers = driver.getJDBCUrlParsers();
        return !JdbcUrlParserUtil.extractHostsPorts((Collection)parsers, (String)url, (Ref)Ref.create()).isEmpty();
    }

    @Nullable
    private static LocalDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseCliAction.$$$reportNull$$$0(11);
        }
        return (LocalDataSource)JBIterable.of((Object[])((PsiElement[])e.getData(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY))).filterMap(o -> o instanceof DbElement ? ((DbElement)o).getDataSource() : null).filterMap(DbImplUtilCore::getMaybeLocalDataSource).unique().single();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOneConfigurationText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOneConfigurationText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHostAndPortExists";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static class Restore
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Restore.$$$reportNull$$$0(0);
            }
            return dataSource.isReadOnly() ? null : RestoreConfigurationsHolder.of(dataSource.getDbms());
        }

        @Override
        @NotNull
        protected String getText(String param) {
            String string = DatabaseBundle.message((String)"restore.with", (Object[])new Object[]{param});
            if (string == null) {
                Restore.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction$Restore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction$Restore";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class Dump
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Dump.$$$reportNull$$$0(0);
            }
            return DumpConfigurationsHolder.of(dataSource.getDbms());
        }

        @Override
        @NotNull
        protected String getText(String param) {
            String string = DatabaseBundle.message((String)"dump.with", (Object[])new Object[]{param});
            if (string == null) {
                Dump.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DatabaseCliAction$Dump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DatabaseCliAction$Dump";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

