/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.suppression;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.inspections.suppression.SqlFileSuppressInspectionFix;
import com.intellij.sql.inspections.suppression.SqlInspectionSuppressorDelegate;
import com.intellij.sql.inspections.suppression.SqlStatementSuppressInspectionFix;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlInspectionSuppressor
implements InspectionSuppressor {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*(@ (.+))?");

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(1);
        }
        if (!(element instanceof SqlElement) && !(element.getParent() instanceof SqlElement)) {
            return false;
        }
        if (SqlInspectionSuppressorDelegate.Companion.isSuppressedFor(element, toolId)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        Condition<PsiElement> fileState = SqlInspectionSuppressor.getSuppressionsForFile((PsiElement)file, file).get(toolId);
        if (fileState != null && fileState.value((Object)element)) {
            return true;
        }
        SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class, (boolean)false);
        if (statement2 == null) {
            return false;
        }
        Condition<PsiElement> statementState = SqlInspectionSuppressor.getSuppressionsForStatement(statement2).get(toolId);
        return statementState != null && statementState.value((Object)element);
    }

    @Nullable
    private static Condition<PsiElement> findSuppressionAmongLeaves(@Nullable PsiElement root, @NotNull String toolId, int prefixLength) {
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SyntaxTraverser.ApiEx api = root instanceof PsiFile ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        return (Condition)SqlInspectionSuppressor.leafs(root, (SyntaxTraverser.ApiEx<PsiElement>)api).takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment).filterMap(e -> SqlInspectionSuppressor.getSuppressionState(e, toolId, prefixLength)).reduce((c1, c2) -> Conditions.or((Condition)c1, (Condition)c2));
    }

    private static Map<String, Condition<PsiElement>> getSuppressionsForFile(@NotNull PsiElement element, @NotNull PsiFile file) {
        if (element == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(4);
        }
        return SqlInspectionSuppressor.getSuppressions(element, (Function<String, Condition<PsiElement>>)((Function)id -> SqlInspectionSuppressor.findSuppressionAmongLeaves((PsiElement)file, id + "ForFile", SqlInspectionSuppressor.prefixLength((PsiElement)file))));
    }

    private static Map<String, Condition<PsiElement>> getSuppressionsForStatement(@NotNull SqlStatement statement2) {
        if (statement2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(5);
        }
        return SqlInspectionSuppressor.getSuppressions((PsiElement)statement2, (Function<String, Condition<PsiElement>>)((Function)id -> {
            SqlStatement currentElement = statement2;
            while (currentElement != null) {
                int prefixLength = SqlInspectionSuppressor.prefixLength((PsiElement)currentElement);
                PsiElement first2 = currentElement.getFirstChild() instanceof PsiComment ? currentElement.getFirstChild() : SqlInspectionSuppressor.nextLeaf((PsiElement)currentElement, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed());
                Condition<PsiElement> state = SqlInspectionSuppressor.findSuppressionAmongLeaves(first2, id, prefixLength);
                if (state != null) {
                    return state;
                }
                currentElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, SqlStatement.class);
            }
            return null;
        }));
    }

    private static Map<String, Condition<PsiElement>> getSuppressions(@NotNull PsiElement element, @NotNull Function<String, Condition<PsiElement>> compute2) {
        if (element == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(6);
        }
        if (compute2 == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(7);
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap((Function)compute2), (Object[])new Object[]{element.getContainingFile()}));
    }

    @Nullable
    private static ObjectPath getSuppressionPath(@Nullable PsiElement element) {
        PsiElement parent;
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (!(parent instanceof SqlIdentifier)) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof SqlReferenceExpression)) {
            return null;
        }
        SqlReferenceExpression referenceExpression = (SqlReferenceExpression)grandParent;
        ObjectKind kind = referenceExpression.getReferenceElementType().getTargetKind();
        String name2 = referenceExpression.getName();
        return ObjectPath.create((String)name2, (ObjectKind)kind);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        ObjectPath path;
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(8);
        }
        if ((path = SqlInspectionSuppressor.getSuppressionPath(element)) != null) {
            SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SqlStatementSuppressInspectionFix(toolId, null), new SqlStatementSuppressInspectionFix(toolId, path), new SqlFileSuppressInspectionFix(toolId, null), new SqlFileSuppressInspectionFix(toolId, path)};
            if (suppressQuickFixArray == null) {
                SqlInspectionSuppressor.$$$reportNull$$$0(9);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SqlStatementSuppressInspectionFix(toolId, null), new SqlFileSuppressInspectionFix(toolId, null)};
        if (suppressQuickFixArray == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(10);
        }
        return suppressQuickFixArray;
    }

    @NotNull
    private static JBIterable<PsiElement> leafs(@Nullable PsiElement element, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = JBIterable.generate((Object)SqlInspectionSuppressor.firstLeaf(element, api), e -> SqlInspectionSuppressor.nextLeaf(e, api));
        if (jBIterable == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement firstLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(13);
        }
        PsiElement next = e;
        while (next != null) {
            PsiElement first2 = (PsiElement)api.first((Object)next);
            if (first2 == null) {
                if (next.getTextLength() > 0) break;
                next = (PsiElement)api.next((Object)next);
                continue;
            }
            next = first2;
        }
        return next;
    }

    @Nullable
    private static PsiElement nextLeaf(@Nullable PsiElement e, @NotNull SyntaxTraverser.ApiEx<PsiElement> api) {
        if (api == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(14);
        }
        PsiElement p2 = e;
        while (p2 != null) {
            PsiElement next = SqlInspectionSuppressor.firstLeaf((PsiElement)api.next((Object)p2), api);
            if (next != null) {
                return next;
            }
            p2 = (PsiElement)api.parent((Object)p2);
        }
        return null;
    }

    private static boolean matchesPath(@NotNull PsiElement originalElement, @NotNull ObjectPath targetPath) {
        if (originalElement == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(15);
        }
        if (targetPath == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(16);
        }
        if (!(originalElement instanceof SqlIdentifier)) {
            return false;
        }
        PsiElement parent = originalElement.getParent();
        if (!(parent instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlReferenceExpression referenceExpression = (SqlReferenceExpression)parent;
        ObjectKind kind = referenceExpression.getReferenceElementType().getTargetKind();
        String name2 = referenceExpression.getName();
        return kind.equals(targetPath.kind) && name2.equals(targetPath.name);
    }

    @Nullable
    private static Condition<PsiElement> getSuppressionState(@Nullable PsiElement e, @NotNull String toolId, int prefixLength) {
        if (toolId == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(17);
        }
        if (!(e instanceof PsiComment)) {
            return null;
        }
        for (String line : StringUtil.splitByLines((String)e.getText())) {
            Matcher m;
            if (line.length() < prefixLength || !(m = SUPPRESS_PATTERN.matcher(line.substring(prefixLength))).matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)m.group(1), (String)toolId)) continue;
            int groupCount = m.groupCount();
            String targetPathStr = groupCount > 1 ? m.group(groupCount) : null;
            ObjectPath targetPath = targetPathStr != null ? ObjectPath.deserialize((String)targetPathStr.trim()) : null;
            return targetPath != null ? element -> SqlInspectionSuppressor.matchesPath(element, targetPath) : Conditions.alwaysTrue();
        }
        return null;
    }

    private static int prefixLength(@NotNull PsiElement element) {
        Commenter commenter;
        if (element == null) {
            SqlInspectionSuppressor.$$$reportNull$$$0(18);
        }
        String prefix = (String)ObjectUtils.notNull((Object)((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getContainingFile().getLanguage())) == null ? null : commenter.getLineCommentPrefix()), (Object)"");
        return prefix.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/suppression/SqlInspectionSuppressor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "leafs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSuppressionAmongLeaves";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionsForStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "leafs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "firstLeaf";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nextLeaf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matchesPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prefixLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

