/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.parser;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pro.cython.parser.CythonDeclParsing;
import com.intellij.python.pro.cython.parser.CythonParsingContext;
import com.intellij.python.pro.cython.parser.CythonTokenTypes;
import com.intellij.python.pro.cython.psi.elementTypes.CythonElementTypes;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyParsingBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CythonFunctionParsing
extends FunctionParsing {
    @NonNls
    protected static final String TOK_NONE = "None";

    public CythonFunctionParsing(CythonParsingContext context) {
        super((ParsingContext)context);
    }

    public CythonParsingContext getParsingContext() {
        return (CythonParsingContext)this.myContext;
    }

    protected IElementType getFunctionType() {
        return CythonElementTypes.FUNCTION_DECLARATION;
    }

    protected IElementType getReferenceType() {
        return CythonElementTypes.REFERENCE_EXPRESSION;
    }

    protected void parseFunctionInnards(@NotNull SyntaxTreeBuilder.Marker functionMarker, boolean async) {
        if (functionMarker == null) {
            CythonFunctionParsing.$$$reportNull$$$0(0);
        }
        this.myBuilder.advanceLexer();
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        this.parseIdentifierOrSkip(new IElementType[]{PyTokenTypes.LPAR});
        this.parseParameterList();
        this.parseReturnTypeAnnotation();
        mark.done((IElementType)CythonElementTypes.NAME_DECL);
        this.checkMatches((IElementType)PyTokenTypes.COLON, PyParsingBundle.message((String)"PARSE.expected.colon", (Object[])new Object[0]));
        CythonParsingContext context = this.getParsingContext();
        context.pushScope(context.getScope().withFunction(async));
        this.getStatementParser().parseSuite(functionMarker, this.getFunctionType());
        context.popScope();
    }

    protected boolean parseParameter(IElementType endToken, boolean isLambda) {
        if (this.parseSingleStarParameter(endToken)) {
            return true;
        }
        if (isLambda || this.atAnyOfTokens(new IElementType[]{PyTokenTypes.MULT, PyTokenTypes.EXP})) {
            return super.parseParameter(endToken, isLambda);
        }
        if (this.atToken(endToken)) {
            return false;
        }
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        if (this.atToken((IElementType)PyTokenTypes.DOT)) {
            this.parseEllipsis();
            marker.done((IElementType)CythonElementTypes.ELLIPSIS_DECL);
        } else {
            CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
            declParser.parseBaseTypeDecl(true);
            declParser.parseNameDecl(false, false, false);
            if (this.atAnyOfTokens(new IElementType[]{PyTokenTypes.NOT_KEYWORD, PyTokenTypes.OR_KEYWORD})) {
                this.nextToken();
                if (this.atToken((IElementType)PyTokenTypes.NONE_KEYWORD) || this.atToken((IElementType)PyTokenTypes.IDENTIFIER, TOK_NONE)) {
                    this.nextToken();
                } else {
                    this.myBuilder.error(PyParsingBundle.message((String)"PARSE.0.expected", (Object[])new Object[]{TOK_NONE}));
                }
            }
            this.parseParameterAnnotation();
            if (this.atToken((IElementType)PyTokenTypes.EQ)) {
                this.nextToken();
                if (this.atAnyOfTokens(new IElementType[]{CythonTokenTypes.QUESTION, PyTokenTypes.MULT})) {
                    this.nextToken();
                } else {
                    this.getExpressionParser().parseSingleExpression(false);
                }
            }
            marker.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
        }
        return true;
    }

    public void parseParameterAnnotation() {
        super.parseParameterAnnotation(false);
    }

    public void parseReturnTypeAnnotation() {
        super.parseReturnTypeAnnotation(false);
    }

    protected void parseDeclarationAfterDecorator(SyntaxTreeBuilder.Marker endMarker, boolean async) {
        if (this.atAnyOfTokens(new IElementType[]{CythonTokenTypes.CDEF_KEYWORD, CythonTokenTypes.CPDEF_KEYWORD})) {
            this.nextToken();
            this.getParsingContext().getStatementParser().parseCdefStatement(endMarker);
        } else if (this.atToken((IElementType)PyTokenTypes.DEF_KEYWORD)) {
            this.parseFunctionInnards(endMarker, async);
        } else if (this.atToken((IElementType)PyTokenTypes.CLASS_KEYWORD)) {
            this.getStatementParser().parseClassDeclaration(endMarker);
        } else {
            SyntaxTreeBuilder.Marker nameDecl = this.myBuilder.mark();
            this.myBuilder.error(PyParsingBundle.message((String)"PARSE.expected.@.or.def", (Object[])new Object[0]));
            SyntaxTreeBuilder.Marker parameterList = this.myBuilder.mark();
            parameterList.done(PyElementTypes.PARAMETER_LIST);
            nameDecl.done((IElementType)CythonElementTypes.NAME_DECL);
            this.myBuilder.mark().done(PyElementTypes.STATEMENT_LIST);
            endMarker.done(this.getFunctionType());
        }
    }

    protected void parseParameterSubList() {
        this.assertCurrentToken(PyTokenTypes.LPAR);
        CythonDeclParsing declParser = this.getParsingContext().getDeclParser();
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        declParser.parseBaseTypeDecl(true);
        declParser.parseNameDecl(false, false, false);
        marker.done((IElementType)CythonElementTypes.NAMED_PARAMETER);
    }

    public void parseDecoratorExpression() {
        this.getStatementParser().parseDottedName();
        if (this.myBuilder.getTokenType() == PyTokenTypes.LPAR) {
            this.getExpressionParser().parseArgumentList();
        } else {
            SyntaxTreeBuilder.Marker argListMarker = this.myBuilder.mark();
            argListMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, null);
            argListMarker.done((IElementType)PyElementTypes.ARGUMENT_LIST);
        }
    }

    private boolean parseSingleStarParameter(IElementType endToken) {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        if (this.atToken((IElementType)PyTokenTypes.MULT)) {
            this.nextToken();
            if (this.atAnyOfTokens(new IElementType[]{endToken, PyTokenTypes.COMMA})) {
                marker.drop();
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    private void parseEllipsis() {
        String msg = PyParsingBundle.message((String)"PARSE.expected.ellipsis", (Object[])new Object[0]);
        if (this.checkMatches((IElementType)PyTokenTypes.DOT, msg) && this.checkMatches((IElementType)PyTokenTypes.DOT, msg)) {
            this.checkMatches((IElementType)PyTokenTypes.DOT, msg);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionMarker", "com/intellij/python/pro/cython/parser/CythonFunctionParsing", "parseFunctionInnards"));
    }
}

