/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.python.pro.cython.CythonResolveUtil;
import com.intellij.python.pro.cython.psi.CythonIncludeStatement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonIncludeReference
implements PsiReference {
    private final CythonIncludeStatement myElement;

    public CythonIncludeReference(@NotNull CythonIncludeStatement element) {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @NotNull
    public PsiElement getElement() {
        CythonIncludeStatement cythonIncludeStatement = this.myElement;
        if (cythonIncludeStatement == null) {
            CythonIncludeReference.$$$reportNull$$$0(1);
        }
        return cythonIncludeStatement;
    }

    @Nullable
    public PsiElement resolve() {
        PyStringLiteralExpression arg = this.myElement.getArgument();
        if (arg != null) {
            String filename = arg.getStringValue();
            VirtualFile includedFile = CythonResolveUtil.findFile(CythonResolveUtil.getIncludePath((PsiElement)this.myElement, true), filename);
            if (includedFile != null) {
                return CythonResolveUtil.toCythonFile(this.myElement.getProject(), includedFile);
            }
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        PyStringLiteralExpression arg = this.myElement.getArgument();
        return arg != null ? arg.getStringValue() : "";
    }

    @NotNull
    public TextRange getRangeInElement() {
        List ranges;
        PyStringLiteralExpression arg = this.myElement.getArgument();
        if (arg != null && !(ranges = arg.getStringValueTextRanges()).isEmpty()) {
            Iterator iterator = ranges.iterator();
            TextRange result = (TextRange)iterator.next();
            while (iterator.hasNext()) {
                result = result.union((TextRange)iterator.next());
            }
            TextRange textRange = result.shiftRight(arg.getStartOffsetInParent());
            if (textRange == null) {
                CythonIncludeReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = TextRange.EMPTY_RANGE;
        if (textRange == null) {
            CythonIncludeReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PyStringLiteralExpression arg;
        if (newElementName == null) {
            CythonIncludeReference.$$$reportNull$$$0(4);
        }
        if ((arg = this.myElement.getArgument()) != null) {
            ElementManipulators.handleContentChange((PsiElement)arg, (String)newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(5);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(6);
        }
        if (element instanceof PyFile) {
            return this.resolve() == element;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CythonIncludeReference) {
            CythonIncludeReference other = (CythonIncludeReference)o;
            return ((Object)((Object)this.myElement)).equals(other.getElement());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)((Object)this.myElement)).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/cython/psi/CythonIncludeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/cython/psi/CythonIncludeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

