/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.run;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dbt.DbtBundle;
import com.intellij.dbt.DbtIcons;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.console.DbtCliUtilKt;
import com.intellij.dbt.console.DbtConsoleService;
import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessHandlerFactory;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/dbt/run/DbtCompileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "service", "Lcom/intellij/dbt/console/DbtConsoleService;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtCompileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtCompileAction.kt\ncom/intellij/dbt/run/DbtCompileAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,64:1\n40#2,3:65\n*S KotlinDebug\n*F\n+ 1 DbtCompileAction.kt\ncom/intellij/dbt/run/DbtCompileAction\n*L\n19#1:65,3\n*E\n"})
public final class DbtCompileAction
extends DumbAwareAction {
    @NotNull
    private final DbtConsoleService service;

    public DbtCompileAction() {
        boolean $i$f$service = false;
        Class<DbtConsoleService> serviceClass$iv = DbtConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.service = (DbtConsoleService)object;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (module == null) {
            return;
        }
        Module module2 = module;
        VirtualFile virtualFile = DbtUtils.Companion.getDbtDirectory(module2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile dbtDirectory = virtualFile;
        GeneralCommandLine cmd = DbtCliUtilKt.getDbtCommandLine(DbtCommand.COMPILE, module2, dbtDirectory.getPath());
        String selectedText = editor2.getSelectionModel().getSelectedText();
        String[] stringArray = (String[])selectedText;
        if (!(stringArray == null || stringArray.length() == 0)) {
            stringArray = new String[]{"--inline", selectedText};
            v4 = cmd.withParameters(stringArray);
        } else {
            stringArray = new String[]{"--select", file.getVirtualFile().getNameWithoutExtension()};
            v4 = cmd.withParameters(stringArray);
        }
        OSProcessHandler oSProcessHandler = ProcessHandlerFactory.getInstance().createColoredProcessHandler(cmd);
        Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createColoredProcessHandler(...)");
        OSProcessHandler processHandler = oSProcessHandler;
        ProcessTerminatedListener.attach((ProcessHandler)((ProcessHandler)processHandler));
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.service.showConsoleViewContent(project, (ProcessHandler)processHandler);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        e.getPresentation().setIcon(DbtIcons.Dbt);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        CharSequence charSequence = editor2.getSelectionModel().getSelectedText();
        if (charSequence == null || charSequence.length() == 0) {
            e.getPresentation().setText(DbtBundle.message("action.dbtCompileAction.text", new Object[0]));
            e.getPresentation().setDescription(DbtBundle.message("action.dbtCompileAction.description", new Object[0]));
        } else {
            e.getPresentation().setText(DbtBundle.message("action.dbtCompileSelectedFragmentAction.text", new Object[0]));
            e.getPresentation().setDescription(DbtBundle.message("action.dbtCompileSelectedFragmentAction.description", new Object[0]));
        }
        if (!DbtUtils.Companion.isSqlDialect(file)) {
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }
}

