/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.python;

import com.intellij.aiplayground.python.LooksLikeCode;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/aiplayground/python/PromptDetector;", "", "<init>", "()V", "placeholderRe", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "containsPlaceholder", "", "t", "", "looksLikeBibTex", "s", "looksLikeRegex", "sysRe", "looksLikeSystemPrompt", "verbs", "instrRe", "looksLikeInstructionPrompt", "isPrompt", "text", "intellij.aiplayground.python"})
@SourceDebugExtension(value={"SMAP\nPromptDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptDetector.kt\ncom/intellij/aiplayground/python/PromptDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1788#2,4:78\n1788#2,4:82\n1761#2,3:86\n*S KotlinDebug\n*F\n+ 1 PromptDetector.kt\ncom/intellij/aiplayground/python/PromptDetector\n*L\n17#1:78,4\n32#1:82,4\n46#1:86,3\n*E\n"})
public final class PromptDetector {
    @NotNull
    public static final PromptDetector INSTANCE = new PromptDetector();
    private static final Pattern placeholderRe = Pattern.compile("(?<![{$])\\{[\\p{L}_][\\p{L}\\p{N}_]*}(?!})");
    private static final Pattern sysRe;
    @NotNull
    private static final String verbs;
    private static final Pattern instrRe;

    private PromptDetector() {
    }

    private final boolean containsPlaceholder(String t) {
        return placeholderRe.matcher(t).find();
    }

    private final boolean looksLikeBibTex(String s) {
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)s)).toString(), (String)"@", (boolean)false, (int)2, null)) {
            return true;
        }
        if (s.length() > 100 && StringsKt.lines((CharSequence)s).size() >= 3) {
            int n;
            String string = s.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String l = string;
            Object[] objectArray = new String[]{"title=", "author=", "journal=", "booktitle=", "year=", "doi="};
            List keys = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$count$iv = keys;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)l, (CharSequence)it, (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n >= 2;
        }
        return false;
    }

    private final boolean looksLikeRegex(String s) {
        int n;
        Object[] objectArray = new String[]{"\\\\d", "\\\\w", "\\\\s", "[", "]", "(?:", "(?=", "(?!", "(?P<", ".*", ".+", "$", "^", "|", "\\\\b", "\\\\B", "\\\\A", "\\\\Z"};
        List toks = CollectionsKt.listOf((Object[])objectArray);
        String string = s.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String l = string;
        Iterable $this$count$iv = toks;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)l, (CharSequence)it, (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n >= 2;
    }

    private final boolean looksLikeSystemPrompt(String t) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = StringsKt.lines((CharSequence)t);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String s;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    char[] cArray = new char[]{'#', ' '};
                    Intrinsics.checkNotNullExpressionValue((Object)StringsKt.trimStart((String)it, (char[])cArray).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    if (!sysRe.matcher(s).lookingAt()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean looksLikeInstructionPrompt(String t) {
        String s = ((Object)StringsKt.trim((CharSequence)t)).toString();
        Matcher matcher = instrRe.matcher(s);
        int matchesCount = 0;
        while (matcher.find()) {
            if (++matchesCount <= 3) continue;
            return true;
        }
        return false;
    }

    public final boolean isPrompt(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.looksLikeBibTex(text) || this.looksLikeRegex(text) || LooksLikeCode.INSTANCE.looksLikeCode(text)) {
            return false;
        }
        boolean isSystemPrompt = Registry.Companion.get("com.intellij.aiplayground.python.experimental.detect.system.prompts").asBoolean() ? this.looksLikeSystemPrompt(text) || this.looksLikeInstructionPrompt(text) : false;
        return this.containsPlaceholder(text) || isSystemPrompt;
    }

    static {
        Object[] objectArray = new String[]{"you are\\b", "you have\\b", "you should\\b", "as an ai\\b", "act as\\b", "assistant[,:]?\\b", "answer (only|solely)\\b", "please\\b", "human[: ]", "system[: ]", "remember\\b", "question\\b", "i need\\b", "tell me\\b", "you function\\b", "show me\\b"};
        sysRe = Pattern.compile(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null), 2);
        verbs = "write|generate|create|explain|describe|summarize|translate|answer|provide|return|output|list|classify|convert|give|determine|identify|respond|rate|assess|compare|solve|edit|get|rephrase|replace";
        instrRe = Pattern.compile("\\b(" + verbs + ")\\b", 2);
    }
}

