/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPageModelImpl<Row, Column>
extends GridPagingModelImpl<Row, Column>
implements MultiPageModel<Row, Column> {
    private final DataGridSettings mySettings;
    private final EventDispatcher<MultiPageModel.PageModelListener> myPageModelListeners;
    private int myPageSize;
    private int myPageStart;
    private int myPageEnd;
    private long myTotalRowCount;
    private boolean myTotalRowCountIsPrecise;
    private boolean myTotalRowCountUpdateable;

    public MultiPageModelImpl(@NotNull GridModel<Row, Column> model, @Nullable DataGridSettings settings) {
        if (model == null) {
            MultiPageModelImpl.$$$reportNull$$$0(0);
        }
        super(model);
        this.myPageModelListeners = EventDispatcher.create(MultiPageModel.PageModelListener.class);
        this.myPageSize = -2;
        this.myPageStart = 1;
        this.mySettings = settings;
    }

    @Override
    public boolean isFirstPage() {
        return this.myPageStart == 1;
    }

    @Override
    public boolean isLastPage() {
        return this.myPageEnd == -1 || (long)this.myPageEnd >= this.myTotalRowCount && this.myTotalRowCountIsPrecise;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.myPageSize = pageSize;
        ((MultiPageModel.PageModelListener)this.myPageModelListeners.getMulticaster()).pageSizeChanged();
    }

    @Override
    public int getPageSize() {
        return this.myPageSize == -2 ? GridUtilCore.getPageSize(this.mySettings) : this.myPageSize;
    }

    @Override
    public boolean pageSizeSet() {
        return this.myPageSize != -2;
    }

    @Override
    public long getTotalRowCount() {
        return this.myTotalRowCount;
    }

    @Override
    public boolean isTotalRowCountPrecise() {
        return this.myTotalRowCountIsPrecise;
    }

    @Override
    public boolean isTotalRowCountUpdateable() {
        return this.myTotalRowCountUpdateable;
    }

    @Override
    public int getPageStart() {
        return this.myPageStart;
    }

    @Override
    public int getPageEnd() {
        return this.myPageEnd;
    }

    @Override
    public void setPageStart(int pageStart) {
        this.myPageStart = pageStart;
        ((MultiPageModel.PageModelListener)this.myPageModelListeners.getMulticaster()).pageStartChanged();
    }

    @Override
    public void setPageEnd(int pageEnd) {
        this.myPageEnd = pageEnd;
    }

    @Override
    public void setTotalRowCount(long totalRowCount, boolean precise) {
        this.myTotalRowCount = totalRowCount;
        this.myTotalRowCountIsPrecise = precise;
    }

    @Override
    public void setTotalRowCountUpdateable(boolean updateable) {
        this.myTotalRowCountUpdateable = updateable;
    }

    @Override
    public void addPageModelListener(@NotNull MultiPageModel.PageModelListener listener) {
        if (listener == null) {
            MultiPageModelImpl.$$$reportNull$$$0(1);
        }
        this.myPageModelListeners.addListener((EventListener)listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/MultiPageModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addPageModelListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

