/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRequireFrameworkIndexHandler
extends FrameworkIndexingHandler {
    @Override
    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        ASTNode methodExpression;
        if (node == null) {
            JSRequireFrameworkIndexHandler.$$$reportNull$$$0(0);
        }
        if ((methodExpression = node.getFirstChildNode()).getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getFirstChildNode();
        if (referencedNameElement == null) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)"require", (CharSequence)referencedNameElement.getChars());
    }

    @Override
    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        if (node == null) {
            JSRequireFrameworkIndexHandler.$$$reportNull$$$0(1);
        }
        return this.checkRequireCall(node.getTreeParent());
    }

    private boolean checkRequireCall(@Nullable ASTNode parent) {
        if (parent != null && parent.getElementType() == JSElementTypes.ARGUMENT_LIST) {
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JSStubElementTypes.CALL_EXPRESSION && this.shouldCreateStubForCallExpression(grandParent);
        }
        return false;
    }

    @Override
    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        PsiElement grandParent;
        PsiElement parent;
        if (expression == null) {
            JSRequireFrameworkIndexHandler.$$$reportNull$$$0(2);
        }
        return (parent = expression.getParent()) instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)grandParent).isRequireCall();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSRequireFrameworkIndexHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCreateStubForLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSignificantValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

