/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHeaderKeeper {
    @NotNull
    private final PsiElement myContainer;
    @Nullable
    private CutState myCutState;
    @Nullable
    private final SmartPsiElementPointer<PsiComment> mySmartPointToHeaderComment;

    public FileHeaderKeeper(@NotNull PsiElement container) {
        if (container == null) {
            FileHeaderKeeper.$$$reportNull$$$0(0);
        }
        this.myContainer = container;
        PsiComment header = this.findHeader();
        this.mySmartPointToHeaderComment = header == null ? null : SmartPointerManager.getInstance((Project)container.getProject()).createSmartPsiElementPointer((PsiElement)header);
    }

    public void saveStateAndCutHeader() {
        this.myCutState = this.cutHeader();
    }

    public boolean canMove() {
        return this.getComment() != null;
    }

    @Nullable
    private PsiComment getComment() {
        return this.mySmartPointToHeaderComment == null ? null : (PsiComment)this.mySmartPointToHeaderComment.getElement();
    }

    public void moveHeader() {
        this.restoreHeader(this.cutHeader());
    }

    public void restoreHeaderForSavedState() {
        CutState state = this.myCutState;
        PsiElement newHeader = this.restoreHeader(state);
        if (state != null && newHeader != null) {
            state.myEraser.process(newHeader);
        }
    }

    public CutState cutHeader() {
        PsiComment comment = this.getComment();
        if (comment == null) {
            return null;
        }
        PsiComment header = (PsiComment)comment.copy();
        ArrayList<PsiWhiteSpace> afterSpaces = new ArrayList<PsiWhiteSpace>();
        PsiElement prevElement = comment.getPrevSibling();
        PsiWhiteSpace beforeHeader = prevElement instanceof PsiWhiteSpace ? (PsiWhiteSpace)prevElement.copy() : null;
        NewLineEraser eraser = new NewLineEraser((PsiElement)comment);
        PsiElement current = comment.getNextSibling();
        comment.delete();
        while (current instanceof PsiWhiteSpace && current.isValid()) {
            afterSpaces.add((PsiWhiteSpace)current.copy());
            PsiElement next = current.getNextSibling();
            current.delete();
            current = next;
        }
        return new CutState(header, beforeHeader, afterSpaces, eraser);
    }

    @Nullable
    private PsiComment findHeader() {
        PsiElement declarationCandidate;
        PsiElement firstElement = FileHeaderKeeper.getFirstNotWhiteSpace(this.myContainer);
        if (firstElement == null || firstElement instanceof PsiComment) {
            return null;
        }
        PsiElement child = FileHeaderKeeper.getFirstNotWhiteSpace(firstElement);
        PsiComment comment = (PsiComment)ObjectUtils.tryCast((Object)child, PsiComment.class);
        if (comment == null) {
            return null;
        }
        PsiElement next = comment.getNextSibling();
        if (next instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)next.getText(), (char)'\n') <= 1 && !((declarationCandidate = next.getNextSibling()) instanceof JSExpression)) {
            return null;
        }
        return comment;
    }

    @Nullable
    private static PsiElement getFirstNotWhiteSpace(@NotNull PsiElement element2) {
        PsiElement firstElement;
        if (element2 == null) {
            FileHeaderKeeper.$$$reportNull$$$0(1);
        }
        if ((firstElement = element2.getFirstChild()) instanceof PsiWhiteSpace) {
            firstElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstElement);
        }
        return firstElement;
    }

    private PsiElement restoreHeader(@Nullable CutState state) {
        if (state == null || state.myHeader == null) {
            return null;
        }
        PsiElement anchor = this.getInsertionAnchor();
        if (anchor != null) {
            anchor = this.myContainer.addBefore((PsiElement)state.myHeader, anchor);
            if (state.myBeforeHeader != null) {
                this.myContainer.addBefore((PsiElement)state.myBeforeHeader, anchor);
            }
        } else {
            anchor = this.myContainer.add((PsiElement)state.myHeader);
        }
        PsiElement newHeader = anchor;
        for (PsiWhiteSpace space : state.myAfterSpaces) {
            anchor = this.myContainer.addAfter((PsiElement)space, anchor);
        }
        return newHeader;
    }

    private PsiElement getInsertionAnchor() {
        return this.myContainer.getFirstChild();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/FileHeaderKeeper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstNotWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CutState {
        @Nullable
        private final PsiWhiteSpace myBeforeHeader;
        @NotNull
        private final List<PsiWhiteSpace> myAfterSpaces;
        @Nullable
        private final PsiComment myHeader;
        @NotNull
        private final NewLineEraser myEraser;

        CutState(@Nullable PsiComment header, @Nullable PsiWhiteSpace beforeHeader, @NotNull List<PsiWhiteSpace> afterSpaces, @NotNull NewLineEraser eraser) {
            if (afterSpaces == null) {
                CutState.$$$reportNull$$$0(0);
            }
            if (eraser == null) {
                CutState.$$$reportNull$$$0(1);
            }
            this.myBeforeHeader = beforeHeader;
            this.myAfterSpaces = afterSpaces;
            this.myHeader = header;
            this.myEraser = eraser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "afterSpaces";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "eraser";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/FileHeaderKeeper$CutState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

