/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptParameterPropertyToFieldIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(1);
        }
        JSParameter param = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)element2, JSParameter.class);
        assert (param != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)param);
        ASTNode newMember = JSChangeUtil.createClassMemberFromText(project, param.getText() + semicolon, DialectDetector.languageDialectOfElement(element2));
        JSFunction f = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)param, JSFunction.class);
        assert (f != null);
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)param, JSClass.class);
        assert (clazz != null);
        clazz.addBefore(newMember.getPsi(), f);
        JSBlockStatement blockStatement = f.getBlock();
        assert (blockStatement != null);
        JSSourceElement[] statements = blockStatement.getStatementListItems();
        JSStatement assignment = JSPsiElementFactory.createJSStatement("this." + param.getName() + " = " + param.getName() + semicolon, f);
        PsiElement newElement = null;
        if (statements.length == 0) {
            newElement = blockStatement.addAfter((PsiElement)assignment, blockStatement.getFirstChild());
        } else {
            boolean superFound = false;
            for (JSSourceElement statement : statements) {
                JSExpression methodExpression;
                JSExpression expression;
                if (!(statement instanceof JSExpressionStatement) || !((expression = ((JSExpressionStatement)statement).getExpression()) instanceof JSCallExpression) || !((methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSSuperExpression)) continue;
                superFound = true;
                newElement = blockStatement.addAfter((PsiElement)assignment, (PsiElement)statement);
            }
            if (!superFound) {
                newElement = blockStatement.addAfter((PsiElement)assignment, blockStatement.getFirstChild());
            }
        }
        assert (newElement != null);
        FormatFixer.create(newElement, FormatFixer.Mode.Reformat).fixFormat();
        JSAttributeListWrapper wrapperForParam = new JSAttributeListWrapper(param);
        wrapperForParam.removeAccessModifier();
        wrapperForParam.removeOriginalAttributes();
        wrapperForParam.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
        wrapperForParam.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, false);
        wrapperForParam.applyTo(param);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        JSParameter param = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)element2, JSParameter.class);
        if (param == null || !DialectDetector.isTypeScript((PsiElement)param)) {
            return false;
        }
        PsiElement parent = param.getParent();
        if (!(parent instanceof JSParameterList)) {
            return false;
        }
        PsiElement parentParent = parent.getParent();
        if (!(parentParent instanceof JSFunction) || !((JSFunction)parentParent).isConstructor() || ((JSFunction)parentParent).getBlock() == null) {
            return false;
        }
        JSAttributeList attributeList = param.getAttributeList();
        return attributeList != null && (attributeList.hasModifier(JSAttributeList.ModifierType.READONLY) || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || attributeList.getExplicitAccessType() != null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("ts.convert.parameter.property.to.field", new Object[0]);
        if (string == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("ts.convert.parameter.property.to.field", new Object[0]);
        if (string == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptParameterPropertyToFieldIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptParameterPropertyToFieldIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

