/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryExtDocProviderFactory {
    private final Map<String, ExternalDocumentationProvider> myProviderMap = new HashMap<String, ExternalDocumentationProvider>();
    private static final Logger LOG = Logger.getInstance(JSLibraryExtDocProviderFactory.class);

    @Nullable
    public ExternalDocumentationProvider getProvider(@NotNull String docUrl) {
        if (docUrl == null) {
            JSLibraryExtDocProviderFactory.$$$reportNull$$$0(0);
        }
        if (this.myProviderMap.containsKey(docUrl)) {
            return this.myProviderMap.get(docUrl);
        }
        String docKey = JSExternalLibraryDocBundle.findMatchingDocKey(docUrl);
        if (docKey != null) {
            try {
                String providerClass = JSExternalLibraryDocBundle.getOfflineDocProvider(docKey);
                if (providerClass != null) {
                    Constructor<?> cons = Class.forName(providerClass).getConstructor(String.class);
                    ExternalDocumentationProvider provider = (ExternalDocumentationProvider)cons.newInstance(docUrl);
                    this.myProviderMap.put(docUrl, provider);
                    return provider;
                }
            }
            catch (Exception e) {
                LOG.error("Can not create external JavaScript documentation provider", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docUrl", "com/intellij/lang/javascript/library/JSLibraryExtDocProviderFactory", "getProvider"));
    }
}

