/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.util.ProcessingContext;
import java.math.BigInteger;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSBigIntLiteralTypeImpl
extends JSBigIntType
implements JSPrimitiveLiteralType<BigInteger> {
    private final BigInteger myLiteral;
    private final boolean myAllowWidening;
    @Nullable
    private final String myValueAsString;

    public JSBigIntLiteralTypeImpl(BigInteger literal, boolean allowWidening, @NotNull JSTypeSource source, @Nullable String valueAsString) {
        if (source == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
        this.myValueAsString = valueAsString;
    }

    public JSBigIntLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
        String value = JSTypeSerializer.readString(inputStream);
        BigInteger bigInt = JSNumberParser.tryParseBigInt(value);
        this.myLiteral = bigInt != null ? bigInt : BigInteger.ZERO;
        this.myValueAsString = value;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
        JSTypeSerializer.writeString(this.getValueAsString(), outputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        if (elementType instanceof JSBigIntLiteralTypeImpl && this.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral.equals(((JSBigIntLiteralTypeImpl)elementType).myLiteral);
        }
        if (!this.myAllowWidening && elementType instanceof JSBigIntType) {
            return this.isJavaScript();
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                BigInteger numericValue = value.getBigIntValue();
                return numericValue != null && numericValue.equals(this.myLiteral);
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        return super.isEquivalentToWithSameClass(type2, processingContext, allowResolve) && this.myLiteral.equals(((JSBigIntLiteralTypeImpl)type2).myLiteral);
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.getValueAsString();
        if (string == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : this.myLiteral.toString();
        if (string == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public BigInteger getLiteral() {
        BigInteger bigInteger = this.myLiteral;
        if (bigInteger == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return bigInteger;
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    protected JSBigIntLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBigIntLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return new JSBigIntLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source, this.myValueAsString);
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSBigIntLiteralTypeImpl jSBigIntLiteralTypeImpl = this;
            if (jSBigIntLiteralTypeImpl == null) {
                JSBigIntLiteralTypeImpl.$$$reportNull$$$0(11);
            }
            return jSBigIntLiteralTypeImpl;
        }
        return new JSBigIntLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource(), this.myValueAsString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBigIntLiteralTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBigIntLiteralTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

