/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSImportConfigResolveContextImpl;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileReferenceRootsProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportConfigResolveContextImpl;", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSImportConfigResolveContextImpl;", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;", "config", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "<init>", "(Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;)V", "myTypeRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myTypes", "", "myAllowJs", "", "myContainingDirectory", "myModuleResolution", "Lcom/intellij/lang/javascript/config/JSModuleResolution;", "myModuleSuffixes", "myRootsProvider", "Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "getModuleSuffixes", "getRootsProvider", "allowJs", "getNodeModuleSearchProcessor", "Lcom/intellij/lang/javascript/frameworks/modules/JSDirectorySearchProcessor;", "equals", "other", "", "hashCode", "", "intellij.javascript.impl"})
public final class TypeScriptImportConfigResolveContextImpl
extends JSImportConfigResolveContextImpl
implements TypeScriptImportResolveContext {
    @NotNull
    private final Collection<VirtualFile> myTypeRoots;
    @NotNull
    private final Collection<String> myTypes;
    private final boolean myAllowJs;
    @NotNull
    private final VirtualFile myContainingDirectory;
    @NotNull
    private final JSModuleResolution myModuleResolution;
    @NotNull
    private final Collection<String> myModuleSuffixes;
    @NotNull
    private final JSFileResolveRootsProvider myRootsProvider;

    public TypeScriptImportConfigResolveContextImpl(@NotNull TypeScriptConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        Collection<VirtualFile> collection = config.getTypeRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getTypeRoots(...)");
        this.myTypeRoots = collection;
        Collection<String> collection2 = config.getTypes();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getTypes(...)");
        this.myTypes = collection2;
        this.myAllowJs = config.allowJs();
        VirtualFile virtualFile = config.getConfigDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfigDirectory(...)");
        this.myContainingDirectory = virtualFile;
        JSModuleResolution jSModuleResolution = config.getEffectiveResolution();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)jSModuleResolution), (String)"getEffectiveResolution(...)");
        this.myModuleResolution = jSModuleResolution;
        Collection<String> collection3 = config.getModuleSuffixes();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"getModuleSuffixes(...)");
        this.myModuleSuffixes = collection3;
        this.myRootsProvider = new TypeScriptFileReferenceRootsProvider(this);
    }

    @Override
    @NotNull
    public Collection<String> getModuleSuffixes() {
        return this.myModuleSuffixes;
    }

    @Override
    @NotNull
    public JSFileResolveRootsProvider getRootsProvider() {
        return this.myRootsProvider;
    }

    @Override
    public boolean allowJs() {
        return this.myAllowJs;
    }

    @Override
    @NotNull
    public JSDirectorySearchProcessor getNodeModuleSearchProcessor() {
        TypeScriptNodeSearchProcessor typeScriptNodeSearchProcessor = TypeScriptNodeSearchProcessor.TS_PROCESSOR;
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptNodeSearchProcessor, (String)"TS_PROCESSOR");
        return typeScriptNodeSearchProcessor;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsconfig.TypeScriptImportConfigResolveContextImpl");
        TypeScriptImportConfigResolveContextImpl cfr_ignored_0 = (TypeScriptImportConfigResolveContextImpl)other;
        if (!Intrinsics.areEqual(this.myTypeRoots, ((TypeScriptImportConfigResolveContextImpl)other).myTypeRoots)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.myTypes, ((TypeScriptImportConfigResolveContextImpl)other).myTypes)) {
            return false;
        }
        if (this.myAllowJs != ((TypeScriptImportConfigResolveContextImpl)other).myAllowJs) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myContainingDirectory, (Object)((TypeScriptImportConfigResolveContextImpl)other).myContainingDirectory)) {
            return false;
        }
        if (this.myModuleResolution != ((TypeScriptImportConfigResolveContextImpl)other).myModuleResolution) {
            return false;
        }
        return Intrinsics.areEqual(this.myModuleSuffixes, ((TypeScriptImportConfigResolveContextImpl)other).myModuleSuffixes);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + ((Object)this.myTypeRoots).hashCode();
        result2 = 31 * result2 + ((Object)this.myTypes).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.myAllowJs);
        result2 = 31 * result2 + this.myModuleResolution.hashCode();
        result2 = 31 * result2 + ((Object)this.myModuleSuffixes).hashCode();
        return result2;
    }
}

