/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public interface PuppetDataTypes {
    @NonNls
    public static final String RESOURCE_TYPE_NAME = "Resource";
    @NonNls
    public static final String CLASS_TYPE_NAME = "Class";
    @NonNls
    public static final String TYPE_TYPE_NAME = "Type";
    @NonNls
    public static final String VARIANT_TYPE_NAME = "Variant";
    public static final List<String> CORE_DATA_TYPES = List.of("String", "Integer", "Float", "Numeric", "Boolean", "Array", "Hash", "Regexp", "Undef", "Default", "SemVer", "SemVerRange", "Timespan", "Timestamp", "NotUndef", "Iterator", "Iterable", "Runtime", "Sensitive");
    public static final List<String> RESOURCE_AND_CLASS_DATATYPES = List.of("Resource", "Class");
    public static final List<String> ABSTRACT_DATA_TYPES = List.of("Scalar", "Collection", "Variant", "Data", "Pattern", "Enum", "Tuple", "Struct", "Optional", "CatalogEntry", "Any", "Callable", "Type");
    public static final List<String> ALL_DATA_TYPES = ContainerUtil.concat((List[])new List[]{CORE_DATA_TYPES, RESOURCE_AND_CLASS_DATATYPES, ABSTRACT_DATA_TYPES});
    public static final Set<String> ALL_LOWERCASED_DATA_TYPES = new HashSet<String>(ContainerUtil.map(ALL_DATA_TYPES, StringUtil::toLowerCase));
}

