/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.service;

import com.intellij.dataWrangler.executor.CodePreviewProvider;
import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.executor.DataWranglerEngine;
import com.intellij.dataWrangler.executor.DataWranglerTransformationStepsManager;
import com.intellij.dataWrangler.impl.operations.DataWranglerTransformationStepsManagerImpl;
import com.intellij.dataWrangler.impl.service.DataWranglerServiceKt;
import com.intellij.dataWrangler.impl.service.DataWranglerSessionImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0010\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/dataWrangler/impl/service/DataWranglerService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject$intellij_dataWrangler_impl", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getDWEngines", "", "Lcom/intellij/dataWrangler/executor/DataWranglerEngine;", "createDWSession", "Lcom/intellij/dataWrangler/impl/service/DataWranglerSessionImpl;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "tryCreateDWSession", "C", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "engine", "canCreateDWSession", "", "intellij.dataWrangler.impl"})
public final class DataWranglerService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public DataWranglerService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final Project getProject$intellij_dataWrangler_impl() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    private final List<DataWranglerEngine<?>> getDWEngines() {
        return DataWranglerEngine.Companion.getEP().getExtensionList();
    }

    @Nullable
    public final DataWranglerSessionImpl<?> createDWSession(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        for (DataWranglerEngine<?> engine : this.getDWEngines()) {
            DataWranglerSessionImpl<?> session = this.tryCreateDWSession(engine, dataContext);
            if (session == null) continue;
            return session;
        }
        DataWranglerServiceKt.access$getLOG$p().warn("No valid DW engine available");
        return null;
    }

    private final <C extends DataWranglerContext> DataWranglerSessionImpl<C> tryCreateDWSession(DataWranglerEngine<C> engine, DataContext dataContext) {
        DataWranglerContext dataWranglerContext = engine.createInitialContext(dataContext);
        if (dataWranglerContext == null) {
            return null;
        }
        DataWranglerContext context = dataWranglerContext;
        DataWranglerTransformationStepsManagerImpl<DataWranglerContext> transformationManager = DataWranglerTransformationStepsManagerImpl.Companion.createDefault(context);
        CodePreviewProvider previewProvider = engine.getPreviewProvider();
        return new DataWranglerSessionImpl<DataWranglerContext>(this.coroutineScope, engine, (DataWranglerTransformationStepsManager)transformationManager, previewProvider, context);
    }

    public final boolean canCreateDWSession(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        for (DataWranglerEngine<?> engine : this.getDWEngines()) {
            if (!engine.canCreateDWContext(dataContext)) continue;
            return true;
        }
        return false;
    }
}

