/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NodeunitExecutionUtils {
    @NonNls
    public static final NodePackageDescriptor PKG = new NodePackageDescriptor("nodeunit");

    private NodeunitExecutionUtils() {
    }

    public static void checkConfiguration(@NotNull Project project, @NotNull NodeunitSettings settings) throws RuntimeConfigurationException {
        if (project == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(1);
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        File nodeunitModuleDir = new File(settings.getNodeunitPackage().getSystemDependentPath());
        if (!nodeunitModuleDir.isAbsolute()) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.package.text", new Object[0]));
        }
        if (!nodeunitModuleDir.isDirectory()) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.package.text", new Object[0]));
        }
        String workingDirectoryStr = settings.getWorkingDirectory();
        if (workingDirectoryStr.isEmpty() || ".".equals(workingDirectoryStr)) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.working.dir.text", new Object[0]));
        }
        File workingDirectory = new File(workingDirectoryStr);
        if (!workingDirectory.isDirectory()) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.working.dir.text", new Object[0]));
        }
        if (settings.getTestType() == NodeunitTestType.DIRECTORY) {
            File testDirectory = new File(workingDirectory, settings.getDirectory());
            if (!testDirectory.isDirectory()) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.test.dir.text", new Object[0]));
            }
        } else {
            File jsTestFile = new File(workingDirectory, settings.getJsFile());
            if (!jsTestFile.isFile()) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("nodeunit.rc.check.test.file.text", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils";
        objectArray[2] = "checkConfiguration";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

