/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment;

import com.intellij.httpClient.http.request.environment.DistanceFromFileComparator;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProviderKt;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentIndex;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.environment.MyVariablesExternalizer;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001f\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R=\u0010\u0012\u001a$\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u0015j\u0002`\u00170\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider;", "", "<init>", "()V", "getByName", "Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "name", "", "getByNameFast", "getByNameFast$intellij_restClient", "provideEnvironments", "Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentsSearchResult;", "fastEnvironments", "", "environmentsFromIndex", "environmentByNameFromIndex", "gist", "Lcom/intellij/util/gist/PsiFileGist;", "", "Lkotlin/Pair;", "", "Lcom/intellij/httpClient/http/request/environment/EnvStoredInfo;", "getGist", "()Lcom/intellij/util/gist/PsiFileGist;", "gist$delegate", "Lkotlin/Lazy;", "EnvironmentDescriptor", "EnvironmentsSearchResult", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientEnvironmentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,315:1\n295#2,2:316\n295#2,2:318\n774#2:320\n865#2,2:321\n295#2,2:353\n295#2,2:355\n1056#2:358\n1563#2:359\n1634#2,3:360\n774#2:363\n865#2,2:364\n1617#2,9:366\n1869#2:375\n1870#2:377\n1626#2:378\n1056#2:379\n11554#3:323\n13472#3:324\n13473#3:326\n11555#3:327\n11554#3:328\n13472#3:329\n13473#3:331\n11555#3:332\n11554#3:333\n13472#3:334\n13473#3:336\n11555#3:337\n11554#3:338\n13472#3:339\n13473#3:341\n11555#3:342\n1#4:325\n1#4:330\n1#4:335\n1#4:340\n1#4:376\n382#5,7:343\n126#6:350\n153#6,2:351\n155#6:357\n*S KotlinDebug\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider\n*L\n34#1:316,2\n48#1:318,2\n146#1:320\n146#1:321,2\n85#1:353,2\n86#1:355,2\n91#1:358\n105#1:359\n105#1:360,3\n108#1:363\n108#1:364,2\n111#1:366,9\n111#1:375\n111#1:377\n111#1:378\n116#1:379\n68#1:323\n68#1:324\n68#1:326\n68#1:327\n69#1:328\n69#1:329\n69#1:331\n69#1:332\n72#1:333\n72#1:334\n72#1:336\n72#1:337\n73#1:338\n73#1:339\n73#1:341\n73#1:342\n68#1:325\n69#1:330\n72#1:335\n73#1:340\n111#1:376\n80#1:343,7\n84#1:350\n84#1:351,2\n84#1:357\n*E\n"})
public final class HttpClientEnvironmentsProvider {
    @NotNull
    public static final HttpClientEnvironmentsProvider INSTANCE = new HttpClientEnvironmentsProvider();
    @NotNull
    private static final Lazy gist$delegate = LazyKt.lazy(HttpClientEnvironmentsProvider::gist_delegate$lambda$21);

    private HttpClientEnvironmentsProvider() {
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @Nullable
    public final EnvironmentDescriptor getByName(@NotNull PsiFile file, @NotNull String name) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.fastEnvironments(file);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EnvironmentDescriptor it = (EnvironmentDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        EnvironmentDescriptor fast = v0;
        if (fast != null) {
            return fast;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        return this.environmentByNameFromIndex(file, name);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @Nullable
    public final EnvironmentDescriptor getByNameFast$intellij_restClient(@NotNull PsiFile file, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.fastEnvironments(file);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EnvironmentDescriptor it = (EnvironmentDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final EnvironmentsSearchResult provideEnvironments(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<EnvironmentDescriptor> fileRelated = this.fastEnvironments(file);
        return new EnvironmentsSearchResult(fileRelated, this.environmentsFromIndex(file));
    }

    private final List<EnvironmentDescriptor> fastEnvironments(PsiFile file) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> HttpClientEnvironmentsProvider.fastEnvironments$lambda$11(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private final List<EnvironmentDescriptor> environmentsFromIndex(PsiFile file) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> HttpClientEnvironmentsProvider.environmentsFromIndex$lambda$16(file));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final EnvironmentDescriptor environmentByNameFromIndex(PsiFile file, String name) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        VirtualFile virtualFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (ScratchUtil.isScratch((VirtualFile)file.getVirtualFile())) {
            virtualFile = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile == null) {
                virtualFile = file.getOriginalFile().getVirtualFile();
            }
        } else {
            virtualFile = file.getOriginalFile().getVirtualFile();
        }
        VirtualFile anchor = virtualFile;
        Collection<VirtualFile> files = HttpRequestIndex.getEnvironmentFiles(project2, name, file);
        Intrinsics.checkNotNull(files);
        Iterable iterable = files;
        Intrinsics.checkNotNull((Object)anchor);
        VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.minWithOrNull((Iterable)iterable, (Comparator)new DistanceFromFileComparator(anchor));
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile nearestFile = virtualFile2;
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
        boolean isPrivate = ArraysKt.contains((Object[])HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (Object)nearestFile.getName());
        Iterable iterable2 = files;
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (isPrivate) {
                Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
                bl = ArraysKt.contains((Object[])HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (Object)it.getName());
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
                bl = ArraysKt.contains((Object[])HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (Object)it.getName());
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        VirtualFile nearestOtherFile = (VirtualFile)CollectionsKt.minWithOrNull((Iterable)((List)destination$iv$iv), (Comparator)new DistanceFromFileComparator(nearestFile));
        VirtualFile pubFile = isPrivate ? nearestOtherFile : nearestFile;
        VirtualFile privateFile = isPrivate ? nearestFile : nearestOtherFile;
        VirtualFile virtualFile3 = pubFile;
        VirtualFile virtualFile4 = privateFile;
        return new EnvironmentDescriptor(name, (PsiFile)(virtualFile3 != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile3, (Project)project2) : null), (PsiFile)(virtualFile4 != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile4, (Project)project2) : null), false);
    }

    private final PsiFileGist<List<Pair<String, Set<String>>>> getGist() {
        Lazy lazy = gist$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (PsiFileGist)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result fastEnvironments$lambda$11(PsiFile $file) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Object element$iv$iv3;
        Object[] $this$mapNotNullTo$iv;
        PsiFile it$iv;
        boolean bl2;
        String it;
        boolean bl3;
        Object element$iv;
        Object element$iv$iv2;
        int n;
        Object[] $this$mapNotNullTo$iv2;
        PsiDirectory psiDirectory = $file.getParent();
        if (psiDirectory == null) {
            return CachedValueProvider.Result.createSingleDependency((Object)CollectionsKt.emptyList(), (Object)PsiModificationTracker.MODIFICATION_COUNT);
        }
        PsiDirectory parent = psiDirectory;
        List envFiles = new ArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
        Object[] objectArray = HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES;
        Object[] destination$iv = (Object[])envFiles;
        boolean $i$f$mapNotNullTo = false;
        Object[] $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            element$iv = element$iv$iv2 = $this$forEach$iv$iv[n];
            bl3 = false;
            it = (String)element$iv;
            boolean bl4 = false;
            if (parent.findFile(it) == null) continue;
            bl2 = false;
            destination$iv.add(it$iv);
        }
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
        $this$mapNotNullTo$iv2 = HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES;
        destination$iv = envFiles;
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
        $i$f$forEach = false;
        n2 = $this$forEach$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            element$iv = element$iv$iv2 = $this$forEach$iv$iv[n];
            bl3 = false;
            it = (String)element$iv;
            boolean bl5 = false;
            if (parent.findFile(it) == null) continue;
            bl2 = false;
            destination$iv.add(it$iv);
        }
        PsiDirectory grandParent = parent.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
        destination$iv = HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES;
        Object destination$iv2 = envFiles;
        boolean $i$f$mapNotNullTo2 = false;
        Object[] $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv3 : $this$forEach$iv$iv2) {
            PsiFile it$iv2;
            void element$iv2 = element$iv$iv3;
            boolean bl6 = false;
            String it2 = (String)element$iv2;
            boolean bl7 = false;
            PsiDirectory psiDirectory2 = grandParent;
            if ((psiDirectory2 != null ? psiDirectory2.findFile(it2) : null) == null) continue;
            it$iv2 = it$iv2;
            bl = false;
            destination$iv2.add(it$iv2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
        $this$mapNotNullTo$iv = HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES;
        destination$iv2 = envFiles;
        $i$f$mapNotNullTo2 = false;
        $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
        $i$f$forEach2 = false;
        int element$iv$iv4 = $this$forEach$iv$iv2.length;
        for (n2 = 0; n2 < element$iv$iv4; ++n2) {
            PsiFile it$iv3;
            Object element$iv3 = element$iv$iv3 = $this$forEach$iv$iv2[n2];
            boolean bl8 = false;
            String it3 = (String)element$iv3;
            boolean bl9 = false;
            PsiDirectory psiDirectory3 = grandParent;
            if ((psiDirectory3 != null ? psiDirectory3.findFile(it3) : null) == null) continue;
            it$iv3 = it$iv3;
            bl = false;
            destination$iv2.add(it$iv3);
        }
        Map envNamesInFiles = new LinkedHashMap();
        for (PsiFile envFile : envFiles) {
            List envNames = (List)INSTANCE.getGist().getFileData(envFile);
            Iterator $i$f$forEach3 = envNames.iterator();
            while ($i$f$forEach3.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                String envName = (String)((Pair)$i$f$forEach3.next()).component1();
                element$iv$iv3 = envNamesInFiles;
                String key$iv = envName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl10 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Collection)object).add(envFile);
            }
        }
        Map $this$map$iv = envNamesInFiles;
        boolean $i$f$map = false;
        Map $i$f$forEach3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v5;
            PsiFile publicFile;
            String env;
            Collection collection;
            block13: {
                Object v4;
                List files;
                block12: {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl11 = false;
                    env = (String)entry.getKey();
                    files = (List)entry.getValue();
                    Iterable $this$firstOrNull$iv = files;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv4 : $this$firstOrNull$iv) {
                        PsiFile it4 = (PsiFile)element$iv4;
                        boolean bl12 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (String)"ENV_FILE_NAMES");
                        if (!ArraysKt.contains((Object[])HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES, (Object)it4.getName())) continue;
                        v4 = element$iv4;
                        break block12;
                    }
                    v4 = null;
                }
                publicFile = v4;
                Iterable $this$firstOrNull$iv = files;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv5 : $this$firstOrNull$iv) {
                    PsiFile it5 = (PsiFile)element$iv5;
                    boolean bl13 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (String)"ENV_PRIVATE_FILE_NAMES");
                    if (!ArraysKt.contains((Object[])HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES, (Object)it5.getName())) continue;
                    v5 = element$iv5;
                    break block13;
                }
                v5 = null;
            }
            PsiFile privateFile = v5;
            collection.add(new EnvironmentDescriptor(env, publicFile, privateFile, true));
        }
        List result2 = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = result2;
        boolean $i$f$sortedBy = false;
        Object[] objectArray2 = new Object[]{HttpClientEnvironmentsProviderKt.access$jsonModificationTracker($file), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS};
        return CachedValueProvider.Result.create((Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EnvironmentDescriptor it = (EnvironmentDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (EnvironmentDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private static final CachedValueProvider.Result environmentsFromIndex$lambda$16(PsiFile $file) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Project project = $file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2)) {
            Object[] objectArray = new Object[]{DumbService.Companion.getInstance(project2).getModificationTracker()};
            return CachedValueProvider.Result.create((Object)CollectionsKt.emptyList(), (Object[])objectArray);
        }
        Iterable $this$map$iv = INSTANCE.fastEnvironments($file);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EnvironmentDescriptor environmentDescriptor = (EnvironmentDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List fastEnvironments = (List)destination$iv$iv;
        Collection<String> collection = HttpRequestIndex.getAllEnvironments(project2, $file);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllEnvironments(...)");
        Iterable $i$f$map22 = collection;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!fastEnvironments.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List envs2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
        Iterable $this$mapNotNull$iv = envs2;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EnvironmentDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String env = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)env);
            if (INSTANCE.environmentByNameFromIndex($file, env) == null) continue;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List result2 = (List)destination$iv$iv3;
        Iterable $this$sortedBy$iv = result2;
        boolean $i$f$sortedBy = false;
        Object[] objectArray = new Object[]{HttpClientEnvironmentsProviderKt.access$jsonModificationTracker($file), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, DumbService.Companion.getInstance(project2).getModificationTracker()};
        return CachedValueProvider.Result.create((Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EnvironmentDescriptor it = (EnvironmentDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (EnvironmentDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }), (Object[])objectArray);
    }

    private static final List gist_delegate$lambda$21$lambda$19(PsiFile file) {
        List list2;
        if (!(file instanceof JsonFile)) {
            return new ArrayList();
        }
        List $this$gist_delegate_u24lambda_u2421_u24lambda_u2419_u24lambda_u2418 = list2 = (List)new ArrayList();
        boolean bl = false;
        Map<String, Set<String>> map2 = HttpRequestEnvironmentIndex.getVariablesFromFile(file);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getVariablesFromFile(...)");
        for (Map.Entry<String, Set<String>> entry : map2.entrySet()) {
            $this$gist_delegate_u24lambda_u2421_u24lambda_u2419_u24lambda_u2418.add(TuplesKt.to((Object)entry.getKey(), entry.getValue()));
        }
        return list2;
    }

    private static final List gist_delegate$lambda$21$lambda$20(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final PsiFileGist gist_delegate$lambda$21() {
        return GistManager.getInstance().newPsiFileGist("http.client.environment.files.gist.key", 2, (DataExternalizer)MyVariablesExternalizer.INSTANCE, arg_0 -> HttpClientEnvironmentsProvider.gist_delegate$lambda$21$lambda$20(HttpClientEnvironmentsProvider::gist_delegate$lambda$21$lambda$19, arg_0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u00120\u0011H\u0007J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0007J\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\bJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c2\u0003J5\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor;", "", "name", "", "publicEnvFile", "Lcom/intellij/psi/PsiFile;", "privateEnvFile", "isFast", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiFile;Z)V", "getName", "()Ljava/lang/String;", "getPublicEnvFile", "()Lcom/intellij/psi/PsiFile;", "getPrivateEnvFile", "getFilesContent", "", "Lkotlin/Pair;", "", "getVariables", "isSingle", "()Z", "single", "forcedPublicEnv", "getForcedPublicEnv", "forcedPrivateEnvFile", "getForcedPrivateEnvFile", "getFile", "private", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientEnvironmentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1563#3:317\n1634#3,2:318\n295#3,2:320\n1636#3:322\n*S KotlinDebug\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor\n*L\n184#1:317\n184#1:318,2\n186#1:320,2\n184#1:322\n*E\n"})
    public static final class EnvironmentDescriptor {
        @NotNull
        private final String name;
        @Nullable
        private final PsiFile publicEnvFile;
        @Nullable
        private final PsiFile privateEnvFile;
        private final boolean isFast;

        public EnvironmentDescriptor(@NotNull String name, @Nullable PsiFile publicEnvFile, @Nullable PsiFile privateEnvFile, boolean isFast) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.publicEnvFile = publicEnvFile;
            this.privateEnvFile = privateEnvFile;
            this.isFast = isFast;
            if (!(this.publicEnvFile != null || this.privateEnvFile != null)) {
                boolean bl = false;
                String string = "One of the files must be not-null!";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final PsiFile getPublicEnvFile() {
            return this.publicEnvFile;
        }

        @Nullable
        public final PsiFile getPrivateEnvFile() {
            return this.privateEnvFile;
        }

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        @RequiresReadLock
        @NotNull
        public final List<Pair<PsiFile, Set<String>>> getFilesContent() {
            void $this$mapTo$iv$iv;
            Object[] objectArray = new PsiFile[]{this.privateEnvFile, this.publicEnvFile};
            Iterable $this$map$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Set set2;
                void file;
                PsiFile psiFile = (PsiFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = file;
                if (this.isFast) {
                    Object v2;
                    void var11_11;
                    block5: {
                        void $this$firstOrNull$iv;
                        Object object = INSTANCE.getGist().getFileData((PsiFile)file);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFileData(...)");
                        Iterable iterable2 = (Iterable)object;
                        var11_11 = v0;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)this.name)) continue;
                            v2 = element$iv;
                            break block5;
                        }
                        v2 = null;
                    }
                    v0 = var11_11;
                    Pair pair = v2;
                    Set set3 = pair != null ? (Set)pair.getSecond() : null;
                    if (set3 == null) {
                        set3 = SetsKt.emptySet();
                    }
                    set2 = CollectionsKt.toSet((Iterable)set3);
                } else {
                    List list2 = FileBasedIndex.getInstance().getValues(HttpRequestEnvironmentIndex.INDEX_ID, (Object)this.name, GlobalSearchScope.fileScope((PsiFile)file));
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValues(...)");
                    set2 = SequencesKt.toSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)list2)));
                }
                collection.add(TuplesKt.to((Object)v0, (Object)set2));
            }
            return (List)destination$iv$iv;
        }

        @RequiresBackgroundThread
        @RequiresReadLock
        @NotNull
        public final Set<String> getVariables() {
            Set set2;
            Set $this$getVariables_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            Iterator<Pair<PsiFile, Set<String>>> iterator = this.getFilesContent().iterator();
            while (iterator.hasNext()) {
                Set variables2 = (Set)iterator.next().component2();
                $this$getVariables_u24lambda_u243.addAll(variables2);
            }
            return SetsKt.build((Set)set2);
        }

        public final boolean isSingle() {
            return this.publicEnvFile == null || this.privateEnvFile == null;
        }

        @NotNull
        public final PsiFile single() {
            PsiFile psiFile = this.publicEnvFile;
            if (psiFile == null && (psiFile = this.privateEnvFile) == null) {
                throw new IllegalStateException("Both files are nulls. Impossible!!".toString());
            }
            return psiFile;
        }

        @NotNull
        public final PsiFile getForcedPublicEnv() {
            PsiFile psiFile = this.publicEnvFile;
            if (psiFile == null) {
                throw new IllegalStateException("publicEnvFile is null".toString());
            }
            return psiFile;
        }

        @NotNull
        public final PsiFile getForcedPrivateEnvFile() {
            PsiFile psiFile = this.privateEnvFile;
            if (psiFile == null) {
                throw new IllegalStateException("privateEnvFile is null".toString());
            }
            return psiFile;
        }

        @Nullable
        public final PsiFile getFile(boolean bl) {
            return bl ? this.privateEnvFile : this.publicEnvFile;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final PsiFile component2() {
            return this.publicEnvFile;
        }

        @Nullable
        public final PsiFile component3() {
            return this.privateEnvFile;
        }

        private final boolean component4() {
            return this.isFast;
        }

        @NotNull
        public final EnvironmentDescriptor copy(@NotNull String name, @Nullable PsiFile publicEnvFile, @Nullable PsiFile privateEnvFile, boolean isFast) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new EnvironmentDescriptor(name, publicEnvFile, privateEnvFile, isFast);
        }

        public static /* synthetic */ EnvironmentDescriptor copy$default(EnvironmentDescriptor environmentDescriptor, String string, PsiFile psiFile, PsiFile psiFile2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = environmentDescriptor.name;
            }
            if ((n & 2) != 0) {
                psiFile = environmentDescriptor.publicEnvFile;
            }
            if ((n & 4) != 0) {
                psiFile2 = environmentDescriptor.privateEnvFile;
            }
            if ((n & 8) != 0) {
                bl = environmentDescriptor.isFast;
            }
            return environmentDescriptor.copy(string, psiFile, psiFile2, bl);
        }

        @NotNull
        public String toString() {
            return "EnvironmentDescriptor(name=" + this.name + ", publicEnvFile=" + this.publicEnvFile + ", privateEnvFile=" + this.privateEnvFile + ", isFast=" + this.isFast + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.publicEnvFile == null ? 0 : this.publicEnvFile.hashCode());
            result2 = result2 * 31 + (this.privateEnvFile == null ? 0 : this.privateEnvFile.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isFast);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnvironmentDescriptor)) {
                return false;
            }
            EnvironmentDescriptor environmentDescriptor = (EnvironmentDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)environmentDescriptor.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publicEnvFile, (Object)environmentDescriptor.publicEnvFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.privateEnvFile, (Object)environmentDescriptor.privateEnvFile)) {
                return false;
            }
            return this.isFast == environmentDescriptor.isFast;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentsSearchResult;", "", "fileRelated", "", "Lcom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentDescriptor;", "fromProject", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getFileRelated", "()Ljava/util/List;", "getFromProject", "asList", "asListOfNames", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientEnvironmentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentsSearchResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1634#2,3:316\n1634#2,3:319\n*S KotlinDebug\n*F\n+ 1 HttpClientEnvironmentsProvider.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentsProvider$EnvironmentsSearchResult\n*L\n232#1:316,3\n233#1:319,3\n*E\n"})
    public static final class EnvironmentsSearchResult {
        @NotNull
        private final List<EnvironmentDescriptor> fileRelated;
        @NotNull
        private final List<EnvironmentDescriptor> fromProject;

        public EnvironmentsSearchResult(@NotNull List<EnvironmentDescriptor> fileRelated, @NotNull List<EnvironmentDescriptor> fromProject) {
            Intrinsics.checkNotNullParameter(fileRelated, (String)"fileRelated");
            Intrinsics.checkNotNullParameter(fromProject, (String)"fromProject");
            this.fileRelated = fileRelated;
            this.fromProject = fromProject;
        }

        @NotNull
        public final List<EnvironmentDescriptor> getFileRelated() {
            return this.fileRelated;
        }

        @NotNull
        public final List<EnvironmentDescriptor> getFromProject() {
            return this.fromProject;
        }

        @NotNull
        public final List<EnvironmentDescriptor> asList() {
            return CollectionsKt.plus((Collection)this.fileRelated, (Iterable)this.fromProject);
        }

        @NotNull
        public final List<String> asListOfNames() {
            EnvironmentDescriptor it;
            Collection collection;
            Iterable $this$mapTo$iv;
            List list2;
            List $this$asListOfNames_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable iterable = this.fileRelated;
            Collection destination$iv = $this$asListOfNames_u24lambda_u242;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                EnvironmentDescriptor environmentDescriptor = (EnvironmentDescriptor)item$iv;
                collection = destination$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            $this$mapTo$iv = this.fromProject;
            destination$iv = $this$asListOfNames_u24lambda_u242;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (EnvironmentDescriptor)item$iv;
                collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getName());
            }
            return CollectionsKt.build((List)list2);
        }

        @NotNull
        public final List<EnvironmentDescriptor> component1() {
            return this.fileRelated;
        }

        @NotNull
        public final List<EnvironmentDescriptor> component2() {
            return this.fromProject;
        }

        @NotNull
        public final EnvironmentsSearchResult copy(@NotNull List<EnvironmentDescriptor> fileRelated, @NotNull List<EnvironmentDescriptor> fromProject) {
            Intrinsics.checkNotNullParameter(fileRelated, (String)"fileRelated");
            Intrinsics.checkNotNullParameter(fromProject, (String)"fromProject");
            return new EnvironmentsSearchResult(fileRelated, fromProject);
        }

        public static /* synthetic */ EnvironmentsSearchResult copy$default(EnvironmentsSearchResult environmentsSearchResult, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = environmentsSearchResult.fileRelated;
            }
            if ((n & 2) != 0) {
                list3 = environmentsSearchResult.fromProject;
            }
            return environmentsSearchResult.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "EnvironmentsSearchResult(fileRelated=" + this.fileRelated + ", fromProject=" + this.fromProject + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.fileRelated).hashCode();
            result2 = result2 * 31 + ((Object)this.fromProject).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnvironmentsSearchResult)) {
                return false;
            }
            EnvironmentsSearchResult environmentsSearchResult = (EnvironmentsSearchResult)other;
            if (!Intrinsics.areEqual(this.fileRelated, environmentsSearchResult.fileRelated)) {
                return false;
            }
            return Intrinsics.areEqual(this.fromProject, environmentsSearchResult.fromProject);
        }
    }
}

