#[inline]
pub unsafe fn CreateDataModelManager<P0>(debughost: P0) -> windows_core::Result<IDataModelManager>
where
    P0: windows_core::Param<IDebugHost>,
{
    windows_link::link!("dbgmodel.dll" "system" fn CreateDataModelManager(debughost : * mut core::ffi::c_void, manager : *mut * mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe {
        let mut result__ = core::mem::zeroed();
        CreateDataModelManager(debughost.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
    }
}
#[inline]
pub unsafe fn DebugConnect<P0>(remoteoptions: P0, interfaceid: *const windows_core::GUID, interface: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCSTR>,
{
    windows_link::link!("dbgeng.dll" "system" fn DebugConnect(remoteoptions : windows_core::PCSTR, interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { DebugConnect(remoteoptions.param().abi(), interfaceid, interface as _).ok() }
}
#[inline]
pub unsafe fn DebugConnectWide<P0>(remoteoptions: P0, interfaceid: *const windows_core::GUID, interface: *mut *mut core::ffi::c_void) -> windows_core::Result<()>
where
    P0: windows_core::Param<windows_core::PCWSTR>,
{
    windows_link::link!("dbgeng.dll" "system" fn DebugConnectWide(remoteoptions : windows_core::PCWSTR, interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    unsafe { DebugConnectWide(remoteoptions.param().abi(), interfaceid, interface as _).ok() }
}
#[inline]
pub unsafe fn DebugCreate<T>() -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_link::link!("dbgeng.dll" "system" fn DebugCreate(interfaceid : *const windows_core::GUID, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { DebugCreate(&T::IID, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
#[inline]
pub unsafe fn DebugCreateEx<T>(dbgengoptions: u32) -> windows_core::Result<T>
where
    T: windows_core::Interface,
{
    windows_link::link!("dbgeng.dll" "system" fn DebugCreateEx(interfaceid : *const windows_core::GUID, dbgengoptions : u32, interface : *mut *mut core::ffi::c_void) -> windows_core::HRESULT);
    let mut result__ = core::ptr::null_mut();
    unsafe { DebugCreateEx(&T::IID, dbgengoptions, &mut result__).and_then(|| windows_core::Type::from_abi(result__)) }
}
pub const ADDRESS_TYPE_INDEX_NOT_FOUND: u32 = 11u32;
pub const Ambiguous: SignatureComparison = SignatureComparison(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct ArrayDimension {
    pub LowerBound: i64,
    pub Length: u64,
    pub Stride: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BUSDATA {
    pub BusDataType: u32,
    pub BusNumber: u32,
    pub SlotNumber: u32,
    pub Buffer: *mut core::ffi::c_void,
    pub Offset: u32,
    pub Length: u32,
}
impl Default for BUSDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CANNOT_ALLOCATE_MEMORY: u32 = 9u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CKCL_DATA {
    pub NextLogEvent: *mut core::ffi::c_void,
    pub TAnalyzeString: windows_core::PSTR,
    pub TAnalyzeReturnType: TANALYZE_RETURN,
}
impl Default for CKCL_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CKCL_LISTHEAD {
    pub LogEventListHead: *mut CKCL_DATA,
    pub Heap: super::super::super::super::Foundation::HANDLE,
}
impl Default for CKCL_LISTHEAD {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CLSID_DebugFailureAnalysisBasic: windows_core::GUID = windows_core::GUID::from_u128(0xb74eed7f_1c7d_4c1b_959f_b96dd9175aa4);
pub const CLSID_DebugFailureAnalysisKernel: windows_core::GUID = windows_core::GUID::from_u128(0xee433078_64af_4c33_ab2f_ecad7f2a002d);
pub const CLSID_DebugFailureAnalysisTarget: windows_core::GUID = windows_core::GUID::from_u128(0xba9bfb05_ef75_4bbd_a745_a6b5529458b8);
pub const CLSID_DebugFailureAnalysisUser: windows_core::GUID = windows_core::GUID::from_u128(0xe60b0c93_cf49_4a32_8147_0362202dc56b);
pub const CLSID_DebugFailureAnalysisWinCE: windows_core::GUID = windows_core::GUID::from_u128(0x67d5e86f_f5e2_462a_9233_1bd616fcc7e8);
pub const CLSID_DebugFailureAnalysisXBox360: windows_core::GUID = windows_core::GUID::from_u128(0x901625bb_95f1_4318_ac80_9d733cee8c8b);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CPU_INFO {
    pub Type: u32,
    pub NumCPUs: u32,
    pub CurrentProc: u32,
    pub ProcInfo: [DEBUG_PROCESSOR_IDENTIFICATION_ALL; 2048],
    pub Mhz: u32,
}
impl Default for CPU_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CPU_INFO_v1 {
    pub Type: u32,
    pub NumCPUs: u32,
    pub CurrentProc: u32,
    pub ProcInfo: [DEBUG_PROCESSOR_IDENTIFICATION_ALL; 32],
    pub Mhz: u32,
}
impl Default for CPU_INFO_v1 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct CPU_INFO_v2 {
    pub Type: u32,
    pub NumCPUs: u32,
    pub CurrentProc: u32,
    pub ProcInfo: [DEBUG_PROCESSOR_IDENTIFICATION_ALL; 1280],
    pub Mhz: u32,
}
impl Default for CPU_INFO_v2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const CROSS_PLATFORM_MAXIMUM_PROCESSORS: u32 = 2048u32;
pub const CURRENT_KD_SECONDARY_VERSION: u32 = 2u32;
pub const CallingConventionCDecl: CallingConventionKind = CallingConventionKind(1i32);
pub const CallingConventionFastCall: CallingConventionKind = CallingConventionKind(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CallingConventionKind(pub i32);
pub const CallingConventionStdCall: CallingConventionKind = CallingConventionKind(3i32);
pub const CallingConventionSysCall: CallingConventionKind = CallingConventionKind(4i32);
pub const CallingConventionThisCall: CallingConventionKind = CallingConventionKind(5i32);
pub const CallingConventionUnknown: CallingConventionKind = CallingConventionKind(0i32);
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DBGKD_DEBUG_DATA_HEADER32 {
    pub List: super::super::super::Kernel::LIST_ENTRY32,
    pub OwnerTag: u32,
    pub Size: u32,
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DBGKD_DEBUG_DATA_HEADER64 {
    pub List: super::super::super::Kernel::LIST_ENTRY64,
    pub OwnerTag: u32,
    pub Size: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DBGKD_GET_VERSION32 {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub ProtocolVersion: u16,
    pub Flags: u16,
    pub KernBase: u32,
    pub PsLoadedModuleList: u32,
    pub MachineType: u16,
    pub ThCallbackStack: u16,
    pub NextCallback: u16,
    pub FramePointer: u16,
    pub KiCallUserMode: u32,
    pub KeUserCallbackDispatcher: u32,
    pub BreakpointWithStatus: u32,
    pub DebuggerDataList: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DBGKD_GET_VERSION64 {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub ProtocolVersion: u8,
    pub KdSecondaryVersion: u8,
    pub Flags: u16,
    pub MachineType: u16,
    pub MaxPacketType: u8,
    pub MaxStateChange: u8,
    pub MaxManipulate: u8,
    pub Simulation: u8,
    pub Unused: [u16; 1],
    pub KernBase: u64,
    pub PsLoadedModuleList: u64,
    pub DebuggerDataList: u64,
}
impl Default for DBGKD_GET_VERSION64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DBGKD_MAJOR_BIG: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(2i32);
pub const DBGKD_MAJOR_CE: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(10i32);
pub const DBGKD_MAJOR_COUNT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(11i32);
pub const DBGKD_MAJOR_EFI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(5i32);
pub const DBGKD_MAJOR_EXDI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(3i32);
pub const DBGKD_MAJOR_HYPERVISOR: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(8i32);
pub const DBGKD_MAJOR_MIDORI: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(9i32);
pub const DBGKD_MAJOR_NT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(0i32);
pub const DBGKD_MAJOR_NTBD: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(4i32);
pub const DBGKD_MAJOR_SINGULARITY: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(7i32);
pub const DBGKD_MAJOR_TNT: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(6i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DBGKD_MAJOR_TYPES(pub i32);
pub const DBGKD_MAJOR_XBOX: DBGKD_MAJOR_TYPES = DBGKD_MAJOR_TYPES(1i32);
pub const DBGKD_SIMULATION_EXDI: i32 = 1i32;
pub const DBGKD_SIMULATION_NONE: i32 = 0i32;
pub const DBGKD_VERS_FLAG_DATA: u32 = 2u32;
pub const DBGKD_VERS_FLAG_HAL_IN_NTOS: u32 = 64u32;
pub const DBGKD_VERS_FLAG_HSS: u32 = 16u32;
pub const DBGKD_VERS_FLAG_MP: u32 = 1u32;
pub const DBGKD_VERS_FLAG_NOMM: u32 = 8u32;
pub const DBGKD_VERS_FLAG_PARTITIONS: u32 = 32u32;
pub const DBGKD_VERS_FLAG_PTR64: u32 = 4u32;
pub const DBG_DUMP_ADDRESS_AT_END: u32 = 131072u32;
pub const DBG_DUMP_ADDRESS_OF_FIELD: u32 = 65536u32;
pub const DBG_DUMP_ARRAY: u32 = 32768u32;
pub const DBG_DUMP_BLOCK_RECURSE: u32 = 2097152u32;
pub const DBG_DUMP_CALL_FOR_EACH: u32 = 8u32;
pub const DBG_DUMP_COMPACT_OUT: u32 = 8192u32;
pub const DBG_DUMP_COPY_TYPE_DATA: u32 = 262144u32;
pub const DBG_DUMP_FIELD_ARRAY: u32 = 16u32;
pub const DBG_DUMP_FIELD_CALL_BEFORE_PRINT: u32 = 1u32;
pub const DBG_DUMP_FIELD_COPY_FIELD_DATA: u32 = 32u32;
pub const DBG_DUMP_FIELD_DEFAULT_STRING: u32 = 65536u32;
pub const DBG_DUMP_FIELD_FULL_NAME: u32 = 8u32;
pub const DBG_DUMP_FIELD_GUID_STRING: u32 = 524288u32;
pub const DBG_DUMP_FIELD_MULTI_STRING: u32 = 262144u32;
pub const DBG_DUMP_FIELD_NO_CALLBACK_REQ: u32 = 2u32;
pub const DBG_DUMP_FIELD_NO_PRINT: u32 = 16384u32;
pub const DBG_DUMP_FIELD_RECUR_ON_THIS: u32 = 4u32;
pub const DBG_DUMP_FIELD_RETURN_ADDRESS: u32 = 4096u32;
pub const DBG_DUMP_FIELD_SIZE_IN_BITS: u32 = 8192u32;
pub const DBG_DUMP_FIELD_UTF32_STRING: u32 = 1048576u32;
pub const DBG_DUMP_FIELD_WCHAR_STRING: u32 = 131072u32;
pub const DBG_DUMP_FUNCTION_FORMAT: u32 = 1048576u32;
pub const DBG_DUMP_GET_SIZE_ONLY: u32 = 128u32;
pub const DBG_DUMP_LIST: u32 = 32u32;
pub const DBG_DUMP_MATCH_SIZE: u32 = 4194304u32;
pub const DBG_DUMP_NO_INDENT: u32 = 1u32;
pub const DBG_DUMP_NO_OFFSET: u32 = 2u32;
pub const DBG_DUMP_NO_PRINT: u32 = 64u32;
pub const DBG_DUMP_READ_PHYSICAL: u32 = 524288u32;
pub const DBG_DUMP_VERBOSE: u32 = 4u32;
pub const DBG_FRAME_DEFAULT: u32 = 0u32;
pub const DBG_FRAME_IGNORE_INLINE: u32 = 4294967295u32;
pub const DBG_RETURN_SUBTYPES: u32 = 0u32;
pub const DBG_RETURN_TYPE: u32 = 0u32;
pub const DBG_RETURN_TYPE_VALUES: u32 = 0u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DBG_THREAD_ATTRIBUTES {
    pub ThreadIndex: u32,
    pub ProcessID: u64,
    pub ThreadID: u64,
    pub AttributeBits: u64,
    pub BoolBits: u32,
    pub BlockedOnPID: u64,
    pub BlockedOnTID: u64,
    pub CritSecAddress: u64,
    pub Timeout_msec: u32,
    pub StringData: [i8; 100],
    pub SymName: [i8; 100],
}
impl Default for DBG_THREAD_ATTRIBUTES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_ADDSYNTHMOD_DEFAULT: u32 = 0u32;
pub const DEBUG_ADDSYNTHMOD_ZEROBASE: u32 = 1u32;
pub const DEBUG_ADDSYNTHSYM_DEFAULT: u32 = 0u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_ANALYSIS_PROCESSOR_INFO {
    pub SizeOfStruct: u32,
    pub Model: u32,
    pub Family: u32,
    pub Stepping: u32,
    pub Architecture: u32,
    pub Revision: u32,
    pub CurrentClockSpeed: u32,
    pub CurrentVoltage: u32,
    pub MaxClockSpeed: u32,
    pub ProcessorType: u32,
    pub DeviceID: [i8; 32],
    pub Manufacturer: [i8; 64],
    pub Name: [i8; 64],
    pub Version: [i8; 64],
    pub Description: [i8; 64],
}
impl Default for DEBUG_ANALYSIS_PROCESSOR_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_ANY_ID: u32 = 4294967295u32;
pub const DEBUG_ASMOPT_DEFAULT: u32 = 0u32;
pub const DEBUG_ASMOPT_IGNORE_OUTPUT_WIDTH: u32 = 4u32;
pub const DEBUG_ASMOPT_NO_CODE_BYTES: u32 = 2u32;
pub const DEBUG_ASMOPT_SOURCE_LINE_NUMBER: u32 = 8u32;
pub const DEBUG_ASMOPT_VERBOSE: u32 = 1u32;
pub const DEBUG_ATTACH_DEFAULT: u32 = 0u32;
pub const DEBUG_ATTACH_EXDI_DRIVER: u32 = 2u32;
pub const DEBUG_ATTACH_EXISTING: u32 = 2u32;
pub const DEBUG_ATTACH_INSTALL_DRIVER: u32 = 4u32;
pub const DEBUG_ATTACH_INVASIVE_NO_INITIAL_BREAK: u32 = 8u32;
pub const DEBUG_ATTACH_INVASIVE_RESUME_PROCESS: u32 = 16u32;
pub const DEBUG_ATTACH_KERNEL_CONNECTION: u32 = 0u32;
pub const DEBUG_ATTACH_LOCAL_KERNEL: u32 = 1u32;
pub const DEBUG_ATTACH_NONINVASIVE: u32 = 1u32;
pub const DEBUG_ATTACH_NONINVASIVE_ALLOW_PARTIAL: u32 = 32u32;
pub const DEBUG_ATTACH_NONINVASIVE_NO_SUSPEND: u32 = 4u32;
pub const DEBUG_BREAKPOINT_ADDER_ONLY: u32 = 8u32;
pub const DEBUG_BREAKPOINT_CODE: u32 = 0u32;
pub const DEBUG_BREAKPOINT_DATA: u32 = 1u32;
pub const DEBUG_BREAKPOINT_DEFERRED: u32 = 2u32;
pub const DEBUG_BREAKPOINT_ENABLED: u32 = 4u32;
pub const DEBUG_BREAKPOINT_GO_ONLY: u32 = 1u32;
pub const DEBUG_BREAKPOINT_INLINE: u32 = 3u32;
pub const DEBUG_BREAKPOINT_ONE_SHOT: u32 = 16u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_BREAKPOINT_PARAMETERS {
    pub Offset: u64,
    pub Id: u32,
    pub BreakType: u32,
    pub ProcType: u32,
    pub Flags: u32,
    pub DataSize: u32,
    pub DataAccessType: u32,
    pub PassCount: u32,
    pub CurrentPassCount: u32,
    pub MatchThread: u32,
    pub CommandSize: u32,
    pub OffsetExpressionSize: u32,
}
pub const DEBUG_BREAKPOINT_TIME: u32 = 2u32;
pub const DEBUG_BREAK_EXECUTE: u32 = 4u32;
pub const DEBUG_BREAK_IO: u32 = 8u32;
pub const DEBUG_BREAK_READ: u32 = 1u32;
pub const DEBUG_BREAK_WRITE: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_CACHED_SYMBOL_INFO {
    pub ModBase: u64,
    pub Arg1: u64,
    pub Arg2: u64,
    pub Id: u32,
    pub Arg3: u32,
}
pub const DEBUG_CDS_ALL: u32 = 4294967295u32;
pub const DEBUG_CDS_DATA: u32 = 2u32;
pub const DEBUG_CDS_REFRESH: u32 = 4u32;
pub const DEBUG_CDS_REFRESH_ADDBREAKPOINT: u32 = 4u32;
pub const DEBUG_CDS_REFRESH_EVALUATE: u32 = 1u32;
pub const DEBUG_CDS_REFRESH_EXECUTE: u32 = 2u32;
pub const DEBUG_CDS_REFRESH_EXECUTECOMMANDFILE: u32 = 3u32;
pub const DEBUG_CDS_REFRESH_INLINESTEP: u32 = 16u32;
pub const DEBUG_CDS_REFRESH_INLINESTEP_PSEUDO: u32 = 17u32;
pub const DEBUG_CDS_REFRESH_REMOVEBREAKPOINT: u32 = 5u32;
pub const DEBUG_CDS_REFRESH_SETSCOPE: u32 = 12u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFRAMEBYINDEX: u32 = 13u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFROMJITDEBUGINFO: u32 = 14u32;
pub const DEBUG_CDS_REFRESH_SETSCOPEFROMSTOREDEVENT: u32 = 15u32;
pub const DEBUG_CDS_REFRESH_SETVALUE: u32 = 10u32;
pub const DEBUG_CDS_REFRESH_SETVALUE2: u32 = 11u32;
pub const DEBUG_CDS_REFRESH_WRITEPHYSICAL: u32 = 8u32;
pub const DEBUG_CDS_REFRESH_WRITEPHYSICAL2: u32 = 9u32;
pub const DEBUG_CDS_REFRESH_WRITEVIRTUAL: u32 = 6u32;
pub const DEBUG_CDS_REFRESH_WRITEVIRTUALUNCACHED: u32 = 7u32;
pub const DEBUG_CDS_REGISTERS: u32 = 1u32;
pub const DEBUG_CES_ALL: u32 = 4294967295u32;
pub const DEBUG_CES_ASSEMBLY_OPTIONS: u32 = 4096u32;
pub const DEBUG_CES_BREAKPOINTS: u32 = 4u32;
pub const DEBUG_CES_CODE_LEVEL: u32 = 8u32;
pub const DEBUG_CES_CURRENT_THREAD: u32 = 1u32;
pub const DEBUG_CES_EFFECTIVE_PROCESSOR: u32 = 2u32;
pub const DEBUG_CES_ENGINE_OPTIONS: u32 = 32u32;
pub const DEBUG_CES_EVENT_FILTERS: u32 = 256u32;
pub const DEBUG_CES_EXECUTION_STATUS: u32 = 16u32;
pub const DEBUG_CES_EXPRESSION_SYNTAX: u32 = 8192u32;
pub const DEBUG_CES_EXTENSIONS: u32 = 1024u32;
pub const DEBUG_CES_LOG_FILE: u32 = 64u32;
pub const DEBUG_CES_PROCESS_OPTIONS: u32 = 512u32;
pub const DEBUG_CES_RADIX: u32 = 128u32;
pub const DEBUG_CES_SYSTEMS: u32 = 2048u32;
pub const DEBUG_CES_TEXT_REPLACEMENTS: u32 = 16384u32;
pub const DEBUG_CLASS_IMAGE_FILE: u32 = 3u32;
pub const DEBUG_CLASS_KERNEL: u32 = 1u32;
pub const DEBUG_CLASS_UNINITIALIZED: u32 = 0u32;
pub const DEBUG_CLASS_USER_WINDOWS: u32 = 2u32;
pub const DEBUG_CLIENT_CDB: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_CLIENT_CONTEXT {
    pub cbSize: u32,
    pub eClient: u32,
}
pub const DEBUG_CLIENT_KD: u32 = 5u32;
pub const DEBUG_CLIENT_NTKD: u32 = 3u32;
pub const DEBUG_CLIENT_NTSD: u32 = 2u32;
pub const DEBUG_CLIENT_UNKNOWN: u32 = 0u32;
pub const DEBUG_CLIENT_VSINT: u32 = 1u32;
pub const DEBUG_CLIENT_WINDBG: u32 = 6u32;
pub const DEBUG_CLIENT_WINIDE: u32 = 7u32;
pub const DEBUG_CMDEX_ADD_EVENT_STRING: u32 = 1u32;
pub const DEBUG_CMDEX_INVALID: u32 = 0u32;
pub const DEBUG_CMDEX_RESET_EVENT_STRINGS: u32 = 2u32;
pub const DEBUG_COMMAND_EXCEPTION_ID: u32 = 3688893886u32;
pub const DEBUG_CONNECT_SESSION_DEFAULT: u32 = 0u32;
pub const DEBUG_CONNECT_SESSION_NO_ANNOUNCE: u32 = 2u32;
pub const DEBUG_CONNECT_SESSION_NO_VERSION: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_CPU_MICROCODE_VERSION {
    pub SizeOfStruct: u32,
    pub CachedSignature: i64,
    pub InitialSignature: i64,
    pub ProcessorModel: u32,
    pub ProcessorFamily: u32,
    pub ProcessorStepping: u32,
    pub ProcessorArchRev: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_CPU_SPEED_INFO {
    pub SizeOfStruct: u32,
    pub CurrentSpeed: u32,
    pub RatedSpeed: u32,
    pub NameString: [u16; 256],
}
impl Default for DEBUG_CPU_SPEED_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_CREATE_PROCESS_OPTIONS {
    pub CreateFlags: u32,
    pub EngCreateFlags: u32,
    pub VerifierFlags: u32,
    pub Reserved: u32,
}
pub const DEBUG_CSS_ALL: u32 = 4294967295u32;
pub const DEBUG_CSS_COLLAPSE_CHILDREN: u32 = 64u32;
pub const DEBUG_CSS_LOADS: u32 = 1u32;
pub const DEBUG_CSS_PATHS: u32 = 8u32;
pub const DEBUG_CSS_SCOPE: u32 = 4u32;
pub const DEBUG_CSS_SYMBOL_OPTIONS: u32 = 16u32;
pub const DEBUG_CSS_TYPE_OPTIONS: u32 = 32u32;
pub const DEBUG_CSS_UNLOADS: u32 = 2u32;
pub const DEBUG_CURRENT_DEFAULT: u32 = 15u32;
pub const DEBUG_CURRENT_DISASM: u32 = 2u32;
pub const DEBUG_CURRENT_REGISTERS: u32 = 4u32;
pub const DEBUG_CURRENT_SOURCE_LINE: u32 = 8u32;
pub const DEBUG_CURRENT_SYMBOL: u32 = 1u32;
pub const DEBUG_DATA_BASE_TRANSLATION_VIRTUAL_OFFSET: u32 = 3u32;
pub const DEBUG_DATA_BreakpointWithStatusAddr: u32 = 32u32;
pub const DEBUG_DATA_CmNtCSDVersionAddr: u32 = 616u32;
pub const DEBUG_DATA_DumpAttributes: u32 = 100072u32;
pub const DEBUG_DATA_DumpFormatVersion: u32 = 100040u32;
pub const DEBUG_DATA_DumpMmStorage: u32 = 100064u32;
pub const DEBUG_DATA_DumpPowerState: u32 = 100056u32;
pub const DEBUG_DATA_DumpWriterStatus: u32 = 100032u32;
pub const DEBUG_DATA_DumpWriterVersion: u32 = 100048u32;
pub const DEBUG_DATA_EtwpDebuggerData: u32 = 816u32;
pub const DEBUG_DATA_ExpNumberOfPagedPoolsAddr: u32 = 112u32;
pub const DEBUG_DATA_ExpPagedPoolDescriptorAddr: u32 = 104u32;
pub const DEBUG_DATA_ExpSystemResourcesListAddr: u32 = 96u32;
pub const DEBUG_DATA_IopErrorLogListHeadAddr: u32 = 144u32;
pub const DEBUG_DATA_KPCR_OFFSET: u32 = 0u32;
pub const DEBUG_DATA_KPRCB_OFFSET: u32 = 1u32;
pub const DEBUG_DATA_KTHREAD_OFFSET: u32 = 2u32;
pub const DEBUG_DATA_KdPrintBufferSizeAddr: u32 = 720u32;
pub const DEBUG_DATA_KdPrintCircularBufferAddr: u32 = 480u32;
pub const DEBUG_DATA_KdPrintCircularBufferEndAddr: u32 = 488u32;
pub const DEBUG_DATA_KdPrintCircularBufferPtrAddr: u32 = 712u32;
pub const DEBUG_DATA_KdPrintRolloverCountAddr: u32 = 504u32;
pub const DEBUG_DATA_KdPrintWritePointerAddr: u32 = 496u32;
pub const DEBUG_DATA_KeBugCheckCallbackListHeadAddr: u32 = 128u32;
pub const DEBUG_DATA_KeTimeIncrementAddr: u32 = 120u32;
pub const DEBUG_DATA_KeUserCallbackDispatcherAddr: u32 = 64u32;
pub const DEBUG_DATA_KernBase: u32 = 24u32;
pub const DEBUG_DATA_KernelVerifierAddr: u32 = 576u32;
pub const DEBUG_DATA_KiBugcheckDataAddr: u32 = 136u32;
pub const DEBUG_DATA_KiCallUserModeAddr: u32 = 56u32;
pub const DEBUG_DATA_KiNormalSystemCall: u32 = 528u32;
pub const DEBUG_DATA_KiProcessorBlockAddr: u32 = 536u32;
pub const DEBUG_DATA_MmAllocatedNonPagedPoolAddr: u32 = 592u32;
pub const DEBUG_DATA_MmAvailablePagesAddr: u32 = 424u32;
pub const DEBUG_DATA_MmBadPagesDetected: u32 = 800u32;
pub const DEBUG_DATA_MmDriverCommitAddr: u32 = 352u32;
pub const DEBUG_DATA_MmExtendedCommitAddr: u32 = 376u32;
pub const DEBUG_DATA_MmFreePageListHeadAddr: u32 = 392u32;
pub const DEBUG_DATA_MmHighestPhysicalPageAddr: u32 = 240u32;
pub const DEBUG_DATA_MmHighestUserAddressAddr: u32 = 456u32;
pub const DEBUG_DATA_MmLastUnloadedDriverAddr: u32 = 552u32;
pub const DEBUG_DATA_MmLoadedUserImageListAddr: u32 = 512u32;
pub const DEBUG_DATA_MmLowestPhysicalPageAddr: u32 = 232u32;
pub const DEBUG_DATA_MmMaximumNonPagedPoolInBytesAddr: u32 = 256u32;
pub const DEBUG_DATA_MmModifiedNoWritePageListHeadAddr: u32 = 416u32;
pub const DEBUG_DATA_MmModifiedPageListHeadAddr: u32 = 408u32;
pub const DEBUG_DATA_MmNonPagedPoolEndAddr: u32 = 280u32;
pub const DEBUG_DATA_MmNonPagedPoolStartAddr: u32 = 272u32;
pub const DEBUG_DATA_MmNonPagedSystemStartAddr: u32 = 264u32;
pub const DEBUG_DATA_MmNumberOfPagingFilesAddr: u32 = 224u32;
pub const DEBUG_DATA_MmNumberOfPhysicalPagesAddr: u32 = 248u32;
pub const DEBUG_DATA_MmPageSize: u32 = 312u32;
pub const DEBUG_DATA_MmPagedPoolCommitAddr: u32 = 368u32;
pub const DEBUG_DATA_MmPagedPoolEndAddr: u32 = 296u32;
pub const DEBUG_DATA_MmPagedPoolInformationAddr: u32 = 304u32;
pub const DEBUG_DATA_MmPagedPoolStartAddr: u32 = 288u32;
pub const DEBUG_DATA_MmPeakCommitmentAddr: u32 = 600u32;
pub const DEBUG_DATA_MmPfnDatabaseAddr: u32 = 192u32;
pub const DEBUG_DATA_MmPhysicalMemoryBlockAddr: u32 = 624u32;
pub const DEBUG_DATA_MmProcessCommitAddr: u32 = 360u32;
pub const DEBUG_DATA_MmResidentAvailablePagesAddr: u32 = 432u32;
pub const DEBUG_DATA_MmSessionBase: u32 = 632u32;
pub const DEBUG_DATA_MmSessionSize: u32 = 640u32;
pub const DEBUG_DATA_MmSharedCommitAddr: u32 = 344u32;
pub const DEBUG_DATA_MmSizeOfPagedPoolInBytesAddr: u32 = 320u32;
pub const DEBUG_DATA_MmSpecialPoolTagAddr: u32 = 568u32;
pub const DEBUG_DATA_MmStandbyPageListHeadAddr: u32 = 400u32;
pub const DEBUG_DATA_MmSubsectionBaseAddr: u32 = 216u32;
pub const DEBUG_DATA_MmSystemCacheEndAddr: u32 = 176u32;
pub const DEBUG_DATA_MmSystemCacheStartAddr: u32 = 168u32;
pub const DEBUG_DATA_MmSystemCacheWsAddr: u32 = 184u32;
pub const DEBUG_DATA_MmSystemParentTablePage: u32 = 648u32;
pub const DEBUG_DATA_MmSystemPtesEndAddr: u32 = 208u32;
pub const DEBUG_DATA_MmSystemPtesStartAddr: u32 = 200u32;
pub const DEBUG_DATA_MmSystemRangeStartAddr: u32 = 464u32;
pub const DEBUG_DATA_MmTotalCommitLimitAddr: u32 = 328u32;
pub const DEBUG_DATA_MmTotalCommitLimitMaximumAddr: u32 = 608u32;
pub const DEBUG_DATA_MmTotalCommittedPagesAddr: u32 = 336u32;
pub const DEBUG_DATA_MmTriageActionTakenAddr: u32 = 560u32;
pub const DEBUG_DATA_MmUnloadedDriversAddr: u32 = 544u32;
pub const DEBUG_DATA_MmUserProbeAddressAddr: u32 = 472u32;
pub const DEBUG_DATA_MmVerifierDataAddr: u32 = 584u32;
pub const DEBUG_DATA_MmVirtualTranslationBase: u32 = 656u32;
pub const DEBUG_DATA_MmZeroedPageListHeadAddr: u32 = 384u32;
pub const DEBUG_DATA_NonPagedPoolDescriptorAddr: u32 = 448u32;
pub const DEBUG_DATA_NtBuildLabAddr: u32 = 520u32;
pub const DEBUG_DATA_ObpRootDirectoryObjectAddr: u32 = 152u32;
pub const DEBUG_DATA_ObpTypeObjectTypeAddr: u32 = 160u32;
pub const DEBUG_DATA_OffsetEprocessDirectoryTableBase: u32 = 686u32;
pub const DEBUG_DATA_OffsetEprocessParentCID: u32 = 684u32;
pub const DEBUG_DATA_OffsetEprocessPeb: u32 = 682u32;
pub const DEBUG_DATA_OffsetKThreadApcProcess: u32 = 672u32;
pub const DEBUG_DATA_OffsetKThreadBStore: u32 = 676u32;
pub const DEBUG_DATA_OffsetKThreadBStoreLimit: u32 = 678u32;
pub const DEBUG_DATA_OffsetKThreadInitialStack: u32 = 670u32;
pub const DEBUG_DATA_OffsetKThreadKernelStack: u32 = 668u32;
pub const DEBUG_DATA_OffsetKThreadNextProcessor: u32 = 664u32;
pub const DEBUG_DATA_OffsetKThreadState: u32 = 674u32;
pub const DEBUG_DATA_OffsetKThreadTeb: u32 = 666u32;
pub const DEBUG_DATA_OffsetPrcbCpuType: u32 = 696u32;
pub const DEBUG_DATA_OffsetPrcbCurrentThread: u32 = 692u32;
pub const DEBUG_DATA_OffsetPrcbDpcRoutine: u32 = 690u32;
pub const DEBUG_DATA_OffsetPrcbMhz: u32 = 694u32;
pub const DEBUG_DATA_OffsetPrcbNumber: u32 = 702u32;
pub const DEBUG_DATA_OffsetPrcbProcessorState: u32 = 700u32;
pub const DEBUG_DATA_OffsetPrcbVendorString: u32 = 698u32;
pub const DEBUG_DATA_PROCESSOR_IDENTIFICATION: u32 = 4u32;
pub const DEBUG_DATA_PROCESSOR_SPEED: u32 = 5u32;
pub const DEBUG_DATA_PaeEnabled: u32 = 100000u32;
pub const DEBUG_DATA_PagingLevels: u32 = 100080u32;
pub const DEBUG_DATA_PoolTrackTableAddr: u32 = 440u32;
pub const DEBUG_DATA_ProductType: u32 = 100016u32;
pub const DEBUG_DATA_PsActiveProcessHeadAddr: u32 = 80u32;
pub const DEBUG_DATA_PsLoadedModuleListAddr: u32 = 72u32;
pub const DEBUG_DATA_PspCidTableAddr: u32 = 88u32;
pub const DEBUG_DATA_PteBase: u32 = 864u32;
pub const DEBUG_DATA_SPACE_BUS_DATA: u32 = 5u32;
pub const DEBUG_DATA_SPACE_CONTROL: u32 = 2u32;
pub const DEBUG_DATA_SPACE_COUNT: u32 = 7u32;
pub const DEBUG_DATA_SPACE_DEBUGGER_DATA: u32 = 6u32;
pub const DEBUG_DATA_SPACE_IO: u32 = 3u32;
pub const DEBUG_DATA_SPACE_MSR: u32 = 4u32;
pub const DEBUG_DATA_SPACE_PHYSICAL: u32 = 1u32;
pub const DEBUG_DATA_SPACE_VIRTUAL: u32 = 0u32;
pub const DEBUG_DATA_SavedContextAddr: u32 = 40u32;
pub const DEBUG_DATA_SharedUserData: u32 = 100008u32;
pub const DEBUG_DATA_SizeEProcess: u32 = 680u32;
pub const DEBUG_DATA_SizeEThread: u32 = 704u32;
pub const DEBUG_DATA_SizePrcb: u32 = 688u32;
pub const DEBUG_DATA_SuiteMask: u32 = 100024u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_DECODE_ERROR {
    pub SizeOfStruct: u32,
    pub Code: u32,
    pub TreatAsStatus: windows_core::BOOL,
    pub Source: [i8; 64],
    pub Message: [i8; 260],
}
impl Default for DEBUG_DECODE_ERROR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_DEVICE_OBJECT_INFO {
    pub SizeOfStruct: u32,
    pub DevObjAddress: u64,
    pub ReferenceCount: u32,
    pub QBusy: windows_core::BOOL,
    pub DriverObject: u64,
    pub CurrentIrp: u64,
    pub DevExtension: u64,
    pub DevObjExtension: u64,
}
pub const DEBUG_DISASM_EFFECTIVE_ADDRESS: u32 = 1u32;
pub const DEBUG_DISASM_MATCHING_SYMBOLS: u32 = 2u32;
pub const DEBUG_DISASM_SOURCE_FILE_NAME: u32 = 8u32;
pub const DEBUG_DISASM_SOURCE_LINE_NUMBER: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_DRIVER_OBJECT_INFO {
    pub SizeOfStruct: u32,
    pub DriverSize: u32,
    pub DriverObjAddress: u64,
    pub DriverStart: u64,
    pub DriverExtension: u64,
    pub DeviceObject: u64,
    pub DriverName: DEBUG_DRIVER_OBJECT_INFO_0,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_DRIVER_OBJECT_INFO_0 {
    pub Length: u16,
    pub MaximumLength: u16,
    pub Buffer: u64,
}
pub const DEBUG_DUMP_ACTIVE: u32 = 1030u32;
pub const DEBUG_DUMP_DEFAULT: u32 = 1025u32;
pub const DEBUG_DUMP_FILE_BASE: u32 = 4294967295u32;
pub const DEBUG_DUMP_FILE_LOAD_FAILED_INDEX: u32 = 4294967295u32;
pub const DEBUG_DUMP_FILE_ORIGINAL_CAB_INDEX: u32 = 4294967294u32;
pub const DEBUG_DUMP_FILE_PAGE_FILE_DUMP: u32 = 0u32;
pub const DEBUG_DUMP_FULL: u32 = 1026u32;
pub const DEBUG_DUMP_IMAGE_FILE: u32 = 1027u32;
pub const DEBUG_DUMP_SMALL: u32 = 1024u32;
pub const DEBUG_DUMP_TRACE_LOG: u32 = 1028u32;
pub const DEBUG_DUMP_WINDOWS_CE: u32 = 1029u32;
pub const DEBUG_ECREATE_PROCESS_DEFAULT: u32 = 0u32;
pub const DEBUG_ECREATE_PROCESS_INHERIT_HANDLES: u32 = 1u32;
pub const DEBUG_ECREATE_PROCESS_USE_IMPLICIT_COMMAND_LINE: u32 = 4u32;
pub const DEBUG_ECREATE_PROCESS_USE_VERIFIER_FLAGS: u32 = 2u32;
pub const DEBUG_EINDEX_FROM_CURRENT: u32 = 2u32;
pub const DEBUG_EINDEX_FROM_END: u32 = 1u32;
pub const DEBUG_EINDEX_FROM_START: u32 = 0u32;
pub const DEBUG_EINDEX_NAME: u32 = 0u32;
pub const DEBUG_END_ACTIVE_DETACH: u32 = 2u32;
pub const DEBUG_END_ACTIVE_TERMINATE: u32 = 1u32;
pub const DEBUG_END_DISCONNECT: u32 = 4u32;
pub const DEBUG_END_PASSIVE: u32 = 0u32;
pub const DEBUG_END_REENTRANT: u32 = 3u32;
pub const DEBUG_ENGOPT_ALL: u32 = 32505855u32;
pub const DEBUG_ENGOPT_ALLOW_NETWORK_PATHS: u32 = 4u32;
pub const DEBUG_ENGOPT_ALLOW_READ_ONLY_BREAKPOINTS: u32 = 1024u32;
pub const DEBUG_ENGOPT_DEBUGGING_SENSITIVE_DATA: u32 = 4194304u32;
pub const DEBUG_ENGOPT_DISABLESQM: u32 = 524288u32;
pub const DEBUG_ENGOPT_DISABLE_EXECUTION_COMMANDS: u32 = 65536u32;
pub const DEBUG_ENGOPT_DISABLE_MANAGED_SUPPORT: u32 = 16384u32;
pub const DEBUG_ENGOPT_DISABLE_MODULE_SYMBOL_LOAD: u32 = 32768u32;
pub const DEBUG_ENGOPT_DISABLE_STEPLINES_OPTIONS: u32 = 2097152u32;
pub const DEBUG_ENGOPT_DISALLOW_IMAGE_FILE_MAPPING: u32 = 131072u32;
pub const DEBUG_ENGOPT_DISALLOW_NETWORK_PATHS: u32 = 8u32;
pub const DEBUG_ENGOPT_DISALLOW_SHELL_COMMANDS: u32 = 4096u32;
pub const DEBUG_ENGOPT_FAIL_INCOMPLETE_INFORMATION: u32 = 512u32;
pub const DEBUG_ENGOPT_FINAL_BREAK: u32 = 128u32;
pub const DEBUG_ENGOPT_IGNORE_DBGHELP_VERSION: u32 = 1u32;
pub const DEBUG_ENGOPT_IGNORE_EXTENSION_VERSIONS: u32 = 2u32;
pub const DEBUG_ENGOPT_IGNORE_LOADER_EXCEPTIONS: u32 = 16u32;
pub const DEBUG_ENGOPT_INITIAL_BREAK: u32 = 32u32;
pub const DEBUG_ENGOPT_INITIAL_MODULE_BREAK: u32 = 64u32;
pub const DEBUG_ENGOPT_KD_QUIET_MODE: u32 = 8192u32;
pub const DEBUG_ENGOPT_NO_EXECUTE_REPEAT: u32 = 256u32;
pub const DEBUG_ENGOPT_PREFER_DML: u32 = 262144u32;
pub const DEBUG_ENGOPT_PREFER_TRACE_FILES: u32 = 8388608u32;
pub const DEBUG_ENGOPT_RESOLVE_SHADOWED_VARIABLES: u32 = 16777216u32;
pub const DEBUG_ENGOPT_SYNCHRONIZE_BREAKPOINTS: u32 = 2048u32;
pub const DEBUG_EVENT_BREAKPOINT: u32 = 1u32;
pub const DEBUG_EVENT_CHANGE_DEBUGGEE_STATE: u32 = 1024u32;
pub const DEBUG_EVENT_CHANGE_ENGINE_STATE: u32 = 2048u32;
pub const DEBUG_EVENT_CHANGE_SYMBOL_STATE: u32 = 4096u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_EVENT_CONTEXT {
    pub Size: u32,
    pub ProcessEngineId: u32,
    pub ThreadEngineId: u32,
    pub FrameEngineId: u32,
}
pub const DEBUG_EVENT_CREATE_PROCESS: u32 = 16u32;
pub const DEBUG_EVENT_CREATE_THREAD: u32 = 4u32;
pub const DEBUG_EVENT_EXCEPTION: u32 = 2u32;
pub const DEBUG_EVENT_EXIT_PROCESS: u32 = 32u32;
pub const DEBUG_EVENT_EXIT_THREAD: u32 = 8u32;
pub const DEBUG_EVENT_LOAD_MODULE: u32 = 64u32;
pub const DEBUG_EVENT_SERVICE_EXCEPTION: u32 = 8192u32;
pub const DEBUG_EVENT_SESSION_STATUS: u32 = 512u32;
pub const DEBUG_EVENT_SYSTEM_ERROR: u32 = 256u32;
pub const DEBUG_EVENT_UNLOAD_MODULE: u32 = 128u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_EXCEPTION_FILTER_PARAMETERS {
    pub ExecutionOption: u32,
    pub ContinueOption: u32,
    pub TextSize: u32,
    pub CommandSize: u32,
    pub SecondCommandSize: u32,
    pub ExceptionCode: u32,
}
pub const DEBUG_EXECUTE_DEFAULT: u32 = 0u32;
pub const DEBUG_EXECUTE_ECHO: u32 = 1u32;
pub const DEBUG_EXECUTE_EVENT: u32 = 2048u32;
pub const DEBUG_EXECUTE_EXTENSION: u32 = 32u32;
pub const DEBUG_EXECUTE_HOTKEY: u32 = 1024u32;
pub const DEBUG_EXECUTE_INTERNAL: u32 = 64u32;
pub const DEBUG_EXECUTE_MENU: u32 = 512u32;
pub const DEBUG_EXECUTE_NOT_LOGGED: u32 = 2u32;
pub const DEBUG_EXECUTE_NO_REPEAT: u32 = 4u32;
pub const DEBUG_EXECUTE_SCRIPT: u32 = 128u32;
pub const DEBUG_EXECUTE_TOOLBAR: u32 = 256u32;
pub const DEBUG_EXECUTE_USER_CLICKED: u32 = 16u32;
pub const DEBUG_EXECUTE_USER_TYPED: u32 = 8u32;
pub const DEBUG_EXEC_FLAGS_NONBLOCK: u32 = 1u32;
pub const DEBUG_EXPR_CPLUSPLUS: u32 = 1u32;
pub const DEBUG_EXPR_MASM: u32 = 0u32;
pub const DEBUG_EXTENSION_AT_ENGINE: u32 = 0u32;
pub const DEBUG_EXTINIT_HAS_COMMAND_HELP: u32 = 1u32;
pub const DEBUG_EXT_PVALUE_DEFAULT: u32 = 0u32;
pub const DEBUG_EXT_PVTYPE_IS_POINTER: u32 = 1u32;
pub const DEBUG_EXT_PVTYPE_IS_VALUE: u32 = 0u32;
pub const DEBUG_EXT_QVALUE_DEFAULT: u32 = 0u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEBUG_FAILURE_TYPE(pub i32);
pub const DEBUG_FA_ENTRY_ANSI_STRING: FA_ENTRY_TYPE = FA_ENTRY_TYPE(5i32);
pub const DEBUG_FA_ENTRY_ANSI_STRINGs: FA_ENTRY_TYPE = FA_ENTRY_TYPE(6i32);
pub const DEBUG_FA_ENTRY_ARRAY: FA_ENTRY_TYPE = FA_ENTRY_TYPE(32768i32);
pub const DEBUG_FA_ENTRY_EXTENSION_CMD: FA_ENTRY_TYPE = FA_ENTRY_TYPE(7i32);
pub const DEBUG_FA_ENTRY_INSTRUCTION_OFFSET: FA_ENTRY_TYPE = FA_ENTRY_TYPE(3i32);
pub const DEBUG_FA_ENTRY_NO_TYPE: FA_ENTRY_TYPE = FA_ENTRY_TYPE(0i32);
pub const DEBUG_FA_ENTRY_POINTER: FA_ENTRY_TYPE = FA_ENTRY_TYPE(4i32);
pub const DEBUG_FA_ENTRY_STRUCTURED_DATA: FA_ENTRY_TYPE = FA_ENTRY_TYPE(8i32);
pub const DEBUG_FA_ENTRY_ULONG: FA_ENTRY_TYPE = FA_ENTRY_TYPE(1i32);
pub const DEBUG_FA_ENTRY_ULONG64: FA_ENTRY_TYPE = FA_ENTRY_TYPE(2i32);
pub const DEBUG_FA_ENTRY_UNICODE_STRING: FA_ENTRY_TYPE = FA_ENTRY_TYPE(9i32);
pub const DEBUG_FILTER_BREAK: u32 = 0u32;
pub const DEBUG_FILTER_CREATE_PROCESS: u32 = 2u32;
pub const DEBUG_FILTER_CREATE_THREAD: u32 = 0u32;
pub const DEBUG_FILTER_DEBUGGEE_OUTPUT: u32 = 9u32;
pub const DEBUG_FILTER_EXIT_PROCESS: u32 = 3u32;
pub const DEBUG_FILTER_EXIT_THREAD: u32 = 1u32;
pub const DEBUG_FILTER_GO_HANDLED: u32 = 0u32;
pub const DEBUG_FILTER_GO_NOT_HANDLED: u32 = 1u32;
pub const DEBUG_FILTER_IGNORE: u32 = 3u32;
pub const DEBUG_FILTER_INITIAL_BREAKPOINT: u32 = 7u32;
pub const DEBUG_FILTER_INITIAL_MODULE_LOAD: u32 = 8u32;
pub const DEBUG_FILTER_LOAD_MODULE: u32 = 4u32;
pub const DEBUG_FILTER_OUTPUT: u32 = 2u32;
pub const DEBUG_FILTER_REMOVE: u32 = 4u32;
pub const DEBUG_FILTER_SECOND_CHANCE_BREAK: u32 = 1u32;
pub const DEBUG_FILTER_SYSTEM_ERROR: u32 = 6u32;
pub const DEBUG_FILTER_UNLOAD_MODULE: u32 = 5u32;
pub const DEBUG_FIND_SOURCE_BEST_MATCH: u32 = 2u32;
pub const DEBUG_FIND_SOURCE_DEFAULT: u32 = 0u32;
pub const DEBUG_FIND_SOURCE_FULL_PATH: u32 = 1u32;
pub const DEBUG_FIND_SOURCE_NO_SRCSRV: u32 = 4u32;
pub const DEBUG_FIND_SOURCE_TOKEN_LOOKUP: u32 = 8u32;
pub const DEBUG_FIND_SOURCE_WITH_CHECKSUM: u32 = 16u32;
pub const DEBUG_FIND_SOURCE_WITH_CHECKSUM_STRICT: u32 = 32u32;
pub const DEBUG_FLR_ACPI: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(24576i32);
pub const DEBUG_FLR_ACPI_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(24832i32);
pub const DEBUG_FLR_ACPI_EXTENSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(11i32);
pub const DEBUG_FLR_ACPI_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(13i32);
pub const DEBUG_FLR_ACPI_RESCONFLICT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12i32);
pub const DEBUG_FLR_ADDITIONAL_DEBUGTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65546i32);
pub const DEBUG_FLR_ADDITIONAL_XML: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1150976i32);
pub const DEBUG_FLR_ADD_PROCESS_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8219i32);
pub const DEBUG_FLR_ALUREON: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12372i32);
pub const DEBUG_FLR_ANALYSIS_REPROCESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052705i32);
pub const DEBUG_FLR_ANALYSIS_SESSION_ELAPSED_TIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052701i32);
pub const DEBUG_FLR_ANALYSIS_SESSION_HOST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052700i32);
pub const DEBUG_FLR_ANALYSIS_SESSION_TIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052699i32);
pub const DEBUG_FLR_ANALYSIS_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052702i32);
pub const DEBUG_FLR_ANALYZABLE_POOL_CORRUPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8202i32);
pub const DEBUG_FLR_APPKILL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8212i32);
pub const DEBUG_FLR_APPLICATION_VERIFIER_LOADED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048626i32);
pub const DEBUG_FLR_APPS_NOT_TERMINATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8258i32);
pub const DEBUG_FLR_APPVERIFERFLAGS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048600i32);
pub const DEBUG_FLR_ARM_WRITE_AV_CAVEAT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8241i32);
pub const DEBUG_FLR_ASSERT_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(768i32);
pub const DEBUG_FLR_ASSERT_FILE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(769i32);
pub const DEBUG_FLR_ASSERT_INSTRUCTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(778i32);
pub const DEBUG_FLR_BADPAGES_DETECTED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4109i32);
pub const DEBUG_FLR_BAD_HANDLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17i32);
pub const DEBUG_FLR_BAD_MEMORY_REFERENCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8210i32);
pub const DEBUG_FLR_BAD_OBJECT_REFERENCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8211i32);
pub const DEBUG_FLR_BAD_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8193i32);
pub const DEBUG_FLR_BLOCKED_THREAD0: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741818i32);
pub const DEBUG_FLR_BLOCKED_THREAD1: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741817i32);
pub const DEBUG_FLR_BLOCKED_THREAD2: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741816i32);
pub const DEBUG_FLR_BLOCKING_PROCESSID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741815i32);
pub const DEBUG_FLR_BLOCKING_THREAD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741820i32);
pub const DEBUG_FLR_BOOST_FOLLOWUP_TO_SPECIFIC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8222i32);
pub const DEBUG_FLR_BOOTSTAT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(28672i32);
pub const DEBUG_FLR_BOOTSTAT_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(28928i32);
pub const DEBUG_FLR_BUCKET_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65536i32);
pub const DEBUG_FLR_BUCKET_ID_CHECKSUM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052684i32);
pub const DEBUG_FLR_BUCKET_ID_FLAVOR_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052686i32);
pub const DEBUG_FLR_BUCKET_ID_FUNCTION_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052676i32);
pub const DEBUG_FLR_BUCKET_ID_FUNC_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65589i32);
pub const DEBUG_FLR_BUCKET_ID_IMAGE_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052703i32);
pub const DEBUG_FLR_BUCKET_ID_MODULE_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052674i32);
pub const DEBUG_FLR_BUCKET_ID_MODVER_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052675i32);
pub const DEBUG_FLR_BUCKET_ID_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052677i32);
pub const DEBUG_FLR_BUCKET_ID_PREFIX_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052673i32);
pub const DEBUG_FLR_BUCKET_ID_PRIVATE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052704i32);
pub const DEBUG_FLR_BUCKET_ID_TIMEDATESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052683i32);
pub const DEBUG_FLR_BUGCHECKING_DRIVER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12292i32);
pub const DEBUG_FLR_BUGCHECKING_DRIVER_IDTAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65559i32);
pub const DEBUG_FLR_BUGCHECK_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4108i32);
pub const DEBUG_FLR_BUGCHECK_DESC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1538i32);
pub const DEBUG_FLR_BUGCHECK_P1: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4115i32);
pub const DEBUG_FLR_BUGCHECK_P2: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4116i32);
pub const DEBUG_FLR_BUGCHECK_P3: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4117i32);
pub const DEBUG_FLR_BUGCHECK_P4: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4118i32);
pub const DEBUG_FLR_BUGCHECK_SPECIFIER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1537i32);
pub const DEBUG_FLR_BUGCHECK_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1536i32);
pub const DEBUG_FLR_BUILDNAME_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12349i32);
pub const DEBUG_FLR_BUILDOSVER_STR_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052929i32);
pub const DEBUG_FLR_BUILD_OS_FULL_VERSION_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65567i32);
pub const DEBUG_FLR_BUILD_VERSION_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65566i32);
pub const DEBUG_FLR_CANCELLATION_NOT_SUPPORTED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12350i32);
pub const DEBUG_FLR_CHKIMG_EXTENSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(19i32);
pub const DEBUG_FLR_CHPE_PROCESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435433i32);
pub const DEBUG_FLR_CLIENT_DRIVER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1031i32);
pub const DEBUG_FLR_COLLECT_DATA_FOR_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65577i32);
pub const DEBUG_FLR_COMPUTER_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65578i32);
pub const DEBUG_FLR_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741823i32);
pub const DEBUG_FLR_CONTEXT_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097164i32);
pub const DEBUG_FLR_CONTEXT_FLAGS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097165i32);
pub const DEBUG_FLR_CONTEXT_FOLLOWUP_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097191i32);
pub const DEBUG_FLR_CONTEXT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097168i32);
pub const DEBUG_FLR_CONTEXT_METADATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097211i32);
pub const DEBUG_FLR_CONTEXT_ORDER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097166i32);
pub const DEBUG_FLR_CONTEXT_RESTORE_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65551i32);
pub const DEBUG_FLR_CONTEXT_SYSTEM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097167i32);
pub const DEBUG_FLR_CORRUPTING_POOL_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1026i32);
pub const DEBUG_FLR_CORRUPTING_POOL_TAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1027i32);
pub const DEBUG_FLR_CORRUPT_MODULE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8192i32);
pub const DEBUG_FLR_CORRUPT_SERVICE_TABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12308i32);
pub const DEBUG_FLR_COVERAGE_BUILD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8244i32);
pub const DEBUG_FLR_CPU_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12330i32);
pub const DEBUG_FLR_CPU_FAMILY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12333i32);
pub const DEBUG_FLR_CPU_MICROCODE_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12329i32);
pub const DEBUG_FLR_CPU_MICROCODE_ZERO_INTEL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8228i32);
pub const DEBUG_FLR_CPU_MODEL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12334i32);
pub const DEBUG_FLR_CPU_OVERCLOCKED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8198i32);
pub const DEBUG_FLR_CPU_SPEED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12331i32);
pub const DEBUG_FLR_CPU_STEPPING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12335i32);
pub const DEBUG_FLR_CPU_VENDOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12332i32);
pub const DEBUG_FLR_CRITICAL_PROCESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4119i32);
pub const DEBUG_FLR_CRITICAL_PROCESS_REPORTGUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65628i32);
pub const DEBUG_FLR_CRITICAL_SECTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16i32);
pub const DEBUG_FLR_CURRENT_IRQL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(512i32);
pub const DEBUG_FLR_CUSTOMER_CRASH_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12299i32);
pub const DEBUG_FLR_CUSTOMREPORTTAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435454i32);
pub const DEBUG_FLR_CUSTOM_ANALYSIS_TAG_MAX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1342177280i32);
pub const DEBUG_FLR_CUSTOM_ANALYSIS_TAG_MIN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1610612736i32);
pub const DEBUG_FLR_CUSTOM_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435431i32);
pub const DEBUG_FLR_CUSTOM_COMMAND_OUTPUT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435430i32);
pub const DEBUG_FLR_DEADLOCK_INPROC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048589i32);
pub const DEBUG_FLR_DEADLOCK_XPROC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048590i32);
pub const DEBUG_FLR_DEBUG_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1118208i32);
pub const DEBUG_FLR_DEFAULT_BUCKET_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65544i32);
pub const DEBUG_FLR_DEFAULT_SOLUTION_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12294i32);
pub const DEBUG_FLR_DERIVED_WAIT_CHAIN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048583i32);
pub const DEBUG_FLR_DESKTOP_HEAP_MISSING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048593i32);
pub const DEBUG_FLR_DETOURED_IMAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12351i32);
pub const DEBUG_FLR_DEVICE_NODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(28i32);
pub const DEBUG_FLR_DEVICE_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3i32);
pub const DEBUG_FLR_DISKIO_READ_FAILURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12353i32);
pub const DEBUG_FLR_DISKIO_WRITE_FAILURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12354i32);
pub const DEBUG_FLR_DISKSEC_ISSUEDESCSTRING_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435450i32);
pub const DEBUG_FLR_DISKSEC_MFGID_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435451i32);
pub const DEBUG_FLR_DISKSEC_MODEL_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435452i32);
pub const DEBUG_FLR_DISKSEC_ORGID_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435453i32);
pub const DEBUG_FLR_DISKSEC_PRIVATE_DATASIZE_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435444i32);
pub const DEBUG_FLR_DISKSEC_PRIVATE_OFFSET_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435445i32);
pub const DEBUG_FLR_DISKSEC_PRIVATE_TOTSIZE_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435446i32);
pub const DEBUG_FLR_DISKSEC_PUBLIC_DATASIZE_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435447i32);
pub const DEBUG_FLR_DISKSEC_PUBLIC_OFFSET_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435448i32);
pub const DEBUG_FLR_DISKSEC_PUBLIC_TOTSIZE_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435449i32);
pub const DEBUG_FLR_DISKSEC_REASON_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435442i32);
pub const DEBUG_FLR_DISKSEC_TOTALSIZE_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435443i32);
pub const DEBUG_FLR_DISK_HARDWARE_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8206i32);
pub const DEBUG_FLR_DPC_RUNTIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4111i32);
pub const DEBUG_FLR_DPC_STACK_BASE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741809i32);
pub const DEBUG_FLR_DPC_TIMELIMIT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4112i32);
pub const DEBUG_FLR_DPC_TIMEOUT_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4110i32);
pub const DEBUG_FLR_DRIVER_HARDWAREID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65552i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_DEVICE_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65554i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_DEVICE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65633i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_ID_BUS_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65557i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_REV_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65556i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_SUBSYS_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65555i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_SUBVENDOR_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65632i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_VENDOR_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65553i32);
pub const DEBUG_FLR_DRIVER_HARDWARE_VENDOR_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65631i32);
pub const DEBUG_FLR_DRIVER_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2i32);
pub const DEBUG_FLR_DRIVER_VERIFIER_IO_VIOLATION_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4096i32);
pub const DEBUG_FLR_DRIVER_XML_DESCRIPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65562i32);
pub const DEBUG_FLR_DRIVER_XML_MANUFACTURER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65564i32);
pub const DEBUG_FLR_DRIVER_XML_PRODUCTNAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65563i32);
pub const DEBUG_FLR_DRIVER_XML_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65565i32);
pub const DEBUG_FLR_DRVPOWERSTATE_SUBCODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4101i32);
pub const DEBUG_FLR_DUMPSTREAM_COMMENTA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435435i32);
pub const DEBUG_FLR_DUMPSTREAM_COMMENTW: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435434i32);
pub const DEBUG_FLR_DUMP_CLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048627i32);
pub const DEBUG_FLR_DUMP_FILE_ATTRIBUTES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4113i32);
pub const DEBUG_FLR_DUMP_FLAGS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048625i32);
pub const DEBUG_FLR_DUMP_QUALIFIER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048628i32);
pub const DEBUG_FLR_DUMP_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048602i32);
pub const DEBUG_FLR_END_MESSAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65612i32);
pub const DEBUG_FLR_ERESOURCE_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(22i32);
pub const DEBUG_FLR_EVENT_CODE_DATA_MISMATCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12338i32);
pub const DEBUG_FLR_EXCEPTION_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4097i32);
pub const DEBUG_FLR_EXCEPTION_CODE_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4098i32);
pub const DEBUG_FLR_EXCEPTION_CODE_STR_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052672i32);
pub const DEBUG_FLR_EXCEPTION_CONTEXT_RECURSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12352i32);
pub const DEBUG_FLR_EXCEPTION_DOESNOT_MATCH_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(777i32);
pub const DEBUG_FLR_EXCEPTION_MODULE_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097190i32);
pub const DEBUG_FLR_EXCEPTION_PARAMETER1: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(770i32);
pub const DEBUG_FLR_EXCEPTION_PARAMETER2: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(771i32);
pub const DEBUG_FLR_EXCEPTION_PARAMETER3: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(772i32);
pub const DEBUG_FLR_EXCEPTION_PARAMETER4: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(773i32);
pub const DEBUG_FLR_EXCEPTION_RECORD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(774i32);
pub const DEBUG_FLR_EXCEPTION_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(776i32);
pub const DEBUG_FLR_EXECUTE_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(30i32);
pub const DEBUG_FLR_FAILED_INSTRUCTION_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(9i32);
pub const DEBUG_FLR_FAILURE_ANALYSIS_SOURCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65591i32);
pub const DEBUG_FLR_FAILURE_BUCKET_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65561i32);
pub const DEBUG_FLR_FAILURE_DISPLAY_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097239i32);
pub const DEBUG_FLR_FAILURE_EXCEPTION_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65607i32);
pub const DEBUG_FLR_FAILURE_FUNCTION_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65609i32);
pub const DEBUG_FLR_FAILURE_ID_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65592i32);
pub const DEBUG_FLR_FAILURE_ID_HASH_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65593i32);
pub const DEBUG_FLR_FAILURE_ID_REPORT_LINK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65594i32);
pub const DEBUG_FLR_FAILURE_IMAGE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65608i32);
pub const DEBUG_FLR_FAILURE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097238i32);
pub const DEBUG_FLR_FAILURE_MODULE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65629i32);
pub const DEBUG_FLR_FAILURE_PROBLEM_CLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65606i32);
pub const DEBUG_FLR_FAILURE_SYMBOL_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65610i32);
pub const DEBUG_FLR_FAULTING_INSTR_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12297i32);
pub const DEBUG_FLR_FAULTING_IP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483648i32);
pub const DEBUG_FLR_FAULTING_LOCAL_VARIABLE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048623i32);
pub const DEBUG_FLR_FAULTING_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483647i32);
pub const DEBUG_FLR_FAULTING_SERVICE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65570i32);
pub const DEBUG_FLR_FAULTING_SOURCE_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65569i32);
pub const DEBUG_FLR_FAULTING_SOURCE_COMMIT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65634i32);
pub const DEBUG_FLR_FAULTING_SOURCE_CONTROL_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65635i32);
pub const DEBUG_FLR_FAULTING_SOURCE_FILE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65586i32);
pub const DEBUG_FLR_FAULTING_SOURCE_LINE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65585i32);
pub const DEBUG_FLR_FAULTING_SOURCE_LINE_NUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65587i32);
pub const DEBUG_FLR_FAULTING_SOURCE_PROJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65636i32);
pub const DEBUG_FLR_FAULTING_SOURCE_REPO_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65637i32);
pub const DEBUG_FLR_FAULTING_SOURCE_REPO_URL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65638i32);
pub const DEBUG_FLR_FAULTING_SOURCE_SRV_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65639i32);
pub const DEBUG_FLR_FAULTING_THREAD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741824i32);
pub const DEBUG_FLR_FAULT_THREAD_SHA1_HASH_M: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048597i32);
pub const DEBUG_FLR_FAULT_THREAD_SHA1_HASH_MF: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048595i32);
pub const DEBUG_FLR_FAULT_THREAD_SHA1_HASH_MFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048596i32);
pub const DEBUG_FLR_FA_ADHOC_ANALYSIS_ITEMS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097230i32);
pub const DEBUG_FLR_FA_PERF_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097214i32);
pub const DEBUG_FLR_FA_PERF_ELAPSED_MS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097218i32);
pub const DEBUG_FLR_FA_PERF_ITEM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097215i32);
pub const DEBUG_FLR_FA_PERF_ITEM_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097216i32);
pub const DEBUG_FLR_FA_PERF_ITERATIONS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097217i32);
pub const DEBUG_FLR_FEATURE_PATH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65613i32);
pub const DEBUG_FLR_FILESYSTEMS_NTFS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(30208i32);
pub const DEBUG_FLR_FILESYSTEMS_NTFS_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(30448i32);
pub const DEBUG_FLR_FILESYSTEMS_REFS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(30720i32);
pub const DEBUG_FLR_FILESYSTEMS_REFS_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(30960i32);
pub const DEBUG_FLR_FILE_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1280i32);
pub const DEBUG_FLR_FILE_IN_CAB: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65571i32);
pub const DEBUG_FLR_FILE_LINE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1281i32);
pub const DEBUG_FLR_FIXED_IN_OSVERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65543i32);
pub const DEBUG_FLR_FOLLOWUP_BEFORE_RETRACER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65611i32);
pub const DEBUG_FLR_FOLLOWUP_BUCKET_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483641i32);
pub const DEBUG_FLR_FOLLOWUP_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097153i32);
pub const DEBUG_FLR_FOLLOWUP_DRIVER_ONLY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8196i32);
pub const DEBUG_FLR_FOLLOWUP_IP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483645i32);
pub const DEBUG_FLR_FOLLOWUP_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65539i32);
pub const DEBUG_FLR_FRAME_ONE_INVALID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483644i32);
pub const DEBUG_FLR_FRAME_SOURCE_FILE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097240i32);
pub const DEBUG_FLR_FRAME_SOURCE_FILE_PATH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097241i32);
pub const DEBUG_FLR_FRAME_SOURCE_LINE_NUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097242i32);
pub const DEBUG_FLR_FREED_POOL_TAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1028i32);
pub const DEBUG_FLR_GSFAILURE_ANALYSIS_TEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12323i32);
pub const DEBUG_FLR_GSFAILURE_COOKIES_MATCH_EXH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12356i32);
pub const DEBUG_FLR_GSFAILURE_CORRUPTED_COOKIE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12314i32);
pub const DEBUG_FLR_GSFAILURE_CORRUPTED_EBP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12315i32);
pub const DEBUG_FLR_GSFAILURE_CORRUPTED_EBPESP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12318i32);
pub const DEBUG_FLR_GSFAILURE_FALSE_POSITIVE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8236i32);
pub const DEBUG_FLR_GSFAILURE_FRAME_COOKIE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12312i32);
pub const DEBUG_FLR_GSFAILURE_FRAME_COOKIE_COMPLEMENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12313i32);
pub const DEBUG_FLR_GSFAILURE_FUNCTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12310i32);
pub const DEBUG_FLR_GSFAILURE_MANAGED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12357i32);
pub const DEBUG_FLR_GSFAILURE_MANAGED_FRAMEID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12360i32);
pub const DEBUG_FLR_GSFAILURE_MANAGED_THREADID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12359i32);
pub const DEBUG_FLR_GSFAILURE_MEMORY_READ_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12320i32);
pub const DEBUG_FLR_GSFAILURE_MISSING_ESTABLISHER_FRAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12355i32);
pub const DEBUG_FLR_GSFAILURE_MODULE_COOKIE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12311i32);
pub const DEBUG_FLR_GSFAILURE_NOT_UP2DATE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12326i32);
pub const DEBUG_FLR_GSFAILURE_OFF_BY_ONE_OVERRUN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12324i32);
pub const DEBUG_FLR_GSFAILURE_OVERRUN_LOCAL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12316i32);
pub const DEBUG_FLR_GSFAILURE_OVERRUN_LOCAL_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12317i32);
pub const DEBUG_FLR_GSFAILURE_POSITIVELY_CORRUPTED_EBPESP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12319i32);
pub const DEBUG_FLR_GSFAILURE_POSITIVE_BUFFER_OVERFLOW: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12322i32);
pub const DEBUG_FLR_GSFAILURE_PROBABLY_NOT_USING_GS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12321i32);
pub const DEBUG_FLR_GSFAILURE_RA_SMASHED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12325i32);
pub const DEBUG_FLR_GSFAILURE_UP2DATE_UNKNOWN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12327i32);
pub const DEBUG_FLR_HANDLE_VALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(24i32);
pub const DEBUG_FLR_HANG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8209i32);
pub const DEBUG_FLR_HANG_DATA_NEEDED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048584i32);
pub const DEBUG_FLR_HANG_REPORT_THREAD_IS_IDLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048594i32);
pub const DEBUG_FLR_HARDWARE_BUCKET_TAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65581i32);
pub const DEBUG_FLR_HARDWARE_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8214i32);
pub const DEBUG_FLR_HIGH_NONPAGED_POOL_USAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8255i32);
pub const DEBUG_FLR_HIGH_PAGED_POOL_USAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8256i32);
pub const DEBUG_FLR_HIGH_PROCESS_COMMIT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8253i32);
pub const DEBUG_FLR_HIGH_SERVICE_COMMIT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8254i32);
pub const DEBUG_FLR_HIGH_SHARED_COMMIT_USAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8257i32);
pub const DEBUG_FLR_HOLDINFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65595i32);
pub const DEBUG_FLR_HOLDINFO_ACTIVE_HOLD_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65596i32);
pub const DEBUG_FLR_HOLDINFO_ALWAYS_HOLD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65600i32);
pub const DEBUG_FLR_HOLDINFO_ALWAYS_IGNORE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65599i32);
pub const DEBUG_FLR_HOLDINFO_HISTORIC_HOLD_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65598i32);
pub const DEBUG_FLR_HOLDINFO_LAST_SEEN_HOLD_DATE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65604i32);
pub const DEBUG_FLR_HOLDINFO_MANUAL_HOLD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65602i32);
pub const DEBUG_FLR_HOLDINFO_MAX_HOLD_LIMIT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65601i32);
pub const DEBUG_FLR_HOLDINFO_NOTIFICATION_ALIASES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65603i32);
pub const DEBUG_FLR_HOLDINFO_RECOMMEND_HOLD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65605i32);
pub const DEBUG_FLR_HOLDINFO_TENET_SOCRE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65597i32);
pub const DEBUG_FLR_IGNORE_BUCKET_ID_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8238i32);
pub const DEBUG_FLR_IGNORE_LARGE_MODULE_CORRUPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8237i32);
pub const DEBUG_FLR_IGNORE_MODULE_HARDWARE_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8240i32);
pub const DEBUG_FLR_IMAGE_CLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65579i32);
pub const DEBUG_FLR_IMAGE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65537i32);
pub const DEBUG_FLR_IMAGE_TIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483646i32);
pub const DEBUG_FLR_IMAGE_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483642i32);
pub const DEBUG_FLR_INSTR_POINTER_CLIFAULT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12306i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_FREE_BLOCK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12343i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_MODULE_NOT_IN_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12346i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_PAGED_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12370i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_RESERVED_BLOCK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12344i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_UNLOADED_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12340i32);
pub const DEBUG_FLR_INSTR_POINTER_IN_VM_MAPPED_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12345i32);
pub const DEBUG_FLR_INSTR_POINTER_MISALIGNED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12305i32);
pub const DEBUG_FLR_INSTR_POINTER_NOT_IN_STREAM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12347i32);
pub const DEBUG_FLR_INSTR_POINTER_ON_HEAP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12337i32);
pub const DEBUG_FLR_INSTR_POINTER_ON_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12336i32);
pub const DEBUG_FLR_INSTR_SESSION_POOL_TAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1030i32);
pub const DEBUG_FLR_INTEL_CPU_BIOS_UPGRADE_NEEDED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8229i32);
pub const DEBUG_FLR_INTERNAL_BUCKET_CONTINUABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16389i32);
pub const DEBUG_FLR_INTERNAL_BUCKET_HITCOUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16387i32);
pub const DEBUG_FLR_INTERNAL_BUCKET_STATUS_TEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16390i32);
pub const DEBUG_FLR_INTERNAL_BUCKET_URL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16385i32);
pub const DEBUG_FLR_INTERNAL_RAID_BUG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16384i32);
pub const DEBUG_FLR_INTERNAL_RAID_BUG_DATABASE_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16388i32);
pub const DEBUG_FLR_INTERNAL_RESPONSE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65550i32);
pub const DEBUG_FLR_INTERNAL_SOLUTION_TEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16386i32);
pub const DEBUG_FLR_INVALID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(0i32);
pub const DEBUG_FLR_INVALID_DPC_FOUND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(7i32);
pub const DEBUG_FLR_INVALID_HEAP_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(18i32);
pub const DEBUG_FLR_INVALID_KERNEL_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8205i32);
pub const DEBUG_FLR_INVALID_OPCODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8218i32);
pub const DEBUG_FLR_INVALID_PFN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4i32);
pub const DEBUG_FLR_INVALID_USEREVENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(261i32);
pub const DEBUG_FLR_INVALID_USER_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8231i32);
pub const DEBUG_FLR_IOCONTROL_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4099i32);
pub const DEBUG_FLR_IOSB_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(260i32);
pub const DEBUG_FLR_IO_ERROR_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(775i32);
pub const DEBUG_FLR_IRP_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(256i32);
pub const DEBUG_FLR_IRP_CANCEL_ROUTINE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(259i32);
pub const DEBUG_FLR_IRP_MAJOR_FN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(257i32);
pub const DEBUG_FLR_IRP_MINOR_FN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(258i32);
pub const DEBUG_FLR_KERNEL: DEBUG_FAILURE_TYPE = DEBUG_FAILURE_TYPE(1i32);
pub const DEBUG_FLR_KERNEL_LOG_PROCESS_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65582i32);
pub const DEBUG_FLR_KERNEL_LOG_STATUS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65583i32);
pub const DEBUG_FLR_KERNEL_VERIFIER_ENABLED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8234i32);
pub const DEBUG_FLR_KEYVALUE_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1122304i32);
pub const DEBUG_FLR_KEY_VALUES_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1122560i32);
pub const DEBUG_FLR_KEY_VALUES_VARIANT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1122816i32);
pub const DEBUG_FLR_KM_MODULE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048629i32);
pub const DEBUG_FLR_LARGE_TICK_INCREMENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12369i32);
pub const DEBUG_FLR_LAST_CONTROL_TRANSFER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(10i32);
pub const DEBUG_FLR_LCIE_ISO_AVAILABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048618i32);
pub const DEBUG_FLR_LEAKED_SESSION_POOL_TAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1029i32);
pub const DEBUG_FLR_LEGACY_PAGE_TABLE_ACCESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8252i32);
pub const DEBUG_FLR_LIVE_KERNEL_DUMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8243i32);
pub const DEBUG_FLR_LOADERLOCK_BLOCKED_API: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048605i32);
pub const DEBUG_FLR_LOADERLOCK_IN_WAIT_CHAIN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048587i32);
pub const DEBUG_FLR_LOADERLOCK_OWNER_API: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048604i32);
pub const DEBUG_FLR_LOP_STACKHASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12309i32);
pub const DEBUG_FLR_LOW_SYSTEM_COMMIT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8251i32);
pub const DEBUG_FLR_MACHINE_INFO_SHA1_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048608i32);
pub const DEBUG_FLR_MANAGED_ANALYSIS_PROVIDER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1804i32);
pub const DEBUG_FLR_MANAGED_BITNESS_MISMATCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1797i32);
pub const DEBUG_FLR_MANAGED_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1792i32);
pub const DEBUG_FLR_MANAGED_ENGINE_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1803i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2048i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_CALLSTACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2052i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_CMD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2288i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_CONTEXT_MESSAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1799i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_HRESULT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2049i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_INNER_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2064i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_INNER_CALLSTACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2068i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_INNER_HRESULT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2065i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_INNER_MESSAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2067i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_INNER_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2066i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_MESSAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2051i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_MESSAGE_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1795i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_NESTED_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2080i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_NESTED_CALLSTACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2084i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_NESTED_HRESULT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2081i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_NESTED_MESSAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2083i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_NESTED_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2082i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1794i32);
pub const DEBUG_FLR_MANAGED_EXCEPTION_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2050i32);
pub const DEBUG_FLR_MANAGED_FRAME_CHAIN_CORRUPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12358i32);
pub const DEBUG_FLR_MANAGED_HRESULT_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1802i32);
pub const DEBUG_FLR_MANAGED_KERNEL_DEBUGGER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1801i32);
pub const DEBUG_FLR_MANAGED_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1793i32);
pub const DEBUG_FLR_MANAGED_OBJECT_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1798i32);
pub const DEBUG_FLR_MANAGED_STACK_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1800i32);
pub const DEBUG_FLR_MANAGED_STACK_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1796i32);
pub const DEBUG_FLR_MANAGED_THREAD_CMD_CALLSTACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2544i32);
pub const DEBUG_FLR_MANAGED_THREAD_CMD_STACKOBJECTS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2545i32);
pub const DEBUG_FLR_MANAGED_THREAD_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2304i32);
pub const DEBUG_FLR_MANUAL_BREAKIN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8208i32);
pub const DEBUG_FLR_MARKER_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65560i32);
pub const DEBUG_FLR_MARKER_FILE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65549i32);
pub const DEBUG_FLR_MARKER_MODULE_FILE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65558i32);
pub const DEBUG_FLR_MASK_ALL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1i32);
pub const DEBUG_FLR_MEMDIAG_LASTRUN_STATUS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12341i32);
pub const DEBUG_FLR_MEMDIAG_LASTRUN_TIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12342i32);
pub const DEBUG_FLR_MEMORY_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1134592i32);
pub const DEBUG_FLR_MEMORY_CORRUPTION_SIGNATURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12348i32);
pub const DEBUG_FLR_MEMORY_CORRUPTOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12289i32);
pub const DEBUG_FLR_MILCORE_BREAK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8232i32);
pub const DEBUG_FLR_MINUTES_SINCE_LAST_EVENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048225i32);
pub const DEBUG_FLR_MINUTES_SINCE_LAST_EVENT_OF_THIS_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048226i32);
pub const DEBUG_FLR_MISSING_CLR_SYMBOL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8249i32);
pub const DEBUG_FLR_MISSING_IMPORTANT_SYMBOL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8248i32);
pub const DEBUG_FLR_MM_INTERNAL_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4100i32);
pub const DEBUG_FLR_MODLIST_SHA1_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048601i32);
pub const DEBUG_FLR_MODLIST_TSCHKSUM_SHA1_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048606i32);
pub const DEBUG_FLR_MODLIST_UNLOADED_SHA1_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048607i32);
pub const DEBUG_FLR_MODULE_BUCKET_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65545i32);
pub const DEBUG_FLR_MODULE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048624i32);
pub const DEBUG_FLR_MODULE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65542i32);
pub const DEBUG_FLR_MODULE_PRODUCTNAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65576i32);
pub const DEBUG_FLR_MOD_SPECIFIC_DATA_ONLY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8226i32);
pub const DEBUG_FLR_NO_ARCH_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8239i32);
pub const DEBUG_FLR_NO_BUGCHECK_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8216i32);
pub const DEBUG_FLR_NO_IMAGE_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8215i32);
pub const DEBUG_FLR_NO_IMAGE_TIMESTAMP_IN_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8233i32);
pub const DEBUG_FLR_NTGLOBALFLAG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048599i32);
pub const DEBUG_FLR_ON_DPC_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8242i32);
pub const DEBUG_FLR_ORIGINAL_CAB_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65568i32);
pub const DEBUG_FLR_OSBUILD_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052928i32);
pub const DEBUG_FLR_OS_BRANCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052680i32);
pub const DEBUG_FLR_OS_BUILD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052678i32);
pub const DEBUG_FLR_OS_BUILD_LAYERS_XML: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052711i32);
pub const DEBUG_FLR_OS_BUILD_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052708i32);
pub const DEBUG_FLR_OS_BUILD_TIMESTAMP_ISO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052697i32);
pub const DEBUG_FLR_OS_BUILD_TIMESTAMP_LAB: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052681i32);
pub const DEBUG_FLR_OS_FLAVOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052685i32);
pub const DEBUG_FLR_OS_LOCALE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052696i32);
pub const DEBUG_FLR_OS_LOCALE_LCID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052709i32);
pub const DEBUG_FLR_OS_MAJOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052706i32);
pub const DEBUG_FLR_OS_MINOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052707i32);
pub const DEBUG_FLR_OS_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052692i32);
pub const DEBUG_FLR_OS_NAME_EDITION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052693i32);
pub const DEBUG_FLR_OS_PLATFORM_ARCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052694i32);
pub const DEBUG_FLR_OS_PLATFORM_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052710i32);
pub const DEBUG_FLR_OS_PRODUCT_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052688i32);
pub const DEBUG_FLR_OS_REVISION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052691i32);
pub const DEBUG_FLR_OS_SERVICEPACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052679i32);
pub const DEBUG_FLR_OS_SERVICEPACK_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052695i32);
pub const DEBUG_FLR_OS_SKU: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052687i32);
pub const DEBUG_FLR_OS_SUITE_MASK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052689i32);
pub const DEBUG_FLR_OS_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052682i32);
pub const DEBUG_FLR_OS_VERSION_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12291i32);
pub const DEBUG_FLR_OVERLAPPED_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8227i32);
pub const DEBUG_FLR_OVERLAPPED_UNLOADED_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8230i32);
pub const DEBUG_FLR_PAGE_HASH_ERRORS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4114i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEBUG_FLR_PARAM_TYPE(pub i32);
pub const DEBUG_FLR_PG_MISMATCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(27i32);
pub const DEBUG_FLR_PHONE_APPID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048215i32);
pub const DEBUG_FLR_PHONE_APPVERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048217i32);
pub const DEBUG_FLR_PHONE_BOOTLOADERVERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048209i32);
pub const DEBUG_FLR_PHONE_BUILDBRANCH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048196i32);
pub const DEBUG_FLR_PHONE_BUILDER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048197i32);
pub const DEBUG_FLR_PHONE_BUILDNUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048194i32);
pub const DEBUG_FLR_PHONE_BUILDTIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048195i32);
pub const DEBUG_FLR_PHONE_FIRMWAREREVISION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048202i32);
pub const DEBUG_FLR_PHONE_HARDWAREREVISION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048206i32);
pub const DEBUG_FLR_PHONE_LCID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048198i32);
pub const DEBUG_FLR_PHONE_MCCMNC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048201i32);
pub const DEBUG_FLR_PHONE_OPERATOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048200i32);
pub const DEBUG_FLR_PHONE_QFE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048199i32);
pub const DEBUG_FLR_PHONE_RADIOHARDWAREREVISION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048207i32);
pub const DEBUG_FLR_PHONE_RADIOSOFTWAREREVISION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048208i32);
pub const DEBUG_FLR_PHONE_RAM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048203i32);
pub const DEBUG_FLR_PHONE_REPORTGUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048210i32);
pub const DEBUG_FLR_PHONE_REPORTTIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048214i32);
pub const DEBUG_FLR_PHONE_ROMVERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048204i32);
pub const DEBUG_FLR_PHONE_SKUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048216i32);
pub const DEBUG_FLR_PHONE_SOCVERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048205i32);
pub const DEBUG_FLR_PHONE_SOURCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048211i32);
pub const DEBUG_FLR_PHONE_SOURCEEXTERNAL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048212i32);
pub const DEBUG_FLR_PHONE_UIF_APPID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048220i32);
pub const DEBUG_FLR_PHONE_UIF_APPNAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048219i32);
pub const DEBUG_FLR_PHONE_UIF_CATEGORY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048221i32);
pub const DEBUG_FLR_PHONE_UIF_COMMENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048218i32);
pub const DEBUG_FLR_PHONE_UIF_ORIGIN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048222i32);
pub const DEBUG_FLR_PHONE_USERALIAS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048213i32);
pub const DEBUG_FLR_PHONE_VERSIONMAJOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048192i32);
pub const DEBUG_FLR_PHONE_VERSIONMINOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048193i32);
pub const DEBUG_FLR_PLATFORM_BUCKET_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65630i32);
pub const DEBUG_FLR_PNP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(32768i32);
pub const DEBUG_FLR_PNP_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(33024i32);
pub const DEBUG_FLR_PNP_IRP_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(32770i32);
pub const DEBUG_FLR_PNP_IRP_ADDRESS_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(264i32);
pub const DEBUG_FLR_PNP_TRIAGE_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(32769i32);
pub const DEBUG_FLR_PNP_TRIAGE_DATA_DEPRECATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(23i32);
pub const DEBUG_FLR_POISONED_TB: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8200i32);
pub const DEBUG_FLR_POOL_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1024i32);
pub const DEBUG_FLR_POOL_CORRUPTOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12288i32);
pub const DEBUG_FLR_POSSIBLE_INVALID_CONTROL_TRANSFER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8199i32);
pub const DEBUG_FLR_POSSIBLE_STACK_OVERFLOW: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8245i32);
pub const DEBUG_FLR_POWERREQUEST_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29i32);
pub const DEBUG_FLR_PO_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(24833i32);
pub const DEBUG_FLR_PREVIOUS_IRQL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(513i32);
pub const DEBUG_FLR_PREVIOUS_MODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(265i32);
pub const DEBUG_FLR_PRIMARY_PROBLEM_CLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048579i32);
pub const DEBUG_FLR_PRIMARY_PROBLEM_CLASS_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048580i32);
pub const DEBUG_FLR_PROBLEM_CLASSES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048578i32);
pub const DEBUG_FLR_PROBLEM_CODE_PATH_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048585i32);
pub const DEBUG_FLR_PROCESSES_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1142784i32);
pub const DEBUG_FLR_PROCESSOR_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741814i32);
pub const DEBUG_FLR_PROCESSOR_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12339i32);
pub const DEBUG_FLR_PROCESS_BAM_CURRENT_THROTTLED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435437i32);
pub const DEBUG_FLR_PROCESS_BAM_PREVIOUS_THROTTLED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435436i32);
pub const DEBUG_FLR_PROCESS_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097189i32);
pub const DEBUG_FLR_PROCESS_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65547i32);
pub const DEBUG_FLR_PROCESS_OBJECT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8i32);
pub const DEBUG_FLR_PROCESS_PRODUCTNAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65575i32);
pub const DEBUG_FLR_RAISED_IRQL_USER_FAULT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8220i32);
pub const DEBUG_FLR_READ_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(14i32);
pub const DEBUG_FLR_RECURRING_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12296i32);
pub const DEBUG_FLR_REGISTRYTXT_SOURCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65584i32);
pub const DEBUG_FLR_REGISTRYTXT_STRESS_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12307i32);
pub const DEBUG_FLR_REGISTRY_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3145728i32);
pub const DEBUG_FLR_REPORT_INFO_CREATION_TIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048229i32);
pub const DEBUG_FLR_REPORT_INFO_GUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048227i32);
pub const DEBUG_FLR_REPORT_INFO_SOURCE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048228i32);
pub const DEBUG_FLR_REQUESTED_IRQL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(514i32);
pub const DEBUG_FLR_RESERVED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1i32);
pub const DEBUG_FLR_RESOURCE_CALL_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4352i32);
pub const DEBUG_FLR_RESOURCE_CALL_TYPE_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4353i32);
pub const DEBUG_FLR_SCM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20992i32);
pub const DEBUG_FLR_SCM_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21232i32);
pub const DEBUG_FLR_SCM_BLACKBOX_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21233i32);
pub const DEBUG_FLR_SCM_BLACKBOX_ENTRY_CONTROLCODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21234i32);
pub const DEBUG_FLR_SCM_BLACKBOX_ENTRY_SERVICENAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21236i32);
pub const DEBUG_FLR_SCM_BLACKBOX_ENTRY_STARTTIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21235i32);
pub const DEBUG_FLR_SEARCH_HANG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048614i32);
pub const DEBUG_FLR_SECURITY_COOKIES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4105i32);
pub const DEBUG_FLR_SERVICE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20480i32);
pub const DEBUG_FLR_SERVICETABLE_MODIFIED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12371i32);
pub const DEBUG_FLR_SERVICE_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1146880i32);
pub const DEBUG_FLR_SERVICE_DEPENDONGROUP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20486i32);
pub const DEBUG_FLR_SERVICE_DEPENDONSERVICE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20485i32);
pub const DEBUG_FLR_SERVICE_DESCRIPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20484i32);
pub const DEBUG_FLR_SERVICE_DISPLAYNAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20483i32);
pub const DEBUG_FLR_SERVICE_GROUP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20482i32);
pub const DEBUG_FLR_SERVICE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20481i32);
pub const DEBUG_FLR_SHOW_ERRORLOG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8207i32);
pub const DEBUG_FLR_SHOW_LCIE_ISO_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048619i32);
pub const DEBUG_FLR_SIMULTANEOUS_TELSVC_INSTANCES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048223i32);
pub const DEBUG_FLR_SIMULTANEOUS_TELWP_INSTANCES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1879048224i32);
pub const DEBUG_FLR_SINGLE_BIT_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8203i32);
pub const DEBUG_FLR_SINGLE_BIT_PFN_PAGE_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8213i32);
pub const DEBUG_FLR_SKIP_CORRUPT_MODULE_DETECTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8235i32);
pub const DEBUG_FLR_SKIP_MODULE_SPECIFIC_BUCKET_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65588i32);
pub const DEBUG_FLR_SKIP_STACK_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8217i32);
pub const DEBUG_FLR_SM_BUFFER_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177286i32);
pub const DEBUG_FLR_SM_COMPRESSION_FORMAT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177280i32);
pub const DEBUG_FLR_SM_ONEBIT_SOLUTION_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177287i32);
pub const DEBUG_FLR_SM_SOURCE_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177283i32);
pub const DEBUG_FLR_SM_SOURCE_PFN1: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177281i32);
pub const DEBUG_FLR_SM_SOURCE_PFN2: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177282i32);
pub const DEBUG_FLR_SM_SOURCE_SIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177284i32);
pub const DEBUG_FLR_SM_TARGET_PFN: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1342177285i32);
pub const DEBUG_FLR_SOLUTION_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12293i32);
pub const DEBUG_FLR_SOLUTION_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12295i32);
pub const DEBUG_FLR_SPECIAL_POOL_CORRUPTION_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1025i32);
pub const DEBUG_FLR_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097152i32);
pub const DEBUG_FLR_STACKHASH_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1138688i32);
pub const DEBUG_FLR_STACKUSAGE_FUNCTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12363i32);
pub const DEBUG_FLR_STACKUSAGE_FUNCTION_SIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12364i32);
pub const DEBUG_FLR_STACKUSAGE_IMAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12361i32);
pub const DEBUG_FLR_STACKUSAGE_IMAGE_SIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12362i32);
pub const DEBUG_FLR_STACKUSAGE_RECURSION_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12365i32);
pub const DEBUG_FLR_STACK_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65540i32);
pub const DEBUG_FLR_STACK_FRAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097155i32);
pub const DEBUG_FLR_STACK_FRAMES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097212i32);
pub const DEBUG_FLR_STACK_FRAME_FLAGS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097163i32);
pub const DEBUG_FLR_STACK_FRAME_FUNCTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097162i32);
pub const DEBUG_FLR_STACK_FRAME_IMAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097161i32);
pub const DEBUG_FLR_STACK_FRAME_INSTRUCTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097157i32);
pub const DEBUG_FLR_STACK_FRAME_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097160i32);
pub const DEBUG_FLR_STACK_FRAME_MODULE_BASE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097224i32);
pub const DEBUG_FLR_STACK_FRAME_NUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097156i32);
pub const DEBUG_FLR_STACK_FRAME_SRC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097225i32);
pub const DEBUG_FLR_STACK_FRAME_SYMBOL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097158i32);
pub const DEBUG_FLR_STACK_FRAME_SYMBOL_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097159i32);
pub const DEBUG_FLR_STACK_OVERFLOW: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12301i32);
pub const DEBUG_FLR_STACK_POINTER_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12302i32);
pub const DEBUG_FLR_STACK_POINTER_MISALIGNED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12304i32);
pub const DEBUG_FLR_STACK_POINTER_ONEBIT_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12303i32);
pub const DEBUG_FLR_STACK_SHA1_HASH_M: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097221i32);
pub const DEBUG_FLR_STACK_SHA1_HASH_MF: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097219i32);
pub const DEBUG_FLR_STACK_SHA1_HASH_MFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097220i32);
pub const DEBUG_FLR_STACK_TEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65541i32);
pub const DEBUG_FLR_STATUS_CODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4102i32);
pub const DEBUG_FLR_STORAGE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29696i32);
pub const DEBUG_FLR_STORAGE_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29936i32);
pub const DEBUG_FLR_STORAGE_ISSUEDESCSTRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29700i32);
pub const DEBUG_FLR_STORAGE_MFGID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29699i32);
pub const DEBUG_FLR_STORAGE_MODEL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29698i32);
pub const DEBUG_FLR_STORAGE_ORGID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29697i32);
pub const DEBUG_FLR_STORAGE_PRIVATE_DATASIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29706i32);
pub const DEBUG_FLR_STORAGE_PRIVATE_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29705i32);
pub const DEBUG_FLR_STORAGE_PRIVATE_TOTSIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29704i32);
pub const DEBUG_FLR_STORAGE_PUBLIC_DATASIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29703i32);
pub const DEBUG_FLR_STORAGE_PUBLIC_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29702i32);
pub const DEBUG_FLR_STORAGE_PUBLIC_TOTSIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29701i32);
pub const DEBUG_FLR_STORAGE_REASON: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29708i32);
pub const DEBUG_FLR_STORAGE_TOTALSIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(29707i32);
pub const DEBUG_FLR_STORE_DEVELOPER_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612743i32);
pub const DEBUG_FLR_STORE_IS_MICROSOFT_PRODUCT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612754i32);
pub const DEBUG_FLR_STORE_LEGACY_PARENT_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612747i32);
pub const DEBUG_FLR_STORE_LEGACY_WINDOWS_PHONE_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612749i32);
pub const DEBUG_FLR_STORE_LEGACY_WINDOWS_STORE_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612748i32);
pub const DEBUG_FLR_STORE_LEGACY_XBOX_360_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612751i32);
pub const DEBUG_FLR_STORE_LEGACY_XBOX_ONE_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612750i32);
pub const DEBUG_FLR_STORE_PACKAGE_FAMILY_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612744i32);
pub const DEBUG_FLR_STORE_PACKAGE_IDENTITY_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612745i32);
pub const DEBUG_FLR_STORE_PREFERRED_SKU_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612753i32);
pub const DEBUG_FLR_STORE_PRIMARY_PARENT_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612746i32);
pub const DEBUG_FLR_STORE_PRODUCT_DESCRIPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612738i32);
pub const DEBUG_FLR_STORE_PRODUCT_DISPLAY_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612737i32);
pub const DEBUG_FLR_STORE_PRODUCT_EXTENDED_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612739i32);
pub const DEBUG_FLR_STORE_PRODUCT_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612736i32);
pub const DEBUG_FLR_STORE_PUBLISHER_CERTIFICATE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612742i32);
pub const DEBUG_FLR_STORE_PUBLISHER_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612740i32);
pub const DEBUG_FLR_STORE_PUBLISHER_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612741i32);
pub const DEBUG_FLR_STORE_URL_APP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612755i32);
pub const DEBUG_FLR_STORE_URL_APPHEALTH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612756i32);
pub const DEBUG_FLR_STORE_XBOX_TITLE_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1610612752i32);
pub const DEBUG_FLR_STREAM_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1130496i32);
pub const DEBUG_FLR_SUSPECT_CODE_PATH_HASH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048586i32);
pub const DEBUG_FLR_SVCHOST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20736i32);
pub const DEBUG_FLR_SVCHOST_GROUP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20737i32);
pub const DEBUG_FLR_SVCHOST_IMAGEPATH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20738i32);
pub const DEBUG_FLR_SVCHOST_SERVICEDLL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20739i32);
pub const DEBUG_FLR_SWITCH_PROCESS_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8223i32);
pub const DEBUG_FLR_SYMBOL_FROM_RAW_STACK_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-2147483643i32);
pub const DEBUG_FLR_SYMBOL_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65538i32);
pub const DEBUG_FLR_SYMBOL_ON_RAW_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4104i32);
pub const DEBUG_FLR_SYMBOL_ROUTINE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65580i32);
pub const DEBUG_FLR_SYMBOL_STACK_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4103i32);
pub const DEBUG_FLR_SYSINFO_BASEBOARD_MANUFACTURER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17156i32);
pub const DEBUG_FLR_SYSINFO_BASEBOARD_PRODUCT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17157i32);
pub const DEBUG_FLR_SYSINFO_BASEBOARD_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17158i32);
pub const DEBUG_FLR_SYSINFO_BIOS_DATE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17161i32);
pub const DEBUG_FLR_SYSINFO_BIOS_VENDOR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17159i32);
pub const DEBUG_FLR_SYSINFO_BIOS_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17160i32);
pub const DEBUG_FLR_SYSINFO_SYSTEM_MANUFACTURER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17152i32);
pub const DEBUG_FLR_SYSINFO_SYSTEM_PRODUCT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17153i32);
pub const DEBUG_FLR_SYSINFO_SYSTEM_SKU: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17154i32);
pub const DEBUG_FLR_SYSINFO_SYSTEM_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17155i32);
pub const DEBUG_FLR_SYSTEM_LOCALE_deprecated: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12298i32);
pub const DEBUG_FLR_SYSXML_CHECKSUM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16897i32);
pub const DEBUG_FLR_SYSXML_LOCALEID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16896i32);
pub const DEBUG_FLR_TARGET_MODE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4107i32);
pub const DEBUG_FLR_TARGET_TIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8250i32);
pub const DEBUG_FLR_TESTRESULTGUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435455i32);
pub const DEBUG_FLR_TESTRESULTSERVER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435456i32);
pub const DEBUG_FLR_THREADPOOL_WAITER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(4106i32);
pub const DEBUG_FLR_THREAD_ATTRIBUTES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048577i32);
pub const DEBUG_FLR_TIMELINE_ANALYSIS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1126400i32);
pub const DEBUG_FLR_TIMELINE_TIMES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1126401i32);
pub const DEBUG_FLR_TRAP_FRAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741822i32);
pub const DEBUG_FLR_TRAP_FRAME_RECURSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12300i32);
pub const DEBUG_FLR_TRIAGER_OS_BUILD_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12328i32);
pub const DEBUG_FLR_TSS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741821i32);
pub const DEBUG_FLR_TWO_BIT_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8204i32);
pub const DEBUG_FLR_ULS_SCRIPT_EXCEPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048617i32);
pub const DEBUG_FLR_UNALIGNED_STACK_POINTER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12290i32);
pub const DEBUG_FLR_UNKNOWN: DEBUG_FAILURE_TYPE = DEBUG_FAILURE_TYPE(0i32);
pub const DEBUG_FLR_UNKNOWN_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8201i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_FOLLOWUP_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65573i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_PROBLEM_CLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048581i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_PROBLEM_CLASS_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048582i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65574i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_SYMBOL_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65572i32);
pub const DEBUG_FLR_UNRESPONSIVE_UI_THREAD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741819i32);
pub const DEBUG_FLR_UNUSED001: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8197i32);
pub const DEBUG_FLR_URLS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048610i32);
pub const DEBUG_FLR_URLS_DISCOVERED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048609i32);
pub const DEBUG_FLR_URL_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048611i32);
pub const DEBUG_FLR_URL_LCIE_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048620i32);
pub const DEBUG_FLR_URL_URLMON_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048621i32);
pub const DEBUG_FLR_URL_XMLHTTPREQ_SYNC_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048622i32);
pub const DEBUG_FLR_USBPORT_OCADATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(20i32);
pub const DEBUG_FLR_USER: DEBUG_FAILURE_TYPE = DEBUG_FAILURE_TYPE(2i32);
pub const DEBUG_FLR_USERBREAK_PEB_PAGEDOUT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8225i32);
pub const DEBUG_FLR_USERMODE_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048576i32);
pub const DEBUG_FLR_USER_GLOBAL_ATTRIBUTES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3153920i32);
pub const DEBUG_FLR_USER_LCID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052690i32);
pub const DEBUG_FLR_USER_LCID_STR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1052698i32);
pub const DEBUG_FLR_USER_MODE_BUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65614i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_EVENTTYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65616i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65615i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P0: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65619i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P1: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65620i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P2: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65621i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P3: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65622i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P4: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65623i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P5: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65624i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P6: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65625i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_P7: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65626i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_REPORTCREATIONTIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65618i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_REPORTGUID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65617i32);
pub const DEBUG_FLR_USER_MODE_BUCKET_STRING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65627i32);
pub const DEBUG_FLR_USER_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65548i32);
pub const DEBUG_FLR_USER_PROBLEM_CLASSES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3162112i32);
pub const DEBUG_FLR_USER_THREAD_ATTRIBUTES: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3158016i32);
pub const DEBUG_FLR_USE_DEFAULT_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8221i32);
pub const DEBUG_FLR_VERIFIER_DRIVER_ENTRY: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(263i32);
pub const DEBUG_FLR_VERIFIER_FOUND_DEADLOCK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(26i32);
pub const DEBUG_FLR_VERIFIER_STOP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8224i32);
pub const DEBUG_FLR_VIDEO_TDR_CONTEXT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(262i32);
pub const DEBUG_FLR_VIRTUAL_MACHINE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(17162i32);
pub const DEBUG_FLR_WAIT_CHAIN_COMMAND: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048598i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_00: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16648i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_01: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16649i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_02: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16650i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_03: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16651i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_04: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16652i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_05: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16653i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_06: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16654i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_07: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16655i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_08: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16656i32);
pub const DEBUG_FLR_WATSON_GENERIC_BUCKETING_09: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16657i32);
pub const DEBUG_FLR_WATSON_GENERIC_EVENT_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16647i32);
pub const DEBUG_FLR_WATSON_IBUCKET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16644i32);
pub const DEBUG_FLR_WATSON_IBUCKETTABLE_S1_RESP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048613i32);
pub const DEBUG_FLR_WATSON_IBUCKET_S1_RESP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048612i32);
pub const DEBUG_FLR_WATSON_MODULE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16640i32);
pub const DEBUG_FLR_WATSON_MODULE_OFFSET: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16642i32);
pub const DEBUG_FLR_WATSON_MODULE_TIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16645i32);
pub const DEBUG_FLR_WATSON_MODULE_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16641i32);
pub const DEBUG_FLR_WATSON_PROCESS_TIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16646i32);
pub const DEBUG_FLR_WATSON_PROCESS_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16643i32);
pub const DEBUG_FLR_WCT_XML_AVAILABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048591i32);
pub const DEBUG_FLR_WERCOLLECTION_DEFAULTCOLLECTION_FAILURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435438i32);
pub const DEBUG_FLR_WERCOLLECTION_MINIDUMP_WRITE_FAILURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435439i32);
pub const DEBUG_FLR_WERCOLLECTION_PROCESSHEAPDUMP_REQUEST_FAILURE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435440i32);
pub const DEBUG_FLR_WERCOLLECTION_PROCESSTERMINATED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435441i32);
pub const DEBUG_FLR_WER_DATA_COLLECTION_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048615i32);
pub const DEBUG_FLR_WER_MACHINE_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048616i32);
pub const DEBUG_FLR_WHEA_ERROR_RECORD: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(25i32);
pub const DEBUG_FLR_WINLOGON_BLACKBOX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-268435432i32);
pub const DEBUG_FLR_WMI_QUERY_DATA: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(3149824i32);
pub const DEBUG_FLR_WORKER_ROUTINE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(5i32);
pub const DEBUG_FLR_WORK_ITEM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(6i32);
pub const DEBUG_FLR_WORK_QUEUE_ITEM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(21i32);
pub const DEBUG_FLR_WQL_EVENTLOG_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16899i32);
pub const DEBUG_FLR_WQL_EVENT_COUNT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(16898i32);
pub const DEBUG_FLR_WRITE_ADDRESS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(15i32);
pub const DEBUG_FLR_WRONG_SYMBOLS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8195i32);
pub const DEBUG_FLR_WRONG_SYMBOLS_SIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8247i32);
pub const DEBUG_FLR_WRONG_SYMBOLS_TIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8246i32);
pub const DEBUG_FLR_XBOX_LIVE_ENVIRONMENT: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12368i32);
pub const DEBUG_FLR_XBOX_SYSTEM_CRASHTIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12367i32);
pub const DEBUG_FLR_XBOX_SYSTEM_UPTIME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(12366i32);
pub const DEBUG_FLR_XCS_PATH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048603i32);
pub const DEBUG_FLR_XDV_HELP_LINK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741811i32);
pub const DEBUG_FLR_XDV_RULE_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741810i32);
pub const DEBUG_FLR_XDV_STATE_VARIABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741812i32);
pub const DEBUG_FLR_XDV_VIOLATED_CONDITION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(-1073741813i32);
pub const DEBUG_FLR_XHCI_FIRMWARE_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(65590i32);
pub const DEBUG_FLR_XML_APPLICATION_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097231i32);
pub const DEBUG_FLR_XML_ATTRIBUTE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097194i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_D1VALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097197i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_D2VALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097198i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_DOVALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097199i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_FRAME_NUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097201i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097193i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097195i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_THREAD_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097202i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_VALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097196i32);
pub const DEBUG_FLR_XML_ATTRIBUTE_VALUE_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097200i32);
pub const DEBUG_FLR_XML_ENCODED_OFFSETS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097213i32);
pub const DEBUG_FLR_XML_EVENTTYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097235i32);
pub const DEBUG_FLR_XML_GLOBALATTRIBUTE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097192i32);
pub const DEBUG_FLR_XML_MODERN_ASYNC_REQUEST_OUTSTANDING: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097234i32);
pub const DEBUG_FLR_XML_MODULE_INFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097169i32);
pub const DEBUG_FLR_XML_MODULE_INFO_BASE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097186i32);
pub const DEBUG_FLR_XML_MODULE_INFO_CHECKSUM: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097174i32);
pub const DEBUG_FLR_XML_MODULE_INFO_COMPANY_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097182i32);
pub const DEBUG_FLR_XML_MODULE_INFO_DRIVER_GROUP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097251i32);
pub const DEBUG_FLR_XML_MODULE_INFO_FILE_DESCRIPTION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097183i32);
pub const DEBUG_FLR_XML_MODULE_INFO_FILE_FLAGS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097223i32);
pub const DEBUG_FLR_XML_MODULE_INFO_FIXED_FILE_VER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097178i32);
pub const DEBUG_FLR_XML_MODULE_INFO_FIXED_PROD_VER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097179i32);
pub const DEBUG_FLR_XML_MODULE_INFO_IMAGE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097172i32);
pub const DEBUG_FLR_XML_MODULE_INFO_IMAGE_PATH: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097173i32);
pub const DEBUG_FLR_XML_MODULE_INFO_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097170i32);
pub const DEBUG_FLR_XML_MODULE_INFO_INTERNAL_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097184i32);
pub const DEBUG_FLR_XML_MODULE_INFO_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097171i32);
pub const DEBUG_FLR_XML_MODULE_INFO_ON_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097177i32);
pub const DEBUG_FLR_XML_MODULE_INFO_ORIG_FILE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097185i32);
pub const DEBUG_FLR_XML_MODULE_INFO_PRODUCT_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097188i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SIZE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097187i32);
pub const DEBUG_FLR_XML_MODULE_INFO_STRING_FILE_VER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097180i32);
pub const DEBUG_FLR_XML_MODULE_INFO_STRING_PROD_VER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097181i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMBOL_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097222i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_IMAGE_DETAIL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097245i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_IMAGE_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097244i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_IMAGE_SEC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097246i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_IMAGE_STATUS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097243i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_PDB_DETAIL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097249i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_PDB_ERROR: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097248i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_PDB_SEC: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097250i32);
pub const DEBUG_FLR_XML_MODULE_INFO_SYMSRV_PDB_STATUS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097247i32);
pub const DEBUG_FLR_XML_MODULE_INFO_TIMESTAMP: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097175i32);
pub const DEBUG_FLR_XML_MODULE_INFO_UNLOADED: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097176i32);
pub const DEBUG_FLR_XML_MODULE_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097154i32);
pub const DEBUG_FLR_XML_PACKAGE_MONIKER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097232i32);
pub const DEBUG_FLR_XML_PACKAGE_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097236i32);
pub const DEBUG_FLR_XML_PACKAGE_RELATIVE_APPLICATION_ID: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097233i32);
pub const DEBUG_FLR_XML_PACKAGE_VERSION: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097237i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097204i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_FRAME_NUMBER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097208i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_LIST: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097203i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_NAME: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097205i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_THREAD_INDEX: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097209i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_VALUE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097206i32);
pub const DEBUG_FLR_XML_PROBLEMCLASS_VALUE_TYPE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097207i32);
pub const DEBUG_FLR_XML_STACK_FRAME_TRIAGE_STATUS: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097210i32);
pub const DEBUG_FLR_XML_SYSTEMINFO: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097226i32);
pub const DEBUG_FLR_XML_SYSTEMINFO_SYSTEMMANUFACTURER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097227i32);
pub const DEBUG_FLR_XML_SYSTEMINFO_SYSTEMMARKER: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097229i32);
pub const DEBUG_FLR_XML_SYSTEMINFO_SYSTEMMODEL: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(2097228i32);
pub const DEBUG_FLR_XPROC_DUMP_AVAILABLE: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048592i32);
pub const DEBUG_FLR_XPROC_HANG: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(1048588i32);
pub const DEBUG_FLR_ZEROED_STACK: DEBUG_FLR_PARAM_TYPE = DEBUG_FLR_PARAM_TYPE(8194i32);
pub const DEBUG_FORMAT_CAB_SECONDARY_ALL_IMAGES: u32 = 268435456u32;
pub const DEBUG_FORMAT_CAB_SECONDARY_FILES: u32 = 1073741824u32;
pub const DEBUG_FORMAT_DEFAULT: u32 = 0u32;
pub const DEBUG_FORMAT_NO_OVERWRITE: u32 = 2147483648u32;
pub const DEBUG_FORMAT_USER_SMALL_ADD_AVX_XSTATE_CONTEXT: u32 = 131072u32;
pub const DEBUG_FORMAT_USER_SMALL_CODE_SEGMENTS: u32 = 4096u32;
pub const DEBUG_FORMAT_USER_SMALL_DATA_SEGMENTS: u32 = 16u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_MEMORY: u32 = 32u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_PATHS: u32 = 64u32;
pub const DEBUG_FORMAT_USER_SMALL_FILTER_TRIAGE: u32 = 65536u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_AUXILIARY_STATE: u32 = 16384u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_MEMORY: u32 = 1u32;
pub const DEBUG_FORMAT_USER_SMALL_FULL_MEMORY_INFO: u32 = 1024u32;
pub const DEBUG_FORMAT_USER_SMALL_HANDLE_DATA: u32 = 2u32;
pub const DEBUG_FORMAT_USER_SMALL_IGNORE_INACCESSIBLE_MEM: u32 = 134217728u32;
pub const DEBUG_FORMAT_USER_SMALL_INDIRECT_MEMORY: u32 = 8u32;
pub const DEBUG_FORMAT_USER_SMALL_IPT_TRACE: u32 = 262144u32;
pub const DEBUG_FORMAT_USER_SMALL_MODULE_HEADERS: u32 = 32768u32;
pub const DEBUG_FORMAT_USER_SMALL_NO_AUXILIARY_STATE: u32 = 8192u32;
pub const DEBUG_FORMAT_USER_SMALL_NO_OPTIONAL_DATA: u32 = 512u32;
pub const DEBUG_FORMAT_USER_SMALL_PRIVATE_READ_WRITE_MEMORY: u32 = 256u32;
pub const DEBUG_FORMAT_USER_SMALL_PROCESS_THREAD_DATA: u32 = 128u32;
pub const DEBUG_FORMAT_USER_SMALL_SCAN_PARTIAL_PAGES: u32 = 268435456u32;
pub const DEBUG_FORMAT_USER_SMALL_THREAD_INFO: u32 = 2048u32;
pub const DEBUG_FORMAT_USER_SMALL_UNLOADED_MODULES: u32 = 4u32;
pub const DEBUG_FORMAT_WRITE_CAB: u32 = 536870912u32;
pub const DEBUG_FRAME_DEFAULT: u32 = 0u32;
pub const DEBUG_FRAME_IGNORE_INLINE: u32 = 1u32;
pub const DEBUG_GETFNENT_DEFAULT: u32 = 0u32;
pub const DEBUG_GETFNENT_RAW_ENTRY_ONLY: u32 = 1u32;
pub const DEBUG_GETMOD_DEFAULT: u32 = 0u32;
pub const DEBUG_GETMOD_NO_LOADED_MODULES: u32 = 1u32;
pub const DEBUG_GETMOD_NO_UNLOADED_MODULES: u32 = 2u32;
pub const DEBUG_GET_PROC_DEFAULT: u32 = 0u32;
pub const DEBUG_GET_PROC_FULL_MATCH: u32 = 1u32;
pub const DEBUG_GET_PROC_ONLY_MATCH: u32 = 2u32;
pub const DEBUG_GET_PROC_SERVICE_NAME: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_GET_TEXT_COMPLETIONS_IN {
    pub Flags: u32,
    pub MatchCountLimit: u32,
    pub Reserved: [u64; 3],
}
impl Default for DEBUG_GET_TEXT_COMPLETIONS_IN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_DOT_COMMAND: u32 = 1u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_EXTENSION_COMMAND: u32 = 2u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_IS_SYMBOL: u32 = 4u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_DOT_COMMANDS: u32 = 1u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_EXTENSION_COMMANDS: u32 = 2u32;
pub const DEBUG_GET_TEXT_COMPLETIONS_NO_SYMBOLS: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_GET_TEXT_COMPLETIONS_OUT {
    pub Flags: u32,
    pub ReplaceIndex: u32,
    pub MatchCount: u32,
    pub Reserved1: u32,
    pub Reserved2: [u64; 2],
}
impl Default for DEBUG_GET_TEXT_COMPLETIONS_OUT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_GSEL_ALLOW_HIGHER: u32 = 4u32;
pub const DEBUG_GSEL_ALLOW_LOWER: u32 = 2u32;
pub const DEBUG_GSEL_DEFAULT: u32 = 0u32;
pub const DEBUG_GSEL_INLINE_CALLSITE: u32 = 16u32;
pub const DEBUG_GSEL_NEAREST_ONLY: u32 = 8u32;
pub const DEBUG_GSEL_NO_SYMBOL_LOADS: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_HANDLE_DATA_BASIC {
    pub TypeNameSize: u32,
    pub ObjectNameSize: u32,
    pub Attributes: u32,
    pub GrantedAccess: u32,
    pub HandleCount: u32,
    pub PointerCount: u32,
}
pub const DEBUG_HANDLE_DATA_TYPE_ALL_HANDLE_OPERATIONS: u32 = 10u32;
pub const DEBUG_HANDLE_DATA_TYPE_BASIC: u32 = 0u32;
pub const DEBUG_HANDLE_DATA_TYPE_HANDLE_COUNT: u32 = 3u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_EVENT_1: u32 = 13u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_1: u32 = 7u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_MUTANT_2: u32 = 8u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_PROCESS_1: u32 = 11u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_PROCESS_2: u32 = 12u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_SECTION_1: u32 = 14u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_SEMAPHORE_1: u32 = 15u32;
pub const DEBUG_HANDLE_DATA_TYPE_MINI_THREAD_1: u32 = 6u32;
pub const DEBUG_HANDLE_DATA_TYPE_OBJECT_NAME: u32 = 2u32;
pub const DEBUG_HANDLE_DATA_TYPE_OBJECT_NAME_WIDE: u32 = 5u32;
pub const DEBUG_HANDLE_DATA_TYPE_PER_HANDLE_OPERATIONS: u32 = 9u32;
pub const DEBUG_HANDLE_DATA_TYPE_TYPE_NAME: u32 = 1u32;
pub const DEBUG_HANDLE_DATA_TYPE_TYPE_NAME_WIDE: u32 = 4u32;
pub const DEBUG_INTERRUPT_ACTIVE: u32 = 0u32;
pub const DEBUG_INTERRUPT_EXIT: u32 = 2u32;
pub const DEBUG_INTERRUPT_PASSIVE: u32 = 1u32;
pub const DEBUG_IOUTPUT_ADDR_TRANSLATE: u32 = 134217728u32;
pub const DEBUG_IOUTPUT_BREAKPOINT: u32 = 536870912u32;
pub const DEBUG_IOUTPUT_EVENT: u32 = 268435456u32;
pub const DEBUG_IOUTPUT_KD_PROTOCOL: u32 = 2147483648u32;
pub const DEBUG_IOUTPUT_REMOTING: u32 = 1073741824u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_IRP_INFO {
    pub SizeOfStruct: u32,
    pub IrpAddress: u64,
    pub IoStatus: u32,
    pub StackCount: u32,
    pub CurrentLocation: u32,
    pub MdlAddress: u64,
    pub Thread: u64,
    pub CancelRoutine: u64,
    pub CurrentStack: DEBUG_IRP_STACK_INFO,
    pub Stack: [DEBUG_IRP_STACK_INFO; 10],
}
impl Default for DEBUG_IRP_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_IRP_STACK_INFO {
    pub Major: u8,
    pub Minor: u8,
    pub DeviceObject: u64,
    pub FileObject: u64,
    pub CompletionRoutine: u64,
    pub StackAddress: u64,
}
pub const DEBUG_KERNEL_ACTIVE_DUMP: u32 = 1030u32;
pub const DEBUG_KERNEL_CONNECTION: u32 = 0u32;
pub const DEBUG_KERNEL_DUMP: u32 = 1025u32;
pub const DEBUG_KERNEL_EXDI_DRIVER: u32 = 2u32;
pub const DEBUG_KERNEL_FULL_DUMP: u32 = 1026u32;
pub const DEBUG_KERNEL_IDNA: u32 = 3u32;
pub const DEBUG_KERNEL_INSTALL_DRIVER: u32 = 4u32;
pub const DEBUG_KERNEL_LOCAL: u32 = 1u32;
pub const DEBUG_KERNEL_REPT: u32 = 5u32;
pub const DEBUG_KERNEL_SMALL_DUMP: u32 = 1024u32;
pub const DEBUG_KERNEL_TRACE_LOG: u32 = 1028u32;
pub const DEBUG_KNOWN_STRUCT_GET_NAMES: u32 = 1u32;
pub const DEBUG_KNOWN_STRUCT_GET_SINGLE_LINE_OUTPUT: u32 = 2u32;
pub const DEBUG_KNOWN_STRUCT_SUPPRESS_TYPE_NAME: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_BREAKPOINT {
    pub Id: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_EXCEPTION {
    pub ExceptionRecord: super::EXCEPTION_RECORD64,
    pub FirstChance: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_EXIT_PROCESS {
    pub ExitCode: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_EXIT_THREAD {
    pub ExitCode: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_LOAD_MODULE {
    pub Base: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_SERVICE_EXCEPTION {
    pub Kind: u32,
    pub DataSize: u32,
    pub Address: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_SYSTEM_ERROR {
    pub Error: u32,
    pub Level: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_LAST_EVENT_INFO_UNLOAD_MODULE {
    pub Base: u64,
}
pub const DEBUG_LEVEL_ASSEMBLY: u32 = 1u32;
pub const DEBUG_LEVEL_SOURCE: u32 = 0u32;
pub const DEBUG_LIVE_USER_NON_INVASIVE: u32 = 33u32;
pub const DEBUG_LOG_APPEND: u32 = 1u32;
pub const DEBUG_LOG_DEFAULT: u32 = 0u32;
pub const DEBUG_LOG_DML: u32 = 4u32;
pub const DEBUG_LOG_UNICODE: u32 = 2u32;
pub const DEBUG_MANAGED_ALLOWED: u32 = 1u32;
pub const DEBUG_MANAGED_DISABLED: u32 = 0u32;
pub const DEBUG_MANAGED_DLL_LOADED: u32 = 2u32;
pub const DEBUG_MANRESET_DEFAULT: u32 = 0u32;
pub const DEBUG_MANRESET_LOAD_DLL: u32 = 1u32;
pub const DEBUG_MANSTR_LOADED_SUPPORT_DLL: u32 = 1u32;
pub const DEBUG_MANSTR_LOAD_STATUS: u32 = 2u32;
pub const DEBUG_MANSTR_NONE: u32 = 0u32;
pub const DEBUG_MODNAME_IMAGE: u32 = 0u32;
pub const DEBUG_MODNAME_LOADED_IMAGE: u32 = 2u32;
pub const DEBUG_MODNAME_MAPPED_IMAGE: u32 = 4u32;
pub const DEBUG_MODNAME_MODULE: u32 = 1u32;
pub const DEBUG_MODNAME_SYMBOL_FILE: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_MODULE_AND_ID {
    pub ModuleBase: u64,
    pub Id: u64,
}
pub const DEBUG_MODULE_EXE_MODULE: u32 = 4u32;
pub const DEBUG_MODULE_EXPLICIT: u32 = 8u32;
pub const DEBUG_MODULE_LOADED: u32 = 0u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_MODULE_PARAMETERS {
    pub Base: u64,
    pub Size: u32,
    pub TimeDateStamp: u32,
    pub Checksum: u32,
    pub Flags: u32,
    pub SymbolType: u32,
    pub ImageNameSize: u32,
    pub ModuleNameSize: u32,
    pub LoadedImageNameSize: u32,
    pub SymbolFileNameSize: u32,
    pub MappedImageNameSize: u32,
    pub Reserved: [u64; 2],
}
impl Default for DEBUG_MODULE_PARAMETERS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_MODULE_SECONDARY: u32 = 16u32;
pub const DEBUG_MODULE_SYM_BAD_CHECKSUM: u32 = 65536u32;
pub const DEBUG_MODULE_SYNTHETIC: u32 = 32u32;
pub const DEBUG_MODULE_UNLOADED: u32 = 1u32;
pub const DEBUG_MODULE_USER_MODE: u32 = 2u32;
pub const DEBUG_NOTIFY_SESSION_ACCESSIBLE: u32 = 2u32;
pub const DEBUG_NOTIFY_SESSION_ACTIVE: u32 = 0u32;
pub const DEBUG_NOTIFY_SESSION_INACCESSIBLE: u32 = 3u32;
pub const DEBUG_NOTIFY_SESSION_INACTIVE: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_OFFSET_REGION {
    pub Base: u64,
    pub Size: u64,
}
pub const DEBUG_OFFSINFO_VIRTUAL_SOURCE: u32 = 1u32;
pub const DEBUG_OUTCBF_COMBINED_EXPLICIT_FLUSH: u32 = 1u32;
pub const DEBUG_OUTCBF_DML_HAS_SPECIAL_CHARACTERS: u32 = 4u32;
pub const DEBUG_OUTCBF_DML_HAS_TAGS: u32 = 2u32;
pub const DEBUG_OUTCBI_ANY_FORMAT: u32 = 6u32;
pub const DEBUG_OUTCBI_DML: u32 = 4u32;
pub const DEBUG_OUTCBI_EXPLICIT_FLUSH: u32 = 1u32;
pub const DEBUG_OUTCBI_TEXT: u32 = 2u32;
pub const DEBUG_OUTCB_DML: u32 = 1u32;
pub const DEBUG_OUTCB_EXPLICIT_FLUSH: u32 = 2u32;
pub const DEBUG_OUTCB_TEXT: u32 = 0u32;
pub const DEBUG_OUTCTL_ALL_CLIENTS: u32 = 1u32;
pub const DEBUG_OUTCTL_ALL_OTHER_CLIENTS: u32 = 2u32;
pub const DEBUG_OUTCTL_AMBIENT: u32 = 4294967295u32;
pub const DEBUG_OUTCTL_AMBIENT_DML: u32 = 4294967294u32;
pub const DEBUG_OUTCTL_AMBIENT_TEXT: u32 = 4294967295u32;
pub const DEBUG_OUTCTL_DML: u32 = 32u32;
pub const DEBUG_OUTCTL_IGNORE: u32 = 3u32;
pub const DEBUG_OUTCTL_LOG_ONLY: u32 = 4u32;
pub const DEBUG_OUTCTL_NOT_LOGGED: u32 = 8u32;
pub const DEBUG_OUTCTL_OVERRIDE_MASK: u32 = 16u32;
pub const DEBUG_OUTCTL_SEND_MASK: u32 = 7u32;
pub const DEBUG_OUTCTL_THIS_CLIENT: u32 = 0u32;
pub const DEBUG_OUTPUT_DEBUGGEE: u32 = 128u32;
pub const DEBUG_OUTPUT_DEBUGGEE_PROMPT: u32 = 256u32;
pub const DEBUG_OUTPUT_ERROR: u32 = 2u32;
pub const DEBUG_OUTPUT_EXTENSION_WARNING: u32 = 64u32;
pub const DEBUG_OUTPUT_IDENTITY_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTPUT_NAME_END: windows_core::PCSTR = windows_core::s!("**NAME**");
pub const DEBUG_OUTPUT_NAME_END_T: windows_core::PCWSTR = windows_core::w!("**NAME**");
pub const DEBUG_OUTPUT_NAME_END_WIDE: windows_core::PCWSTR = windows_core::w!("**NAME**");
pub const DEBUG_OUTPUT_NORMAL: u32 = 1u32;
pub const DEBUG_OUTPUT_OFFSET_END: windows_core::PCSTR = windows_core::s!("**OFF**");
pub const DEBUG_OUTPUT_OFFSET_END_T: windows_core::PCWSTR = windows_core::w!("**OFF**");
pub const DEBUG_OUTPUT_OFFSET_END_WIDE: windows_core::PCWSTR = windows_core::w!("**OFF**");
pub const DEBUG_OUTPUT_PROMPT: u32 = 16u32;
pub const DEBUG_OUTPUT_PROMPT_REGISTERS: u32 = 32u32;
pub const DEBUG_OUTPUT_STATUS: u32 = 1024u32;
pub const DEBUG_OUTPUT_SYMBOLS: u32 = 512u32;
pub const DEBUG_OUTPUT_SYMBOLS_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_NAMES: u32 = 1u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_OFFSETS: u32 = 2u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_TYPES: u32 = 16u32;
pub const DEBUG_OUTPUT_SYMBOLS_NO_VALUES: u32 = 4u32;
pub const DEBUG_OUTPUT_TYPE_END: windows_core::PCSTR = windows_core::s!("**TYPE**");
pub const DEBUG_OUTPUT_TYPE_END_T: windows_core::PCWSTR = windows_core::w!("**TYPE**");
pub const DEBUG_OUTPUT_TYPE_END_WIDE: windows_core::PCWSTR = windows_core::w!("**TYPE**");
pub const DEBUG_OUTPUT_VALUE_END: windows_core::PCSTR = windows_core::s!("**VALUE**");
pub const DEBUG_OUTPUT_VALUE_END_T: windows_core::PCWSTR = windows_core::w!("**VALUE**");
pub const DEBUG_OUTPUT_VALUE_END_WIDE: windows_core::PCWSTR = windows_core::w!("**VALUE**");
pub const DEBUG_OUTPUT_VERBOSE: u32 = 8u32;
pub const DEBUG_OUTPUT_WARNING: u32 = 4u32;
pub const DEBUG_OUTPUT_XML: u32 = 2048u32;
pub const DEBUG_OUTSYM_ALLOW_DISPLACEMENT: u32 = 4u32;
pub const DEBUG_OUTSYM_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTSYM_FORCE_OFFSET: u32 = 1u32;
pub const DEBUG_OUTSYM_SOURCE_LINE: u32 = 2u32;
pub const DEBUG_OUTTYPE_ADDRESS_AT_END: u32 = 131072u32;
pub const DEBUG_OUTTYPE_ADDRESS_OF_FIELD: u32 = 65536u32;
pub const DEBUG_OUTTYPE_BLOCK_RECURSE: u32 = 2097152u32;
pub const DEBUG_OUTTYPE_COMPACT_OUTPUT: u32 = 8u32;
pub const DEBUG_OUTTYPE_DEFAULT: u32 = 0u32;
pub const DEBUG_OUTTYPE_NO_INDENT: u32 = 1u32;
pub const DEBUG_OUTTYPE_NO_OFFSET: u32 = 2u32;
pub const DEBUG_OUTTYPE_VERBOSE: u32 = 4u32;
pub const DEBUG_OUT_TEXT_REPL_DEFAULT: u32 = 0u32;
pub const DEBUG_PHYSICAL_CACHED: u32 = 1u32;
pub const DEBUG_PHYSICAL_DEFAULT: u32 = 0u32;
pub const DEBUG_PHYSICAL_UNCACHED: u32 = 2u32;
pub const DEBUG_PHYSICAL_WRITE_COMBINED: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_PNP_TRIAGE_INFO {
    pub SizeOfStruct: u32,
    pub Lock_Address: u64,
    pub Lock_ActiveCount: i32,
    pub Lock_ContentionCount: u32,
    pub Lock_NumberOfExclusiveWaiters: u32,
    pub Lock_NumberOfSharedWaiters: u32,
    pub Lock_Flag: u16,
    pub TriagedThread: u64,
    pub ThreadCount: i32,
    pub TriagedThread_WaitTime: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_POOLTAG_DESCRIPTION {
    pub SizeOfStruct: u32,
    pub PoolTag: u32,
    pub Description: [i8; 260],
    pub Binary: [i8; 32],
    pub Owner: [i8; 32],
}
impl Default for DEBUG_POOLTAG_DESCRIPTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUG_POOL_DATA {
    pub SizeofStruct: u32,
    pub PoolBlock: u64,
    pub Pool: u64,
    pub PreviousSize: u32,
    pub Size: u32,
    pub PoolTag: u32,
    pub ProcessBilled: u64,
    pub Anonymous: DEBUG_POOL_DATA_0,
    pub Reserved2: [u64; 4],
    pub PoolTagDescription: [i8; 64],
}
impl Default for DEBUG_POOL_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUG_POOL_DATA_0 {
    pub Anonymous: DEBUG_POOL_DATA_0_0,
    pub AsUlong: u32,
}
impl Default for DEBUG_POOL_DATA_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_POOL_DATA_0_0 {
    pub _bitfield: u32,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DEBUG_POOL_REGION(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    pub Alpha: DEBUG_PROCESSOR_IDENTIFICATION_ALPHA,
    pub Amd64: DEBUG_PROCESSOR_IDENTIFICATION_AMD64,
    pub Ia64: DEBUG_PROCESSOR_IDENTIFICATION_IA64,
    pub X86: DEBUG_PROCESSOR_IDENTIFICATION_X86,
    pub Arm: DEBUG_PROCESSOR_IDENTIFICATION_ARM,
    pub Arm64: DEBUG_PROCESSOR_IDENTIFICATION_ARM64,
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_ALL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ALPHA {
    pub Type: u32,
    pub Revision: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    pub Family: u32,
    pub Model: u32,
    pub Stepping: u32,
    pub VendorString: [i8; 16],
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_AMD64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    pub Model: u32,
    pub Revision: u32,
    pub VendorString: [i8; 16],
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_ARM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    pub Model: u32,
    pub Revision: u32,
    pub VendorString: [i8; 16],
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_ARM64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    pub Model: u32,
    pub Revision: u32,
    pub Family: u32,
    pub ArchRev: u32,
    pub VendorString: [i8; 16],
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_IA64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    pub Family: u32,
    pub Model: u32,
    pub Stepping: u32,
    pub VendorString: [i8; 16],
}
impl Default for DEBUG_PROCESSOR_IDENTIFICATION_X86 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_PROCESS_DETACH_ON_EXIT: u32 = 1u32;
pub const DEBUG_PROCESS_ONLY_THIS_PROCESS: u32 = 2u32;
pub const DEBUG_PROC_DESC_DEFAULT: u32 = 0u32;
pub const DEBUG_PROC_DESC_NO_COMMAND_LINE: u32 = 8u32;
pub const DEBUG_PROC_DESC_NO_MTS_PACKAGES: u32 = 4u32;
pub const DEBUG_PROC_DESC_NO_PATHS: u32 = 1u32;
pub const DEBUG_PROC_DESC_NO_SERVICES: u32 = 2u32;
pub const DEBUG_PROC_DESC_NO_SESSION_ID: u32 = 16u32;
pub const DEBUG_PROC_DESC_NO_USER_NAME: u32 = 32u32;
pub const DEBUG_PROC_DESC_WITH_ARCHITECTURE: u32 = 128u32;
pub const DEBUG_PROC_DESC_WITH_PACKAGEFAMILY: u32 = 64u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_READ_USER_MINIDUMP_STREAM {
    pub StreamType: u32,
    pub Flags: u32,
    pub Offset: u64,
    pub Buffer: *mut core::ffi::c_void,
    pub BufferSize: u32,
    pub BufferUsed: u32,
}
impl Default for DEBUG_READ_USER_MINIDUMP_STREAM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_REGISTERS_ALL: u32 = 7u32;
pub const DEBUG_REGISTERS_DEFAULT: u32 = 0u32;
pub const DEBUG_REGISTERS_FLOAT: u32 = 4u32;
pub const DEBUG_REGISTERS_INT32: u32 = 1u32;
pub const DEBUG_REGISTERS_INT64: u32 = 2u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_REGISTER_DESCRIPTION {
    pub Type: u32,
    pub Flags: u32,
    pub SubregMaster: u32,
    pub SubregLength: u32,
    pub SubregMask: u64,
    pub SubregShift: u32,
    pub Reserved0: u32,
}
pub const DEBUG_REGISTER_SUB_REGISTER: u32 = 1u32;
pub const DEBUG_REGSRC_DEBUGGEE: u32 = 0u32;
pub const DEBUG_REGSRC_EXPLICIT: u32 = 1u32;
pub const DEBUG_REGSRC_FRAME: u32 = 2u32;
pub const DEBUG_REQUEST_ADD_CACHED_SYMBOL_INFO: u32 = 16u32;
pub const DEBUG_REQUEST_CLOSE_TOKEN: u32 = 30u32;
pub const DEBUG_REQUEST_CURRENT_OUTPUT_CALLBACKS_ARE_DML_AWARE: u32 = 19u32;
pub const DEBUG_REQUEST_DUPLICATE_TOKEN: u32 = 28u32;
pub const DEBUG_REQUEST_EXT_TYPED_DATA_ANSI: u32 = 12u32;
pub const DEBUG_REQUEST_GET_ADDITIONAL_CREATE_OPTIONS: u32 = 4u32;
pub const DEBUG_REQUEST_GET_CACHED_SYMBOL_INFO: u32 = 15u32;
pub const DEBUG_REQUEST_GET_CAPTURED_EVENT_CODE_OFFSET: u32 = 10u32;
pub const DEBUG_REQUEST_GET_DUMP_HEADER: u32 = 21u32;
pub const DEBUG_REQUEST_GET_EXTENSION_SEARCH_PATH_WIDE: u32 = 13u32;
pub const DEBUG_REQUEST_GET_IMAGE_ARCHITECTURE: u32 = 39u32;
pub const DEBUG_REQUEST_GET_INSTRUMENTATION_VERSION: u32 = 37u32;
pub const DEBUG_REQUEST_GET_MODULE_ARCHITECTURE: u32 = 38u32;
pub const DEBUG_REQUEST_GET_OFFSET_UNWIND_INFORMATION: u32 = 20u32;
pub const DEBUG_REQUEST_GET_TEXT_COMPLETIONS_ANSI: u32 = 18u32;
pub const DEBUG_REQUEST_GET_TEXT_COMPLETIONS_WIDE: u32 = 14u32;
pub const DEBUG_REQUEST_GET_WIN32_MAJOR_MINOR_VERSIONS: u32 = 6u32;
pub const DEBUG_REQUEST_INLINE_QUERY: u32 = 35u32;
pub const DEBUG_REQUEST_MIDORI: u32 = 23u32;
pub const DEBUG_REQUEST_MISC_INFORMATION: u32 = 25u32;
pub const DEBUG_REQUEST_OPEN_PROCESS_TOKEN: u32 = 26u32;
pub const DEBUG_REQUEST_OPEN_THREAD_TOKEN: u32 = 27u32;
pub const DEBUG_REQUEST_PROCESS_DESCRIPTORS: u32 = 24u32;
pub const DEBUG_REQUEST_QUERY_INFO_TOKEN: u32 = 29u32;
pub const DEBUG_REQUEST_READ_CAPTURED_EVENT_CODE_STREAM: u32 = 11u32;
pub const DEBUG_REQUEST_READ_USER_MINIDUMP_STREAM: u32 = 7u32;
pub const DEBUG_REQUEST_REMOVE_CACHED_SYMBOL_INFO: u32 = 17u32;
pub const DEBUG_REQUEST_RESUME_THREAD: u32 = 34u32;
pub const DEBUG_REQUEST_SET_ADDITIONAL_CREATE_OPTIONS: u32 = 5u32;
pub const DEBUG_REQUEST_SET_DUMP_HEADER: u32 = 22u32;
pub const DEBUG_REQUEST_SET_LOCAL_IMPLICIT_COMMAND_LINE: u32 = 9u32;
pub const DEBUG_REQUEST_SOURCE_PATH_HAS_SOURCE_SERVER: u32 = 0u32;
pub const DEBUG_REQUEST_TARGET_CAN_DETACH: u32 = 8u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_CONTEXT: u32 = 1u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_RECORD: u32 = 3u32;
pub const DEBUG_REQUEST_TARGET_EXCEPTION_THREAD: u32 = 2u32;
pub const DEBUG_REQUEST_TL_INSTRUMENTATION_AWARE: u32 = 36u32;
pub const DEBUG_REQUEST_WOW_MODULE: u32 = 32u32;
pub const DEBUG_REQUEST_WOW_PROCESS: u32 = 31u32;
pub const DEBUG_SCOPE_GROUP_ALL: u32 = 3u32;
pub const DEBUG_SCOPE_GROUP_ARGUMENTS: u32 = 1u32;
pub const DEBUG_SCOPE_GROUP_BY_DATAMODEL: u32 = 4u32;
pub const DEBUG_SCOPE_GROUP_LOCALS: u32 = 2u32;
pub const DEBUG_SERVERS_ALL: u32 = 3u32;
pub const DEBUG_SERVERS_DEBUGGER: u32 = 1u32;
pub const DEBUG_SERVERS_PROCESS: u32 = 2u32;
pub const DEBUG_SESSION_ACTIVE: u32 = 0u32;
pub const DEBUG_SESSION_END: u32 = 4u32;
pub const DEBUG_SESSION_END_SESSION_ACTIVE_DETACH: u32 = 2u32;
pub const DEBUG_SESSION_END_SESSION_ACTIVE_TERMINATE: u32 = 1u32;
pub const DEBUG_SESSION_END_SESSION_PASSIVE: u32 = 3u32;
pub const DEBUG_SESSION_FAILURE: u32 = 7u32;
pub const DEBUG_SESSION_HIBERNATE: u32 = 6u32;
pub const DEBUG_SESSION_REBOOT: u32 = 5u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_SMBIOS_INFO {
    pub SizeOfStruct: u32,
    pub SmbiosMajorVersion: u8,
    pub SmbiosMinorVersion: u8,
    pub DMIVersion: u8,
    pub TableSize: u32,
    pub BiosMajorRelease: u8,
    pub BiosMinorRelease: u8,
    pub FirmwareMajorRelease: u8,
    pub FirmwareMinorRelease: u8,
    pub BaseBoardManufacturer: [i8; 64],
    pub BaseBoardProduct: [i8; 64],
    pub BaseBoardVersion: [i8; 64],
    pub BiosReleaseDate: [i8; 64],
    pub BiosVendor: [i8; 64],
    pub BiosVersion: [i8; 64],
    pub SystemFamily: [i8; 64],
    pub SystemManufacturer: [i8; 64],
    pub SystemProductName: [i8; 64],
    pub SystemSKU: [i8; 64],
    pub SystemVersion: [i8; 64],
}
impl Default for DEBUG_SMBIOS_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_SOURCE_IS_STATEMENT: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_SPECIFIC_FILTER_PARAMETERS {
    pub ExecutionOption: u32,
    pub ContinueOption: u32,
    pub TextSize: u32,
    pub CommandSize: u32,
    pub ArgumentSize: u32,
}
pub const DEBUG_SRCFILE_SYMBOL_CHECKSUMINFO: u32 = 2u32;
pub const DEBUG_SRCFILE_SYMBOL_TOKEN: u32 = 0u32;
pub const DEBUG_SRCFILE_SYMBOL_TOKEN_SOURCE_COMMAND_WIDE: u32 = 1u32;
pub const DEBUG_STACK_ARGUMENTS: u32 = 1u32;
pub const DEBUG_STACK_COLUMN_NAMES: u32 = 16u32;
pub const DEBUG_STACK_DML: u32 = 2048u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_STACK_FRAME {
    pub InstructionOffset: u64,
    pub ReturnOffset: u64,
    pub FrameOffset: u64,
    pub StackOffset: u64,
    pub FuncTableEntry: u64,
    pub Params: [u64; 4],
    pub Reserved: [u64; 6],
    pub Virtual: windows_core::BOOL,
    pub FrameNumber: u32,
}
impl Default for DEBUG_STACK_FRAME {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_STACK_FRAME_ADDRESSES: u32 = 8u32;
pub const DEBUG_STACK_FRAME_ADDRESSES_RA_ONLY: u32 = 256u32;
pub const DEBUG_STACK_FRAME_ARCH: u32 = 16384u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_STACK_FRAME_EX {
    pub InstructionOffset: u64,
    pub ReturnOffset: u64,
    pub FrameOffset: u64,
    pub StackOffset: u64,
    pub FuncTableEntry: u64,
    pub Params: [u64; 4],
    pub Reserved: [u64; 6],
    pub Virtual: windows_core::BOOL,
    pub FrameNumber: u32,
    pub InlineFrameContext: u32,
    pub Reserved1: u32,
}
impl Default for DEBUG_STACK_FRAME_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_STACK_FRAME_MEMORY_USAGE: u32 = 512u32;
pub const DEBUG_STACK_FRAME_NUMBERS: u32 = 64u32;
pub const DEBUG_STACK_FRAME_OFFSETS: u32 = 4096u32;
pub const DEBUG_STACK_FUNCTION_INFO: u32 = 2u32;
pub const DEBUG_STACK_NONVOLATILE_REGISTERS: u32 = 32u32;
pub const DEBUG_STACK_PARAMETERS: u32 = 128u32;
pub const DEBUG_STACK_PARAMETERS_NEWLINE: u32 = 1024u32;
pub const DEBUG_STACK_PROVIDER: u32 = 8192u32;
pub const DEBUG_STACK_SOURCE_LINE: u32 = 4u32;
pub const DEBUG_STATUS_BREAK: u32 = 6u32;
pub const DEBUG_STATUS_GO: u32 = 1u32;
pub const DEBUG_STATUS_GO_HANDLED: u32 = 2u32;
pub const DEBUG_STATUS_GO_NOT_HANDLED: u32 = 3u32;
pub const DEBUG_STATUS_IGNORE_EVENT: u32 = 9u32;
pub const DEBUG_STATUS_INSIDE_WAIT: u64 = 4294967296u64;
pub const DEBUG_STATUS_MASK: u32 = 31u32;
pub const DEBUG_STATUS_NO_CHANGE: u32 = 0u32;
pub const DEBUG_STATUS_NO_DEBUGGEE: u32 = 7u32;
pub const DEBUG_STATUS_OUT_OF_SYNC: u32 = 15u32;
pub const DEBUG_STATUS_RESTART_REQUESTED: u32 = 10u32;
pub const DEBUG_STATUS_REVERSE_GO: u32 = 11u32;
pub const DEBUG_STATUS_REVERSE_STEP_BRANCH: u32 = 12u32;
pub const DEBUG_STATUS_REVERSE_STEP_INTO: u32 = 14u32;
pub const DEBUG_STATUS_REVERSE_STEP_OVER: u32 = 13u32;
pub const DEBUG_STATUS_STEP_BRANCH: u32 = 8u32;
pub const DEBUG_STATUS_STEP_INTO: u32 = 5u32;
pub const DEBUG_STATUS_STEP_OVER: u32 = 4u32;
pub const DEBUG_STATUS_TIMEOUT: u32 = 17u32;
pub const DEBUG_STATUS_WAIT_INPUT: u32 = 16u32;
pub const DEBUG_STATUS_WAIT_TIMEOUT: u64 = 8589934592u64;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_SYMBOL_ENTRY {
    pub ModuleBase: u64,
    pub Offset: u64,
    pub Id: u64,
    pub Arg64: u64,
    pub Size: u32,
    pub Flags: u32,
    pub TypeId: u32,
    pub NameSize: u32,
    pub Token: u32,
    pub Tag: u32,
    pub Arg32: u32,
    pub Reserved: u32,
}
pub const DEBUG_SYMBOL_EXPANDED: u32 = 16u32;
pub const DEBUG_SYMBOL_EXPANSION_LEVEL_MASK: u32 = 15u32;
pub const DEBUG_SYMBOL_IS_ARGUMENT: u32 = 256u32;
pub const DEBUG_SYMBOL_IS_ARRAY: u32 = 64u32;
pub const DEBUG_SYMBOL_IS_FLOAT: u32 = 128u32;
pub const DEBUG_SYMBOL_IS_LOCAL: u32 = 512u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_SYMBOL_PARAMETERS {
    pub Module: u64,
    pub TypeId: u32,
    pub ParentSymbol: u32,
    pub SubElements: u32,
    pub Flags: u32,
    pub Reserved: u64,
}
pub const DEBUG_SYMBOL_READ_ONLY: u32 = 32u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_SYMBOL_SOURCE_ENTRY {
    pub ModuleBase: u64,
    pub Offset: u64,
    pub FileNameId: u64,
    pub EngineInternal: u64,
    pub Size: u32,
    pub Flags: u32,
    pub FileNameSize: u32,
    pub StartLine: u32,
    pub EndLine: u32,
    pub StartColumn: u32,
    pub EndColumn: u32,
    pub Reserved: u32,
}
pub const DEBUG_SYMENT_IS_CODE: u32 = 1u32;
pub const DEBUG_SYMENT_IS_DATA: u32 = 2u32;
pub const DEBUG_SYMENT_IS_LOCAL: u32 = 8u32;
pub const DEBUG_SYMENT_IS_MANAGED: u32 = 16u32;
pub const DEBUG_SYMENT_IS_PARAMETER: u32 = 4u32;
pub const DEBUG_SYMENT_IS_SYNTHETIC: u32 = 32u32;
pub const DEBUG_SYMINFO_BREAKPOINT_SOURCE_LINE: u32 = 0u32;
pub const DEBUG_SYMINFO_GET_MODULE_SYMBOL_NAMES_AND_OFFSETS: u32 = 3u32;
pub const DEBUG_SYMINFO_GET_SYMBOL_NAME_BY_OFFSET_AND_TAG_WIDE: u32 = 2u32;
pub const DEBUG_SYMINFO_IMAGEHLP_MODULEW64: u32 = 1u32;
pub const DEBUG_SYMTYPE_CODEVIEW: u32 = 2u32;
pub const DEBUG_SYMTYPE_COFF: u32 = 1u32;
pub const DEBUG_SYMTYPE_DEFERRED: u32 = 5u32;
pub const DEBUG_SYMTYPE_DIA: u32 = 7u32;
pub const DEBUG_SYMTYPE_EXPORT: u32 = 4u32;
pub const DEBUG_SYMTYPE_NONE: u32 = 0u32;
pub const DEBUG_SYMTYPE_PDB: u32 = 3u32;
pub const DEBUG_SYMTYPE_SYM: u32 = 6u32;
pub const DEBUG_SYSOBJINFO_CURRENT_PROCESS_COOKIE: u32 = 2u32;
pub const DEBUG_SYSOBJINFO_THREAD_BASIC_INFORMATION: u32 = 0u32;
pub const DEBUG_SYSOBJINFO_THREAD_NAME_WIDE: u32 = 1u32;
pub const DEBUG_SYSVERSTR_BUILD: u32 = 1u32;
pub const DEBUG_SYSVERSTR_SERVICE_PACK: u32 = 0u32;
pub const DEBUG_TBINFO_AFFINITY: u32 = 32u32;
pub const DEBUG_TBINFO_ALL: u32 = 63u32;
pub const DEBUG_TBINFO_EXIT_STATUS: u32 = 1u32;
pub const DEBUG_TBINFO_PRIORITY: u32 = 4u32;
pub const DEBUG_TBINFO_PRIORITY_CLASS: u32 = 2u32;
pub const DEBUG_TBINFO_START_OFFSET: u32 = 16u32;
pub const DEBUG_TBINFO_TIMES: u32 = 8u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_THREAD_BASIC_INFORMATION {
    pub Valid: u32,
    pub ExitStatus: u32,
    pub PriorityClass: u32,
    pub Priority: u32,
    pub CreateTime: u64,
    pub ExitTime: u64,
    pub KernelTime: u64,
    pub UserTime: u64,
    pub StartOffset: u64,
    pub Affinity: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_TRIAGE_FOLLOWUP_INFO {
    pub SizeOfStruct: u32,
    pub OwnerNameSize: u32,
    pub OwnerName: windows_core::PSTR,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_TRIAGE_FOLLOWUP_INFO_2 {
    pub SizeOfStruct: u32,
    pub OwnerNameSize: u32,
    pub OwnerName: windows_core::PSTR,
    pub FeaturePathSize: u32,
    pub FeaturePath: windows_core::PSTR,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DEBUG_TYPED_DATA {
    pub ModBase: u64,
    pub Offset: u64,
    pub EngineHandle: u64,
    pub Data: u64,
    pub Size: u32,
    pub Flags: u32,
    pub TypeId: u32,
    pub BaseTypeId: u32,
    pub Tag: u32,
    pub Register: u32,
    pub Internal: [u64; 9],
}
impl Default for DEBUG_TYPED_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DEBUG_TYPED_DATA_IS_IN_MEMORY: u32 = 1u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_CACHED: u32 = 4u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_DEFAULT: u32 = 2u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_MEMORY: u32 = 14u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_UNCACHED: u32 = 6u32;
pub const DEBUG_TYPED_DATA_PHYSICAL_WRITE_COMBINED: u32 = 8u32;
pub const DEBUG_TYPEOPTS_FORCERADIX_OUTPUT: u32 = 4u32;
pub const DEBUG_TYPEOPTS_LONGSTATUS_DISPLAY: u32 = 2u32;
pub const DEBUG_TYPEOPTS_MATCH_MAXSIZE: u32 = 8u32;
pub const DEBUG_TYPEOPTS_UNICODE_DISPLAY: u32 = 1u32;
pub const DEBUG_USER_WINDOWS_DUMP: u32 = 1025u32;
pub const DEBUG_USER_WINDOWS_DUMP_WINDOWS_CE: u32 = 1029u32;
pub const DEBUG_USER_WINDOWS_IDNA: u32 = 2u32;
pub const DEBUG_USER_WINDOWS_PROCESS: u32 = 0u32;
pub const DEBUG_USER_WINDOWS_PROCESS_SERVER: u32 = 1u32;
pub const DEBUG_USER_WINDOWS_REPT: u32 = 3u32;
pub const DEBUG_USER_WINDOWS_SMALL_DUMP: u32 = 1024u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DEBUG_VALUE {
    pub Anonymous: DEBUG_VALUE_0,
    pub TailOfRawBytes: u32,
    pub Type: u32,
}
impl Default for DEBUG_VALUE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DEBUG_VALUE_0 {
    pub I8: u8,
    pub I16: u16,
    pub I32: u32,
    pub Anonymous: DEBUG_VALUE_0_0,
    pub F32: f32,
    pub F64: f64,
    pub F80Bytes: [u8; 10],
    pub F82Bytes: [u8; 11],
    pub F128Bytes: [u8; 16],
    pub VI8: [u8; 16],
    pub VI16: [u16; 8],
    pub VI32: [u32; 4],
    pub VI64: [u64; 2],
    pub VF32: [f32; 4],
    pub VF64: [f64; 2],
    pub I64Parts32: DEBUG_VALUE_0_1,
    pub F128Parts64: DEBUG_VALUE_0_2,
    pub RawBytes: [u8; 24],
}
impl Default for DEBUG_VALUE_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_VALUE_0_0 {
    pub I64: u64,
    pub Nat: windows_core::BOOL,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_VALUE_0_2 {
    pub LowPart: u64,
    pub HighPart: i64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct DEBUG_VALUE_0_1 {
    pub LowPart: u32,
    pub HighPart: u32,
}
pub const DEBUG_VALUE_FLOAT128: u32 = 9u32;
pub const DEBUG_VALUE_FLOAT32: u32 = 5u32;
pub const DEBUG_VALUE_FLOAT64: u32 = 6u32;
pub const DEBUG_VALUE_FLOAT80: u32 = 7u32;
pub const DEBUG_VALUE_FLOAT82: u32 = 8u32;
pub const DEBUG_VALUE_INT16: u32 = 2u32;
pub const DEBUG_VALUE_INT32: u32 = 3u32;
pub const DEBUG_VALUE_INT64: u32 = 4u32;
pub const DEBUG_VALUE_INT8: u32 = 1u32;
pub const DEBUG_VALUE_INVALID: u32 = 0u32;
pub const DEBUG_VALUE_TYPES: u32 = 12u32;
pub const DEBUG_VALUE_VECTOR128: u32 = 11u32;
pub const DEBUG_VALUE_VECTOR64: u32 = 10u32;
pub const DEBUG_VSEARCH_DEFAULT: u32 = 0u32;
pub const DEBUG_VSEARCH_WRITABLE_ONLY: u32 = 1u32;
pub const DEBUG_VSOURCE_DEBUGGEE: u32 = 1u32;
pub const DEBUG_VSOURCE_DUMP_WITHOUT_MEMINFO: u32 = 3u32;
pub const DEBUG_VSOURCE_INVALID: u32 = 0u32;
pub const DEBUG_VSOURCE_MAPPED_IMAGE: u32 = 2u32;
pub const DEBUG_WAIT_DEFAULT: u32 = 0u32;
pub const DISK_READ_0_BYTES: TANALYZE_RETURN = TANALYZE_RETURN(3i32);
pub const DISK_WRITE: TANALYZE_RETURN = TANALYZE_RETURN(4i32);
pub const DUMP_HANDLE_FLAG_CID_TABLE: u32 = 32u32;
pub const DUMP_HANDLE_FLAG_KERNEL_TABLE: u32 = 16u32;
pub const DUMP_HANDLE_FLAG_PRINT_FREE_ENTRY: u32 = 4u32;
pub const DUMP_HANDLE_FLAG_PRINT_OBJECT: u32 = 2u32;
pub const DbgPoolRegionMax: DEBUG_POOL_REGION = DEBUG_POOL_REGION(6i32);
pub const DbgPoolRegionNonPaged: DEBUG_POOL_REGION = DEBUG_POOL_REGION(3i32);
pub const DbgPoolRegionNonPagedExpansion: DEBUG_POOL_REGION = DEBUG_POOL_REGION(4i32);
pub const DbgPoolRegionPaged: DEBUG_POOL_REGION = DEBUG_POOL_REGION(2i32);
pub const DbgPoolRegionSessionPaged: DEBUG_POOL_REGION = DEBUG_POOL_REGION(5i32);
pub const DbgPoolRegionSpecial: DEBUG_POOL_REGION = DEBUG_POOL_REGION(1i32);
pub const DbgPoolRegionUnknown: DEBUG_POOL_REGION = DEBUG_POOL_REGION(0i32);
windows_core::imp::define_interface!(DebugBaseEventCallbacks, DebugBaseEventCallbacks_Vtbl, 0);
impl core::ops::Deref for DebugBaseEventCallbacks {
    type Target = IDebugEventCallbacks;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(DebugBaseEventCallbacks, windows_core::IUnknown, IDebugEventCallbacks);
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacks_Vtbl {
    pub base__: IDebugEventCallbacks_Vtbl,
}
pub trait DebugBaseEventCallbacks_Impl: IDebugEventCallbacks_Impl {}
impl DebugBaseEventCallbacks_Vtbl {
    pub const fn new<Identity: DebugBaseEventCallbacks_Impl, const OFFSET: isize>() -> Self {
        Self { base__: IDebugEventCallbacks_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DebugBaseEventCallbacks as windows_core::Interface>::IID || iid == &<IDebugEventCallbacks as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for DebugBaseEventCallbacks {}
windows_core::imp::define_interface!(DebugBaseEventCallbacksWide, DebugBaseEventCallbacksWide_Vtbl, 0);
impl core::ops::Deref for DebugBaseEventCallbacksWide {
    type Target = IDebugEventCallbacksWide;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(DebugBaseEventCallbacksWide, windows_core::IUnknown, IDebugEventCallbacksWide);
#[repr(C)]
#[doc(hidden)]
pub struct DebugBaseEventCallbacksWide_Vtbl {
    pub base__: IDebugEventCallbacksWide_Vtbl,
}
pub trait DebugBaseEventCallbacksWide_Impl: IDebugEventCallbacksWide_Impl {}
impl DebugBaseEventCallbacksWide_Vtbl {
    pub const fn new<Identity: DebugBaseEventCallbacksWide_Impl, const OFFSET: isize>() -> Self {
        Self { base__: IDebugEventCallbacksWide_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<DebugBaseEventCallbacksWide as windows_core::Interface>::IID || iid == &<IDebugEventCallbacksWide as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for DebugBaseEventCallbacksWide {}
pub type ENTRY_CALLBACK = Option<unsafe extern "system" fn(entryaddress: u64, context: *mut core::ffi::c_void) -> windows_core::HRESULT>;
pub const ERROR_DBG_CANCELLED: u32 = 3221226695u32;
pub const ERROR_DBG_TIMEOUT: u32 = 3221226932u32;
pub const EXIT_ON_CONTROLC: u32 = 8u32;
pub const EXIT_STATUS: TANALYZE_RETURN = TANALYZE_RETURN(2i32);
pub const EXTDLL_DATA_QUERY_BUILD_BINDIR: u32 = 1u32;
pub const EXTDLL_DATA_QUERY_BUILD_BINDIR_SYMSRV: u32 = 11u32;
pub const EXTDLL_DATA_QUERY_BUILD_SYMDIR: u32 = 2u32;
pub const EXTDLL_DATA_QUERY_BUILD_SYMDIR_SYMSRV: u32 = 12u32;
pub const EXTDLL_DATA_QUERY_BUILD_WOW64BINDIR: u32 = 4u32;
pub const EXTDLL_DATA_QUERY_BUILD_WOW64BINDIR_SYMSRV: u32 = 14u32;
pub const EXTDLL_DATA_QUERY_BUILD_WOW64SYMDIR: u32 = 3u32;
pub const EXTDLL_DATA_QUERY_BUILD_WOW64SYMDIR_SYMSRV: u32 = 13u32;
pub type EXTDLL_ITERATERTLBALANCEDNODES = Option<unsafe extern "system" fn(rootnode: u64, entryoffset: u32, callback: ENTRY_CALLBACK, callbackcontext: *mut core::ffi::c_void)>;
pub type EXTDLL_QUERYDATABYTAG = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, dwdatatag: u32, pqueryinfo: *const core::ffi::c_void, pdata: *mut u8, cbdata: u32) -> windows_core::HRESULT>;
pub type EXTDLL_QUERYDATABYTAGEX = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, dwdatatag: u32, pqueryinfo: *const core::ffi::c_void, pdata: *mut u8, cbdata: u32, pdataex: *mut u8, cbdataex: u32) -> windows_core::HRESULT>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTSTACKTRACE {
    pub FramePointer: u32,
    pub ProgramCounter: u32,
    pub ReturnAddress: u32,
    pub Args: [u32; 4],
}
impl Default for EXTSTACKTRACE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTSTACKTRACE32 {
    pub FramePointer: u32,
    pub ProgramCounter: u32,
    pub ReturnAddress: u32,
    pub Args: [u32; 4],
}
impl Default for EXTSTACKTRACE32 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXTSTACKTRACE64 {
    pub FramePointer: u64,
    pub ProgramCounter: u64,
    pub ReturnAddress: u64,
    pub Args: [u64; 4],
}
impl Default for EXTSTACKTRACE64 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type EXTS_JOB_PROCESS_CALLBACK = Option<unsafe extern "system" fn(job: u64, process: u64, context: *mut core::ffi::c_void) -> bool>;
pub type EXTS_TABLE_ENTRY_CALLBACK = Option<unsafe extern "system" fn(entry: u64, context: *mut core::ffi::c_void) -> bool>;
pub type EXT_ANALYSIS_PLUGIN = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, callphase: FA_EXTENSION_PLUGIN_PHASE, panalysis: windows_core::Ref<'_, IDebugFailureAnalysis2>) -> windows_core::HRESULT>;
pub type EXT_ANALYZER = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient>, bucketsuffix: windows_core::PSTR, cbbucketsuffix: u32, debugtext: windows_core::PSTR, cbdebugtext: u32, flags: *const u32, panalysis: windows_core::Ref<'_, IDebugFailureAnalysis>) -> windows_core::HRESULT>;
pub const EXT_ANALYZER_FLAG_ID: u32 = 2u32;
pub const EXT_ANALYZER_FLAG_MOD: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EXT_API_VERSION {
    pub MajorVersion: u16,
    pub MinorVersion: u16,
    pub Revision: u16,
    pub Reserved: u16,
}
pub const EXT_API_VERSION_NUMBER: u32 = 5u32;
pub const EXT_API_VERSION_NUMBER32: u32 = 5u32;
pub const EXT_API_VERSION_NUMBER64: u32 = 6u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXT_CAB_XML_DATA {
    pub SizeOfStruct: u32,
    pub XmlObjectTag: windows_core::PCWSTR,
    pub NumSubTags: u32,
    pub SubTags: [EXT_CAB_XML_DATA_0; 1],
}
impl Default for EXT_CAB_XML_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EXT_CAB_XML_DATA_0 {
    pub SubTag: windows_core::PCWSTR,
    pub MatchPattern: windows_core::PCWSTR,
    pub ReturnText: windows_core::PWSTR,
    pub ReturnTextSize: u32,
    pub _bitfield: u32,
    pub Reserved2: u32,
}
pub type EXT_DECODE_ERROR = Option<unsafe extern "system" fn(pdecodeerror: *mut DEBUG_DECODE_ERROR)>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXT_FIND_FILE {
    pub FileName: windows_core::PCWSTR,
    pub IndexedSize: u64,
    pub ImageTimeDateStamp: u32,
    pub ImageCheckSum: u32,
    pub ExtraInfo: *mut core::ffi::c_void,
    pub ExtraInfoSize: u32,
    pub Flags: u32,
    pub FileMapping: *mut core::ffi::c_void,
    pub FileMappingSize: u64,
    pub FileHandle: super::super::super::super::Foundation::HANDLE,
    pub FoundFileName: windows_core::PWSTR,
    pub FoundFileNameChars: u32,
}
impl Default for EXT_FIND_FILE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EXT_FIND_FILE_ALLOW_GIVEN_PATH: u32 = 1u32;
pub type EXT_GET_DEBUG_FAILURE_ANALYSIS = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, flags: u32, classid: windows_core::GUID, ppanalysis: windows_core::OutRef<'_, IDebugFailureAnalysis2>) -> windows_core::HRESULT>;
pub type EXT_GET_ENVIRONMENT_VARIABLE = Option<unsafe extern "system" fn(peb: u64, variable: windows_core::PCSTR, buffer: windows_core::PCSTR, buffersize: u32) -> windows_core::HRESULT>;
pub type EXT_GET_FAILURE_ANALYSIS = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, flags: u32, ppanalysis: windows_core::OutRef<'_, IDebugFailureAnalysis>) -> windows_core::HRESULT>;
pub type EXT_GET_FA_ENTRIES_DATA = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, count: *mut u32, entries: *mut *mut FA_ENTRY) -> windows_core::HRESULT>;
pub type EXT_GET_HANDLE_TRACE = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient>, tracetype: u32, startindex: u32, handlevalue: *mut u64, stackfunctions: *mut u64, stacktracesize: u32) -> windows_core::HRESULT>;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct EXT_MATCH_PATTERN_A {
    pub Str: windows_core::PCSTR,
    pub Pattern: windows_core::PCSTR,
    pub CaseSensitive: u32,
}
pub type EXT_RELOAD_TRIAGER = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>) -> windows_core::HRESULT>;
pub type EXT_TARGET_INFO = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, ptargetinfo: *mut TARGET_DEBUG_INFO) -> windows_core::HRESULT>;
pub const EXT_TDF_PHYSICAL_CACHED: u32 = 4u32;
pub const EXT_TDF_PHYSICAL_DEFAULT: u32 = 2u32;
pub const EXT_TDF_PHYSICAL_MEMORY: u32 = 14u32;
pub const EXT_TDF_PHYSICAL_UNCACHED: u32 = 6u32;
pub const EXT_TDF_PHYSICAL_WRITE_COMBINED: u32 = 8u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EXT_TDOP(pub i32);
pub const EXT_TDOP_COPY: EXT_TDOP = EXT_TDOP(0i32);
pub const EXT_TDOP_COUNT: EXT_TDOP = EXT_TDOP(19i32);
pub const EXT_TDOP_EVALUATE: EXT_TDOP = EXT_TDOP(5i32);
pub const EXT_TDOP_GET_ARRAY_ELEMENT: EXT_TDOP = EXT_TDOP(12i32);
pub const EXT_TDOP_GET_DEREFERENCE: EXT_TDOP = EXT_TDOP(13i32);
pub const EXT_TDOP_GET_FIELD: EXT_TDOP = EXT_TDOP(4i32);
pub const EXT_TDOP_GET_FIELD_OFFSET: EXT_TDOP = EXT_TDOP(11i32);
pub const EXT_TDOP_GET_POINTER_TO: EXT_TDOP = EXT_TDOP(16i32);
pub const EXT_TDOP_GET_TYPE_NAME: EXT_TDOP = EXT_TDOP(6i32);
pub const EXT_TDOP_GET_TYPE_SIZE: EXT_TDOP = EXT_TDOP(14i32);
pub const EXT_TDOP_HAS_FIELD: EXT_TDOP = EXT_TDOP(10i32);
pub const EXT_TDOP_OUTPUT_FULL_VALUE: EXT_TDOP = EXT_TDOP(9i32);
pub const EXT_TDOP_OUTPUT_SIMPLE_VALUE: EXT_TDOP = EXT_TDOP(8i32);
pub const EXT_TDOP_OUTPUT_TYPE_DEFINITION: EXT_TDOP = EXT_TDOP(15i32);
pub const EXT_TDOP_OUTPUT_TYPE_NAME: EXT_TDOP = EXT_TDOP(7i32);
pub const EXT_TDOP_RELEASE: EXT_TDOP = EXT_TDOP(1i32);
pub const EXT_TDOP_SET_FROM_EXPR: EXT_TDOP = EXT_TDOP(2i32);
pub const EXT_TDOP_SET_FROM_TYPE_ID_AND_U64: EXT_TDOP = EXT_TDOP(17i32);
pub const EXT_TDOP_SET_FROM_U64_EXPR: EXT_TDOP = EXT_TDOP(3i32);
pub const EXT_TDOP_SET_PTR_FROM_TYPE_ID_AND_U64: EXT_TDOP = EXT_TDOP(18i32);
pub type EXT_TRIAGE_FOLLOWUP = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, symbolname: windows_core::PCSTR, ownerinfo: *mut DEBUG_TRIAGE_FOLLOWUP_INFO) -> u32>;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EXT_TYPED_DATA {
    pub Operation: EXT_TDOP,
    pub Flags: u32,
    pub InData: DEBUG_TYPED_DATA,
    pub OutData: DEBUG_TYPED_DATA,
    pub InStrIndex: u32,
    pub In32: u32,
    pub Out32: u32,
    pub In64: u64,
    pub Out64: u64,
    pub StrBufferIndex: u32,
    pub StrBufferChars: u32,
    pub StrCharsNeeded: u32,
    pub DataBufferIndex: u32,
    pub DataBufferBytes: u32,
    pub DataBytesNeeded: u32,
    pub Status: windows_core::HRESULT,
    pub Reserved: [u64; 8],
}
impl Default for EXT_TYPED_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub type EXT_XML_DATA = Option<unsafe extern "system" fn(client: windows_core::Ref<'_, IDebugClient4>, pxmpdata: *mut EXT_CAB_XML_DATA) -> windows_core::HRESULT>;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ErrorClass(pub i32);
pub const ErrorClassError: ErrorClass = ErrorClass(1i32);
pub const ErrorClassWarning: ErrorClass = ErrorClass(0i32);
pub const FAILURE_ANALYSIS_ASSUME_HANG: u32 = 4u32;
pub const FAILURE_ANALYSIS_AUTOBUG_PROCESSING: u32 = 64u32;
pub const FAILURE_ANALYSIS_AUTOSET_SYMPATH: u32 = 16384u32;
pub const FAILURE_ANALYSIS_CALLSTACK_XML: u32 = 256u32;
pub const FAILURE_ANALYSIS_CALLSTACK_XML_FULL_SOURCE_INFO: u32 = 16777216u32;
pub const FAILURE_ANALYSIS_CREATE_INSTANCE: u32 = 1048576u32;
pub const FAILURE_ANALYSIS_EXCEPTION_AS_HANG: u32 = 32u32;
pub const FAILURE_ANALYSIS_HEAP_CORRUPTION_BLAME_FUNCTION: u32 = 33554432u32;
pub const FAILURE_ANALYSIS_IGNORE_BREAKIN: u32 = 8u32;
pub const FAILURE_ANALYSIS_LIVE_DEBUG_HOLD_CHECK: u32 = 2097152u32;
pub const FAILURE_ANALYSIS_MODULE_INFO_XML: u32 = 4096u32;
pub const FAILURE_ANALYSIS_MULTI_TARGET: u32 = 131072u32;
pub const FAILURE_ANALYSIS_NO_DB_LOOKUP: u32 = 1u32;
pub const FAILURE_ANALYSIS_NO_IMAGE_CORRUPTION: u32 = 8192u32;
pub const FAILURE_ANALYSIS_PERMIT_HEAP_ACCESS_VIOLATIONS: u32 = 67108864u32;
pub const FAILURE_ANALYSIS_REGISTRY_DATA: u32 = 512u32;
pub const FAILURE_ANALYSIS_SET_FAILURE_CONTEXT: u32 = 16u32;
pub const FAILURE_ANALYSIS_SHOW_SOURCE: u32 = 262144u32;
pub const FAILURE_ANALYSIS_SHOW_WCT_STACKS: u32 = 524288u32;
pub const FAILURE_ANALYSIS_USER_ATTRIBUTES: u32 = 2048u32;
pub const FAILURE_ANALYSIS_USER_ATTRIBUTES_ALL: u32 = 32768u32;
pub const FAILURE_ANALYSIS_USER_ATTRIBUTES_FRAMES: u32 = 65536u32;
pub const FAILURE_ANALYSIS_VERBOSE: u32 = 2u32;
pub const FAILURE_ANALYSIS_WMI_QUERY_DATA: u32 = 1024u32;
pub const FAILURE_ANALYSIS_XML_FILE_OUTPUT: u32 = 4194304u32;
pub const FAILURE_ANALYSIS_XML_OUTPUT: u32 = 128u32;
pub const FAILURE_ANALYSIS_XSD_VERIFY: u32 = 8388608u32;
pub const FAILURE_ANALYSIS_XSLT_FILE_INPUT: u32 = 268435456u32;
pub const FAILURE_ANALYSIS_XSLT_FILE_OUTPUT: u32 = 536870912u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FA_ENTRY {
    pub Tag: DEBUG_FLR_PARAM_TYPE,
    pub FullSize: u16,
    pub DataSize: u16,
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FA_ENTRY_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FA_EXTENSION_PLUGIN_PHASE(pub i32);
pub const FA_PLUGIN_INITIALIZATION: FA_EXTENSION_PLUGIN_PHASE = FA_EXTENSION_PLUGIN_PHASE(1i32);
pub const FA_PLUGIN_POST_BUCKETING: FA_EXTENSION_PLUGIN_PHASE = FA_EXTENSION_PLUGIN_PHASE(8i32);
pub const FA_PLUGIN_PRE_BUCKETING: FA_EXTENSION_PLUGIN_PHASE = FA_EXTENSION_PLUGIN_PHASE(4i32);
pub const FA_PLUGIN_STACK_ANALYSIS: FA_EXTENSION_PLUGIN_PHASE = FA_EXTENSION_PLUGIN_PHASE(2i32);
pub const FIELDS_DID_NOT_MATCH: u32 = 4u32;
#[repr(C)]
#[derive(Clone, Copy)]
pub struct FIELD_INFO {
    pub fName: *mut u8,
    pub printName: *mut u8,
    pub size: u32,
    pub fOptions: u32,
    pub address: u64,
    pub Anonymous: FIELD_INFO_0,
    pub TypeId: u32,
    pub FieldOffset: u32,
    pub BufferSize: u32,
    pub BitField: FIELD_INFO_1,
    pub _bitfield: u32,
}
impl Default for FIELD_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union FIELD_INFO_0 {
    pub fieldCallBack: *mut core::ffi::c_void,
    pub pBuffer: *mut core::ffi::c_void,
}
impl Default for FIELD_INFO_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct FIELD_INFO_1 {
    pub Position: u16,
    pub Size: u16,
}
pub const FormatBSTRString: PreferredFormat = PreferredFormat(8i32);
pub const FormatEnumNameOnly: PreferredFormat = PreferredFormat(12i32);
pub const FormatEscapedStringWithQuote: PreferredFormat = PreferredFormat(13i32);
pub const FormatHString: PreferredFormat = PreferredFormat(10i32);
pub const FormatNone: PreferredFormat = PreferredFormat(0i32);
pub const FormatQuotedHString: PreferredFormat = PreferredFormat(9i32);
pub const FormatQuotedString: PreferredFormat = PreferredFormat(2i32);
pub const FormatQuotedUTF32String: PreferredFormat = PreferredFormat(15i32);
pub const FormatQuotedUTF8String: PreferredFormat = PreferredFormat(6i32);
pub const FormatQuotedUnicodeString: PreferredFormat = PreferredFormat(4i32);
pub const FormatRaw: PreferredFormat = PreferredFormat(11i32);
pub const FormatSingleCharacter: PreferredFormat = PreferredFormat(1i32);
pub const FormatString: PreferredFormat = PreferredFormat(3i32);
pub const FormatUTF32String: PreferredFormat = PreferredFormat(14i32);
pub const FormatUTF8String: PreferredFormat = PreferredFormat(7i32);
pub const FormatUnicodeString: PreferredFormat = PreferredFormat(5i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct GET_CONTEXT_EX {
    pub Status: u32,
    pub ContextSize: u32,
    pub pContext: *mut core::ffi::c_void,
}
impl Default for GET_CONTEXT_EX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_CURRENT_PROCESS_ADDRESS {
    pub Processor: u32,
    pub CurrentThread: u64,
    pub Address: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_CURRENT_THREAD_ADDRESS {
    pub Processor: u32,
    pub Address: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_EXPRESSION_EX {
    pub Expression: windows_core::PCSTR,
    pub Remainder: windows_core::PCSTR,
    pub Value: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_INPUT_LINE {
    pub Prompt: windows_core::PCSTR,
    pub Buffer: windows_core::PSTR,
    pub BufferSize: u32,
    pub InputSize: u32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_PEB_ADDRESS {
    pub CurrentThread: u64,
    pub Address: u64,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_SET_SYMPATH {
    pub Args: windows_core::PCSTR,
    pub Result: windows_core::PSTR,
    pub Length: i32,
}
#[repr(C)]
#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct GET_TEB_ADDRESS {
    pub Address: u64,
}
windows_core::imp::define_interface!(ICodeAddressConcept, ICodeAddressConcept_Vtbl, 0xc7371568_5c78_4a00_a4ab_6ef8823184cb);
windows_core::imp::interface_hierarchy!(ICodeAddressConcept, windows_core::IUnknown);
impl ICodeAddressConcept {
    pub unsafe fn GetContainingSymbol<P0>(&self, pcontextobject: P0) -> windows_core::Result<IDebugHostSymbol>
    where
        P0: windows_core::Param<IModelObject>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetContainingSymbol)(windows_core::Interface::as_raw(self), pcontextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICodeAddressConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetContainingSymbol: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait ICodeAddressConcept_Impl: windows_core::IUnknownImpl {
    fn GetContainingSymbol(&self, pcontextobject: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<IDebugHostSymbol>;
}
impl ICodeAddressConcept_Vtbl {
    pub const fn new<Identity: ICodeAddressConcept_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetContainingSymbol<Identity: ICodeAddressConcept_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcontextobject: *mut core::ffi::c_void, ppsymbol: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match ICodeAddressConcept_Impl::GetContainingSymbol(this, core::mem::transmute_copy(&pcontextobject)) {
                    Ok(ok__) => {
                        ppsymbol.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetContainingSymbol: GetContainingSymbol::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<ICodeAddressConcept as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for ICodeAddressConcept {}
windows_core::imp::define_interface!(IComparableConcept, IComparableConcept_Vtbl, 0xa7830646_9f0c_4a31_ba19_503f33e6c8a3);
windows_core::imp::interface_hierarchy!(IComparableConcept, windows_core::IUnknown);
impl IComparableConcept {
    pub unsafe fn CompareObjects<P0, P1>(&self, contextobject: P0, otherobject: P1) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IModelObject>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CompareObjects)(windows_core::Interface::as_raw(self), contextobject.param().abi(), otherobject.param().abi(), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComparableConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CompareObjects: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IComparableConcept_Impl: windows_core::IUnknownImpl {
    fn CompareObjects(&self, contextobject: windows_core::Ref<'_, IModelObject>, otherobject: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<i32>;
}
impl IComparableConcept_Vtbl {
    pub const fn new<Identity: IComparableConcept_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CompareObjects<Identity: IComparableConcept_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contextobject: *mut core::ffi::c_void, otherobject: *mut core::ffi::c_void, comparisonresult: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IComparableConcept_Impl::CompareObjects(this, core::mem::transmute_copy(&contextobject), core::mem::transmute_copy(&otherobject)) {
                    Ok(ok__) => {
                        comparisonresult.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CompareObjects: CompareObjects::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IComparableConcept as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IComparableConcept {}
windows_core::imp::define_interface!(IDataModelConcept, IDataModelConcept_Vtbl, 0xfcb98d1d_1114_4fbf_b24c_effcb5def0d3);
windows_core::imp::interface_hierarchy!(IDataModelConcept, windows_core::IUnknown);
impl IDataModelConcept {
    pub unsafe fn InitializeObject<P0, P1, P2>(&self, modelobject: P0, matchingtypesignature: P1, wildcardmatches: P2) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
        P2: windows_core::Param<IDebugHostSymbolEnumerator>,
    {
        unsafe { (windows_core::Interface::vtable(self).InitializeObject)(windows_core::Interface::as_raw(self), modelobject.param().abi(), matchingtypesignature.param().abi(), wildcardmatches.param().abi()).ok() }
    }
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelConcept_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub InitializeObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelConcept_Impl: windows_core::IUnknownImpl {
    fn InitializeObject(&self, modelobject: windows_core::Ref<'_, IModelObject>, matchingtypesignature: windows_core::Ref<'_, IDebugHostTypeSignature>, wildcardmatches: windows_core::Ref<'_, IDebugHostSymbolEnumerator>) -> windows_core::Result<()>;
    fn GetName(&self) -> windows_core::Result<windows_core::BSTR>;
}
impl IDataModelConcept_Vtbl {
    pub const fn new<Identity: IDataModelConcept_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn InitializeObject<Identity: IDataModelConcept_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelobject: *mut core::ffi::c_void, matchingtypesignature: *mut core::ffi::c_void, wildcardmatches: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelConcept_Impl::InitializeObject(this, core::mem::transmute_copy(&modelobject), core::mem::transmute_copy(&matchingtypesignature), core::mem::transmute_copy(&wildcardmatches)).into()
            }
        }
        unsafe extern "system" fn GetName<Identity: IDataModelConcept_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelConcept_Impl::GetName(this) {
                    Ok(ok__) => {
                        modelname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            InitializeObject: InitializeObject::<Identity, OFFSET>,
            GetName: GetName::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelConcept as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelConcept {}
windows_core::imp::define_interface!(IDataModelManager, IDataModelManager_Vtbl, 0x73fe19f4_a110_4500_8ed9_3c28896f508c);
windows_core::imp::interface_hierarchy!(IDataModelManager, windows_core::IUnknown);
impl IDataModelManager {
    pub unsafe fn Close(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Close)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn CreateNoValue(&self) -> windows_core::Result<IModelObject> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateNoValue)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn CreateErrorObject<P1>(&self, hrerror: windows_core::HRESULT, pwszmessage: P1) -> windows_core::Result<IModelObject>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateErrorObject)(windows_core::Interface::as_raw(self), hrerror, pwszmessage.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn CreateTypedObject<P0, P2>(&self, context: P0, objectlocation: Location, objecttype: P2) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P2: windows_core::Param<IDebugHostType>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateTypedObject)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(objectlocation), objecttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn CreateTypedObjectReference<P0, P2>(&self, context: P0, objectlocation: Location, objecttype: P2) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P2: windows_core::Param<IDebugHostType>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateTypedObjectReference)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(objectlocation), objecttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn CreateSyntheticObject<P0>(&self, context: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateSyntheticObject)(windows_core::Interface::as_raw(self), context.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn CreateDataModelObject<P0>(&self, datamodel: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDataModelConcept>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateDataModelObject)(windows_core::Interface::as_raw(self), datamodel.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::super::Variant::VARIANT) -> windows_core::Result<IModelObject> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateIntrinsicObject)(windows_core::Interface::as_raw(self), objectkind, core::mem::transmute(intrinsicdata), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn CreateTypedIntrinsicObject<P1>(&self, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: P1) -> windows_core::Result<IModelObject>
    where
        P1: windows_core::Param<IDebugHostType>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateTypedIntrinsicObject)(windows_core::Interface::as_raw(self), core::mem::transmute(intrinsicdata), r#type.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetModelForTypeSignature<P0>(&self, typesignature: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetModelForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetModelForType<P0>(&self, r#type: P0, datamodel: *mut Option<IModelObject>, typesignature: Option<*mut Option<IDebugHostTypeSignature>>, wildcardmatches: Option<*mut Option<IDebugHostSymbolEnumerator>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostType>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetModelForType)(windows_core::Interface::as_raw(self), r#type.param().abi(), core::mem::transmute(datamodel), typesignature.unwrap_or(core::mem::zeroed()) as _, wildcardmatches.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn RegisterModelForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
        P1: windows_core::Param<IModelObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterModelForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), datamodel.param().abi()).ok() }
    }
    pub unsafe fn UnregisterModelForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnregisterModelForTypeSignature)(windows_core::Interface::as_raw(self), datamodel.param().abi(), typesignature.param().abi()).ok() }
    }
    pub unsafe fn RegisterExtensionForTypeSignature<P0, P1>(&self, typesignature: P0, datamodel: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugHostTypeSignature>,
        P1: windows_core::Param<IModelObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterExtensionForTypeSignature)(windows_core::Interface::as_raw(self), typesignature.param().abi(), datamodel.param().abi()).ok() }
    }
    pub unsafe fn UnregisterExtensionForTypeSignature<P0, P1>(&self, datamodel: P0, typesignature: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<IDebugHostTypeSignature>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnregisterExtensionForTypeSignature)(windows_core::Interface::as_raw(self), datamodel.param().abi(), typesignature.param().abi()).ok() }
    }
    pub unsafe fn CreateMetadataStore<P0>(&self, parentstore: P0) -> windows_core::Result<IKeyStore>
    where
        P0: windows_core::Param<IKeyStore>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateMetadataStore)(windows_core::Interface::as_raw(self), parentstore.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetRootNamespace(&self) -> windows_core::Result<IModelObject> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRootNamespace)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterNamedModel<P0, P1>(&self, modelname: P0, modeobject: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<IModelObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi(), modeobject.param().abi()).ok() }
    }
    pub unsafe fn UnregisterNamedModel<P0>(&self, modelname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnregisterNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi()).ok() }
    }
    pub unsafe fn AcquireNamedModel<P0>(&self, modelname: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AcquireNamedModel)(windows_core::Interface::as_raw(self), modelname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Close: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateNoValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateErrorObject: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, Location, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateTypedObjectReference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, Location, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateSyntheticObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateDataModelObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub CreateIntrinsicObject: unsafe extern "system" fn(*mut core::ffi::c_void, ModelObjectKind, *const super::super::super::Variant::VARIANT, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    CreateIntrinsicObject: usize,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub CreateTypedIntrinsicObject: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::super::super::Variant::VARIANT, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    CreateTypedIntrinsicObject: usize,
    pub GetModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetModelForType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterModelForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterExtensionForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterExtensionForTypeSignature: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateMetadataStore: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRootNamespace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AcquireNamedModel: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDataModelManager_Impl: windows_core::IUnknownImpl {
    fn Close(&self) -> windows_core::Result<()>;
    fn CreateNoValue(&self) -> windows_core::Result<IModelObject>;
    fn CreateErrorObject(&self, hrerror: windows_core::HRESULT, pwszmessage: &windows_core::PCWSTR) -> windows_core::Result<IModelObject>;
    fn CreateTypedObject(&self, context: windows_core::Ref<'_, IDebugHostContext>, objectlocation: &Location, objecttype: windows_core::Ref<'_, IDebugHostType>) -> windows_core::Result<IModelObject>;
    fn CreateTypedObjectReference(&self, context: windows_core::Ref<'_, IDebugHostContext>, objectlocation: &Location, objecttype: windows_core::Ref<'_, IDebugHostType>) -> windows_core::Result<IModelObject>;
    fn CreateSyntheticObject(&self, context: windows_core::Ref<'_, IDebugHostContext>) -> windows_core::Result<IModelObject>;
    fn CreateDataModelObject(&self, datamodel: windows_core::Ref<'_, IDataModelConcept>) -> windows_core::Result<IModelObject>;
    fn CreateIntrinsicObject(&self, objectkind: ModelObjectKind, intrinsicdata: *const super::super::super::Variant::VARIANT) -> windows_core::Result<IModelObject>;
    fn CreateTypedIntrinsicObject(&self, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: windows_core::Ref<'_, IDebugHostType>) -> windows_core::Result<IModelObject>;
    fn GetModelForTypeSignature(&self, typesignature: windows_core::Ref<'_, IDebugHostTypeSignature>) -> windows_core::Result<IModelObject>;
    fn GetModelForType(&self, r#type: windows_core::Ref<'_, IDebugHostType>, datamodel: windows_core::OutRef<'_, IModelObject>, typesignature: windows_core::OutRef<'_, IDebugHostTypeSignature>, wildcardmatches: windows_core::OutRef<'_, IDebugHostSymbolEnumerator>) -> windows_core::Result<()>;
    fn RegisterModelForTypeSignature(&self, typesignature: windows_core::Ref<'_, IDebugHostTypeSignature>, datamodel: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<()>;
    fn UnregisterModelForTypeSignature(&self, datamodel: windows_core::Ref<'_, IModelObject>, typesignature: windows_core::Ref<'_, IDebugHostTypeSignature>) -> windows_core::Result<()>;
    fn RegisterExtensionForTypeSignature(&self, typesignature: windows_core::Ref<'_, IDebugHostTypeSignature>, datamodel: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<()>;
    fn UnregisterExtensionForTypeSignature(&self, datamodel: windows_core::Ref<'_, IModelObject>, typesignature: windows_core::Ref<'_, IDebugHostTypeSignature>) -> windows_core::Result<()>;
    fn CreateMetadataStore(&self, parentstore: windows_core::Ref<'_, IKeyStore>) -> windows_core::Result<IKeyStore>;
    fn GetRootNamespace(&self) -> windows_core::Result<IModelObject>;
    fn RegisterNamedModel(&self, modelname: &windows_core::PCWSTR, modeobject: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<()>;
    fn UnregisterNamedModel(&self, modelname: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn AcquireNamedModel(&self, modelname: &windows_core::PCWSTR) -> windows_core::Result<IModelObject>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDataModelManager_Vtbl {
    pub const fn new<Identity: IDataModelManager_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Close<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::Close(this).into()
            }
        }
        unsafe extern "system" fn CreateNoValue<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateNoValue(this) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateErrorObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hrerror: windows_core::HRESULT, pwszmessage: windows_core::PCWSTR, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateErrorObject(this, core::mem::transmute_copy(&hrerror), core::mem::transmute(&pwszmessage)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateTypedObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, objectlocation: Location, objecttype: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateTypedObject(this, core::mem::transmute_copy(&context), core::mem::transmute(&objectlocation), core::mem::transmute_copy(&objecttype)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateTypedObjectReference<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, objectlocation: Location, objecttype: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateTypedObjectReference(this, core::mem::transmute_copy(&context), core::mem::transmute(&objectlocation), core::mem::transmute_copy(&objecttype)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateSyntheticObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateSyntheticObject(this, core::mem::transmute_copy(&context)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateDataModelObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, datamodel: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateDataModelObject(this, core::mem::transmute_copy(&datamodel)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateIntrinsicObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, objectkind: ModelObjectKind, intrinsicdata: *const super::super::super::Variant::VARIANT, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateIntrinsicObject(this, core::mem::transmute_copy(&objectkind), core::mem::transmute_copy(&intrinsicdata)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateTypedIntrinsicObject<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateTypedIntrinsicObject(this, core::mem::transmute_copy(&intrinsicdata), core::mem::transmute_copy(&r#type)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetModelForTypeSignature<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, typesignature: *mut core::ffi::c_void, datamodel: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::GetModelForTypeSignature(this, core::mem::transmute_copy(&typesignature)) {
                    Ok(ok__) => {
                        datamodel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetModelForType<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, r#type: *mut core::ffi::c_void, datamodel: *mut *mut core::ffi::c_void, typesignature: *mut *mut core::ffi::c_void, wildcardmatches: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::GetModelForType(this, core::mem::transmute_copy(&r#type), core::mem::transmute_copy(&datamodel), core::mem::transmute_copy(&typesignature), core::mem::transmute_copy(&wildcardmatches)).into()
            }
        }
        unsafe extern "system" fn RegisterModelForTypeSignature<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, typesignature: *mut core::ffi::c_void, datamodel: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::RegisterModelForTypeSignature(this, core::mem::transmute_copy(&typesignature), core::mem::transmute_copy(&datamodel)).into()
            }
        }
        unsafe extern "system" fn UnregisterModelForTypeSignature<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, datamodel: *mut core::ffi::c_void, typesignature: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::UnregisterModelForTypeSignature(this, core::mem::transmute_copy(&datamodel), core::mem::transmute_copy(&typesignature)).into()
            }
        }
        unsafe extern "system" fn RegisterExtensionForTypeSignature<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, typesignature: *mut core::ffi::c_void, datamodel: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::RegisterExtensionForTypeSignature(this, core::mem::transmute_copy(&typesignature), core::mem::transmute_copy(&datamodel)).into()
            }
        }
        unsafe extern "system" fn UnregisterExtensionForTypeSignature<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, datamodel: *mut core::ffi::c_void, typesignature: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::UnregisterExtensionForTypeSignature(this, core::mem::transmute_copy(&datamodel), core::mem::transmute_copy(&typesignature)).into()
            }
        }
        unsafe extern "system" fn CreateMetadataStore<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, parentstore: *mut core::ffi::c_void, metadatastore: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::CreateMetadataStore(this, core::mem::transmute_copy(&parentstore)) {
                    Ok(ok__) => {
                        metadatastore.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRootNamespace<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rootnamespace: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::GetRootNamespace(this) {
                    Ok(ok__) => {
                        rootnamespace.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterNamedModel<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelname: windows_core::PCWSTR, modeobject: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::RegisterNamedModel(this, core::mem::transmute(&modelname), core::mem::transmute_copy(&modeobject)).into()
            }
        }
        unsafe extern "system" fn UnregisterNamedModel<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelManager_Impl::UnregisterNamedModel(this, core::mem::transmute(&modelname)).into()
            }
        }
        unsafe extern "system" fn AcquireNamedModel<Identity: IDataModelManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelname: windows_core::PCWSTR, modelobject: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager_Impl::AcquireNamedModel(this, core::mem::transmute(&modelname)) {
                    Ok(ok__) => {
                        modelobject.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Close: Close::<Identity, OFFSET>,
            CreateNoValue: CreateNoValue::<Identity, OFFSET>,
            CreateErrorObject: CreateErrorObject::<Identity, OFFSET>,
            CreateTypedObject: CreateTypedObject::<Identity, OFFSET>,
            CreateTypedObjectReference: CreateTypedObjectReference::<Identity, OFFSET>,
            CreateSyntheticObject: CreateSyntheticObject::<Identity, OFFSET>,
            CreateDataModelObject: CreateDataModelObject::<Identity, OFFSET>,
            CreateIntrinsicObject: CreateIntrinsicObject::<Identity, OFFSET>,
            CreateTypedIntrinsicObject: CreateTypedIntrinsicObject::<Identity, OFFSET>,
            GetModelForTypeSignature: GetModelForTypeSignature::<Identity, OFFSET>,
            GetModelForType: GetModelForType::<Identity, OFFSET>,
            RegisterModelForTypeSignature: RegisterModelForTypeSignature::<Identity, OFFSET>,
            UnregisterModelForTypeSignature: UnregisterModelForTypeSignature::<Identity, OFFSET>,
            RegisterExtensionForTypeSignature: RegisterExtensionForTypeSignature::<Identity, OFFSET>,
            UnregisterExtensionForTypeSignature: UnregisterExtensionForTypeSignature::<Identity, OFFSET>,
            CreateMetadataStore: CreateMetadataStore::<Identity, OFFSET>,
            GetRootNamespace: GetRootNamespace::<Identity, OFFSET>,
            RegisterNamedModel: RegisterNamedModel::<Identity, OFFSET>,
            UnregisterNamedModel: UnregisterNamedModel::<Identity, OFFSET>,
            AcquireNamedModel: AcquireNamedModel::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelManager as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDataModelManager {}
windows_core::imp::define_interface!(IDataModelManager2, IDataModelManager2_Vtbl, 0xf412c5ea_2284_4622_a660_a697160d3312);
impl core::ops::Deref for IDataModelManager2 {
    type Target = IDataModelManager;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelManager2, windows_core::IUnknown, IDataModelManager);
impl IDataModelManager2 {
    pub unsafe fn AcquireSubNamespace<P0, P1, P2, P3>(&self, modelname: P0, subnamespacemodelname: P1, accessname: P2, metadata: P3) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P1: windows_core::Param<windows_core::PCWSTR>,
        P2: windows_core::Param<windows_core::PCWSTR>,
        P3: windows_core::Param<IKeyStore>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AcquireSubNamespace)(windows_core::Interface::as_raw(self), modelname.param().abi(), subnamespacemodelname.param().abi(), accessname.param().abi(), metadata.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn CreateTypedIntrinsicObjectEx<P0, P2>(&self, context: P0, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: P2) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<IDebugHostContext>,
        P2: windows_core::Param<IDebugHostType>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateTypedIntrinsicObjectEx)(windows_core::Interface::as_raw(self), context.param().abi(), core::mem::transmute(intrinsicdata), r#type.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelManager2_Vtbl {
    pub base__: IDataModelManager_Vtbl,
    pub AcquireSubNamespace: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, windows_core::PCWSTR, windows_core::PCWSTR, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub CreateTypedIntrinsicObjectEx: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const super::super::super::Variant::VARIANT, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    CreateTypedIntrinsicObjectEx: usize,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IDataModelManager2_Impl: IDataModelManager_Impl {
    fn AcquireSubNamespace(&self, modelname: &windows_core::PCWSTR, subnamespacemodelname: &windows_core::PCWSTR, accessname: &windows_core::PCWSTR, metadata: windows_core::Ref<'_, IKeyStore>) -> windows_core::Result<IModelObject>;
    fn CreateTypedIntrinsicObjectEx(&self, context: windows_core::Ref<'_, IDebugHostContext>, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: windows_core::Ref<'_, IDebugHostType>) -> windows_core::Result<IModelObject>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IDataModelManager2_Vtbl {
    pub const fn new<Identity: IDataModelManager2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AcquireSubNamespace<Identity: IDataModelManager2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, modelname: windows_core::PCWSTR, subnamespacemodelname: windows_core::PCWSTR, accessname: windows_core::PCWSTR, metadata: *mut core::ffi::c_void, namespacemodelobject: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager2_Impl::AcquireSubNamespace(this, core::mem::transmute(&modelname), core::mem::transmute(&subnamespacemodelname), core::mem::transmute(&accessname), core::mem::transmute_copy(&metadata)) {
                    Ok(ok__) => {
                        namespacemodelobject.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateTypedIntrinsicObjectEx<Identity: IDataModelManager2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, intrinsicdata: *const super::super::super::Variant::VARIANT, r#type: *mut core::ffi::c_void, object: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelManager2_Impl::CreateTypedIntrinsicObjectEx(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&intrinsicdata), core::mem::transmute_copy(&r#type)) {
                    Ok(ok__) => {
                        object.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IDataModelManager_Vtbl::new::<Identity, OFFSET>(),
            AcquireSubNamespace: AcquireSubNamespace::<Identity, OFFSET>,
            CreateTypedIntrinsicObjectEx: CreateTypedIntrinsicObjectEx::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelManager2 as windows_core::Interface>::IID || iid == &<IDataModelManager as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IDataModelManager2 {}
windows_core::imp::define_interface!(IDataModelNameBinder, IDataModelNameBinder_Vtbl, 0xaf352b7b_8292_4c01_b360_2dc3696c65e7);
windows_core::imp::interface_hierarchy!(IDataModelNameBinder, windows_core::IUnknown);
impl IDataModelNameBinder {
    pub unsafe fn BindValue<P0, P1>(&self, contextobject: P0, name: P1, value: *mut Option<IModelObject>, metadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).BindValue)(windows_core::Interface::as_raw(self), contextobject.param().abi(), name.param().abi(), core::mem::transmute(value), metadata.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn BindReference<P0, P1>(&self, contextobject: P0, name: P1, reference: *mut Option<IModelObject>, metadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IModelObject>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).BindReference)(windows_core::Interface::as_raw(self), contextobject.param().abi(), name.param().abi(), core::mem::transmute(reference), metadata.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn EnumerateValues<P0>(&self, contextobject: P0) -> windows_core::Result<IKeyEnumerator>
    where
        P0: windows_core::Param<IModelObject>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateValues)(windows_core::Interface::as_raw(self), contextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateReferences<P0>(&self, contextobject: P0) -> windows_core::Result<IKeyEnumerator>
    where
        P0: windows_core::Param<IModelObject>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateReferences)(windows_core::Interface::as_raw(self), contextobject.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelNameBinder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub BindValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub BindReference: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateValues: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateReferences: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelNameBinder_Impl: windows_core::IUnknownImpl {
    fn BindValue(&self, contextobject: windows_core::Ref<'_, IModelObject>, name: &windows_core::PCWSTR, value: windows_core::OutRef<'_, IModelObject>, metadata: windows_core::OutRef<'_, IKeyStore>) -> windows_core::Result<()>;
    fn BindReference(&self, contextobject: windows_core::Ref<'_, IModelObject>, name: &windows_core::PCWSTR, reference: windows_core::OutRef<'_, IModelObject>, metadata: windows_core::OutRef<'_, IKeyStore>) -> windows_core::Result<()>;
    fn EnumerateValues(&self, contextobject: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<IKeyEnumerator>;
    fn EnumerateReferences(&self, contextobject: windows_core::Ref<'_, IModelObject>) -> windows_core::Result<IKeyEnumerator>;
}
impl IDataModelNameBinder_Vtbl {
    pub const fn new<Identity: IDataModelNameBinder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn BindValue<Identity: IDataModelNameBinder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contextobject: *mut core::ffi::c_void, name: windows_core::PCWSTR, value: *mut *mut core::ffi::c_void, metadata: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelNameBinder_Impl::BindValue(this, core::mem::transmute_copy(&contextobject), core::mem::transmute(&name), core::mem::transmute_copy(&value), core::mem::transmute_copy(&metadata)).into()
            }
        }
        unsafe extern "system" fn BindReference<Identity: IDataModelNameBinder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contextobject: *mut core::ffi::c_void, name: windows_core::PCWSTR, reference: *mut *mut core::ffi::c_void, metadata: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelNameBinder_Impl::BindReference(this, core::mem::transmute_copy(&contextobject), core::mem::transmute(&name), core::mem::transmute_copy(&reference), core::mem::transmute_copy(&metadata)).into()
            }
        }
        unsafe extern "system" fn EnumerateValues<Identity: IDataModelNameBinder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contextobject: *mut core::ffi::c_void, enumerator: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelNameBinder_Impl::EnumerateValues(this, core::mem::transmute_copy(&contextobject)) {
                    Ok(ok__) => {
                        enumerator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateReferences<Identity: IDataModelNameBinder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contextobject: *mut core::ffi::c_void, enumerator: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelNameBinder_Impl::EnumerateReferences(this, core::mem::transmute_copy(&contextobject)) {
                    Ok(ok__) => {
                        enumerator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            BindValue: BindValue::<Identity, OFFSET>,
            BindReference: BindReference::<Identity, OFFSET>,
            EnumerateValues: EnumerateValues::<Identity, OFFSET>,
            EnumerateReferences: EnumerateReferences::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelNameBinder as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelNameBinder {}
windows_core::imp::define_interface!(IDataModelScript, IDataModelScript_Vtbl, 0x7b4d30fc_b14a_49f8_8d87_d9a1480c97f7);
windows_core::imp::interface_hierarchy!(IDataModelScript, windows_core::IUnknown);
impl IDataModelScript {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn Rename<P0>(&self, scriptname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).Rename)(windows_core::Interface::as_raw(self), scriptname.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Populate<P0>(&self, contentstream: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::super::Com::IStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).Populate)(windows_core::Interface::as_raw(self), contentstream.param().abi()).ok() }
    }
    pub unsafe fn Execute<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn Unlink(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Unlink)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn IsInvocable(&self) -> windows_core::Result<bool> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsInvocable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn InvokeMain<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).InvokeMain)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScript_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Rename: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Populate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Populate: usize,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Unlink: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub IsInvocable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub InvokeMain: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IDataModelScript_Impl: windows_core::IUnknownImpl {
    fn GetName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn Rename(&self, scriptname: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn Populate(&self, contentstream: windows_core::Ref<'_, super::super::super::Com::IStream>) -> windows_core::Result<()>;
    fn Execute(&self, client: windows_core::Ref<'_, IDataModelScriptClient>) -> windows_core::Result<()>;
    fn Unlink(&self) -> windows_core::Result<()>;
    fn IsInvocable(&self) -> windows_core::Result<bool>;
    fn InvokeMain(&self, client: windows_core::Ref<'_, IDataModelScriptClient>) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl IDataModelScript_Vtbl {
    pub const fn new<Identity: IDataModelScript_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetName<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, scriptname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScript_Impl::GetName(this) {
                    Ok(ok__) => {
                        scriptname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Rename<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, scriptname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScript_Impl::Rename(this, core::mem::transmute(&scriptname)).into()
            }
        }
        unsafe extern "system" fn Populate<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contentstream: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScript_Impl::Populate(this, core::mem::transmute_copy(&contentstream)).into()
            }
        }
        unsafe extern "system" fn Execute<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScript_Impl::Execute(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn Unlink<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScript_Impl::Unlink(this).into()
            }
        }
        unsafe extern "system" fn IsInvocable<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, isinvocable: *mut bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScript_Impl::IsInvocable(this) {
                    Ok(ok__) => {
                        isinvocable.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn InvokeMain<Identity: IDataModelScript_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScript_Impl::InvokeMain(this, core::mem::transmute_copy(&client)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetName: GetName::<Identity, OFFSET>,
            Rename: Rename::<Identity, OFFSET>,
            Populate: Populate::<Identity, OFFSET>,
            Execute: Execute::<Identity, OFFSET>,
            Unlink: Unlink::<Identity, OFFSET>,
            IsInvocable: IsInvocable::<Identity, OFFSET>,
            InvokeMain: InvokeMain::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScript as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IDataModelScript {}
windows_core::imp::define_interface!(IDataModelScriptClient, IDataModelScriptClient_Vtbl, 0x3b362b0e_89f0_46c6_a663_dfdc95194aef);
windows_core::imp::interface_hierarchy!(IDataModelScriptClient, windows_core::IUnknown);
impl IDataModelScriptClient {
    pub unsafe fn ReportError<P2>(&self, errclass: ErrorClass, hrfail: windows_core::HRESULT, message: P2, line: u32, position: u32) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).ReportError)(windows_core::Interface::as_raw(self), errclass, hrfail, message.param().abi(), line, position).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ReportError: unsafe extern "system" fn(*mut core::ffi::c_void, ErrorClass, windows_core::HRESULT, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
}
pub trait IDataModelScriptClient_Impl: windows_core::IUnknownImpl {
    fn ReportError(&self, errclass: ErrorClass, hrfail: windows_core::HRESULT, message: &windows_core::PCWSTR, line: u32, position: u32) -> windows_core::Result<()>;
}
impl IDataModelScriptClient_Vtbl {
    pub const fn new<Identity: IDataModelScriptClient_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ReportError<Identity: IDataModelScriptClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, errclass: ErrorClass, hrfail: windows_core::HRESULT, message: windows_core::PCWSTR, line: u32, position: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptClient_Impl::ReportError(this, core::mem::transmute_copy(&errclass), core::mem::transmute_copy(&hrfail), core::mem::transmute(&message), core::mem::transmute_copy(&line), core::mem::transmute_copy(&position)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), ReportError: ReportError::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptClient as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptClient {}
windows_core::imp::define_interface!(IDataModelScriptDebug, IDataModelScriptDebug_Vtbl, 0xde8e0945_9750_4471_ab76_a8f79d6ec350);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebug, windows_core::IUnknown);
impl IDataModelScriptDebug {
    pub unsafe fn GetDebugState(&self) -> ScriptDebugState {
        unsafe { (windows_core::Interface::vtable(self).GetDebugState)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentPosition)(windows_core::Interface::as_raw(self), currentposition as _, positionspanend.unwrap_or(core::mem::zeroed()) as _, linetext.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetStack(&self) -> windows_core::Result<IDataModelScriptDebugStack> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStack)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SetBreakpoint)(windows_core::Interface::as_raw(self), lineposition, columnposition, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn FindBreakpointById(&self, breakpointid: u64) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).FindBreakpointById)(windows_core::Interface::as_raw(self), breakpointid, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateBreakpoints(&self) -> windows_core::Result<IDataModelScriptDebugBreakpointEnumerator> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateBreakpoints)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> windows_core::Result<bool> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventFilter)(windows_core::Interface::as_raw(self), eventfilter, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEventFilter)(windows_core::Interface::as_raw(self), eventfilter, isbreakenabled).ok() }
    }
    pub unsafe fn StartDebugging<P0>(&self, debugclient: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartDebugging)(windows_core::Interface::as_raw(self), debugclient.param().abi()).ok() }
    }
    pub unsafe fn StopDebugging<P0>(&self, debugclient: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).StopDebugging)(windows_core::Interface::as_raw(self), debugclient.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDebugState: unsafe extern "system" fn(*mut core::ffi::c_void) -> ScriptDebugState,
    pub GetCurrentPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetStack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetBreakpoint: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindBreakpointById: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateBreakpoints: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetEventFilter: unsafe extern "system" fn(*mut core::ffi::c_void, ScriptDebugEventFilter, *mut bool) -> windows_core::HRESULT,
    pub SetEventFilter: unsafe extern "system" fn(*mut core::ffi::c_void, ScriptDebugEventFilter, u8) -> windows_core::HRESULT,
    pub StartDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub StopDebugging: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebug_Impl: windows_core::IUnknownImpl {
    fn GetDebugState(&self) -> ScriptDebugState;
    fn GetCurrentPosition(&self, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn GetStack(&self) -> windows_core::Result<IDataModelScriptDebugStack>;
    fn SetBreakpoint(&self, lineposition: u32, columnposition: u32) -> windows_core::Result<IDataModelScriptDebugBreakpoint>;
    fn FindBreakpointById(&self, breakpointid: u64) -> windows_core::Result<IDataModelScriptDebugBreakpoint>;
    fn EnumerateBreakpoints(&self) -> windows_core::Result<IDataModelScriptDebugBreakpointEnumerator>;
    fn GetEventFilter(&self, eventfilter: ScriptDebugEventFilter) -> windows_core::Result<bool>;
    fn SetEventFilter(&self, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> windows_core::Result<()>;
    fn StartDebugging(&self, debugclient: windows_core::Ref<'_, IDataModelScriptDebugClient>) -> windows_core::Result<()>;
    fn StopDebugging(&self, debugclient: windows_core::Ref<'_, IDataModelScriptDebugClient>) -> windows_core::Result<()>;
}
impl IDataModelScriptDebug_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDebugState<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> ScriptDebugState {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebug_Impl::GetDebugState(this)
            }
        }
        unsafe extern "system" fn GetCurrentPosition<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, currentposition: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebug_Impl::GetCurrentPosition(this, core::mem::transmute_copy(&currentposition), core::mem::transmute_copy(&positionspanend), core::mem::transmute_copy(&linetext)).into()
            }
        }
        unsafe extern "system" fn GetStack<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, stack: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug_Impl::GetStack(this) {
                    Ok(ok__) => {
                        stack.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBreakpoint<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lineposition: u32, columnposition: u32, breakpoint: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug_Impl::SetBreakpoint(this, core::mem::transmute_copy(&lineposition), core::mem::transmute_copy(&columnposition)) {
                    Ok(ok__) => {
                        breakpoint.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn FindBreakpointById<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breakpointid: u64, breakpoint: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug_Impl::FindBreakpointById(this, core::mem::transmute_copy(&breakpointid)) {
                    Ok(ok__) => {
                        breakpoint.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateBreakpoints<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breakpointenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug_Impl::EnumerateBreakpoints(this) {
                    Ok(ok__) => {
                        breakpointenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetEventFilter<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eventfilter: ScriptDebugEventFilter, isbreakenabled: *mut bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug_Impl::GetEventFilter(this, core::mem::transmute_copy(&eventfilter)) {
                    Ok(ok__) => {
                        isbreakenabled.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventFilter<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eventfilter: ScriptDebugEventFilter, isbreakenabled: u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebug_Impl::SetEventFilter(this, core::mem::transmute_copy(&eventfilter), core::mem::transmute_copy(&isbreakenabled)).into()
            }
        }
        unsafe extern "system" fn StartDebugging<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, debugclient: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebug_Impl::StartDebugging(this, core::mem::transmute_copy(&debugclient)).into()
            }
        }
        unsafe extern "system" fn StopDebugging<Identity: IDataModelScriptDebug_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, debugclient: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebug_Impl::StopDebugging(this, core::mem::transmute_copy(&debugclient)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDebugState: GetDebugState::<Identity, OFFSET>,
            GetCurrentPosition: GetCurrentPosition::<Identity, OFFSET>,
            GetStack: GetStack::<Identity, OFFSET>,
            SetBreakpoint: SetBreakpoint::<Identity, OFFSET>,
            FindBreakpointById: FindBreakpointById::<Identity, OFFSET>,
            EnumerateBreakpoints: EnumerateBreakpoints::<Identity, OFFSET>,
            GetEventFilter: GetEventFilter::<Identity, OFFSET>,
            SetEventFilter: SetEventFilter::<Identity, OFFSET>,
            StartDebugging: StartDebugging::<Identity, OFFSET>,
            StopDebugging: StopDebugging::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebug as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebug {}
windows_core::imp::define_interface!(IDataModelScriptDebug2, IDataModelScriptDebug2_Vtbl, 0xcbb10ed3_839e_426c_9243_e23535c1ae1a);
impl core::ops::Deref for IDataModelScriptDebug2 {
    type Target = IDataModelScriptDebug;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IDataModelScriptDebug2, windows_core::IUnknown, IDataModelScriptDebug);
impl IDataModelScriptDebug2 {
    pub unsafe fn SetBreakpointAtFunction<P0>(&self, functionname: P0) -> windows_core::Result<IDataModelScriptDebugBreakpoint>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SetBreakpointAtFunction)(windows_core::Interface::as_raw(self), functionname.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebug2_Vtbl {
    pub base__: IDataModelScriptDebug_Vtbl,
    pub SetBreakpointAtFunction: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebug2_Impl: IDataModelScriptDebug_Impl {
    fn SetBreakpointAtFunction(&self, functionname: &windows_core::PCWSTR) -> windows_core::Result<IDataModelScriptDebugBreakpoint>;
}
impl IDataModelScriptDebug2_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebug2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetBreakpointAtFunction<Identity: IDataModelScriptDebug2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, functionname: windows_core::PCWSTR, breakpoint: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebug2_Impl::SetBreakpointAtFunction(this, core::mem::transmute(&functionname)) {
                    Ok(ok__) => {
                        breakpoint.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IDataModelScriptDebug_Vtbl::new::<Identity, OFFSET>(), SetBreakpointAtFunction: SetBreakpointAtFunction::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebug2 as windows_core::Interface>::IID || iid == &<IDataModelScriptDebug as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebug2 {}
windows_core::imp::define_interface!(IDataModelScriptDebugBreakpoint, IDataModelScriptDebugBreakpoint_Vtbl, 0x6bb27b35_02e6_47cb_90a0_5371244032de);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugBreakpoint, windows_core::IUnknown);
impl IDataModelScriptDebugBreakpoint {
    pub unsafe fn GetId(&self) -> u64 {
        unsafe { (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn IsEnabled(&self) -> bool {
        unsafe { (windows_core::Interface::vtable(self).IsEnabled)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn Enable(&self) {
        unsafe { (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn Disable(&self) {
        unsafe { (windows_core::Interface::vtable(self).Disable)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn Remove(&self) {
        unsafe { (windows_core::Interface::vtable(self).Remove)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPosition)(windows_core::Interface::as_raw(self), position as _, positionspanend.unwrap_or(core::mem::zeroed()) as _, linetext.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpoint_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void) -> u64,
    pub IsEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> bool,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub Disable: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub Remove: unsafe extern "system" fn(*mut core::ffi::c_void),
    pub GetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugBreakpoint_Impl: windows_core::IUnknownImpl {
    fn GetId(&self) -> u64;
    fn IsEnabled(&self) -> bool;
    fn Enable(&self);
    fn Disable(&self);
    fn Remove(&self);
    fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut windows_core::BSTR) -> windows_core::Result<()>;
}
impl IDataModelScriptDebugBreakpoint_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetId<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u64 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::GetId(this)
            }
        }
        unsafe extern "system" fn IsEnabled<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> bool {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::IsEnabled(this)
            }
        }
        unsafe extern "system" fn Enable<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::Enable(this)
            }
        }
        unsafe extern "system" fn Disable<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::Disable(this)
            }
        }
        unsafe extern "system" fn Remove<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::Remove(this)
            }
        }
        unsafe extern "system" fn GetPosition<Identity: IDataModelScriptDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpoint_Impl::GetPosition(this, core::mem::transmute_copy(&position), core::mem::transmute_copy(&positionspanend), core::mem::transmute_copy(&linetext)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetId: GetId::<Identity, OFFSET>,
            IsEnabled: IsEnabled::<Identity, OFFSET>,
            Enable: Enable::<Identity, OFFSET>,
            Disable: Disable::<Identity, OFFSET>,
            Remove: Remove::<Identity, OFFSET>,
            GetPosition: GetPosition::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugBreakpoint as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugBreakpoint {}
windows_core::imp::define_interface!(IDataModelScriptDebugBreakpointEnumerator, IDataModelScriptDebugBreakpointEnumerator_Vtbl, 0x39484a75_b4f3_4799_86da_691afa57b299);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugBreakpointEnumerator, windows_core::IUnknown);
impl IDataModelScriptDebugBreakpointEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptDebugBreakpoint> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugBreakpointEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugBreakpointEnumerator_Impl: windows_core::IUnknownImpl {
    fn Reset(&self) -> windows_core::Result<()>;
    fn GetNext(&self) -> windows_core::Result<IDataModelScriptDebugBreakpoint>;
}
impl IDataModelScriptDebugBreakpointEnumerator_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugBreakpointEnumerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reset<Identity: IDataModelScriptDebugBreakpointEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugBreakpointEnumerator_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn GetNext<Identity: IDataModelScriptDebugBreakpointEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breakpoint: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugBreakpointEnumerator_Impl::GetNext(this) {
                    Ok(ok__) => {
                        breakpoint.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Reset: Reset::<Identity, OFFSET>, GetNext: GetNext::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugBreakpointEnumerator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugBreakpointEnumerator {}
windows_core::imp::define_interface!(IDataModelScriptDebugClient, IDataModelScriptDebugClient_Vtbl, 0x53159b6d_d4c4_471b_a863_5b110ca800ca);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugClient, windows_core::IUnknown);
impl IDataModelScriptDebugClient {
    pub unsafe fn NotifyDebugEvent<P1, P2>(&self, peventinfo: *const ScriptDebugEventInformation, pscript: P1, peventdataobject: P2, resumeeventkind: *mut ScriptExecutionKind) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IDataModelScript>,
        P2: windows_core::Param<IModelObject>,
    {
        unsafe { (windows_core::Interface::vtable(self).NotifyDebugEvent)(windows_core::Interface::as_raw(self), peventinfo, pscript.param().abi(), peventdataobject.param().abi(), resumeeventkind as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub NotifyDebugEvent: unsafe extern "system" fn(*mut core::ffi::c_void, *const ScriptDebugEventInformation, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut ScriptExecutionKind) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugClient_Impl: windows_core::IUnknownImpl {
    fn NotifyDebugEvent(&self, peventinfo: *const ScriptDebugEventInformation, pscript: windows_core::Ref<'_, IDataModelScript>, peventdataobject: windows_core::Ref<'_, IModelObject>, resumeeventkind: *mut ScriptExecutionKind) -> windows_core::Result<()>;
}
impl IDataModelScriptDebugClient_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugClient_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn NotifyDebugEvent<Identity: IDataModelScriptDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, peventinfo: *const ScriptDebugEventInformation, pscript: *mut core::ffi::c_void, peventdataobject: *mut core::ffi::c_void, resumeeventkind: *mut ScriptExecutionKind) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugClient_Impl::NotifyDebugEvent(this, core::mem::transmute_copy(&peventinfo), core::mem::transmute_copy(&pscript), core::mem::transmute_copy(&peventdataobject), core::mem::transmute_copy(&resumeeventkind)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), NotifyDebugEvent: NotifyDebugEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugClient as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugClient {}
windows_core::imp::define_interface!(IDataModelScriptDebugStack, IDataModelScriptDebugStack_Vtbl, 0x051364dd_e449_443e_9762_fe578f4a5473);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugStack, windows_core::IUnknown);
impl IDataModelScriptDebugStack {
    pub unsafe fn GetFrameCount(&self) -> u64 {
        unsafe { (windows_core::Interface::vtable(self).GetFrameCount)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetStackFrame(&self, framenumber: u64) -> windows_core::Result<IDataModelScriptDebugStackFrame> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStackFrame)(windows_core::Interface::as_raw(self), framenumber, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStack_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFrameCount: unsafe extern "system" fn(*mut core::ffi::c_void) -> u64,
    pub GetStackFrame: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugStack_Impl: windows_core::IUnknownImpl {
    fn GetFrameCount(&self) -> u64;
    fn GetStackFrame(&self, framenumber: u64) -> windows_core::Result<IDataModelScriptDebugStackFrame>;
}
impl IDataModelScriptDebugStack_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugStack_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFrameCount<Identity: IDataModelScriptDebugStack_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u64 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugStack_Impl::GetFrameCount(this)
            }
        }
        unsafe extern "system" fn GetStackFrame<Identity: IDataModelScriptDebugStack_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, framenumber: u64, stackframe: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStack_Impl::GetStackFrame(this, core::mem::transmute_copy(&framenumber)) {
                    Ok(ok__) => {
                        stackframe.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetFrameCount: GetFrameCount::<Identity, OFFSET>,
            GetStackFrame: GetStackFrame::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugStack as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugStack {}
windows_core::imp::define_interface!(IDataModelScriptDebugStackFrame, IDataModelScriptDebugStackFrame_Vtbl, 0xdec6ed5e_6360_4941_ab4c_a26409de4f82);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugStackFrame, windows_core::IUnknown);
impl IDataModelScriptDebugStackFrame {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: Option<*mut ScriptDebugPosition>, linetext: Option<*mut windows_core::BSTR>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPosition)(windows_core::Interface::as_raw(self), position as _, positionspanend.unwrap_or(core::mem::zeroed()) as _, linetext.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn IsTransitionPoint(&self) -> windows_core::Result<bool> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).IsTransitionPoint)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransition(&self, transitionscript: *mut Option<IDataModelScript>, istransitioncontiguous: *mut bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTransition)(windows_core::Interface::as_raw(self), core::mem::transmute(transitionscript), istransitioncontiguous as _).ok() }
    }
    pub unsafe fn Evaluate<P0>(&self, pwszexpression: P0) -> windows_core::Result<IModelObject>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Evaluate)(windows_core::Interface::as_raw(self), pwszexpression.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateLocals(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateLocals)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateArguments(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateArguments)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugStackFrame_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetPosition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ScriptDebugPosition, *mut ScriptDebugPosition, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub IsTransitionPoint: unsafe extern "system" fn(*mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub GetTransition: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut bool) -> windows_core::HRESULT,
    pub Evaluate: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateLocals: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateArguments: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugStackFrame_Impl: windows_core::IUnknownImpl {
    fn GetName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetPosition(&self, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn IsTransitionPoint(&self) -> windows_core::Result<bool>;
    fn GetTransition(&self, transitionscript: windows_core::OutRef<'_, IDataModelScript>, istransitioncontiguous: *mut bool) -> windows_core::Result<()>;
    fn Evaluate(&self, pwszexpression: &windows_core::PCWSTR) -> windows_core::Result<IModelObject>;
    fn EnumerateLocals(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator>;
    fn EnumerateArguments(&self) -> windows_core::Result<IDataModelScriptDebugVariableSetEnumerator>;
}
impl IDataModelScriptDebugStackFrame_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetName<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, name: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStackFrame_Impl::GetName(this) {
                    Ok(ok__) => {
                        name.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPosition<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, position: *mut ScriptDebugPosition, positionspanend: *mut ScriptDebugPosition, linetext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugStackFrame_Impl::GetPosition(this, core::mem::transmute_copy(&position), core::mem::transmute_copy(&positionspanend), core::mem::transmute_copy(&linetext)).into()
            }
        }
        unsafe extern "system" fn IsTransitionPoint<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, istransitionpoint: *mut bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStackFrame_Impl::IsTransitionPoint(this) {
                    Ok(ok__) => {
                        istransitionpoint.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransition<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, transitionscript: *mut *mut core::ffi::c_void, istransitioncontiguous: *mut bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugStackFrame_Impl::GetTransition(this, core::mem::transmute_copy(&transitionscript), core::mem::transmute_copy(&istransitioncontiguous)).into()
            }
        }
        unsafe extern "system" fn Evaluate<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwszexpression: windows_core::PCWSTR, ppresult: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStackFrame_Impl::Evaluate(this, core::mem::transmute(&pwszexpression)) {
                    Ok(ok__) => {
                        ppresult.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateLocals<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, variablesenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStackFrame_Impl::EnumerateLocals(this) {
                    Ok(ok__) => {
                        variablesenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateArguments<Identity: IDataModelScriptDebugStackFrame_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, variablesenum: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptDebugStackFrame_Impl::EnumerateArguments(this) {
                    Ok(ok__) => {
                        variablesenum.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetName: GetName::<Identity, OFFSET>,
            GetPosition: GetPosition::<Identity, OFFSET>,
            IsTransitionPoint: IsTransitionPoint::<Identity, OFFSET>,
            GetTransition: GetTransition::<Identity, OFFSET>,
            Evaluate: Evaluate::<Identity, OFFSET>,
            EnumerateLocals: EnumerateLocals::<Identity, OFFSET>,
            EnumerateArguments: EnumerateArguments::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugStackFrame as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugStackFrame {}
windows_core::imp::define_interface!(IDataModelScriptDebugVariableSetEnumerator, IDataModelScriptDebugVariableSetEnumerator_Vtbl, 0x0f9feed7_d045_4ac3_98a8_a98942cf6a35);
windows_core::imp::interface_hierarchy!(IDataModelScriptDebugVariableSetEnumerator, windows_core::IUnknown);
impl IDataModelScriptDebugVariableSetEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetNext(&self, variablename: *mut windows_core::BSTR, variablevalue: Option<*mut Option<IModelObject>>, variablemetadata: Option<*mut Option<IKeyStore>>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), core::mem::transmute(variablename), variablevalue.unwrap_or(core::mem::zeroed()) as _, variablemetadata.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptDebugVariableSetEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptDebugVariableSetEnumerator_Impl: windows_core::IUnknownImpl {
    fn Reset(&self) -> windows_core::Result<()>;
    fn GetNext(&self, variablename: *mut windows_core::BSTR, variablevalue: windows_core::OutRef<'_, IModelObject>, variablemetadata: windows_core::OutRef<'_, IKeyStore>) -> windows_core::Result<()>;
}
impl IDataModelScriptDebugVariableSetEnumerator_Vtbl {
    pub const fn new<Identity: IDataModelScriptDebugVariableSetEnumerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reset<Identity: IDataModelScriptDebugVariableSetEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugVariableSetEnumerator_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn GetNext<Identity: IDataModelScriptDebugVariableSetEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, variablename: *mut *mut core::ffi::c_void, variablevalue: *mut *mut core::ffi::c_void, variablemetadata: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptDebugVariableSetEnumerator_Impl::GetNext(this, core::mem::transmute_copy(&variablename), core::mem::transmute_copy(&variablevalue), core::mem::transmute_copy(&variablemetadata)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Reset: Reset::<Identity, OFFSET>, GetNext: GetNext::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptDebugVariableSetEnumerator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptDebugVariableSetEnumerator {}
windows_core::imp::define_interface!(IDataModelScriptHostContext, IDataModelScriptHostContext_Vtbl, 0x014d366a_1f23_4981_9219_b2db8b402054);
windows_core::imp::interface_hierarchy!(IDataModelScriptHostContext, windows_core::IUnknown);
impl IDataModelScriptHostContext {
    pub unsafe fn NotifyScriptChange<P0>(&self, script: P0, changekind: ScriptChangeKind) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScript>,
    {
        unsafe { (windows_core::Interface::vtable(self).NotifyScriptChange)(windows_core::Interface::as_raw(self), script.param().abi(), changekind).ok() }
    }
    pub unsafe fn GetNamespaceObject(&self) -> windows_core::Result<IModelObject> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNamespaceObject)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptHostContext_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub NotifyScriptChange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, ScriptChangeKind) -> windows_core::HRESULT,
    pub GetNamespaceObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptHostContext_Impl: windows_core::IUnknownImpl {
    fn NotifyScriptChange(&self, script: windows_core::Ref<'_, IDataModelScript>, changekind: ScriptChangeKind) -> windows_core::Result<()>;
    fn GetNamespaceObject(&self) -> windows_core::Result<IModelObject>;
}
impl IDataModelScriptHostContext_Vtbl {
    pub const fn new<Identity: IDataModelScriptHostContext_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn NotifyScriptChange<Identity: IDataModelScriptHostContext_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, script: *mut core::ffi::c_void, changekind: ScriptChangeKind) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptHostContext_Impl::NotifyScriptChange(this, core::mem::transmute_copy(&script), core::mem::transmute_copy(&changekind)).into()
            }
        }
        unsafe extern "system" fn GetNamespaceObject<Identity: IDataModelScriptHostContext_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, namespaceobject: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptHostContext_Impl::GetNamespaceObject(this) {
                    Ok(ok__) => {
                        namespaceobject.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            NotifyScriptChange: NotifyScriptChange::<Identity, OFFSET>,
            GetNamespaceObject: GetNamespaceObject::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptHostContext as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptHostContext {}
windows_core::imp::define_interface!(IDataModelScriptManager, IDataModelScriptManager_Vtbl, 0x6fd11e33_e5ad_410b_8011_68c6bc4bf80d);
windows_core::imp::interface_hierarchy!(IDataModelScriptManager, windows_core::IUnknown);
impl IDataModelScriptManager {
    pub unsafe fn GetDefaultNameBinder(&self) -> windows_core::Result<IDataModelNameBinder> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDefaultNameBinder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn RegisterScriptProvider<P0>(&self, provider: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptProvider>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterScriptProvider)(windows_core::Interface::as_raw(self), provider.param().abi()).ok() }
    }
    pub unsafe fn UnregisterScriptProvider<P0>(&self, provider: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDataModelScriptProvider>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnregisterScriptProvider)(windows_core::Interface::as_raw(self), provider.param().abi()).ok() }
    }
    pub unsafe fn FindProviderForScriptType<P0>(&self, scripttype: P0) -> windows_core::Result<IDataModelScriptProvider>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).FindProviderForScriptType)(windows_core::Interface::as_raw(self), scripttype.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn FindProviderForScriptExtension<P0>(&self, scriptextension: P0) -> windows_core::Result<IDataModelScriptProvider>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).FindProviderForScriptExtension)(windows_core::Interface::as_raw(self), scriptextension.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateScriptProviders(&self) -> windows_core::Result<IDataModelScriptProviderEnumerator> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateScriptProviders)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptManager_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDefaultNameBinder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RegisterScriptProvider: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub UnregisterScriptProvider: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindProviderForScriptType: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindProviderForScriptExtension: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateScriptProviders: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptManager_Impl: windows_core::IUnknownImpl {
    fn GetDefaultNameBinder(&self) -> windows_core::Result<IDataModelNameBinder>;
    fn RegisterScriptProvider(&self, provider: windows_core::Ref<'_, IDataModelScriptProvider>) -> windows_core::Result<()>;
    fn UnregisterScriptProvider(&self, provider: windows_core::Ref<'_, IDataModelScriptProvider>) -> windows_core::Result<()>;
    fn FindProviderForScriptType(&self, scripttype: &windows_core::PCWSTR) -> windows_core::Result<IDataModelScriptProvider>;
    fn FindProviderForScriptExtension(&self, scriptextension: &windows_core::PCWSTR) -> windows_core::Result<IDataModelScriptProvider>;
    fn EnumerateScriptProviders(&self) -> windows_core::Result<IDataModelScriptProviderEnumerator>;
}
impl IDataModelScriptManager_Vtbl {
    pub const fn new<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDefaultNameBinder<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppnamebinder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptManager_Impl::GetDefaultNameBinder(this) {
                    Ok(ok__) => {
                        ppnamebinder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterScriptProvider<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, provider: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptManager_Impl::RegisterScriptProvider(this, core::mem::transmute_copy(&provider)).into()
            }
        }
        unsafe extern "system" fn UnregisterScriptProvider<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, provider: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptManager_Impl::UnregisterScriptProvider(this, core::mem::transmute_copy(&provider)).into()
            }
        }
        unsafe extern "system" fn FindProviderForScriptType<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, scripttype: windows_core::PCWSTR, provider: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptManager_Impl::FindProviderForScriptType(this, core::mem::transmute(&scripttype)) {
                    Ok(ok__) => {
                        provider.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn FindProviderForScriptExtension<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, scriptextension: windows_core::PCWSTR, provider: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptManager_Impl::FindProviderForScriptExtension(this, core::mem::transmute(&scriptextension)) {
                    Ok(ok__) => {
                        provider.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateScriptProviders<Identity: IDataModelScriptManager_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enumerator: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptManager_Impl::EnumerateScriptProviders(this) {
                    Ok(ok__) => {
                        enumerator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDefaultNameBinder: GetDefaultNameBinder::<Identity, OFFSET>,
            RegisterScriptProvider: RegisterScriptProvider::<Identity, OFFSET>,
            UnregisterScriptProvider: UnregisterScriptProvider::<Identity, OFFSET>,
            FindProviderForScriptType: FindProviderForScriptType::<Identity, OFFSET>,
            FindProviderForScriptExtension: FindProviderForScriptExtension::<Identity, OFFSET>,
            EnumerateScriptProviders: EnumerateScriptProviders::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptManager as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptManager {}
windows_core::imp::define_interface!(IDataModelScriptProvider, IDataModelScriptProvider_Vtbl, 0x513461e0_4fca_48ce_8658_32f3e2056f3b);
windows_core::imp::interface_hierarchy!(IDataModelScriptProvider, windows_core::IUnknown);
impl IDataModelScriptProvider {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetExtension(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExtension)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn CreateScript(&self) -> windows_core::Result<IDataModelScript> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateScript)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetDefaultTemplateContent(&self) -> windows_core::Result<IDataModelScriptTemplate> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDefaultTemplateContent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn EnumerateTemplates(&self) -> windows_core::Result<IDataModelScriptTemplateEnumerator> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumerateTemplates)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetExtension: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateScript: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDefaultTemplateContent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EnumerateTemplates: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptProvider_Impl: windows_core::IUnknownImpl {
    fn GetName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetExtension(&self) -> windows_core::Result<windows_core::BSTR>;
    fn CreateScript(&self) -> windows_core::Result<IDataModelScript>;
    fn GetDefaultTemplateContent(&self) -> windows_core::Result<IDataModelScriptTemplate>;
    fn EnumerateTemplates(&self) -> windows_core::Result<IDataModelScriptTemplateEnumerator>;
}
impl IDataModelScriptProvider_Vtbl {
    pub const fn new<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetName<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, name: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProvider_Impl::GetName(this) {
                    Ok(ok__) => {
                        name.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetExtension<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, extension: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProvider_Impl::GetExtension(this) {
                    Ok(ok__) => {
                        extension.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateScript<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, script: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProvider_Impl::CreateScript(this) {
                    Ok(ok__) => {
                        script.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDefaultTemplateContent<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, templatecontent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProvider_Impl::GetDefaultTemplateContent(this) {
                    Ok(ok__) => {
                        templatecontent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumerateTemplates<Identity: IDataModelScriptProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enumerator: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProvider_Impl::EnumerateTemplates(this) {
                    Ok(ok__) => {
                        enumerator.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetName: GetName::<Identity, OFFSET>,
            GetExtension: GetExtension::<Identity, OFFSET>,
            CreateScript: CreateScript::<Identity, OFFSET>,
            GetDefaultTemplateContent: GetDefaultTemplateContent::<Identity, OFFSET>,
            EnumerateTemplates: EnumerateTemplates::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptProvider {}
windows_core::imp::define_interface!(IDataModelScriptProviderEnumerator, IDataModelScriptProviderEnumerator_Vtbl, 0x95ba00e2_704a_4fe2_a8f1_a7e7d8fb0941);
windows_core::imp::interface_hierarchy!(IDataModelScriptProviderEnumerator, windows_core::IUnknown);
impl IDataModelScriptProviderEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptProvider> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptProviderEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptProviderEnumerator_Impl: windows_core::IUnknownImpl {
    fn Reset(&self) -> windows_core::Result<()>;
    fn GetNext(&self) -> windows_core::Result<IDataModelScriptProvider>;
}
impl IDataModelScriptProviderEnumerator_Vtbl {
    pub const fn new<Identity: IDataModelScriptProviderEnumerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reset<Identity: IDataModelScriptProviderEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptProviderEnumerator_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn GetNext<Identity: IDataModelScriptProviderEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, provider: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptProviderEnumerator_Impl::GetNext(this) {
                    Ok(ok__) => {
                        provider.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Reset: Reset::<Identity, OFFSET>, GetNext: GetNext::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptProviderEnumerator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptProviderEnumerator {}
windows_core::imp::define_interface!(IDataModelScriptTemplate, IDataModelScriptTemplate_Vtbl, 0x1303dec4_fa3b_4f1b_9224_b953d16babb5);
windows_core::imp::interface_hierarchy!(IDataModelScriptTemplate, windows_core::IUnknown);
impl IDataModelScriptTemplate {
    pub unsafe fn GetName(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetName)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetDescription(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDescription)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetContent(&self) -> windows_core::Result<super::super::super::Com::IStream> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetContent)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplate_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetContent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetContent: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IDataModelScriptTemplate_Impl: windows_core::IUnknownImpl {
    fn GetName(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetDescription(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetContent(&self) -> windows_core::Result<super::super::super::Com::IStream>;
}
#[cfg(feature = "Win32_System_Com")]
impl IDataModelScriptTemplate_Vtbl {
    pub const fn new<Identity: IDataModelScriptTemplate_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetName<Identity: IDataModelScriptTemplate_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, templatename: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptTemplate_Impl::GetName(this) {
                    Ok(ok__) => {
                        templatename.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDescription<Identity: IDataModelScriptTemplate_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, templatedescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptTemplate_Impl::GetDescription(this) {
                    Ok(ok__) => {
                        templatedescription.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetContent<Identity: IDataModelScriptTemplate_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, contentstream: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptTemplate_Impl::GetContent(this) {
                    Ok(ok__) => {
                        contentstream.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetName: GetName::<Identity, OFFSET>,
            GetDescription: GetDescription::<Identity, OFFSET>,
            GetContent: GetContent::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptTemplate as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IDataModelScriptTemplate {}
windows_core::imp::define_interface!(IDataModelScriptTemplateEnumerator, IDataModelScriptTemplateEnumerator_Vtbl, 0x69ce6ae2_2268_4e6f_b062_20ce62bfe677);
windows_core::imp::interface_hierarchy!(IDataModelScriptTemplateEnumerator, windows_core::IUnknown);
impl IDataModelScriptTemplateEnumerator {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetNext(&self) -> windows_core::Result<IDataModelScriptTemplate> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNext)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDataModelScriptTemplateEnumerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDataModelScriptTemplateEnumerator_Impl: windows_core::IUnknownImpl {
    fn Reset(&self) -> windows_core::Result<()>;
    fn GetNext(&self) -> windows_core::Result<IDataModelScriptTemplate>;
}
impl IDataModelScriptTemplateEnumerator_Vtbl {
    pub const fn new<Identity: IDataModelScriptTemplateEnumerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reset<Identity: IDataModelScriptTemplateEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDataModelScriptTemplateEnumerator_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn GetNext<Identity: IDataModelScriptTemplateEnumerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, templatecontent: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDataModelScriptTemplateEnumerator_Impl::GetNext(this) {
                    Ok(ok__) => {
                        templatecontent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Reset: Reset::<Identity, OFFSET>, GetNext: GetNext::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDataModelScriptTemplateEnumerator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDataModelScriptTemplateEnumerator {}
windows_core::imp::define_interface!(IDebugAdvanced, IDebugAdvanced_Vtbl, 0xf2df5f53_071f_47bd_9de6_5734c3fed689);
windows_core::imp::interface_hierarchy!(IDebugAdvanced, windows_core::IUnknown);
impl IDebugAdvanced {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context as _, contextsize).ok() }
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IDebugAdvanced_Impl: windows_core::IUnknownImpl {
    fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
}
impl IDebugAdvanced_Vtbl {
    pub const fn new<Identity: IDebugAdvanced_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetThreadContext<Identity: IDebugAdvanced_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced_Impl::GetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn SetThreadContext<Identity: IDebugAdvanced_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced_Impl::SetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetThreadContext: GetThreadContext::<Identity, OFFSET>,
            SetThreadContext: SetThreadContext::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugAdvanced as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugAdvanced {}
windows_core::imp::define_interface!(IDebugAdvanced2, IDebugAdvanced2_Vtbl, 0x716d14c9_119b_4ba5_af1f_0890e672416a);
windows_core::imp::interface_hierarchy!(IDebugAdvanced2, windows_core::IUnknown);
impl IDebugAdvanced2 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context as _, contextsize).ok() }
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok() }
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, inbuffer.unwrap_or(core::mem::zeroed()) as _, inbuffersize, outbuffer.unwrap_or(core::mem::zeroed()) as _, outbuffersize, outsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSourceFileInformation<P1>(&self, which: u32, sourcefile: P1, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn FindSourceFileAndToken<P2>(&self, startelement: u32, modaddr: u64, file: P2, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, filetoken.unwrap_or(core::mem::zeroed()) as _, filetokensize, foundelement.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), foundsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IDebugAdvanced2_Impl: windows_core::IUnknownImpl {
    fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn Request(&self, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::Result<()>;
    fn GetSourceFileInformation(&self, which: u32, sourcefile: &windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn FindSourceFileAndToken(&self, startelement: u32, modaddr: u64, file: &windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
}
impl IDebugAdvanced2_Vtbl {
    pub const fn new<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetThreadContext<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::GetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn SetThreadContext<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::SetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn Request<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::Request(this, core::mem::transmute_copy(&request), core::mem::transmute_copy(&inbuffer), core::mem::transmute_copy(&inbuffersize), core::mem::transmute_copy(&outbuffer), core::mem::transmute_copy(&outbuffersize), core::mem::transmute_copy(&outsize)).into()
            }
        }
        unsafe extern "system" fn GetSourceFileInformation<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, sourcefile: windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::GetSourceFileInformation(this, core::mem::transmute_copy(&which), core::mem::transmute(&sourcefile), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn FindSourceFileAndToken<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, startelement: u32, modaddr: u64, file: windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::FindSourceFileAndToken(this, core::mem::transmute_copy(&startelement), core::mem::transmute_copy(&modaddr), core::mem::transmute(&file), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&filetoken), core::mem::transmute_copy(&filetokensize), core::mem::transmute_copy(&foundelement), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&foundsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformation<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::GetSymbolInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn GetSystemObjectInformation<Identity: IDebugAdvanced2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced2_Impl::GetSystemObjectInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetThreadContext: GetThreadContext::<Identity, OFFSET>,
            SetThreadContext: SetThreadContext::<Identity, OFFSET>,
            Request: Request::<Identity, OFFSET>,
            GetSourceFileInformation: GetSourceFileInformation::<Identity, OFFSET>,
            FindSourceFileAndToken: FindSourceFileAndToken::<Identity, OFFSET>,
            GetSymbolInformation: GetSymbolInformation::<Identity, OFFSET>,
            GetSystemObjectInformation: GetSystemObjectInformation::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugAdvanced2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugAdvanced2 {}
windows_core::imp::define_interface!(IDebugAdvanced3, IDebugAdvanced3_Vtbl, 0xcba4abb4_84c4_444d_87ca_a04e13286739);
windows_core::imp::interface_hierarchy!(IDebugAdvanced3, windows_core::IUnknown);
impl IDebugAdvanced3 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context as _, contextsize).ok() }
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok() }
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, inbuffer.unwrap_or(core::mem::zeroed()) as _, inbuffersize, outbuffer.unwrap_or(core::mem::zeroed()) as _, outbuffersize, outsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSourceFileInformation<P1>(&self, which: u32, sourcefile: P1, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn FindSourceFileAndToken<P2>(&self, startelement: u32, modaddr: u64, file: P2, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, filetoken.unwrap_or(core::mem::zeroed()) as _, filetokensize, foundelement.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), foundsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSourceFileInformationWide<P1>(&self, which: u32, sourcefile: P1, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSourceFileInformationWide)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn FindSourceFileAndTokenWide<P2>(&self, startelement: u32, modaddr: u64, file: P2, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u16]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindSourceFileAndTokenWide)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, filetoken.unwrap_or(core::mem::zeroed()) as _, filetokensize, foundelement.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), foundsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformationWide)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCWSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IDebugAdvanced3_Impl: windows_core::IUnknownImpl {
    fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn Request(&self, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::Result<()>;
    fn GetSourceFileInformation(&self, which: u32, sourcefile: &windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn FindSourceFileAndToken(&self, startelement: u32, modaddr: u64, file: &windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn GetSourceFileInformationWide(&self, which: u32, sourcefile: &windows_core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn FindSourceFileAndTokenWide(&self, startelement: u32, modaddr: u64, file: &windows_core::PCWSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PWSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
}
impl IDebugAdvanced3_Vtbl {
    pub const fn new<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetThreadContext<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn SetThreadContext<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::SetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn Request<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::Request(this, core::mem::transmute_copy(&request), core::mem::transmute_copy(&inbuffer), core::mem::transmute_copy(&inbuffersize), core::mem::transmute_copy(&outbuffer), core::mem::transmute_copy(&outbuffersize), core::mem::transmute_copy(&outsize)).into()
            }
        }
        unsafe extern "system" fn GetSourceFileInformation<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, sourcefile: windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetSourceFileInformation(this, core::mem::transmute_copy(&which), core::mem::transmute(&sourcefile), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn FindSourceFileAndToken<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, startelement: u32, modaddr: u64, file: windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::FindSourceFileAndToken(this, core::mem::transmute_copy(&startelement), core::mem::transmute_copy(&modaddr), core::mem::transmute(&file), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&filetoken), core::mem::transmute_copy(&filetokensize), core::mem::transmute_copy(&foundelement), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&foundsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformation<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetSymbolInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn GetSystemObjectInformation<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetSystemObjectInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn GetSourceFileInformationWide<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, sourcefile: windows_core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetSourceFileInformationWide(this, core::mem::transmute_copy(&which), core::mem::transmute(&sourcefile), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn FindSourceFileAndTokenWide<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, startelement: u32, modaddr: u64, file: windows_core::PCWSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PWSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::FindSourceFileAndTokenWide(this, core::mem::transmute_copy(&startelement), core::mem::transmute_copy(&modaddr), core::mem::transmute(&file), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&filetoken), core::mem::transmute_copy(&filetokensize), core::mem::transmute_copy(&foundelement), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&foundsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformationWide<Identity: IDebugAdvanced3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced3_Impl::GetSymbolInformationWide(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetThreadContext: GetThreadContext::<Identity, OFFSET>,
            SetThreadContext: SetThreadContext::<Identity, OFFSET>,
            Request: Request::<Identity, OFFSET>,
            GetSourceFileInformation: GetSourceFileInformation::<Identity, OFFSET>,
            FindSourceFileAndToken: FindSourceFileAndToken::<Identity, OFFSET>,
            GetSymbolInformation: GetSymbolInformation::<Identity, OFFSET>,
            GetSystemObjectInformation: GetSystemObjectInformation::<Identity, OFFSET>,
            GetSourceFileInformationWide: GetSourceFileInformationWide::<Identity, OFFSET>,
            FindSourceFileAndTokenWide: FindSourceFileAndTokenWide::<Identity, OFFSET>,
            GetSymbolInformationWide: GetSymbolInformationWide::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugAdvanced3 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugAdvanced3 {}
windows_core::imp::define_interface!(IDebugAdvanced4, IDebugAdvanced4_Vtbl, 0xd1069067_2a65_4bf0_ae97_76184b67856b);
windows_core::imp::interface_hierarchy!(IDebugAdvanced4, windows_core::IUnknown);
impl IDebugAdvanced4 {
    pub unsafe fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetThreadContext)(windows_core::Interface::as_raw(self), context as _, contextsize).ok() }
    }
    pub unsafe fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetThreadContext)(windows_core::Interface::as_raw(self), context, contextsize).ok() }
    }
    pub unsafe fn Request(&self, request: u32, inbuffer: Option<*const core::ffi::c_void>, inbuffersize: u32, outbuffer: Option<*mut core::ffi::c_void>, outbuffersize: u32, outsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), request, inbuffer.unwrap_or(core::mem::zeroed()) as _, inbuffersize, outbuffer.unwrap_or(core::mem::zeroed()) as _, outbuffersize, outsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSourceFileInformation<P1>(&self, which: u32, sourcefile: P1, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSourceFileInformation)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn FindSourceFileAndToken<P2>(&self, startelement: u32, modaddr: u64, file: P2, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u8]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindSourceFileAndToken)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, filetoken.unwrap_or(core::mem::zeroed()) as _, filetokensize, foundelement.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), foundsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSystemObjectInformation)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSourceFileInformationWide<P1>(&self, which: u32, sourcefile: P1, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetSourceFileInformationWide)(windows_core::Interface::as_raw(self), which, sourcefile.param().abi(), arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn FindSourceFileAndTokenWide<P2>(&self, startelement: u32, modaddr: u64, file: P2, flags: u32, filetoken: Option<*const core::ffi::c_void>, filetokensize: u32, foundelement: Option<*mut u32>, buffer: Option<&mut [u16]>, foundsize: Option<*mut u32>) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindSourceFileAndTokenWide)(windows_core::Interface::as_raw(self), startelement, modaddr, file.param().abi(), flags, filetoken.unwrap_or(core::mem::zeroed()) as _, filetokensize, foundelement.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), foundsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformationWide)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetSymbolInformationWideEx(&self, which: u32, arg64: u64, arg32: u32, buffer: Option<*mut core::ffi::c_void>, buffersize: u32, infosize: Option<*mut u32>, stringbuffer: Option<&mut [u16]>, stringsize: Option<*mut u32>, pinfoex: Option<*mut SYMBOL_INFO_EX>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSymbolInformationWideEx)(windows_core::Interface::as_raw(self), which, arg64, arg32, buffer.unwrap_or(core::mem::zeroed()) as _, buffersize, infosize.unwrap_or(core::mem::zeroed()) as _, core::mem::transmute(stringbuffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), stringbuffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _, pinfoex.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugAdvanced4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetThreadContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSystemObjectInformation: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceFileInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u64, u32, *mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub FindSourceFileAndTokenWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, windows_core::PCWSTR, u32, *const core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSymbolInformationWideEx: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u64, u32, *mut core::ffi::c_void, u32, *mut u32, windows_core::PWSTR, u32, *mut u32, *mut SYMBOL_INFO_EX) -> windows_core::HRESULT,
}
pub trait IDebugAdvanced4_Impl: windows_core::IUnknownImpl {
    fn GetThreadContext(&self, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn SetThreadContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
    fn Request(&self, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::Result<()>;
    fn GetSourceFileInformation(&self, which: u32, sourcefile: &windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn FindSourceFileAndToken(&self, startelement: u32, modaddr: u64, file: &windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn GetSystemObjectInformation(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn GetSourceFileInformationWide(&self, which: u32, sourcefile: &windows_core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::Result<()>;
    fn FindSourceFileAndTokenWide(&self, startelement: u32, modaddr: u64, file: &windows_core::PCWSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PWSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformationWide(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn GetSymbolInformationWideEx(&self, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32, pinfoex: *mut SYMBOL_INFO_EX) -> windows_core::Result<()>;
}
impl IDebugAdvanced4_Vtbl {
    pub const fn new<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetThreadContext<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *mut core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn SetThreadContext<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::SetThreadContext(this, core::mem::transmute_copy(&context), core::mem::transmute_copy(&contextsize)).into()
            }
        }
        unsafe extern "system" fn Request<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, request: u32, inbuffer: *const core::ffi::c_void, inbuffersize: u32, outbuffer: *mut core::ffi::c_void, outbuffersize: u32, outsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::Request(this, core::mem::transmute_copy(&request), core::mem::transmute_copy(&inbuffer), core::mem::transmute_copy(&inbuffersize), core::mem::transmute_copy(&outbuffer), core::mem::transmute_copy(&outbuffersize), core::mem::transmute_copy(&outsize)).into()
            }
        }
        unsafe extern "system" fn GetSourceFileInformation<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, sourcefile: windows_core::PCSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSourceFileInformation(this, core::mem::transmute_copy(&which), core::mem::transmute(&sourcefile), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn FindSourceFileAndToken<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, startelement: u32, modaddr: u64, file: windows_core::PCSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::FindSourceFileAndToken(this, core::mem::transmute_copy(&startelement), core::mem::transmute_copy(&modaddr), core::mem::transmute(&file), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&filetoken), core::mem::transmute_copy(&filetokensize), core::mem::transmute_copy(&foundelement), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&foundsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformation<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSymbolInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn GetSystemObjectInformation<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSystemObjectInformation(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn GetSourceFileInformationWide<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, sourcefile: windows_core::PCWSTR, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSourceFileInformationWide(this, core::mem::transmute_copy(&which), core::mem::transmute(&sourcefile), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize)).into()
            }
        }
        unsafe extern "system" fn FindSourceFileAndTokenWide<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, startelement: u32, modaddr: u64, file: windows_core::PCWSTR, flags: u32, filetoken: *const core::ffi::c_void, filetokensize: u32, foundelement: *mut u32, buffer: windows_core::PWSTR, buffersize: u32, foundsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::FindSourceFileAndTokenWide(this, core::mem::transmute_copy(&startelement), core::mem::transmute_copy(&modaddr), core::mem::transmute(&file), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&filetoken), core::mem::transmute_copy(&filetokensize), core::mem::transmute_copy(&foundelement), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&foundsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformationWide<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSymbolInformationWide(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn GetSymbolInformationWideEx<Identity: IDebugAdvanced4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, which: u32, arg64: u64, arg32: u32, buffer: *mut core::ffi::c_void, buffersize: u32, infosize: *mut u32, stringbuffer: windows_core::PWSTR, stringbuffersize: u32, stringsize: *mut u32, pinfoex: *mut SYMBOL_INFO_EX) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugAdvanced4_Impl::GetSymbolInformationWideEx(this, core::mem::transmute_copy(&which), core::mem::transmute_copy(&arg64), core::mem::transmute_copy(&arg32), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&infosize), core::mem::transmute_copy(&stringbuffer), core::mem::transmute_copy(&stringbuffersize), core::mem::transmute_copy(&stringsize), core::mem::transmute_copy(&pinfoex)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetThreadContext: GetThreadContext::<Identity, OFFSET>,
            SetThreadContext: SetThreadContext::<Identity, OFFSET>,
            Request: Request::<Identity, OFFSET>,
            GetSourceFileInformation: GetSourceFileInformation::<Identity, OFFSET>,
            FindSourceFileAndToken: FindSourceFileAndToken::<Identity, OFFSET>,
            GetSymbolInformation: GetSymbolInformation::<Identity, OFFSET>,
            GetSystemObjectInformation: GetSystemObjectInformation::<Identity, OFFSET>,
            GetSourceFileInformationWide: GetSourceFileInformationWide::<Identity, OFFSET>,
            FindSourceFileAndTokenWide: FindSourceFileAndTokenWide::<Identity, OFFSET>,
            GetSymbolInformationWide: GetSymbolInformationWide::<Identity, OFFSET>,
            GetSymbolInformationWideEx: GetSymbolInformationWideEx::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugAdvanced4 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugAdvanced4 {}
windows_core::imp::define_interface!(IDebugBreakpoint, IDebugBreakpoint_Vtbl, 0x5bd9d474_5975_423a_b88b_65a8e7110e65);
windows_core::imp::interface_hierarchy!(IDebugBreakpoint, windows_core::IUnknown);
impl IDebugBreakpoint {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype as _, proctype as _).ok() }
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok() }
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size as _, accesstype as _).ok() }
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok() }
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok() }
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok() }
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), commandsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok() }
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), expressionsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok() }
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
}
pub trait IDebugBreakpoint_Impl: windows_core::IUnknownImpl {
    fn GetId(&self) -> windows_core::Result<u32>;
    fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()>;
    fn GetAdder(&self) -> windows_core::Result<IDebugClient>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn AddFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn SetFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn GetOffset(&self) -> windows_core::Result<u64>;
    fn SetOffset(&self, offset: u64) -> windows_core::Result<()>;
    fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()>;
    fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()>;
    fn GetPassCount(&self) -> windows_core::Result<u32>;
    fn SetPassCount(&self, count: u32) -> windows_core::Result<()>;
    fn GetCurrentPassCount(&self) -> windows_core::Result<u32>;
    fn GetMatchThreadId(&self) -> windows_core::Result<u32>;
    fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()>;
    fn GetCommand(&self, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::Result<()>;
    fn SetCommand(&self, command: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetOffsetExpression(&self, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::Result<()>;
    fn SetOffsetExpression(&self, expression: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()>;
}
impl IDebugBreakpoint_Vtbl {
    pub const fn new<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetId<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetType<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::GetType(this, core::mem::transmute_copy(&breaktype), core::mem::transmute_copy(&proctype)).into()
            }
        }
        unsafe extern "system" fn GetAdder<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, adder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetAdder(this) {
                    Ok(ok__) => {
                        adder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        flags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddFlags<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::AddFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn RemoveFlags<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::RemoveFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetOffset<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetOffset(this) {
                    Ok(ok__) => {
                        offset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOffset<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetOffset(this, core::mem::transmute_copy(&offset)).into()
            }
        }
        unsafe extern "system" fn GetDataParameters<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::GetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn SetDataParameters<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: u32, accesstype: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn GetPassCount<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPassCount<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetPassCount(this, core::mem::transmute_copy(&count)).into()
            }
        }
        unsafe extern "system" fn GetCurrentPassCount<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetCurrentPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMatchThreadId<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint_Impl::GetMatchThreadId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMatchThreadId<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, thread: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetMatchThreadId(this, core::mem::transmute_copy(&thread)).into()
            }
        }
        unsafe extern "system" fn GetCommand<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::GetCommand(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&commandsize)).into()
            }
        }
        unsafe extern "system" fn SetCommand<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, command: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetCommand(this, core::mem::transmute(&command)).into()
            }
        }
        unsafe extern "system" fn GetOffsetExpression<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::GetOffsetExpression(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&expressionsize)).into()
            }
        }
        unsafe extern "system" fn SetOffsetExpression<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, expression: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::SetOffsetExpression(this, core::mem::transmute(&expression)).into()
            }
        }
        unsafe extern "system" fn GetParameters<Identity: IDebugBreakpoint_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint_Impl::GetParameters(this, core::mem::transmute_copy(&params)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetId: GetId::<Identity, OFFSET>,
            GetType: GetType::<Identity, OFFSET>,
            GetAdder: GetAdder::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            AddFlags: AddFlags::<Identity, OFFSET>,
            RemoveFlags: RemoveFlags::<Identity, OFFSET>,
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetOffset: GetOffset::<Identity, OFFSET>,
            SetOffset: SetOffset::<Identity, OFFSET>,
            GetDataParameters: GetDataParameters::<Identity, OFFSET>,
            SetDataParameters: SetDataParameters::<Identity, OFFSET>,
            GetPassCount: GetPassCount::<Identity, OFFSET>,
            SetPassCount: SetPassCount::<Identity, OFFSET>,
            GetCurrentPassCount: GetCurrentPassCount::<Identity, OFFSET>,
            GetMatchThreadId: GetMatchThreadId::<Identity, OFFSET>,
            SetMatchThreadId: SetMatchThreadId::<Identity, OFFSET>,
            GetCommand: GetCommand::<Identity, OFFSET>,
            SetCommand: SetCommand::<Identity, OFFSET>,
            GetOffsetExpression: GetOffsetExpression::<Identity, OFFSET>,
            SetOffsetExpression: SetOffsetExpression::<Identity, OFFSET>,
            GetParameters: GetParameters::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugBreakpoint as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugBreakpoint {}
windows_core::imp::define_interface!(IDebugBreakpoint2, IDebugBreakpoint2_Vtbl, 0x1b278d20_79f2_426e_a3f9_c1ddf375d48e);
windows_core::imp::interface_hierarchy!(IDebugBreakpoint2, windows_core::IUnknown);
impl IDebugBreakpoint2 {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype as _, proctype as _).ok() }
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok() }
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size as _, accesstype as _).ok() }
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok() }
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok() }
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok() }
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), commandsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok() }
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), expressionsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok() }
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params as _).ok() }
    }
    pub unsafe fn GetCommandWide(&self, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommandWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), commandsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetCommandWide)(windows_core::Interface::as_raw(self), command.param().abi()).ok() }
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: Option<&mut [u16]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOffsetExpressionWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), expressionsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOffsetExpressionWide)(windows_core::Interface::as_raw(self), expression.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IDebugBreakpoint2_Impl: windows_core::IUnknownImpl {
    fn GetId(&self) -> windows_core::Result<u32>;
    fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()>;
    fn GetAdder(&self) -> windows_core::Result<IDebugClient>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn AddFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn SetFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn GetOffset(&self) -> windows_core::Result<u64>;
    fn SetOffset(&self, offset: u64) -> windows_core::Result<()>;
    fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()>;
    fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()>;
    fn GetPassCount(&self) -> windows_core::Result<u32>;
    fn SetPassCount(&self, count: u32) -> windows_core::Result<()>;
    fn GetCurrentPassCount(&self) -> windows_core::Result<u32>;
    fn GetMatchThreadId(&self) -> windows_core::Result<u32>;
    fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()>;
    fn GetCommand(&self, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::Result<()>;
    fn SetCommand(&self, command: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetOffsetExpression(&self, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::Result<()>;
    fn SetOffsetExpression(&self, expression: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()>;
    fn GetCommandWide(&self, buffer: windows_core::PWSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::Result<()>;
    fn SetCommandWide(&self, command: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetOffsetExpressionWide(&self, buffer: windows_core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::Result<()>;
    fn SetOffsetExpressionWide(&self, expression: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IDebugBreakpoint2_Vtbl {
    pub const fn new<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetId<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetType<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetType(this, core::mem::transmute_copy(&breaktype), core::mem::transmute_copy(&proctype)).into()
            }
        }
        unsafe extern "system" fn GetAdder<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, adder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetAdder(this) {
                    Ok(ok__) => {
                        adder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        flags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddFlags<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::AddFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn RemoveFlags<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::RemoveFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetOffset<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetOffset(this) {
                    Ok(ok__) => {
                        offset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOffset<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetOffset(this, core::mem::transmute_copy(&offset)).into()
            }
        }
        unsafe extern "system" fn GetDataParameters<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn SetDataParameters<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: u32, accesstype: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn GetPassCount<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPassCount<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetPassCount(this, core::mem::transmute_copy(&count)).into()
            }
        }
        unsafe extern "system" fn GetCurrentPassCount<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetCurrentPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMatchThreadId<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint2_Impl::GetMatchThreadId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMatchThreadId<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, thread: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetMatchThreadId(this, core::mem::transmute_copy(&thread)).into()
            }
        }
        unsafe extern "system" fn GetCommand<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetCommand(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&commandsize)).into()
            }
        }
        unsafe extern "system" fn SetCommand<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, command: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetCommand(this, core::mem::transmute(&command)).into()
            }
        }
        unsafe extern "system" fn GetOffsetExpression<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetOffsetExpression(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&expressionsize)).into()
            }
        }
        unsafe extern "system" fn SetOffsetExpression<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, expression: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetOffsetExpression(this, core::mem::transmute(&expression)).into()
            }
        }
        unsafe extern "system" fn GetParameters<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetParameters(this, core::mem::transmute_copy(&params)).into()
            }
        }
        unsafe extern "system" fn GetCommandWide<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetCommandWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&commandsize)).into()
            }
        }
        unsafe extern "system" fn SetCommandWide<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, command: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetCommandWide(this, core::mem::transmute(&command)).into()
            }
        }
        unsafe extern "system" fn GetOffsetExpressionWide<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::GetOffsetExpressionWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&expressionsize)).into()
            }
        }
        unsafe extern "system" fn SetOffsetExpressionWide<Identity: IDebugBreakpoint2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, expression: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint2_Impl::SetOffsetExpressionWide(this, core::mem::transmute(&expression)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetId: GetId::<Identity, OFFSET>,
            GetType: GetType::<Identity, OFFSET>,
            GetAdder: GetAdder::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            AddFlags: AddFlags::<Identity, OFFSET>,
            RemoveFlags: RemoveFlags::<Identity, OFFSET>,
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetOffset: GetOffset::<Identity, OFFSET>,
            SetOffset: SetOffset::<Identity, OFFSET>,
            GetDataParameters: GetDataParameters::<Identity, OFFSET>,
            SetDataParameters: SetDataParameters::<Identity, OFFSET>,
            GetPassCount: GetPassCount::<Identity, OFFSET>,
            SetPassCount: SetPassCount::<Identity, OFFSET>,
            GetCurrentPassCount: GetCurrentPassCount::<Identity, OFFSET>,
            GetMatchThreadId: GetMatchThreadId::<Identity, OFFSET>,
            SetMatchThreadId: SetMatchThreadId::<Identity, OFFSET>,
            GetCommand: GetCommand::<Identity, OFFSET>,
            SetCommand: SetCommand::<Identity, OFFSET>,
            GetOffsetExpression: GetOffsetExpression::<Identity, OFFSET>,
            SetOffsetExpression: SetOffsetExpression::<Identity, OFFSET>,
            GetParameters: GetParameters::<Identity, OFFSET>,
            GetCommandWide: GetCommandWide::<Identity, OFFSET>,
            SetCommandWide: SetCommandWide::<Identity, OFFSET>,
            GetOffsetExpressionWide: GetOffsetExpressionWide::<Identity, OFFSET>,
            SetOffsetExpressionWide: SetOffsetExpressionWide::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugBreakpoint2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugBreakpoint2 {}
windows_core::imp::define_interface!(IDebugBreakpoint3, IDebugBreakpoint3_Vtbl, 0x38f5c249_b448_43bb_9835_579d4ec02249);
windows_core::imp::interface_hierarchy!(IDebugBreakpoint3, windows_core::IUnknown);
impl IDebugBreakpoint3 {
    pub unsafe fn GetId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetType)(windows_core::Interface::as_raw(self), breaktype as _, proctype as _).ok() }
    }
    pub unsafe fn GetAdder(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAdder)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn SetFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetOffset(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOffset(&self, offset: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOffset)(windows_core::Interface::as_raw(self), offset).ok() }
    }
    pub unsafe fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDataParameters)(windows_core::Interface::as_raw(self), size as _, accesstype as _).ok() }
    }
    pub unsafe fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDataParameters)(windows_core::Interface::as_raw(self), size, accesstype).ok() }
    }
    pub unsafe fn GetPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPassCount(&self, count: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPassCount)(windows_core::Interface::as_raw(self), count).ok() }
    }
    pub unsafe fn GetCurrentPassCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrentPassCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMatchThreadId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMatchThreadId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMatchThreadId)(windows_core::Interface::as_raw(self), thread).ok() }
    }
    pub unsafe fn GetCommand(&self, buffer: Option<&mut [u8]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommand)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), commandsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetCommand<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetCommand)(windows_core::Interface::as_raw(self), command.param().abi()).ok() }
    }
    pub unsafe fn GetOffsetExpression(&self, buffer: Option<&mut [u8]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOffsetExpression)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), expressionsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOffsetExpression<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOffsetExpression)(windows_core::Interface::as_raw(self), expression.param().abi()).ok() }
    }
    pub unsafe fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetParameters)(windows_core::Interface::as_raw(self), params as _).ok() }
    }
    pub unsafe fn GetCommandWide(&self, buffer: Option<&mut [u16]>, commandsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCommandWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), commandsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetCommandWide<P0>(&self, command: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetCommandWide)(windows_core::Interface::as_raw(self), command.param().abi()).ok() }
    }
    pub unsafe fn GetOffsetExpressionWide(&self, buffer: Option<&mut [u16]>, expressionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOffsetExpressionWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), expressionsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOffsetExpressionWide<P0>(&self, expression: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOffsetExpressionWide)(windows_core::Interface::as_raw(self), expression.param().abi()).ok() }
    }
    pub unsafe fn GetGuid(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGuid)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugBreakpoint3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub GetAdder: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub SetOffset: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetDataParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCurrentPassCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetMatchThreadId: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommand: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpression: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT,
    pub GetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetCommandWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOffsetExpressionWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetGuid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
}
pub trait IDebugBreakpoint3_Impl: windows_core::IUnknownImpl {
    fn GetId(&self) -> windows_core::Result<u32>;
    fn GetType(&self, breaktype: *mut u32, proctype: *mut u32) -> windows_core::Result<()>;
    fn GetAdder(&self) -> windows_core::Result<IDebugClient>;
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn AddFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn RemoveFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn SetFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn GetOffset(&self) -> windows_core::Result<u64>;
    fn SetOffset(&self, offset: u64) -> windows_core::Result<()>;
    fn GetDataParameters(&self, size: *mut u32, accesstype: *mut u32) -> windows_core::Result<()>;
    fn SetDataParameters(&self, size: u32, accesstype: u32) -> windows_core::Result<()>;
    fn GetPassCount(&self) -> windows_core::Result<u32>;
    fn SetPassCount(&self, count: u32) -> windows_core::Result<()>;
    fn GetCurrentPassCount(&self) -> windows_core::Result<u32>;
    fn GetMatchThreadId(&self) -> windows_core::Result<u32>;
    fn SetMatchThreadId(&self, thread: u32) -> windows_core::Result<()>;
    fn GetCommand(&self, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::Result<()>;
    fn SetCommand(&self, command: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetOffsetExpression(&self, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::Result<()>;
    fn SetOffsetExpression(&self, expression: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetParameters(&self, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::Result<()>;
    fn GetCommandWide(&self, buffer: windows_core::PWSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::Result<()>;
    fn SetCommandWide(&self, command: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetOffsetExpressionWide(&self, buffer: windows_core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::Result<()>;
    fn SetOffsetExpressionWide(&self, expression: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetGuid(&self) -> windows_core::Result<windows_core::GUID>;
}
impl IDebugBreakpoint3_Vtbl {
    pub const fn new<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetId<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetType<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, breaktype: *mut u32, proctype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetType(this, core::mem::transmute_copy(&breaktype), core::mem::transmute_copy(&proctype)).into()
            }
        }
        unsafe extern "system" fn GetAdder<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, adder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetAdder(this) {
                    Ok(ok__) => {
                        adder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFlags<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        flags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddFlags<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::AddFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn RemoveFlags<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::RemoveFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn SetFlags<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetOffset<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetOffset(this) {
                    Ok(ok__) => {
                        offset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOffset<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, offset: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetOffset(this, core::mem::transmute_copy(&offset)).into()
            }
        }
        unsafe extern "system" fn GetDataParameters<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: *mut u32, accesstype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn SetDataParameters<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, size: u32, accesstype: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetDataParameters(this, core::mem::transmute_copy(&size), core::mem::transmute_copy(&accesstype)).into()
            }
        }
        unsafe extern "system" fn GetPassCount<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPassCount<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetPassCount(this, core::mem::transmute_copy(&count)).into()
            }
        }
        unsafe extern "system" fn GetCurrentPassCount<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetCurrentPassCount(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMatchThreadId<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetMatchThreadId(this) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMatchThreadId<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, thread: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetMatchThreadId(this, core::mem::transmute_copy(&thread)).into()
            }
        }
        unsafe extern "system" fn GetCommand<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetCommand(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&commandsize)).into()
            }
        }
        unsafe extern "system" fn SetCommand<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, command: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetCommand(this, core::mem::transmute(&command)).into()
            }
        }
        unsafe extern "system" fn GetOffsetExpression<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetOffsetExpression(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&expressionsize)).into()
            }
        }
        unsafe extern "system" fn SetOffsetExpression<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, expression: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetOffsetExpression(this, core::mem::transmute(&expression)).into()
            }
        }
        unsafe extern "system" fn GetParameters<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, params: *mut DEBUG_BREAKPOINT_PARAMETERS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetParameters(this, core::mem::transmute_copy(&params)).into()
            }
        }
        unsafe extern "system" fn GetCommandWide<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, commandsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetCommandWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&commandsize)).into()
            }
        }
        unsafe extern "system" fn SetCommandWide<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, command: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetCommandWide(this, core::mem::transmute(&command)).into()
            }
        }
        unsafe extern "system" fn GetOffsetExpressionWide<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, expressionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::GetOffsetExpressionWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&expressionsize)).into()
            }
        }
        unsafe extern "system" fn SetOffsetExpressionWide<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, expression: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugBreakpoint3_Impl::SetOffsetExpressionWide(this, core::mem::transmute(&expression)).into()
            }
        }
        unsafe extern "system" fn GetGuid<Identity: IDebugBreakpoint3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugBreakpoint3_Impl::GetGuid(this) {
                    Ok(ok__) => {
                        guid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetId: GetId::<Identity, OFFSET>,
            GetType: GetType::<Identity, OFFSET>,
            GetAdder: GetAdder::<Identity, OFFSET>,
            GetFlags: GetFlags::<Identity, OFFSET>,
            AddFlags: AddFlags::<Identity, OFFSET>,
            RemoveFlags: RemoveFlags::<Identity, OFFSET>,
            SetFlags: SetFlags::<Identity, OFFSET>,
            GetOffset: GetOffset::<Identity, OFFSET>,
            SetOffset: SetOffset::<Identity, OFFSET>,
            GetDataParameters: GetDataParameters::<Identity, OFFSET>,
            SetDataParameters: SetDataParameters::<Identity, OFFSET>,
            GetPassCount: GetPassCount::<Identity, OFFSET>,
            SetPassCount: SetPassCount::<Identity, OFFSET>,
            GetCurrentPassCount: GetCurrentPassCount::<Identity, OFFSET>,
            GetMatchThreadId: GetMatchThreadId::<Identity, OFFSET>,
            SetMatchThreadId: SetMatchThreadId::<Identity, OFFSET>,
            GetCommand: GetCommand::<Identity, OFFSET>,
            SetCommand: SetCommand::<Identity, OFFSET>,
            GetOffsetExpression: GetOffsetExpression::<Identity, OFFSET>,
            SetOffsetExpression: SetOffsetExpression::<Identity, OFFSET>,
            GetParameters: GetParameters::<Identity, OFFSET>,
            GetCommandWide: GetCommandWide::<Identity, OFFSET>,
            SetCommandWide: SetCommandWide::<Identity, OFFSET>,
            GetOffsetExpressionWide: GetOffsetExpressionWide::<Identity, OFFSET>,
            SetOffsetExpressionWide: SetOffsetExpressionWide::<Identity, OFFSET>,
            GetGuid: GetGuid::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugBreakpoint3 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugBreakpoint3 {}
windows_core::imp::define_interface!(IDebugClient, IDebugClient_Vtbl, 0x27fe5639_8407_4f47_8364_ee118fb08ac8);
windows_core::imp::interface_hierarchy!(IDebugClient, windows_core::IUnknown);
impl IDebugClient {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDebugClient_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
}
impl IDebugClient_Vtbl {
    pub const fn new<Identity: IDebugClient_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient_Impl::FlushCallbacks(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient {}
windows_core::imp::define_interface!(IDebugClient2, IDebugClient2_Vtbl, 0xedbed635_372e_4dab_bbfe_ed0d2f63be81);
windows_core::imp::interface_hierarchy!(IDebugClient2, windows_core::IUnknown);
impl IDebugClient2 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient2_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDebugClient2_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
}
impl IDebugClient2_Vtbl {
    pub const fn new<Identity: IDebugClient2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient2_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::FlushCallbacks(this).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile2<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::WriteDumpFile2(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFile<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, infofile: windows_core::PCSTR, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::AddDumpInformationFile(this, core::mem::transmute(&infofile), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn EndProcessServer<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::EndProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn WaitForProcessServerEnd<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::WaitForProcessServerEnd(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn IsKernelDebuggerEnabled<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::IsKernelDebuggerEnabled(this).into()
            }
        }
        unsafe extern "system" fn TerminateCurrentProcess<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::TerminateCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn DetachCurrentProcess<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::DetachCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn AbandonCurrentProcess<Identity: IDebugClient2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient2_Impl::AbandonCurrentProcess(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
            WriteDumpFile2: WriteDumpFile2::<Identity, OFFSET>,
            AddDumpInformationFile: AddDumpInformationFile::<Identity, OFFSET>,
            EndProcessServer: EndProcessServer::<Identity, OFFSET>,
            WaitForProcessServerEnd: WaitForProcessServerEnd::<Identity, OFFSET>,
            IsKernelDebuggerEnabled: IsKernelDebuggerEnabled::<Identity, OFFSET>,
            TerminateCurrentProcess: TerminateCurrentProcess::<Identity, OFFSET>,
            DetachCurrentProcess: DetachCurrentProcess::<Identity, OFFSET>,
            AbandonCurrentProcess: AbandonCurrentProcess::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient2 {}
windows_core::imp::define_interface!(IDebugClient3, IDebugClient3_Vtbl, 0xdd492d7f_71b8_4ad6_a8dc_1c887479ff91);
windows_core::imp::interface_hierarchy!(IDebugClient3, windows_core::IUnknown);
impl IDebugClient3 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn CreateProcessWide<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttachWide<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient3_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
}
pub trait IDebugClient3_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableNameWide(&self, server: u64, exename: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn CreateProcessWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttachWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
}
impl IDebugClient3_Vtbl {
    pub const fn new<Identity: IDebugClient3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::FlushCallbacks(this).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile2<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::WriteDumpFile2(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFile<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, infofile: windows_core::PCSTR, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::AddDumpInformationFile(this, core::mem::transmute(&infofile), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn EndProcessServer<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::EndProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn WaitForProcessServerEnd<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::WaitForProcessServerEnd(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn IsKernelDebuggerEnabled<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::IsKernelDebuggerEnabled(this).into()
            }
        }
        unsafe extern "system" fn TerminateCurrentProcess<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::TerminateCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn DetachCurrentProcess<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::DetachCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn AbandonCurrentProcess<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::AbandonCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableNameWide<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCWSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient3_Impl::GetRunningProcessSystemIdByExecutableNameWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescriptionWide<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::GetRunningProcessDescriptionWide(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn CreateProcessWide<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::CreateProcessWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttachWide<Identity: IDebugClient3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient3_Impl::CreateProcessAndAttachWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
            WriteDumpFile2: WriteDumpFile2::<Identity, OFFSET>,
            AddDumpInformationFile: AddDumpInformationFile::<Identity, OFFSET>,
            EndProcessServer: EndProcessServer::<Identity, OFFSET>,
            WaitForProcessServerEnd: WaitForProcessServerEnd::<Identity, OFFSET>,
            IsKernelDebuggerEnabled: IsKernelDebuggerEnabled::<Identity, OFFSET>,
            TerminateCurrentProcess: TerminateCurrentProcess::<Identity, OFFSET>,
            DetachCurrentProcess: DetachCurrentProcess::<Identity, OFFSET>,
            AbandonCurrentProcess: AbandonCurrentProcess::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableNameWide: GetRunningProcessSystemIdByExecutableNameWide::<Identity, OFFSET>,
            GetRunningProcessDescriptionWide: GetRunningProcessDescriptionWide::<Identity, OFFSET>,
            CreateProcessWide: CreateProcessWide::<Identity, OFFSET>,
            CreateProcessAndAttachWide: CreateProcessAndAttachWide::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient3 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient3 {}
windows_core::imp::define_interface!(IDebugClient4, IDebugClient4_Vtbl, 0xca83c3de_5089_4cf8_93c8_d892387f2a5e);
windows_core::imp::interface_hierarchy!(IDebugClient4, windows_core::IUnknown);
impl IDebugClient4 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn CreateProcessWide<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttachWide<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok() }
    }
    pub unsafe fn WriteDumpFileWide<P0, P4>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok() }
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient4_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
}
pub trait IDebugClient4_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableNameWide(&self, server: u64, exename: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn CreateProcessWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttachWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn OpenDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64) -> windows_core::Result<()>;
    fn WriteDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::Result<()>;
    fn GetNumberDumpFiles(&self) -> windows_core::Result<u32>;
    fn GetDumpFile(&self, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn GetDumpFileWide(&self, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
}
impl IDebugClient4_Vtbl {
    pub const fn new<Identity: IDebugClient4_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::FlushCallbacks(this).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile2<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::WriteDumpFile2(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFile<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, infofile: windows_core::PCSTR, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AddDumpInformationFile(this, core::mem::transmute(&infofile), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn EndProcessServer<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::EndProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn WaitForProcessServerEnd<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::WaitForProcessServerEnd(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn IsKernelDebuggerEnabled<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::IsKernelDebuggerEnabled(this).into()
            }
        }
        unsafe extern "system" fn TerminateCurrentProcess<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::TerminateCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn DetachCurrentProcess<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::DetachCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn AbandonCurrentProcess<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AbandonCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableNameWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCWSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetRunningProcessSystemIdByExecutableNameWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescriptionWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetRunningProcessDescriptionWide(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn CreateProcessWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::CreateProcessWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttachWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::CreateProcessAndAttachWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFileWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::OpenDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFileWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::WriteDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFileWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::AddDumpInformationFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetNumberDumpFiles<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, number: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient4_Impl::GetNumberDumpFiles(this) {
                    Ok(ok__) => {
                        number.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDumpFile<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetDumpFile(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetDumpFileWide<Identity: IDebugClient4_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient4_Impl::GetDumpFileWide(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
            WriteDumpFile2: WriteDumpFile2::<Identity, OFFSET>,
            AddDumpInformationFile: AddDumpInformationFile::<Identity, OFFSET>,
            EndProcessServer: EndProcessServer::<Identity, OFFSET>,
            WaitForProcessServerEnd: WaitForProcessServerEnd::<Identity, OFFSET>,
            IsKernelDebuggerEnabled: IsKernelDebuggerEnabled::<Identity, OFFSET>,
            TerminateCurrentProcess: TerminateCurrentProcess::<Identity, OFFSET>,
            DetachCurrentProcess: DetachCurrentProcess::<Identity, OFFSET>,
            AbandonCurrentProcess: AbandonCurrentProcess::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableNameWide: GetRunningProcessSystemIdByExecutableNameWide::<Identity, OFFSET>,
            GetRunningProcessDescriptionWide: GetRunningProcessDescriptionWide::<Identity, OFFSET>,
            CreateProcessWide: CreateProcessWide::<Identity, OFFSET>,
            CreateProcessAndAttachWide: CreateProcessAndAttachWide::<Identity, OFFSET>,
            OpenDumpFileWide: OpenDumpFileWide::<Identity, OFFSET>,
            WriteDumpFileWide: WriteDumpFileWide::<Identity, OFFSET>,
            AddDumpInformationFileWide: AddDumpInformationFileWide::<Identity, OFFSET>,
            GetNumberDumpFiles: GetNumberDumpFiles::<Identity, OFFSET>,
            GetDumpFile: GetDumpFile::<Identity, OFFSET>,
            GetDumpFileWide: GetDumpFileWide::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient4 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient4 {}
windows_core::imp::define_interface!(IDebugClient5, IDebugClient5_Vtbl, 0xe3acb9d7_7ec2_4f0c_a0da_e81e0cbbe628);
windows_core::imp::interface_hierarchy!(IDebugClient5, windows_core::IUnknown);
impl IDebugClient5 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn CreateProcessWide<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttachWide<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok() }
    }
    pub unsafe fn WriteDumpFileWide<P0, P4>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok() }
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn AttachKernelWide<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServerWide<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServersWide<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentityWide<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok() }
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient5_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IDebugClient5_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableNameWide(&self, server: u64, exename: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn CreateProcessWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttachWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn OpenDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64) -> windows_core::Result<()>;
    fn WriteDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::Result<()>;
    fn GetNumberDumpFiles(&self) -> windows_core::Result<u32>;
    fn GetDumpFile(&self, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn GetDumpFileWide(&self, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn AttachKernelWide(&self, flags: u32, connectoptions: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptionsWide(&self, buffer: windows_core::PWSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptionsWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn StartProcessServerWide(&self, flags: u32, options: &windows_core::PCWSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServerWide(&self, remoteoptions: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn StartServerWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn OutputServersWide(&self, outputcontrol: u32, machine: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<()>;
    fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide>;
    fn SetOutputCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacksWide>) -> windows_core::Result<()>;
    fn GetOutputLinePrefixWide(&self, buffer: windows_core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefixWide(&self, prefix: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetIdentityWide(&self, buffer: windows_core::PWSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentityWide(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide>;
    fn SetEventCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacksWide>) -> windows_core::Result<()>;
    fn CreateProcess2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn CreateProcess2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn PushOutputLinePrefix(&self, newprefix: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn PushOutputLinePrefixWide(&self, newprefix: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()>;
    fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32>;
    fn GetQuitLockString(&self, buffer: windows_core::PSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockString(&self, string: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetQuitLockStringWide(&self, buffer: windows_core::PWSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockStringWide(&self, string: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IDebugClient5_Vtbl {
    pub const fn new<Identity: IDebugClient5_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::FlushCallbacks(this).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile2<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::WriteDumpFile2(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFile<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, infofile: windows_core::PCSTR, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AddDumpInformationFile(this, core::mem::transmute(&infofile), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn EndProcessServer<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::EndProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn WaitForProcessServerEnd<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::WaitForProcessServerEnd(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn IsKernelDebuggerEnabled<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::IsKernelDebuggerEnabled(this).into()
            }
        }
        unsafe extern "system" fn TerminateCurrentProcess<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::TerminateCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn DetachCurrentProcess<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::DetachCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn AbandonCurrentProcess<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AbandonCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableNameWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCWSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetRunningProcessSystemIdByExecutableNameWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescriptionWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetRunningProcessDescriptionWide(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn CreateProcessWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttachWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessAndAttachWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFileWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OpenDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFileWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::WriteDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFileWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AddDumpInformationFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetNumberDumpFiles<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, number: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetNumberDumpFiles(this) {
                    Ok(ok__) => {
                        number.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDumpFile<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetDumpFile(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetDumpFileWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetDumpFileWide(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn AttachKernelWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::AttachKernelWide(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptionsWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetKernelConnectionOptionsWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptionsWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetKernelConnectionOptionsWide(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServerWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCWSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::StartProcessServerWide(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServerWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCWSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::ConnectProcessServerWide(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn StartServerWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::StartServerWide(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServersWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCWSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OutputServersWide(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacksWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetOutputCallbacksWide(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacksWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputCallbacksWide(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefixWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetOutputLinePrefixWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefixWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetOutputLinePrefixWide(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentityWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetIdentityWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentityWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::OutputIdentityWide(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacksWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetEventCallbacksWide(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacksWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetEventCallbacksWide(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn CreateProcess2<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCSTR, environment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcess2(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment)).into()
            }
        }
        unsafe extern "system" fn CreateProcess2Wide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCWSTR, environment: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcess2Wide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach2<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCSTR, environment: windows_core::PCSTR, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessAndAttach2(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach2Wide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCWSTR, environment: windows_core::PCWSTR, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::CreateProcessAndAttach2Wide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn PushOutputLinePrefix<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newprefix: windows_core::PCSTR, handle: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::PushOutputLinePrefix(this, core::mem::transmute(&newprefix)) {
                    Ok(ok__) => {
                        handle.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn PushOutputLinePrefixWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newprefix: windows_core::PCWSTR, handle: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::PushOutputLinePrefixWide(this, core::mem::transmute(&newprefix)) {
                    Ok(ok__) => {
                        handle.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn PopOutputLinePrefix<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, handle: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::PopOutputLinePrefix(this, core::mem::transmute_copy(&handle)).into()
            }
        }
        unsafe extern "system" fn GetNumberInputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetNumberInputCallbacks(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberOutputCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetNumberOutputCallbacks(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberEventCallbacks<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eventflags: u32, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient5_Impl::GetNumberEventCallbacks(this, core::mem::transmute_copy(&eventflags)) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetQuitLockString<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetQuitLockString(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn SetQuitLockString<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, string: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetQuitLockString(this, core::mem::transmute(&string)).into()
            }
        }
        unsafe extern "system" fn GetQuitLockStringWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::GetQuitLockStringWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn SetQuitLockStringWide<Identity: IDebugClient5_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, string: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient5_Impl::SetQuitLockStringWide(this, core::mem::transmute(&string)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
            WriteDumpFile2: WriteDumpFile2::<Identity, OFFSET>,
            AddDumpInformationFile: AddDumpInformationFile::<Identity, OFFSET>,
            EndProcessServer: EndProcessServer::<Identity, OFFSET>,
            WaitForProcessServerEnd: WaitForProcessServerEnd::<Identity, OFFSET>,
            IsKernelDebuggerEnabled: IsKernelDebuggerEnabled::<Identity, OFFSET>,
            TerminateCurrentProcess: TerminateCurrentProcess::<Identity, OFFSET>,
            DetachCurrentProcess: DetachCurrentProcess::<Identity, OFFSET>,
            AbandonCurrentProcess: AbandonCurrentProcess::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableNameWide: GetRunningProcessSystemIdByExecutableNameWide::<Identity, OFFSET>,
            GetRunningProcessDescriptionWide: GetRunningProcessDescriptionWide::<Identity, OFFSET>,
            CreateProcessWide: CreateProcessWide::<Identity, OFFSET>,
            CreateProcessAndAttachWide: CreateProcessAndAttachWide::<Identity, OFFSET>,
            OpenDumpFileWide: OpenDumpFileWide::<Identity, OFFSET>,
            WriteDumpFileWide: WriteDumpFileWide::<Identity, OFFSET>,
            AddDumpInformationFileWide: AddDumpInformationFileWide::<Identity, OFFSET>,
            GetNumberDumpFiles: GetNumberDumpFiles::<Identity, OFFSET>,
            GetDumpFile: GetDumpFile::<Identity, OFFSET>,
            GetDumpFileWide: GetDumpFileWide::<Identity, OFFSET>,
            AttachKernelWide: AttachKernelWide::<Identity, OFFSET>,
            GetKernelConnectionOptionsWide: GetKernelConnectionOptionsWide::<Identity, OFFSET>,
            SetKernelConnectionOptionsWide: SetKernelConnectionOptionsWide::<Identity, OFFSET>,
            StartProcessServerWide: StartProcessServerWide::<Identity, OFFSET>,
            ConnectProcessServerWide: ConnectProcessServerWide::<Identity, OFFSET>,
            StartServerWide: StartServerWide::<Identity, OFFSET>,
            OutputServersWide: OutputServersWide::<Identity, OFFSET>,
            GetOutputCallbacksWide: GetOutputCallbacksWide::<Identity, OFFSET>,
            SetOutputCallbacksWide: SetOutputCallbacksWide::<Identity, OFFSET>,
            GetOutputLinePrefixWide: GetOutputLinePrefixWide::<Identity, OFFSET>,
            SetOutputLinePrefixWide: SetOutputLinePrefixWide::<Identity, OFFSET>,
            GetIdentityWide: GetIdentityWide::<Identity, OFFSET>,
            OutputIdentityWide: OutputIdentityWide::<Identity, OFFSET>,
            GetEventCallbacksWide: GetEventCallbacksWide::<Identity, OFFSET>,
            SetEventCallbacksWide: SetEventCallbacksWide::<Identity, OFFSET>,
            CreateProcess2: CreateProcess2::<Identity, OFFSET>,
            CreateProcess2Wide: CreateProcess2Wide::<Identity, OFFSET>,
            CreateProcessAndAttach2: CreateProcessAndAttach2::<Identity, OFFSET>,
            CreateProcessAndAttach2Wide: CreateProcessAndAttach2Wide::<Identity, OFFSET>,
            PushOutputLinePrefix: PushOutputLinePrefix::<Identity, OFFSET>,
            PushOutputLinePrefixWide: PushOutputLinePrefixWide::<Identity, OFFSET>,
            PopOutputLinePrefix: PopOutputLinePrefix::<Identity, OFFSET>,
            GetNumberInputCallbacks: GetNumberInputCallbacks::<Identity, OFFSET>,
            GetNumberOutputCallbacks: GetNumberOutputCallbacks::<Identity, OFFSET>,
            GetNumberEventCallbacks: GetNumberEventCallbacks::<Identity, OFFSET>,
            GetQuitLockString: GetQuitLockString::<Identity, OFFSET>,
            SetQuitLockString: SetQuitLockString::<Identity, OFFSET>,
            GetQuitLockStringWide: GetQuitLockStringWide::<Identity, OFFSET>,
            SetQuitLockStringWide: SetQuitLockStringWide::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient5 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient5 {}
windows_core::imp::define_interface!(IDebugClient6, IDebugClient6_Vtbl, 0xfd28b4c5_c498_4686_a28e_62cad2154eb3);
windows_core::imp::interface_hierarchy!(IDebugClient6, windows_core::IUnknown);
impl IDebugClient6 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn CreateProcessWide<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttachWide<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok() }
    }
    pub unsafe fn WriteDumpFileWide<P0, P4>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok() }
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn AttachKernelWide<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServerWide<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServersWide<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentityWide<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok() }
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventContextCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventContextCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient6_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IDebugClient6_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableNameWide(&self, server: u64, exename: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn CreateProcessWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttachWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn OpenDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64) -> windows_core::Result<()>;
    fn WriteDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::Result<()>;
    fn GetNumberDumpFiles(&self) -> windows_core::Result<u32>;
    fn GetDumpFile(&self, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn GetDumpFileWide(&self, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn AttachKernelWide(&self, flags: u32, connectoptions: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptionsWide(&self, buffer: windows_core::PWSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptionsWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn StartProcessServerWide(&self, flags: u32, options: &windows_core::PCWSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServerWide(&self, remoteoptions: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn StartServerWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn OutputServersWide(&self, outputcontrol: u32, machine: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<()>;
    fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide>;
    fn SetOutputCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacksWide>) -> windows_core::Result<()>;
    fn GetOutputLinePrefixWide(&self, buffer: windows_core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefixWide(&self, prefix: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetIdentityWide(&self, buffer: windows_core::PWSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentityWide(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide>;
    fn SetEventCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacksWide>) -> windows_core::Result<()>;
    fn CreateProcess2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn CreateProcess2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn PushOutputLinePrefix(&self, newprefix: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn PushOutputLinePrefixWide(&self, newprefix: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()>;
    fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32>;
    fn GetQuitLockString(&self, buffer: windows_core::PSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockString(&self, string: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetQuitLockStringWide(&self, buffer: windows_core::PWSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockStringWide(&self, string: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetEventContextCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventContextCallbacks>) -> windows_core::Result<()>;
}
impl IDebugClient6_Vtbl {
    pub const fn new<Identity: IDebugClient6_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessA(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessAndAttach(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn GetProcessOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetProcessOptions(this) {
                    Ok(ok__) => {
                        options.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddProcessOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AddProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn RemoveProcessOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::RemoveProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn SetProcessOptions<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetProcessOptions(this, core::mem::transmute_copy(&options)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFile<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OpenDumpFile(this, core::mem::transmute(&dumpfile)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::WriteDumpFile(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier)).into()
            }
        }
        unsafe extern "system" fn ConnectSession<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, historylimit: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::ConnectSession(this, core::mem::transmute_copy(&flags), core::mem::transmute_copy(&historylimit)).into()
            }
        }
        unsafe extern "system" fn StartServer<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::StartServer(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServers<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OutputServers(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn TerminateProcesses<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::TerminateProcesses(this).into()
            }
        }
        unsafe extern "system" fn DetachProcesses<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::DetachProcesses(this).into()
            }
        }
        unsafe extern "system" fn EndSession<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::EndSession(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetExitCode<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, code: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetExitCode(this) {
                    Ok(ok__) => {
                        code.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DispatchCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::DispatchCallbacks(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn ExitDispatch<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::ExitDispatch(this, core::mem::transmute_copy(&client)).into()
            }
        }
        unsafe extern "system" fn CreateClient<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::CreateClient(this) {
                    Ok(ok__) => {
                        client.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetInputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetInputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetInputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetOutputCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputMask<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetOutputMask(this) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputMask<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputMask(this, core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOtherOutputMask<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetOtherOutputMask(this, core::mem::transmute_copy(&client)) {
                    Ok(ok__) => {
                        mask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOtherOutputMask<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, client: *mut core::ffi::c_void, mask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOtherOutputMask(this, core::mem::transmute_copy(&client), core::mem::transmute_copy(&mask)).into()
            }
        }
        unsafe extern "system" fn GetOutputWidth<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetOutputWidth(this) {
                    Ok(ok__) => {
                        columns.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputWidth<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, columns: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputWidth(this, core::mem::transmute_copy(&columns)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefix<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetOutputLinePrefix(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefix<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputLinePrefix(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentity<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetIdentity(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentity<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OutputIdentity(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetEventCallbacks(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetEventCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn FlushCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::FlushCallbacks(this).into()
            }
        }
        unsafe extern "system" fn WriteDumpFile2<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dumpfile: windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::WriteDumpFile2(this, core::mem::transmute(&dumpfile), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFile<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, infofile: windows_core::PCSTR, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AddDumpInformationFile(this, core::mem::transmute(&infofile), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn EndProcessServer<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::EndProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn WaitForProcessServerEnd<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, timeout: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::WaitForProcessServerEnd(this, core::mem::transmute_copy(&timeout)).into()
            }
        }
        unsafe extern "system" fn IsKernelDebuggerEnabled<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::IsKernelDebuggerEnabled(this).into()
            }
        }
        unsafe extern "system" fn TerminateCurrentProcess<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::TerminateCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn DetachCurrentProcess<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::DetachCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn AbandonCurrentProcess<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AbandonCurrentProcess(this).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableNameWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCWSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetRunningProcessSystemIdByExecutableNameWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescriptionWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetRunningProcessDescriptionWide(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn CreateProcessWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttachWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessAndAttachWide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&createflags), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn OpenDumpFileWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OpenDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle)).into()
            }
        }
        unsafe extern "system" fn WriteDumpFileWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::WriteDumpFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&qualifier), core::mem::transmute_copy(&formatflags), core::mem::transmute(&comment)).into()
            }
        }
        unsafe extern "system" fn AddDumpInformationFileWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, filename: windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AddDumpInformationFileWide(this, core::mem::transmute(&filename), core::mem::transmute_copy(&filehandle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetNumberDumpFiles<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, number: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetNumberDumpFiles(this) {
                    Ok(ok__) => {
                        number.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDumpFile<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetDumpFile(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn GetDumpFileWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetDumpFileWide(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&namesize), core::mem::transmute_copy(&handle), core::mem::transmute_copy(&r#type)).into()
            }
        }
        unsafe extern "system" fn AttachKernelWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::AttachKernelWide(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptionsWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetKernelConnectionOptionsWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptionsWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetKernelConnectionOptionsWide(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServerWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCWSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::StartProcessServerWide(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServerWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCWSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::ConnectProcessServerWide(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn StartServerWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::StartServerWide(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn OutputServersWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, machine: windows_core::PCWSTR, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OutputServersWide(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute(&machine), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn GetOutputCallbacksWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetOutputCallbacksWide(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputCallbacksWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputCallbacksWide(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn GetOutputLinePrefixWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetOutputLinePrefixWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&prefixsize)).into()
            }
        }
        unsafe extern "system" fn SetOutputLinePrefixWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prefix: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetOutputLinePrefixWide(this, core::mem::transmute(&prefix)).into()
            }
        }
        unsafe extern "system" fn GetIdentityWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetIdentityWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&identitysize)).into()
            }
        }
        unsafe extern "system" fn OutputIdentityWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputcontrol: u32, flags: u32, format: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::OutputIdentityWide(this, core::mem::transmute_copy(&outputcontrol), core::mem::transmute_copy(&flags), core::mem::transmute(&format)).into()
            }
        }
        unsafe extern "system" fn GetEventCallbacksWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetEventCallbacksWide(this) {
                    Ok(ok__) => {
                        callbacks.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEventCallbacksWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetEventCallbacksWide(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        unsafe extern "system" fn CreateProcess2<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCSTR, environment: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcess2(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment)).into()
            }
        }
        unsafe extern "system" fn CreateProcess2Wide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCWSTR, environment: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcess2Wide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach2<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCSTR, environment: windows_core::PCSTR, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessAndAttach2(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessAndAttach2Wide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, commandline: windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: windows_core::PCWSTR, environment: windows_core::PCWSTR, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::CreateProcessAndAttach2Wide(this, core::mem::transmute_copy(&server), core::mem::transmute(&commandline), core::mem::transmute_copy(&optionsbuffer), core::mem::transmute_copy(&optionsbuffersize), core::mem::transmute(&initialdirectory), core::mem::transmute(&environment), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn PushOutputLinePrefix<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newprefix: windows_core::PCSTR, handle: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::PushOutputLinePrefix(this, core::mem::transmute(&newprefix)) {
                    Ok(ok__) => {
                        handle.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn PushOutputLinePrefixWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, newprefix: windows_core::PCWSTR, handle: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::PushOutputLinePrefixWide(this, core::mem::transmute(&newprefix)) {
                    Ok(ok__) => {
                        handle.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn PopOutputLinePrefix<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, handle: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::PopOutputLinePrefix(this, core::mem::transmute_copy(&handle)).into()
            }
        }
        unsafe extern "system" fn GetNumberInputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetNumberInputCallbacks(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberOutputCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetNumberOutputCallbacks(this) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberEventCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, eventflags: u32, count: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient6_Impl::GetNumberEventCallbacks(this, core::mem::transmute_copy(&eventflags)) {
                    Ok(ok__) => {
                        count.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetQuitLockString<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetQuitLockString(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn SetQuitLockString<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, string: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetQuitLockString(this, core::mem::transmute(&string)).into()
            }
        }
        unsafe extern "system" fn GetQuitLockStringWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PWSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::GetQuitLockStringWide(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&stringsize)).into()
            }
        }
        unsafe extern "system" fn SetQuitLockStringWide<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, string: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetQuitLockStringWide(this, core::mem::transmute(&string)).into()
            }
        }
        unsafe extern "system" fn SetEventContextCallbacks<Identity: IDebugClient6_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, callbacks: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient6_Impl::SetEventContextCallbacks(this, core::mem::transmute_copy(&callbacks)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AttachKernel: AttachKernel::<Identity, OFFSET>,
            GetKernelConnectionOptions: GetKernelConnectionOptions::<Identity, OFFSET>,
            SetKernelConnectionOptions: SetKernelConnectionOptions::<Identity, OFFSET>,
            StartProcessServer: StartProcessServer::<Identity, OFFSET>,
            ConnectProcessServer: ConnectProcessServer::<Identity, OFFSET>,
            DisconnectProcessServer: DisconnectProcessServer::<Identity, OFFSET>,
            GetRunningProcessSystemIds: GetRunningProcessSystemIds::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableName: GetRunningProcessSystemIdByExecutableName::<Identity, OFFSET>,
            GetRunningProcessDescription: GetRunningProcessDescription::<Identity, OFFSET>,
            AttachProcess: AttachProcess::<Identity, OFFSET>,
            CreateProcessA: CreateProcessA::<Identity, OFFSET>,
            CreateProcessAndAttach: CreateProcessAndAttach::<Identity, OFFSET>,
            GetProcessOptions: GetProcessOptions::<Identity, OFFSET>,
            AddProcessOptions: AddProcessOptions::<Identity, OFFSET>,
            RemoveProcessOptions: RemoveProcessOptions::<Identity, OFFSET>,
            SetProcessOptions: SetProcessOptions::<Identity, OFFSET>,
            OpenDumpFile: OpenDumpFile::<Identity, OFFSET>,
            WriteDumpFile: WriteDumpFile::<Identity, OFFSET>,
            ConnectSession: ConnectSession::<Identity, OFFSET>,
            StartServer: StartServer::<Identity, OFFSET>,
            OutputServers: OutputServers::<Identity, OFFSET>,
            TerminateProcesses: TerminateProcesses::<Identity, OFFSET>,
            DetachProcesses: DetachProcesses::<Identity, OFFSET>,
            EndSession: EndSession::<Identity, OFFSET>,
            GetExitCode: GetExitCode::<Identity, OFFSET>,
            DispatchCallbacks: DispatchCallbacks::<Identity, OFFSET>,
            ExitDispatch: ExitDispatch::<Identity, OFFSET>,
            CreateClient: CreateClient::<Identity, OFFSET>,
            GetInputCallbacks: GetInputCallbacks::<Identity, OFFSET>,
            SetInputCallbacks: SetInputCallbacks::<Identity, OFFSET>,
            GetOutputCallbacks: GetOutputCallbacks::<Identity, OFFSET>,
            SetOutputCallbacks: SetOutputCallbacks::<Identity, OFFSET>,
            GetOutputMask: GetOutputMask::<Identity, OFFSET>,
            SetOutputMask: SetOutputMask::<Identity, OFFSET>,
            GetOtherOutputMask: GetOtherOutputMask::<Identity, OFFSET>,
            SetOtherOutputMask: SetOtherOutputMask::<Identity, OFFSET>,
            GetOutputWidth: GetOutputWidth::<Identity, OFFSET>,
            SetOutputWidth: SetOutputWidth::<Identity, OFFSET>,
            GetOutputLinePrefix: GetOutputLinePrefix::<Identity, OFFSET>,
            SetOutputLinePrefix: SetOutputLinePrefix::<Identity, OFFSET>,
            GetIdentity: GetIdentity::<Identity, OFFSET>,
            OutputIdentity: OutputIdentity::<Identity, OFFSET>,
            GetEventCallbacks: GetEventCallbacks::<Identity, OFFSET>,
            SetEventCallbacks: SetEventCallbacks::<Identity, OFFSET>,
            FlushCallbacks: FlushCallbacks::<Identity, OFFSET>,
            WriteDumpFile2: WriteDumpFile2::<Identity, OFFSET>,
            AddDumpInformationFile: AddDumpInformationFile::<Identity, OFFSET>,
            EndProcessServer: EndProcessServer::<Identity, OFFSET>,
            WaitForProcessServerEnd: WaitForProcessServerEnd::<Identity, OFFSET>,
            IsKernelDebuggerEnabled: IsKernelDebuggerEnabled::<Identity, OFFSET>,
            TerminateCurrentProcess: TerminateCurrentProcess::<Identity, OFFSET>,
            DetachCurrentProcess: DetachCurrentProcess::<Identity, OFFSET>,
            AbandonCurrentProcess: AbandonCurrentProcess::<Identity, OFFSET>,
            GetRunningProcessSystemIdByExecutableNameWide: GetRunningProcessSystemIdByExecutableNameWide::<Identity, OFFSET>,
            GetRunningProcessDescriptionWide: GetRunningProcessDescriptionWide::<Identity, OFFSET>,
            CreateProcessWide: CreateProcessWide::<Identity, OFFSET>,
            CreateProcessAndAttachWide: CreateProcessAndAttachWide::<Identity, OFFSET>,
            OpenDumpFileWide: OpenDumpFileWide::<Identity, OFFSET>,
            WriteDumpFileWide: WriteDumpFileWide::<Identity, OFFSET>,
            AddDumpInformationFileWide: AddDumpInformationFileWide::<Identity, OFFSET>,
            GetNumberDumpFiles: GetNumberDumpFiles::<Identity, OFFSET>,
            GetDumpFile: GetDumpFile::<Identity, OFFSET>,
            GetDumpFileWide: GetDumpFileWide::<Identity, OFFSET>,
            AttachKernelWide: AttachKernelWide::<Identity, OFFSET>,
            GetKernelConnectionOptionsWide: GetKernelConnectionOptionsWide::<Identity, OFFSET>,
            SetKernelConnectionOptionsWide: SetKernelConnectionOptionsWide::<Identity, OFFSET>,
            StartProcessServerWide: StartProcessServerWide::<Identity, OFFSET>,
            ConnectProcessServerWide: ConnectProcessServerWide::<Identity, OFFSET>,
            StartServerWide: StartServerWide::<Identity, OFFSET>,
            OutputServersWide: OutputServersWide::<Identity, OFFSET>,
            GetOutputCallbacksWide: GetOutputCallbacksWide::<Identity, OFFSET>,
            SetOutputCallbacksWide: SetOutputCallbacksWide::<Identity, OFFSET>,
            GetOutputLinePrefixWide: GetOutputLinePrefixWide::<Identity, OFFSET>,
            SetOutputLinePrefixWide: SetOutputLinePrefixWide::<Identity, OFFSET>,
            GetIdentityWide: GetIdentityWide::<Identity, OFFSET>,
            OutputIdentityWide: OutputIdentityWide::<Identity, OFFSET>,
            GetEventCallbacksWide: GetEventCallbacksWide::<Identity, OFFSET>,
            SetEventCallbacksWide: SetEventCallbacksWide::<Identity, OFFSET>,
            CreateProcess2: CreateProcess2::<Identity, OFFSET>,
            CreateProcess2Wide: CreateProcess2Wide::<Identity, OFFSET>,
            CreateProcessAndAttach2: CreateProcessAndAttach2::<Identity, OFFSET>,
            CreateProcessAndAttach2Wide: CreateProcessAndAttach2Wide::<Identity, OFFSET>,
            PushOutputLinePrefix: PushOutputLinePrefix::<Identity, OFFSET>,
            PushOutputLinePrefixWide: PushOutputLinePrefixWide::<Identity, OFFSET>,
            PopOutputLinePrefix: PopOutputLinePrefix::<Identity, OFFSET>,
            GetNumberInputCallbacks: GetNumberInputCallbacks::<Identity, OFFSET>,
            GetNumberOutputCallbacks: GetNumberOutputCallbacks::<Identity, OFFSET>,
            GetNumberEventCallbacks: GetNumberEventCallbacks::<Identity, OFFSET>,
            GetQuitLockString: GetQuitLockString::<Identity, OFFSET>,
            SetQuitLockString: SetQuitLockString::<Identity, OFFSET>,
            GetQuitLockStringWide: GetQuitLockStringWide::<Identity, OFFSET>,
            SetQuitLockStringWide: SetQuitLockStringWide::<Identity, OFFSET>,
            SetEventContextCallbacks: SetEventContextCallbacks::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IDebugClient6 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IDebugClient6 {}
windows_core::imp::define_interface!(IDebugClient7, IDebugClient7_Vtbl, 0x13586be3_542e_481e_b1f2_8497ba74f9a9);
windows_core::imp::interface_hierarchy!(IDebugClient7, windows_core::IUnknown);
impl IDebugClient7 {
    pub unsafe fn AttachKernel<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernel)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptions(&self, buffer: Option<&mut [u8]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptions)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptions<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptions)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServer<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServer)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServer<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServer)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DisconnectProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIds(&self, server: u64, ids: Option<&mut [u32]>, actualcount: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRunningProcessSystemIds)(windows_core::Interface::as_raw(self), server, core::mem::transmute(ids.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), ids.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), actualcount.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableName<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableName)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u8]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u8]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescription)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AttachProcess)(windows_core::Interface::as_raw(self), server, processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessA<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessA)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn GetProcessOptions(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetProcessOptions)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProcessOptions)(windows_core::Interface::as_raw(self), options).ok() }
    }
    pub unsafe fn OpenDumpFile<P0>(&self, dumpfile: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi()).ok() }
    }
    pub unsafe fn WriteDumpFile<P0>(&self, dumpfile: P0, qualifier: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier).ok() }
    }
    pub unsafe fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ConnectSession)(windows_core::Interface::as_raw(self), flags, historylimit).ok() }
    }
    pub unsafe fn StartServer<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServer)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServers<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServers)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn TerminateProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachProcesses(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachProcesses)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndSession(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndSession)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn GetExitCode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetExitCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DispatchCallbacks)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn ExitDispatch<P0>(&self, client: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).ExitDispatch)(windows_core::Interface::as_raw(self), client.param().abi()).ok() }
    }
    pub unsafe fn CreateClient(&self) -> windows_core::Result<IDebugClient> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateClient)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetInputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugInputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetInputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputMask(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputMask)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputMask)(windows_core::Interface::as_raw(self), mask).ok() }
    }
    pub unsafe fn GetOtherOutputMask<P0>(&self, client: P0) -> windows_core::Result<u32>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOtherOutputMask<P0>(&self, client: P0, mask: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugClient>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOtherOutputMask)(windows_core::Interface::as_raw(self), client.param().abi(), mask).ok() }
    }
    pub unsafe fn GetOutputWidth(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputWidth)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputWidth)(windows_core::Interface::as_raw(self), columns).ok() }
    }
    pub unsafe fn GetOutputLinePrefix(&self, buffer: Option<&mut [u8]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefix)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefix<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefix)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentity(&self, buffer: Option<&mut [u8]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentity)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentity<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentity)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacks)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn FlushCallbacks(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FlushCallbacks)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteDumpFile2<P0, P3>(&self, dumpfile: P0, qualifier: u32, formatflags: u32, comment: P3) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
        P3: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFile2)(windows_core::Interface::as_raw(self), dumpfile.param().abi(), qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFile<P0>(&self, infofile: P0, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFile)(windows_core::Interface::as_raw(self), infofile.param().abi(), r#type).ok() }
    }
    pub unsafe fn EndProcessServer(&self, server: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndProcessServer)(windows_core::Interface::as_raw(self), server).ok() }
    }
    pub unsafe fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForProcessServerEnd)(windows_core::Interface::as_raw(self), timeout).ok() }
    }
    pub unsafe fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsKernelDebuggerEnabled)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn TerminateCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TerminateCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn DetachCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DetachCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn AbandonCurrentProcess(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbandonCurrentProcess)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetRunningProcessSystemIdByExecutableNameWide<P1>(&self, server: u64, exename: P1, flags: u32) -> windows_core::Result<u32>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetRunningProcessSystemIdByExecutableNameWide)(windows_core::Interface::as_raw(self), server, exename.param().abi(), flags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: Option<&mut [u16]>, actualexenamesize: Option<*mut u32>, description: Option<&mut [u16]>, actualdescriptionsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe {
            (windows_core::Interface::vtable(self).GetRunningProcessDescriptionWide)(
                windows_core::Interface::as_raw(self),
                server,
                systemid,
                flags,
                core::mem::transmute(exename.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                exename.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualexenamesize.unwrap_or(core::mem::zeroed()) as _,
                core::mem::transmute(description.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())),
                description.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
                actualdescriptionsize.unwrap_or(core::mem::zeroed()) as _,
            )
            .ok()
        }
    }
    pub unsafe fn CreateProcessWide<P1>(&self, server: u64, commandline: P1, createflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttachWide<P1>(&self, server: u64, commandline: P1, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttachWide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), createflags, processid, attachflags).ok() }
    }
    pub unsafe fn OpenDumpFileWide<P0>(&self, filename: P0, filehandle: u64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle).ok() }
    }
    pub unsafe fn WriteDumpFileWide<P0, P4>(&self, filename: P0, filehandle: u64, qualifier: u32, formatflags: u32, comment: P4) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).WriteDumpFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, qualifier, formatflags, comment.param().abi()).ok() }
    }
    pub unsafe fn AddDumpInformationFileWide<P0>(&self, filename: P0, filehandle: u64, r#type: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AddDumpInformationFileWide)(windows_core::Interface::as_raw(self), filename.param().abi(), filehandle, r#type).ok() }
    }
    pub unsafe fn GetNumberDumpFiles(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberDumpFiles)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDumpFile(&self, index: u32, buffer: Option<&mut [u8]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFile)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn GetDumpFileWide(&self, index: u32, buffer: Option<&mut [u16]>, namesize: Option<*mut u32>, handle: Option<*mut u64>, r#type: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDumpFileWide)(windows_core::Interface::as_raw(self), index, core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), namesize.unwrap_or(core::mem::zeroed()) as _, handle.unwrap_or(core::mem::zeroed()) as _, r#type as _).ok() }
    }
    pub unsafe fn AttachKernelWide<P1>(&self, flags: u32, connectoptions: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).AttachKernelWide)(windows_core::Interface::as_raw(self), flags, connectoptions.param().abi()).ok() }
    }
    pub unsafe fn GetKernelConnectionOptionsWide(&self, buffer: Option<&mut [u16]>, optionssize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), optionssize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetKernelConnectionOptionsWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetKernelConnectionOptionsWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn StartProcessServerWide<P1>(&self, flags: u32, options: P1, reserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartProcessServerWide)(windows_core::Interface::as_raw(self), flags, options.param().abi(), reserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn ConnectProcessServerWide<P0>(&self, remoteoptions: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectProcessServerWide)(windows_core::Interface::as_raw(self), remoteoptions.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn StartServerWide<P0>(&self, options: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).StartServerWide)(windows_core::Interface::as_raw(self), options.param().abi()).ok() }
    }
    pub unsafe fn OutputServersWide<P1>(&self, outputcontrol: u32, machine: P1, flags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputServersWide)(windows_core::Interface::as_raw(self), outputcontrol, machine.param().abi(), flags).ok() }
    }
    pub unsafe fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOutputCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetOutputCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugOutputCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn GetOutputLinePrefixWide(&self, buffer: Option<&mut [u16]>, prefixsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), prefixsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetOutputLinePrefixWide<P0>(&self, prefix: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetOutputLinePrefixWide)(windows_core::Interface::as_raw(self), prefix.param().abi()).ok() }
    }
    pub unsafe fn GetIdentityWide(&self, buffer: Option<&mut [u16]>, identitysize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetIdentityWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), identitysize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OutputIdentityWide<P2>(&self, outputcontrol: u32, flags: u32, format: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OutputIdentityWide)(windows_core::Interface::as_raw(self), outputcontrol, flags, format.param().abi()).ok() }
    }
    pub unsafe fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEventCallbacksWide)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn SetEventCallbacksWide<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventCallbacksWide>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventCallbacksWide)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcess2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcess2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi()).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCSTR>,
        P4: windows_core::Param<windows_core::PCSTR>,
        P5: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn CreateProcessAndAttach2Wide<P1, P4, P5>(&self, server: u64, commandline: P1, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: P4, environment: P5, processid: u32, attachflags: u32) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::PCWSTR>,
        P4: windows_core::Param<windows_core::PCWSTR>,
        P5: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreateProcessAndAttach2Wide)(windows_core::Interface::as_raw(self), server, commandline.param().abi(), optionsbuffer, optionsbuffersize, initialdirectory.param().abi(), environment.param().abi(), processid, attachflags).ok() }
    }
    pub unsafe fn PushOutputLinePrefix<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefix)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PushOutputLinePrefixWide<P0>(&self, newprefix: P0) -> windows_core::Result<u64>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PushOutputLinePrefixWide)(windows_core::Interface::as_raw(self), newprefix.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PopOutputLinePrefix)(windows_core::Interface::as_raw(self), handle).ok() }
    }
    pub unsafe fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberInputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberOutputCallbacks)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumberEventCallbacks)(windows_core::Interface::as_raw(self), eventflags, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetQuitLockString(&self, buffer: Option<&mut [u8]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockString)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockString<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockString)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
    pub unsafe fn GetQuitLockStringWide(&self, buffer: Option<&mut [u16]>, stringsize: Option<*mut u32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetQuitLockStringWide)(windows_core::Interface::as_raw(self), core::mem::transmute(buffer.as_deref().map_or(core::ptr::null(), |slice| slice.as_ptr())), buffer.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), stringsize.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn SetQuitLockStringWide<P0>(&self, string: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetQuitLockStringWide)(windows_core::Interface::as_raw(self), string.param().abi()).ok() }
    }
    pub unsafe fn SetEventContextCallbacks<P0>(&self, callbacks: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IDebugEventContextCallbacks>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetEventContextCallbacks)(windows_core::Interface::as_raw(self), callbacks.param().abi()).ok() }
    }
    pub unsafe fn SetClientContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetClientContext)(windows_core::Interface::as_raw(self), context, contextsize).ok() }
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDebugClient7_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AttachKernel: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptions: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub StartProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub DisconnectProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIds: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableName: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescription: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PSTR, u32, *mut u32, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub AttachProcess: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessA: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub GetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub AddProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub RemoveProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetProcessOptions: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub OpenDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub WriteDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub ConnectSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub StartServer: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub OutputServers: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub TerminateProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachProcesses: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndSession: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetExitCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub DispatchCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub ExitDispatch: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateClient: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOtherOutputMask: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOutputWidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentity: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FlushCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteDumpFile2: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32, u32, windows_core::PCSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, u32) -> windows_core::HRESULT,
    pub EndProcessServer: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WaitForProcessServerEnd: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub IsKernelDebuggerEnabled: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub TerminateCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub DetachCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AbandonCurrentProcess: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetRunningProcessSystemIdByExecutableNameWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub GetRunningProcessDescriptionWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, u32, u32, windows_core::PWSTR, u32, *mut u32, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub CreateProcessWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttachWide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, u32, u32, u32) -> windows_core::HRESULT,
    pub OpenDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64) -> windows_core::HRESULT,
    pub WriteDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub AddDumpInformationFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u64, u32) -> windows_core::HRESULT,
    pub GetNumberDumpFiles: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFile: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub GetDumpFileWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PWSTR, u32, *mut u32, *mut u64, *mut u32) -> windows_core::HRESULT,
    pub AttachKernelWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetKernelConnectionOptionsWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub StartProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, *const core::ffi::c_void) -> windows_core::HRESULT,
    pub ConnectProcessServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub StartServerWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub OutputServersWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    pub GetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetOutputCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub OutputIdentityWide: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetEventCallbacksWide: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreateProcess2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR) -> windows_core::HRESULT,
    pub CreateProcess2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCSTR, *const core::ffi::c_void, u32, windows_core::PCSTR, windows_core::PCSTR, u32, u32) -> windows_core::HRESULT,
    pub CreateProcessAndAttach2Wide: unsafe extern "system" fn(*mut core::ffi::c_void, u64, windows_core::PCWSTR, *const core::ffi::c_void, u32, windows_core::PCWSTR, windows_core::PCWSTR, u32, u32) -> windows_core::HRESULT,
    pub PushOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR, *mut u64) -> windows_core::HRESULT,
    pub PushOutputLinePrefixWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut u64) -> windows_core::HRESULT,
    pub PopOutputLinePrefix: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub GetNumberInputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberOutputCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNumberEventCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockString: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCSTR) -> windows_core::HRESULT,
    pub GetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, u32, *mut u32) -> windows_core::HRESULT,
    pub SetQuitLockStringWide: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub SetEventContextCallbacks: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetClientContext: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IDebugClient7_Impl: windows_core::IUnknownImpl {
    fn AttachKernel(&self, flags: u32, connectoptions: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptions(&self, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptions(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn StartProcessServer(&self, flags: u32, options: &windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServer(&self, remoteoptions: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn DisconnectProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIds(&self, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableName(&self, server: u64, exename: &windows_core::PCSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescription(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn AttachProcess(&self, server: u64, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessA(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach(&self, server: u64, commandline: &windows_core::PCSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn GetProcessOptions(&self) -> windows_core::Result<u32>;
    fn AddProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn RemoveProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn SetProcessOptions(&self, options: u32) -> windows_core::Result<()>;
    fn OpenDumpFile(&self, dumpfile: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn WriteDumpFile(&self, dumpfile: &windows_core::PCSTR, qualifier: u32) -> windows_core::Result<()>;
    fn ConnectSession(&self, flags: u32, historylimit: u32) -> windows_core::Result<()>;
    fn StartServer(&self, options: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn OutputServers(&self, outputcontrol: u32, machine: &windows_core::PCSTR, flags: u32) -> windows_core::Result<()>;
    fn TerminateProcesses(&self) -> windows_core::Result<()>;
    fn DetachProcesses(&self) -> windows_core::Result<()>;
    fn EndSession(&self, flags: u32) -> windows_core::Result<()>;
    fn GetExitCode(&self) -> windows_core::Result<u32>;
    fn DispatchCallbacks(&self, timeout: u32) -> windows_core::Result<()>;
    fn ExitDispatch(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<()>;
    fn CreateClient(&self) -> windows_core::Result<IDebugClient>;
    fn GetInputCallbacks(&self) -> windows_core::Result<IDebugInputCallbacks>;
    fn SetInputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugInputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputCallbacks(&self) -> windows_core::Result<IDebugOutputCallbacks>;
    fn SetOutputCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacks>) -> windows_core::Result<()>;
    fn GetOutputMask(&self) -> windows_core::Result<u32>;
    fn SetOutputMask(&self, mask: u32) -> windows_core::Result<()>;
    fn GetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>) -> windows_core::Result<u32>;
    fn SetOtherOutputMask(&self, client: windows_core::Ref<'_, IDebugClient>, mask: u32) -> windows_core::Result<()>;
    fn GetOutputWidth(&self) -> windows_core::Result<u32>;
    fn SetOutputWidth(&self, columns: u32) -> windows_core::Result<()>;
    fn GetOutputLinePrefix(&self, buffer: windows_core::PSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefix(&self, prefix: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetIdentity(&self, buffer: windows_core::PSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentity(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetEventCallbacks(&self) -> windows_core::Result<IDebugEventCallbacks>;
    fn SetEventCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacks>) -> windows_core::Result<()>;
    fn FlushCallbacks(&self) -> windows_core::Result<()>;
    fn WriteDumpFile2(&self, dumpfile: &windows_core::PCSTR, qualifier: u32, formatflags: u32, comment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFile(&self, infofile: &windows_core::PCSTR, r#type: u32) -> windows_core::Result<()>;
    fn EndProcessServer(&self, server: u64) -> windows_core::Result<()>;
    fn WaitForProcessServerEnd(&self, timeout: u32) -> windows_core::Result<()>;
    fn IsKernelDebuggerEnabled(&self) -> windows_core::Result<()>;
    fn TerminateCurrentProcess(&self) -> windows_core::Result<()>;
    fn DetachCurrentProcess(&self) -> windows_core::Result<()>;
    fn AbandonCurrentProcess(&self) -> windows_core::Result<()>;
    fn GetRunningProcessSystemIdByExecutableNameWide(&self, server: u64, exename: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<u32>;
    fn GetRunningProcessDescriptionWide(&self, server: u64, systemid: u32, flags: u32, exename: windows_core::PWSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PWSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::Result<()>;
    fn CreateProcessWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttachWide(&self, server: u64, commandline: &windows_core::PCWSTR, createflags: u32, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn OpenDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64) -> windows_core::Result<()>;
    fn WriteDumpFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, qualifier: u32, formatflags: u32, comment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn AddDumpInformationFileWide(&self, filename: &windows_core::PCWSTR, filehandle: u64, r#type: u32) -> windows_core::Result<()>;
    fn GetNumberDumpFiles(&self) -> windows_core::Result<u32>;
    fn GetDumpFile(&self, index: u32, buffer: windows_core::PSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn GetDumpFileWide(&self, index: u32, buffer: windows_core::PWSTR, buffersize: u32, namesize: *mut u32, handle: *mut u64, r#type: *mut u32) -> windows_core::Result<()>;
    fn AttachKernelWide(&self, flags: u32, connectoptions: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetKernelConnectionOptionsWide(&self, buffer: windows_core::PWSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::Result<()>;
    fn SetKernelConnectionOptionsWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn StartProcessServerWide(&self, flags: u32, options: &windows_core::PCWSTR, reserved: *const core::ffi::c_void) -> windows_core::Result<()>;
    fn ConnectProcessServerWide(&self, remoteoptions: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn StartServerWide(&self, options: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn OutputServersWide(&self, outputcontrol: u32, machine: &windows_core::PCWSTR, flags: u32) -> windows_core::Result<()>;
    fn GetOutputCallbacksWide(&self) -> windows_core::Result<IDebugOutputCallbacksWide>;
    fn SetOutputCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugOutputCallbacksWide>) -> windows_core::Result<()>;
    fn GetOutputLinePrefixWide(&self, buffer: windows_core::PWSTR, buffersize: u32, prefixsize: *mut u32) -> windows_core::Result<()>;
    fn SetOutputLinePrefixWide(&self, prefix: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetIdentityWide(&self, buffer: windows_core::PWSTR, buffersize: u32, identitysize: *mut u32) -> windows_core::Result<()>;
    fn OutputIdentityWide(&self, outputcontrol: u32, flags: u32, format: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetEventCallbacksWide(&self) -> windows_core::Result<IDebugEventCallbacksWide>;
    fn SetEventCallbacksWide(&self, callbacks: windows_core::Ref<'_, IDebugEventCallbacksWide>) -> windows_core::Result<()>;
    fn CreateProcess2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn CreateProcess2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2(&self, server: u64, commandline: &windows_core::PCSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCSTR, environment: &windows_core::PCSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn CreateProcessAndAttach2Wide(&self, server: u64, commandline: &windows_core::PCWSTR, optionsbuffer: *const core::ffi::c_void, optionsbuffersize: u32, initialdirectory: &windows_core::PCWSTR, environment: &windows_core::PCWSTR, processid: u32, attachflags: u32) -> windows_core::Result<()>;
    fn PushOutputLinePrefix(&self, newprefix: &windows_core::PCSTR) -> windows_core::Result<u64>;
    fn PushOutputLinePrefixWide(&self, newprefix: &windows_core::PCWSTR) -> windows_core::Result<u64>;
    fn PopOutputLinePrefix(&self, handle: u64) -> windows_core::Result<()>;
    fn GetNumberInputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberOutputCallbacks(&self) -> windows_core::Result<u32>;
    fn GetNumberEventCallbacks(&self, eventflags: u32) -> windows_core::Result<u32>;
    fn GetQuitLockString(&self, buffer: windows_core::PSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockString(&self, string: &windows_core::PCSTR) -> windows_core::Result<()>;
    fn GetQuitLockStringWide(&self, buffer: windows_core::PWSTR, buffersize: u32, stringsize: *mut u32) -> windows_core::Result<()>;
    fn SetQuitLockStringWide(&self, string: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn SetEventContextCallbacks(&self, callbacks: windows_core::Ref<'_, IDebugEventContextCallbacks>) -> windows_core::Result<()>;
    fn SetClientContext(&self, context: *const core::ffi::c_void, contextsize: u32) -> windows_core::Result<()>;
}
impl IDebugClient7_Vtbl {
    pub const fn new<Identity: IDebugClient7_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AttachKernel<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, connectoptions: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::AttachKernel(this, core::mem::transmute_copy(&flags), core::mem::transmute(&connectoptions)).into()
            }
        }
        unsafe extern "system" fn GetKernelConnectionOptions<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, buffer: windows_core::PSTR, buffersize: u32, optionssize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::GetKernelConnectionOptions(this, core::mem::transmute_copy(&buffer), core::mem::transmute_copy(&buffersize), core::mem::transmute_copy(&optionssize)).into()
            }
        }
        unsafe extern "system" fn SetKernelConnectionOptions<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, options: windows_core::PCSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::SetKernelConnectionOptions(this, core::mem::transmute(&options)).into()
            }
        }
        unsafe extern "system" fn StartProcessServer<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32, options: windows_core::PCSTR, reserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::StartProcessServer(this, core::mem::transmute_copy(&flags), core::mem::transmute(&options), core::mem::transmute_copy(&reserved)).into()
            }
        }
        unsafe extern "system" fn ConnectProcessServer<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, remoteoptions: windows_core::PCSTR, server: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient7_Impl::ConnectProcessServer(this, core::mem::transmute(&remoteoptions)) {
                    Ok(ok__) => {
                        server.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn DisconnectProcessServer<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::DisconnectProcessServer(this, core::mem::transmute_copy(&server)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIds<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, ids: *mut u32, count: u32, actualcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::GetRunningProcessSystemIds(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&ids), core::mem::transmute_copy(&count), core::mem::transmute_copy(&actualcount)).into()
            }
        }
        unsafe extern "system" fn GetRunningProcessSystemIdByExecutableName<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, exename: windows_core::PCSTR, flags: u32, id: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IDebugClient7_Impl::GetRunningProcessSystemIdByExecutableName(this, core::mem::transmute_copy(&server), core::mem::transmute(&exename), core::mem::transmute_copy(&flags)) {
                    Ok(ok__) => {
                        id.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetRunningProcessDescription<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, systemid: u32, flags: u32, exename: windows_core::PSTR, exenamesize: u32, actualexenamesize: *mut u32, description: windows_core::PSTR, descriptionsize: u32, actualdescriptionsize: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::GetRunningProcessDescription(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&systemid), core::mem::transmute_copy(&flags), core::mem::transmute_copy(&exename), core::mem::transmute_copy(&exenamesize), core::mem::transmute_copy(&actualexenamesize), core::mem::transmute_copy(&description), core::mem::transmute_copy(&descriptionsize), core::mem::transmute_copy(&actualdescriptionsize)).into()
            }
        }
        unsafe extern "system" fn AttachProcess<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, server: u64, processid: u32, attachflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IDebugClient7_Impl::AttachProcess(this, core::mem::transmute_copy(&server), core::mem::transmute_copy(&processid), core::mem::transmute_copy(&attachflags)).into()
            }
        }
        unsafe extern "system" fn CreateProcessA<Identity: IDebugClient7_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void