package localsearch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/localsearch"

// BasicAction defines an action.
type BasicAction interface {
	AsSearchAction() (*SearchAction, bool)
	AsAction() (*Action, bool)
}

// Action defines an action.
type Action struct {
	// Location - READ-ONLY
	Location *[]Place `json:"location,omitempty"`
	// Result - READ-ONLY; The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - READ-ONLY; A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - READ-ONLY; A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - READ-ONLY; Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - READ-ONLY; For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - READ-ONLY; For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Creator - READ-ONLY
	Creator BasicThing `json:"creator,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// DiscussionURL - READ-ONLY
	DiscussionURL *string `json:"discussionUrl,omitempty"`
	// CommentCount - READ-ONLY
	CommentCount *int32 `json:"commentCount,omitempty"`
	// MainEntity - READ-ONLY
	MainEntity BasicThing `json:"mainEntity,omitempty"`
	// HeadLine - READ-ONLY
	HeadLine *string `json:"headLine,omitempty"`
	// CopyrightHolder - READ-ONLY
	CopyrightHolder BasicThing `json:"copyrightHolder,omitempty"`
	// CopyrightYear - READ-ONLY
	CopyrightYear *int32 `json:"copyrightYear,omitempty"`
	// Disclaimer - READ-ONLY
	Disclaimer *string `json:"disclaimer,omitempty"`
	// IsAccessibleForFree - READ-ONLY
	IsAccessibleForFree *bool `json:"isAccessibleForFree,omitempty"`
	// Genre - READ-ONLY
	Genre *[]string `json:"genre,omitempty"`
	// IsFamilyFriendly - READ-ONLY
	IsFamilyFriendly *bool `json:"isFamilyFriendly,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicAction(body []byte) (BasicAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	default:
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActionArray(body []byte) ([]BasicAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Action.
func (a Action) MarshalJSON() ([]byte, error) {
	a.Type = TypeAction
	objectMap := make(map[string]interface{})
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Action.
func (a Action) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Action.
func (a Action) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsPlaces is the BasicResponseBase implementation for Action.
func (a Action) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Action.
func (a Action) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Action.
func (a Action) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Action.
func (a Action) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Action.
func (a Action) AsAction() (*Action, bool) {
	return &a, true
}

// AsBasicAction is the BasicResponseBase implementation for Action.
func (a Action) AsBasicAction() (BasicAction, bool) {
	return &a, true
}

// AsResponse is the BasicResponseBase implementation for Action.
func (a Action) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Action.
func (a Action) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Action.
func (a Action) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &a, true
}

// AsIntangible is the BasicResponseBase implementation for Action.
func (a Action) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Action.
func (a Action) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Action.
func (a Action) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Action.
func (a Action) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Action.
func (a Action) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Action struct.
func (a *Action) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location []Place
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				a.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				a.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				a.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				a.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				a.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				a.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				a.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				a.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				a.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				a.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				a.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				a.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				a.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				a.IsFamilyFriendly = &isFamilyFriendly
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				a.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				a.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				a.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				a.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				a.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	objectMap := make(map[string]interface{})
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Answer.
func (a Answer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Answer.
func (a Answer) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Answer.
func (a Answer) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Answer struct.
func (a *Answer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				a.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				a.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				a.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				a.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsSearchAction() (*SearchAction, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software
// programs, etc.
type CreativeWork struct {
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - READ-ONLY; For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - READ-ONLY; For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Creator - READ-ONLY
	Creator BasicThing `json:"creator,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// DiscussionURL - READ-ONLY
	DiscussionURL *string `json:"discussionUrl,omitempty"`
	// CommentCount - READ-ONLY
	CommentCount *int32 `json:"commentCount,omitempty"`
	// MainEntity - READ-ONLY
	MainEntity BasicThing `json:"mainEntity,omitempty"`
	// HeadLine - READ-ONLY
	HeadLine *string `json:"headLine,omitempty"`
	// CopyrightHolder - READ-ONLY
	CopyrightHolder BasicThing `json:"copyrightHolder,omitempty"`
	// CopyrightYear - READ-ONLY
	CopyrightYear *int32 `json:"copyrightYear,omitempty"`
	// Disclaimer - READ-ONLY
	Disclaimer *string `json:"disclaimer,omitempty"`
	// IsAccessibleForFree - READ-ONLY
	IsAccessibleForFree *bool `json:"isAccessibleForFree,omitempty"`
	// Genre - READ-ONLY
	Genre *[]string `json:"genre,omitempty"`
	// IsFamilyFriendly - READ-ONLY
	IsFamilyFriendly *bool `json:"isFamilyFriendly,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsPlaces is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				cw.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				cw.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				cw.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				cw.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				cw.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				cw.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				cw.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				cw.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				cw.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				cw.IsFamilyFriendly = &isFamilyFriendly
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cw.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				cw.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				cw.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				cw.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				cw.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				cw.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				cw.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// BasicEntitiesEntityPresentationInfo defines additional information about an entity such as type hints.
type BasicEntitiesEntityPresentationInfo interface {
	AsEntitiesEntityPresentationInfo() (*EntitiesEntityPresentationInfo, bool)
}

// EntitiesEntityPresentationInfo defines additional information about an entity such as type hints.
type EntitiesEntityPresentationInfo struct {
	// EntityScenario - The supported scenario. Possible values include: 'DominantEntity', 'DisambiguationItem', 'ListItem'
	EntityScenario EntityScenario `json:"entityScenario,omitempty"`
	// EntityTypeHints - READ-ONLY; A list of hints that indicate the entity's type. The list could contain a single hint such as Movie or a list of hints such as Place, LocalBusiness, Restaurant. Each successive hint in the array narrows the entity's type.
	EntityTypeHints *[]EntityType `json:"entityTypeHints,omitempty"`
	// EntityTypeDisplayHint - READ-ONLY; A display version of the entity hint. For example, if entityTypeHints is Artist, this field may be set to American Singer.
	EntityTypeDisplayHint *string `json:"entityTypeDisplayHint,omitempty"`
	// Query - READ-ONLY
	Query *string `json:"query,omitempty"`
	// EntitySubTypeHints - READ-ONLY
	EntitySubTypeHints *[]string `json:"entitySubTypeHints,omitempty"`
	// Type - Possible values include: 'TypeEntitiesEntityPresentationInfo'
	Type TypeBasicEntitiesEntityPresentationInfo `json:"_type,omitempty"`
}

func unmarshalBasicEntitiesEntityPresentationInfo(body []byte) (BasicEntitiesEntityPresentationInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var eepi EntitiesEntityPresentationInfo
		err := json.Unmarshal(body, &eepi)
		return eepi, err
	}
}
func unmarshalBasicEntitiesEntityPresentationInfoArray(body []byte) ([]BasicEntitiesEntityPresentationInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eepiArray := make([]BasicEntitiesEntityPresentationInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eepi, err := unmarshalBasicEntitiesEntityPresentationInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		eepiArray[index] = eepi
	}
	return eepiArray, nil
}

// MarshalJSON is the custom marshaler for EntitiesEntityPresentationInfo.
func (eepi EntitiesEntityPresentationInfo) MarshalJSON() ([]byte, error) {
	eepi.Type = TypeEntitiesEntityPresentationInfo
	objectMap := make(map[string]interface{})
	if eepi.EntityScenario != "" {
		objectMap["entityScenario"] = eepi.EntityScenario
	}
	if eepi.Type != "" {
		objectMap["_type"] = eepi.Type
	}
	return json.Marshal(objectMap)
}

// AsEntitiesEntityPresentationInfo is the BasicEntitiesEntityPresentationInfo implementation for EntitiesEntityPresentationInfo.
func (eepi EntitiesEntityPresentationInfo) AsEntitiesEntityPresentationInfo() (*EntitiesEntityPresentationInfo, bool) {
	return &eepi, true
}

// AsBasicEntitiesEntityPresentationInfo is the BasicEntitiesEntityPresentationInfo implementation for EntitiesEntityPresentationInfo.
func (eepi EntitiesEntityPresentationInfo) AsBasicEntitiesEntityPresentationInfo() (BasicEntitiesEntityPresentationInfo, bool) {
	return &eepi, true
}

// BasicError defines the error that occurred.
type BasicError interface {
	AsError() (*Error, bool)
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - READ-ONLY; The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - READ-ONLY; A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - READ-ONLY; The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - READ-ONLY; The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
	// Type - Possible values include: 'TypeError'
	Type TypeBasicError `json:"_type,omitempty"`
}

func unmarshalBasicError(body []byte) (BasicError, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var e Error
		err := json.Unmarshal(body, &e)
		return e, err
	}
}
func unmarshalBasicErrorArray(body []byte) ([]BasicError, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eArray := make([]BasicError, len(rawMessages))

	for index, rawMessage := range rawMessages {
		e, err := unmarshalBasicError(*rawMessage)
		if err != nil {
			return nil, err
		}
		eArray[index] = e
	}
	return eArray, nil
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	e.Type = TypeError
	objectMap := make(map[string]interface{})
	if e.Code != "" {
		objectMap["code"] = e.Code
	}
	if e.Message != nil {
		objectMap["message"] = e.Message
	}
	if e.Type != "" {
		objectMap["_type"] = e.Type
	}
	return json.Marshal(objectMap)
}

// AsError is the BasicError implementation for Error.
func (e Error) AsError() (*Error, bool) {
	return &e, true
}

// AsBasicError is the BasicError implementation for Error.
func (e Error) AsBasicError() (BasicError, bool) {
	return &e, true
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]BasicError `json:"errors,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "errors":
			if v != nil {
				errorsVar, err := unmarshalBasicErrorArray(*v)
				if err != nil {
					return err
				}
				er.Errors = &errorsVar
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				er.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				er.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				er.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				er.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				er.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				er.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				er.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				er.Type = typeVar
			}
		}
	}

	return nil
}

// BasicGeoCoordinates ...
type BasicGeoCoordinates interface {
	AsGeoCoordinates() (*GeoCoordinates, bool)
}

// GeoCoordinates ...
type GeoCoordinates struct {
	Latitude  *float64 `json:"latitude,omitempty"`
	Longitude *float64 `json:"longitude,omitempty"`
	// Elevation - READ-ONLY
	Elevation *float64 `json:"elevation,omitempty"`
	// Type - Possible values include: 'TypeGeoCoordinates'
	Type TypeBasicGeoCoordinates `json:"_type,omitempty"`
}

func unmarshalBasicGeoCoordinates(body []byte) (BasicGeoCoordinates, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var gc GeoCoordinates
		err := json.Unmarshal(body, &gc)
		return gc, err
	}
}
func unmarshalBasicGeoCoordinatesArray(body []byte) ([]BasicGeoCoordinates, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	gcArray := make([]BasicGeoCoordinates, len(rawMessages))

	for index, rawMessage := range rawMessages {
		gc, err := unmarshalBasicGeoCoordinates(*rawMessage)
		if err != nil {
			return nil, err
		}
		gcArray[index] = gc
	}
	return gcArray, nil
}

// MarshalJSON is the custom marshaler for GeoCoordinates.
func (gc GeoCoordinates) MarshalJSON() ([]byte, error) {
	gc.Type = TypeGeoCoordinates
	objectMap := make(map[string]interface{})
	if gc.Latitude != nil {
		objectMap["latitude"] = gc.Latitude
	}
	if gc.Longitude != nil {
		objectMap["longitude"] = gc.Longitude
	}
	if gc.Type != "" {
		objectMap["_type"] = gc.Type
	}
	return json.Marshal(objectMap)
}

// AsGeoCoordinates is the BasicGeoCoordinates implementation for GeoCoordinates.
func (gc GeoCoordinates) AsGeoCoordinates() (*GeoCoordinates, bool) {
	return &gc, true
}

// AsBasicGeoCoordinates is the BasicGeoCoordinates implementation for GeoCoordinates.
func (gc GeoCoordinates) AsBasicGeoCoordinates() (BasicGeoCoordinates, bool) {
	return &gc, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsSearchAction() (*SearchAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicIntangible a utility class that serves as the umbrella for a number of 'intangible' things such as quantities,
// structured values, etc.
type BasicIntangible interface {
	AsPostalAddress() (*PostalAddress, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIntangible() (*Intangible, bool)
}

// Intangible a utility class that serves as the umbrella for a number of 'intangible' things such as
// quantities, structured values, etc.
type Intangible struct {
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicIntangible(body []byte) (BasicIntangible, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIntangibleArray(body []byte) ([]BasicIntangible, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIntangible, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIntangible(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Intangible.
func (i Intangible) MarshalJSON() ([]byte, error) {
	i.Type = TypeIntangible
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicThing() (BasicThing, bool) {
	return &i, true
}

// AsPlaces is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIntangible() (*Intangible, bool) {
	return &i, true
}

// AsBasicIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIntangible() (BasicIntangible, bool) {
	return &i, true
}

// AsSearchAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// UnmarshalJSON is the custom unmarshaler for Intangible struct.
func (i *Intangible) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				i.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				i.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				i.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				i.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				i.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				i.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				i.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				i.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = typeVar
			}
		}
	}

	return nil
}

// Place defines information about a local entity, such as a restaurant or hotel.
type Place struct {
	// Geo - READ-ONLY
	Geo BasicGeoCoordinates `json:"geo,omitempty"`
	// RoutablePoint - READ-ONLY
	RoutablePoint BasicGeoCoordinates `json:"routablePoint,omitempty"`
	// Address - READ-ONLY; The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - READ-ONLY; The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Place.
func (p Place) MarshalJSON() ([]byte, error) {
	p.Type = TypePlace
	objectMap := make(map[string]interface{})
	if p.Type != "" {
		objectMap["_type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Place.
func (p Place) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Place.
func (p Place) AsBasicThing() (BasicThing, bool) {
	return &p, true
}

// AsPlaces is the BasicResponseBase implementation for Place.
func (p Place) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Place.
func (p Place) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Place.
func (p Place) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Place.
func (p Place) AsPlace() (*Place, bool) {
	return &p, true
}

// AsAction is the BasicResponseBase implementation for Place.
func (p Place) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Place.
func (p Place) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Place.
func (p Place) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Place.
func (p Place) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsIdentifiable is the BasicResponseBase implementation for Place.
func (p Place) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Place.
func (p Place) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Place.
func (p Place) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Place.
func (p Place) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Place.
func (p Place) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Place.
func (p Place) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Place.
func (p Place) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Place.
func (p Place) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Place.
func (p Place) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Place.
func (p Place) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Place.
func (p Place) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Place.
func (p Place) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Place struct.
func (p *Place) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "geo":
			if v != nil {
				geo, err := unmarshalBasicGeoCoordinates(*v)
				if err != nil {
					return err
				}
				p.Geo = geo
			}
		case "routablePoint":
			if v != nil {
				routablePoint, err := unmarshalBasicGeoCoordinates(*v)
				if err != nil {
					return err
				}
				p.RoutablePoint = routablePoint
			}
		case "address":
			if v != nil {
				var address PostalAddress
				err = json.Unmarshal(*v, &address)
				if err != nil {
					return err
				}
				p.Address = &address
			}
		case "telephone":
			if v != nil {
				var telephone string
				err = json.Unmarshal(*v, &telephone)
				if err != nil {
					return err
				}
				p.Telephone = &telephone
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				p.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				p.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				p.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				p.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				p.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				p.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				p.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				p.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = typeVar
			}
		}
	}

	return nil
}

// Places defines a local entity answer.
type Places struct {
	// Value - A list of local entities, such as restaurants or hotels.
	Value *[]BasicThing `json:"value,omitempty"`
	// QueryContext - READ-ONLY
	QueryContext BasicQueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - READ-ONLY; The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// IsFamilyFriendly - READ-ONLY
	IsFamilyFriendly *bool `json:"isFamilyFriendly,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Places.
func (p Places) MarshalJSON() ([]byte, error) {
	p.Type = TypePlaces
	objectMap := make(map[string]interface{})
	if p.Value != nil {
		objectMap["value"] = p.Value
	}
	if p.Type != "" {
		objectMap["_type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Places.
func (p Places) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Places.
func (p Places) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Places.
func (p Places) AsPlaces() (*Places, bool) {
	return &p, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &p, true
}

// AsSearchResponse is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Places.
func (p Places) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Places.
func (p Places) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Places.
func (p Places) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Places.
func (p Places) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Places.
func (p Places) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicAnswer() (BasicAnswer, bool) {
	return &p, true
}

// AsErrorResponse is the BasicResponseBase implementation for Places.
func (p Places) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Places.
func (p Places) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Places.
func (p Places) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Places.
func (p Places) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Places struct.
func (p *Places) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				p.Value = &value
			}
		case "queryContext":
			if v != nil {
				queryContext, err := unmarshalBasicQueryContext(*v)
				if err != nil {
					return err
				}
				p.QueryContext = queryContext
			}
		case "totalEstimatedMatches":
			if v != nil {
				var totalEstimatedMatches int64
				err = json.Unmarshal(*v, &totalEstimatedMatches)
				if err != nil {
					return err
				}
				p.TotalEstimatedMatches = &totalEstimatedMatches
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				p.IsFamilyFriendly = &isFamilyFriendly
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				p.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				p.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				p.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				p.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				p.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				p.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = typeVar
			}
		}
	}

	return nil
}

// PostalAddress defines a postal address.
type PostalAddress struct {
	// StreetAddress - READ-ONLY
	StreetAddress *string `json:"streetAddress,omitempty"`
	// AddressLocality - READ-ONLY; The city where the street address is located. For example, Seattle.
	AddressLocality *string `json:"addressLocality,omitempty"`
	// AddressSubregion - READ-ONLY
	AddressSubregion *string `json:"addressSubregion,omitempty"`
	// AddressRegion - READ-ONLY; The state or province code where the street address is located. This could be the two-letter code. For example, WA, or the full name , Washington.
	AddressRegion *string `json:"addressRegion,omitempty"`
	// PostalCode - READ-ONLY; The zip code or postal code where the street address is located. For example, 98052.
	PostalCode *string `json:"postalCode,omitempty"`
	// PostOfficeBoxNumber - READ-ONLY
	PostOfficeBoxNumber *string `json:"postOfficeBoxNumber,omitempty"`
	// AddressCountry - READ-ONLY; The country/region where the street address is located. This could be the two-letter ISO code. For example, US, or the full name, United States.
	AddressCountry *string `json:"addressCountry,omitempty"`
	// CountryIso - READ-ONLY; The two letter ISO code of this country. For example, US.
	CountryIso *string `json:"countryIso,omitempty"`
	// Neighborhood - READ-ONLY; The neighborhood where the street address is located. For example, Westlake.
	Neighborhood *string `json:"neighborhood,omitempty"`
	// AddressRegionAbbreviation - READ-ONLY; Region Abbreviation. For example, WA.
	AddressRegionAbbreviation *string `json:"addressRegionAbbreviation,omitempty"`
	// Text - READ-ONLY; The complete address. For example, 2100 Westlake Ave N, Bellevue, WA 98052.
	Text *string `json:"text,omitempty"`
	// HouseNumber - READ-ONLY
	HouseNumber *string `json:"houseNumber,omitempty"`
	// StreetName - READ-ONLY
	StreetName *string `json:"streetName,omitempty"`
	// FormattingRuleID - READ-ONLY
	FormattingRuleID *string `json:"formattingRuleId,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for PostalAddress.
func (pa PostalAddress) MarshalJSON() ([]byte, error) {
	pa.Type = TypePostalAddress
	objectMap := make(map[string]interface{})
	if pa.Type != "" {
		objectMap["_type"] = pa.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicThing() (BasicThing, bool) {
	return &pa, true
}

// AsPlaces is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPostalAddress() (*PostalAddress, bool) {
	return &pa, true
}

// AsPlace is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicResponse() (BasicResponse, bool) {
	return &pa, true
}

// AsIdentifiable is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &pa, true
}

// AsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicIntangible() (BasicIntangible, bool) {
	return &pa, true
}

// AsSearchAction is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &pa, true
}

// AsResponseBase is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &pa, true
}

// UnmarshalJSON is the custom unmarshaler for PostalAddress struct.
func (pa *PostalAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "streetAddress":
			if v != nil {
				var streetAddress string
				err = json.Unmarshal(*v, &streetAddress)
				if err != nil {
					return err
				}
				pa.StreetAddress = &streetAddress
			}
		case "addressLocality":
			if v != nil {
				var addressLocality string
				err = json.Unmarshal(*v, &addressLocality)
				if err != nil {
					return err
				}
				pa.AddressLocality = &addressLocality
			}
		case "addressSubregion":
			if v != nil {
				var addressSubregion string
				err = json.Unmarshal(*v, &addressSubregion)
				if err != nil {
					return err
				}
				pa.AddressSubregion = &addressSubregion
			}
		case "addressRegion":
			if v != nil {
				var addressRegion string
				err = json.Unmarshal(*v, &addressRegion)
				if err != nil {
					return err
				}
				pa.AddressRegion = &addressRegion
			}
		case "postalCode":
			if v != nil {
				var postalCode string
				err = json.Unmarshal(*v, &postalCode)
				if err != nil {
					return err
				}
				pa.PostalCode = &postalCode
			}
		case "postOfficeBoxNumber":
			if v != nil {
				var postOfficeBoxNumber string
				err = json.Unmarshal(*v, &postOfficeBoxNumber)
				if err != nil {
					return err
				}
				pa.PostOfficeBoxNumber = &postOfficeBoxNumber
			}
		case "addressCountry":
			if v != nil {
				var addressCountry string
				err = json.Unmarshal(*v, &addressCountry)
				if err != nil {
					return err
				}
				pa.AddressCountry = &addressCountry
			}
		case "countryIso":
			if v != nil {
				var countryIso string
				err = json.Unmarshal(*v, &countryIso)
				if err != nil {
					return err
				}
				pa.CountryIso = &countryIso
			}
		case "neighborhood":
			if v != nil {
				var neighborhood string
				err = json.Unmarshal(*v, &neighborhood)
				if err != nil {
					return err
				}
				pa.Neighborhood = &neighborhood
			}
		case "addressRegionAbbreviation":
			if v != nil {
				var addressRegionAbbreviation string
				err = json.Unmarshal(*v, &addressRegionAbbreviation)
				if err != nil {
					return err
				}
				pa.AddressRegionAbbreviation = &addressRegionAbbreviation
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				pa.Text = &textVar
			}
		case "houseNumber":
			if v != nil {
				var houseNumber string
				err = json.Unmarshal(*v, &houseNumber)
				if err != nil {
					return err
				}
				pa.HouseNumber = &houseNumber
			}
		case "streetName":
			if v != nil {
				var streetName string
				err = json.Unmarshal(*v, &streetName)
				if err != nil {
					return err
				}
				pa.StreetName = &streetName
			}
		case "formattingRuleId":
			if v != nil {
				var formattingRuleID string
				err = json.Unmarshal(*v, &formattingRuleID)
				if err != nil {
					return err
				}
				pa.FormattingRuleID = &formattingRuleID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pa.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				pa.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				pa.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				pa.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				pa.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				pa.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				pa.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				pa.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				pa.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pa.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pa.Type = typeVar
			}
		}
	}

	return nil
}

// BasicQueryContext defines the query context that Bing used for the request.
type BasicQueryContext interface {
	AsQueryContext() (*QueryContext, bool)
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - READ-ONLY; The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationDisplayQuery - READ-ONLY; AlteredQuery that is formatted for display purpose. The query string in the AlterationDisplayQuery can be html-escaped and can contain hit-highlighting characters
	AlterationDisplayQuery *string `json:"alterationDisplayQuery,omitempty"`
	// AlterationOverrideQuery - READ-ONLY; The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - READ-ONLY; A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
	// AskUserForLocation - READ-ONLY; A Boolean value that indicates whether Bing requires the user's location to provide accurate results. If you specified the user's location by using the X-MSEdge-ClientIP and X-Search-Location headers, you can ignore this field. For location aware queries, such as "today's weather" or "restaurants near me" that need the user's location to provide accurate results, this field is set to true. For location aware queries that include the location (for example, "Seattle weather"), this field is set to false. This field is also set to false for queries that are not location aware, such as "best sellers".
	AskUserForLocation *bool `json:"askUserForLocation,omitempty"`
	// IsTransactional - READ-ONLY
	IsTransactional *bool `json:"isTransactional,omitempty"`
	// Type - Possible values include: 'TypeQueryContext'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicQueryContext(body []byte) (BasicQueryContext, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	default:
		var qc QueryContext
		err := json.Unmarshal(body, &qc)
		return qc, err
	}
}
func unmarshalBasicQueryContextArray(body []byte) ([]BasicQueryContext, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	qcArray := make([]BasicQueryContext, len(rawMessages))

	for index, rawMessage := range rawMessages {
		qc, err := unmarshalBasicQueryContext(*rawMessage)
		if err != nil {
			return nil, err
		}
		qcArray[index] = qc
	}
	return qcArray, nil
}

// MarshalJSON is the custom marshaler for QueryContext.
func (qc QueryContext) MarshalJSON() ([]byte, error) {
	qc.Type = TypeQueryContext
	objectMap := make(map[string]interface{})
	if qc.OriginalQuery != nil {
		objectMap["originalQuery"] = qc.OriginalQuery
	}
	if qc.Type != "" {
		objectMap["_type"] = qc.Type
	}
	return json.Marshal(objectMap)
}

// AsQueryContext is the BasicQueryContext implementation for QueryContext.
func (qc QueryContext) AsQueryContext() (*QueryContext, bool) {
	return &qc, true
}

// AsBasicQueryContext is the BasicQueryContext implementation for QueryContext.
func (qc QueryContext) AsBasicQueryContext() (BasicQueryContext, bool) {
	return &qc, true
}

// BasicResponse defines a response. All schemas that return at the root of the response must inherit from this object.
type BasicResponse interface {
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsSearchAction() (*SearchAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that return at the root of the response must inherit from this
// object.
type Response struct {
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Response.
func (r Response) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Response.
func (r Response) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Response.
func (r Response) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Response.
func (r Response) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Response.
func (r Response) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Response struct.
func (r *Response) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				r.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				r.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				r.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				r.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				r.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				r.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = typeVar
			}
		}
	}

	return nil
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsSearchAction() (*SearchAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// SearchAction ...
type SearchAction struct {
	// DisplayText - READ-ONLY
	DisplayText *string `json:"displayText,omitempty"`
	// Query - READ-ONLY
	Query *string `json:"query,omitempty"`
	// RichContent - READ-ONLY
	RichContent *[]BasicAnswer `json:"richContent,omitempty"`
	// FormattingRuleID - READ-ONLY
	FormattingRuleID *string `json:"formattingRuleId,omitempty"`
	// Location - READ-ONLY
	Location *[]Place `json:"location,omitempty"`
	// Result - READ-ONLY; The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - READ-ONLY; A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - READ-ONLY; A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - READ-ONLY; Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - READ-ONLY; The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// About - READ-ONLY; For internal use only.
	About *[]BasicThing `json:"about,omitempty"`
	// Mentions - READ-ONLY; For internal use only.
	Mentions *[]BasicThing `json:"mentions,omitempty"`
	// Provider - READ-ONLY; The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Creator - READ-ONLY
	Creator BasicThing `json:"creator,omitempty"`
	// Text - READ-ONLY; Text content of this creative work
	Text *string `json:"text,omitempty"`
	// DiscussionURL - READ-ONLY
	DiscussionURL *string `json:"discussionUrl,omitempty"`
	// CommentCount - READ-ONLY
	CommentCount *int32 `json:"commentCount,omitempty"`
	// MainEntity - READ-ONLY
	MainEntity BasicThing `json:"mainEntity,omitempty"`
	// HeadLine - READ-ONLY
	HeadLine *string `json:"headLine,omitempty"`
	// CopyrightHolder - READ-ONLY
	CopyrightHolder BasicThing `json:"copyrightHolder,omitempty"`
	// CopyrightYear - READ-ONLY
	CopyrightYear *int32 `json:"copyrightYear,omitempty"`
	// Disclaimer - READ-ONLY
	Disclaimer *string `json:"disclaimer,omitempty"`
	// IsAccessibleForFree - READ-ONLY
	IsAccessibleForFree *bool `json:"isAccessibleForFree,omitempty"`
	// Genre - READ-ONLY
	Genre *[]string `json:"genre,omitempty"`
	// IsFamilyFriendly - READ-ONLY
	IsFamilyFriendly *bool `json:"isFamilyFriendly,omitempty"`
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchAction.
func (sa SearchAction) MarshalJSON() ([]byte, error) {
	sa.Type = TypeSearchAction
	objectMap := make(map[string]interface{})
	if sa.Type != "" {
		objectMap["_type"] = sa.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicThing() (BasicThing, bool) {
	return &sa, true
}

// AsPlaces is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicAction() (BasicAction, bool) {
	return &sa, true
}

// AsResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicResponse() (BasicResponse, bool) {
	return &sa, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sa, true
}

// AsAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &sa, true
}

// AsIntangible is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsSearchAction() (*SearchAction, bool) {
	return &sa, true
}

// AsStructuredValue is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchAction.
func (sa SearchAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sa, true
}

// UnmarshalJSON is the custom unmarshaler for SearchAction struct.
func (sa *SearchAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayText":
			if v != nil {
				var displayText string
				err = json.Unmarshal(*v, &displayText)
				if err != nil {
					return err
				}
				sa.DisplayText = &displayText
			}
		case "query":
			if v != nil {
				var query string
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				sa.Query = &query
			}
		case "richContent":
			if v != nil {
				richContent, err := unmarshalBasicAnswerArray(*v)
				if err != nil {
					return err
				}
				sa.RichContent = &richContent
			}
		case "formattingRuleId":
			if v != nil {
				var formattingRuleID string
				err = json.Unmarshal(*v, &formattingRuleID)
				if err != nil {
					return err
				}
				sa.FormattingRuleID = &formattingRuleID
			}
		case "location":
			if v != nil {
				var location []Place
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sa.Location = &location
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sa.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				sa.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				sa.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				sa.ThumbnailURL = &thumbnailURL
			}
		case "about":
			if v != nil {
				about, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.About = &about
			}
		case "mentions":
			if v != nil {
				mentions, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Mentions = &mentions
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				sa.Provider = &provider
			}
		case "creator":
			if v != nil {
				creator, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.Creator = creator
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				sa.Text = &textVar
			}
		case "discussionUrl":
			if v != nil {
				var discussionURL string
				err = json.Unmarshal(*v, &discussionURL)
				if err != nil {
					return err
				}
				sa.DiscussionURL = &discussionURL
			}
		case "commentCount":
			if v != nil {
				var commentCount int32
				err = json.Unmarshal(*v, &commentCount)
				if err != nil {
					return err
				}
				sa.CommentCount = &commentCount
			}
		case "mainEntity":
			if v != nil {
				mainEntity, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.MainEntity = mainEntity
			}
		case "headLine":
			if v != nil {
				var headLine string
				err = json.Unmarshal(*v, &headLine)
				if err != nil {
					return err
				}
				sa.HeadLine = &headLine
			}
		case "copyrightHolder":
			if v != nil {
				copyrightHolder, err := unmarshalBasicThing(*v)
				if err != nil {
					return err
				}
				sa.CopyrightHolder = copyrightHolder
			}
		case "copyrightYear":
			if v != nil {
				var copyrightYear int32
				err = json.Unmarshal(*v, &copyrightYear)
				if err != nil {
					return err
				}
				sa.CopyrightYear = &copyrightYear
			}
		case "disclaimer":
			if v != nil {
				var disclaimer string
				err = json.Unmarshal(*v, &disclaimer)
				if err != nil {
					return err
				}
				sa.Disclaimer = &disclaimer
			}
		case "isAccessibleForFree":
			if v != nil {
				var isAccessibleForFree bool
				err = json.Unmarshal(*v, &isAccessibleForFree)
				if err != nil {
					return err
				}
				sa.IsAccessibleForFree = &isAccessibleForFree
			}
		case "genre":
			if v != nil {
				var genre []string
				err = json.Unmarshal(*v, &genre)
				if err != nil {
					return err
				}
				sa.Genre = &genre
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				sa.IsFamilyFriendly = &isFamilyFriendly
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				sa.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				sa.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sa.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sa.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sa.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sa.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sa.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sa.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = typeVar
			}
		}
	}

	return nil
}

// SearchResponse defines the top-level object that the response includes when the request succeeds.
type SearchResponse struct {
	autorest.Response `json:"-"`
	// QueryContext - READ-ONLY; An object that contains the query string that Bing used for the request. This object contains the query string as entered by the user. It may also contain an altered query string that Bing used for the query if the query string contained a spelling mistake.
	QueryContext BasicQueryContext `json:"queryContext,omitempty"`
	// Places - READ-ONLY; A list of local entities such as restaurants or hotels that are relevant to the query.
	Places *Places `json:"places,omitempty"`
	// Lottery - READ-ONLY
	Lottery BasicSearchResultsAnswer `json:"lottery,omitempty"`
	// SearchResultsConfidenceScore - READ-ONLY
	SearchResultsConfidenceScore *float64 `json:"searchResultsConfidenceScore,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchResponse.
func (sr SearchResponse) MarshalJSON() ([]byte, error) {
	sr.Type = TypeSearchResponse
	objectMap := make(map[string]interface{})
	if sr.Type != "" {
		objectMap["_type"] = sr.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResponse() (*SearchResponse, bool) {
	return &sr, true
}

// AsPostalAddress is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponse() (BasicResponse, bool) {
	return &sr, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sr, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sr, true
}

// UnmarshalJSON is the custom unmarshaler for SearchResponse struct.
func (sr *SearchResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "queryContext":
			if v != nil {
				queryContext, err := unmarshalBasicQueryContext(*v)
				if err != nil {
					return err
				}
				sr.QueryContext = queryContext
			}
		case "places":
			if v != nil {
				var places Places
				err = json.Unmarshal(*v, &places)
				if err != nil {
					return err
				}
				sr.Places = &places
			}
		case "lottery":
			if v != nil {
				lottery, err := unmarshalBasicSearchResultsAnswer(*v)
				if err != nil {
					return err
				}
				sr.Lottery = lottery
			}
		case "searchResultsConfidenceScore":
			if v != nil {
				var searchResultsConfidenceScore float64
				err = json.Unmarshal(*v, &searchResultsConfidenceScore)
				if err != nil {
					return err
				}
				sr.SearchResultsConfidenceScore = &searchResultsConfidenceScore
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sr.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sr.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sr.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sr.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sr.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sr.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = typeVar
			}
		}
	}

	return nil
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	// QueryContext - READ-ONLY
	QueryContext BasicQueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - READ-ONLY; The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// IsFamilyFriendly - READ-ONLY
	IsFamilyFriendly *bool `json:"isFamilyFriendly,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	objectMap := make(map[string]interface{})
	if sra.Type != "" {
		objectMap["_type"] = sra.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// UnmarshalJSON is the custom unmarshaler for SearchResultsAnswer struct.
func (sra *SearchResultsAnswer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "queryContext":
			if v != nil {
				queryContext, err := unmarshalBasicQueryContext(*v)
				if err != nil {
					return err
				}
				sra.QueryContext = queryContext
			}
		case "totalEstimatedMatches":
			if v != nil {
				var totalEstimatedMatches int64
				err = json.Unmarshal(*v, &totalEstimatedMatches)
				if err != nil {
					return err
				}
				sra.TotalEstimatedMatches = &totalEstimatedMatches
			}
		case "isFamilyFriendly":
			if v != nil {
				var isFamilyFriendly bool
				err = json.Unmarshal(*v, &isFamilyFriendly)
				if err != nil {
					return err
				}
				sra.IsFamilyFriendly = &isFamilyFriendly
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sra.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sra.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sra.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sra.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sra.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sra.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sra.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sra.Type = typeVar
			}
		}
	}

	return nil
}

// BasicStructuredValue ...
type BasicStructuredValue interface {
	AsPostalAddress() (*PostalAddress, bool)
	AsStructuredValue() (*StructuredValue, bool)
}

// StructuredValue ...
type StructuredValue struct {
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicStructuredValue(body []byte) (BasicStructuredValue, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	default:
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	}
}
func unmarshalBasicStructuredValueArray(body []byte) ([]BasicStructuredValue, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	svArray := make([]BasicStructuredValue, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sv, err := unmarshalBasicStructuredValue(*rawMessage)
		if err != nil {
			return nil, err
		}
		svArray[index] = sv
	}
	return svArray, nil
}

// MarshalJSON is the custom marshaler for StructuredValue.
func (sv StructuredValue) MarshalJSON() ([]byte, error) {
	sv.Type = TypeStructuredValue
	objectMap := make(map[string]interface{})
	if sv.Type != "" {
		objectMap["_type"] = sv.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicThing() (BasicThing, bool) {
	return &sv, true
}

// AsPlaces is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponse() (BasicResponse, bool) {
	return &sv, true
}

// AsIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sv, true
}

// AsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIntangible() (BasicIntangible, bool) {
	return &sv, true
}

// AsSearchAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsStructuredValue() (*StructuredValue, bool) {
	return &sv, true
}

// AsBasicStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &sv, true
}

// AsResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sv, true
}

// UnmarshalJSON is the custom unmarshaler for StructuredValue struct.
func (sv *StructuredValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sv.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				sv.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				sv.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				sv.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				sv.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sv.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				sv.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				sv.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				sv.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sv.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sv.Type = typeVar
			}
		}
	}

	return nil
}

// BasicThing defines a thing.
type BasicThing interface {
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsSearchAction() (*SearchAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Name - READ-ONLY; The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - READ-ONLY; The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// EntityPresentationInfo - READ-ONLY; Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo BasicEntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// ReadLink - READ-ONLY; The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - READ-ONLY; The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// PotentialAction - READ-ONLY
	PotentialAction *[]BasicAction `json:"potentialAction,omitempty"`
	// ImmediateAction - READ-ONLY
	ImmediateAction *[]BasicAction `json:"immediateAction,omitempty"`
	// PreferredClickthroughURL - READ-ONLY
	PreferredClickthroughURL *string `json:"preferredClickthroughUrl,omitempty"`
	// AdaptiveCard - READ-ONLY
	AdaptiveCard *string `json:"adaptiveCard,omitempty"`
	// ID - READ-ONLY; A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeThing', 'TypePlaces', 'TypeSearchResultsAnswer', 'TypeSearchResponse', 'TypePostalAddress', 'TypePlace', 'TypeAction', 'TypeResponse', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypeCreativeWork', 'TypeIntangible', 'TypeSearchAction', 'TypeStructuredValue'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchAction):
		var sa SearchAction
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsPlaces is the BasicResponseBase implementation for Thing.
func (t Thing) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Thing.
func (t Thing) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Thing.
func (t Thing) AsPlace() (*Place, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsSearchAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchAction() (*SearchAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// UnmarshalJSON is the custom unmarshaler for Thing struct.
func (t *Thing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				t.URL = &URL
			}
		case "entityPresentationInfo":
			if v != nil {
				entityPresentationInfo, err := unmarshalBasicEntitiesEntityPresentationInfo(*v)
				if err != nil {
					return err
				}
				t.EntityPresentationInfo = entityPresentationInfo
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				t.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				t.WebSearchURL = &webSearchURL
			}
		case "potentialAction":
			if v != nil {
				potentialAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				t.PotentialAction = &potentialAction
			}
		case "immediateAction":
			if v != nil {
				immediateAction, err := unmarshalBasicActionArray(*v)
				if err != nil {
					return err
				}
				t.ImmediateAction = &immediateAction
			}
		case "preferredClickthroughUrl":
			if v != nil {
				var preferredClickthroughURL string
				err = json.Unmarshal(*v, &preferredClickthroughURL)
				if err != nil {
					return err
				}
				t.PreferredClickthroughURL = &preferredClickthroughURL
			}
		case "adaptiveCard":
			if v != nil {
				var adaptiveCard string
				err = json.Unmarshal(*v, &adaptiveCard)
				if err != nil {
					return err
				}
				t.AdaptiveCard = &adaptiveCard
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar TypeBasicResponseBase
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = typeVar
			}
		}
	}

	return nil
}
