package policy

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VariablesClient is the client for the Variables methods of the Policy service.
type VariablesClient struct {
	BaseClient
}

// NewVariablesClient creates an instance of the VariablesClient client.
func NewVariablesClient(subscriptionID string) VariablesClient {
	return NewVariablesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVariablesClientWithBaseURI creates an instance of the VariablesClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVariablesClientWithBaseURI(baseURI string, subscriptionID string) VariablesClient {
	return VariablesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate this operation creates or updates a variable with the given subscription and name. Policy variables
// can only be used by a policy definition at the scope they are created or below.
// Parameters:
// variableName - the name of the variable to operate on.
// parameters - parameters for the variable.
func (client VariablesClient) CreateOrUpdate(ctx context.Context, variableName string, parameters Variable) (result Variable, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.VariableProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.VariableProperties.Columns", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policy.VariablesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, variableName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VariablesClient) CreateOrUpdatePreparer(ctx context.Context, variableName string, parameters Variable) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"variableName":   autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VariablesClient) CreateOrUpdateResponder(resp *http.Response) (result Variable, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtManagementGroup this operation creates or updates a variable with the given  management group and
// name. Policy variables can only be used by a policy definition at the scope they are created or below.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
// parameters - parameters for the variable.
func (client VariablesClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, parameters Variable) (result Variable, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.CreateOrUpdateAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.VariableProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.VariableProperties.Columns", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policy.VariablesClient", "CreateOrUpdateAtManagementGroup", err.Error())
	}

	req, err := client.CreateOrUpdateAtManagementGroupPreparer(ctx, managementGroupID, variableName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdateAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdateAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "CreateOrUpdateAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtManagementGroupPreparer prepares the CreateOrUpdateAtManagementGroup request.
func (client VariablesClient) CreateOrUpdateAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string, parameters Variable) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtManagementGroupSender sends the CreateOrUpdateAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) CreateOrUpdateAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateAtManagementGroupResponder handles the response to the CreateOrUpdateAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariablesClient) CreateOrUpdateAtManagementGroupResponder(resp *http.Response) (result Variable, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete this operation deletes a variable, given its name and the subscription it was created in. The scope of a
// variable is the part of its ID preceding '/providers/Microsoft.Authorization/variables/{variableName}'.
// Parameters:
// variableName - the name of the variable to operate on.
func (client VariablesClient) Delete(ctx context.Context, variableName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client VariablesClient) DeletePreparer(ctx context.Context, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"variableName":   autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client VariablesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteAtManagementGroup this operation deletes a variable, given its name and the management group it was created
// in. The scope of a variable is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
func (client VariablesClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, variableName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.DeleteAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtManagementGroupPreparer(ctx, managementGroupID, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "DeleteAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtManagementGroupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "DeleteAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "DeleteAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtManagementGroupPreparer prepares the DeleteAtManagementGroup request.
func (client VariablesClient) DeleteAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtManagementGroupSender sends the DeleteAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) DeleteAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAtManagementGroupResponder handles the response to the DeleteAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariablesClient) DeleteAtManagementGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get this operation retrieves a single variable, given its name and the subscription it was created at.
// Parameters:
// variableName - the name of the variable to operate on.
func (client VariablesClient) Get(ctx context.Context, variableName string) (result Variable, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VariablesClient) GetPreparer(ctx context.Context, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"variableName":   autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VariablesClient) GetResponder(resp *http.Response) (result Variable, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtManagementGroup this operation retrieves a single variable, given its name and the  management group it was
// created at.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
func (client VariablesClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, variableName string) (result Variable, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.GetAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtManagementGroupPreparer(ctx, managementGroupID, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "GetAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "GetAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "GetAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtManagementGroupPreparer prepares the GetAtManagementGroup request.
func (client VariablesClient) GetAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtManagementGroupSender sends the GetAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) GetAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAtManagementGroupResponder handles the response to the GetAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariablesClient) GetAtManagementGroupResponder(resp *http.Response) (result Variable, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List this operation retrieves the list of all variables associated with the given subscription.
func (client VariablesClient) List(ctx context.Context) (result VariableListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.List")
		defer func() {
			sc := -1
			if result.vlr.Response.Response != nil {
				sc = result.vlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "List", resp, "Failure sending request")
		return
	}

	result.vlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.vlr.hasNextLink() && result.vlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client VariablesClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VariablesClient) ListResponder(resp *http.Response) (result VariableListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VariablesClient) listNextResults(ctx context.Context, lastResults VariableListResult) (result VariableListResult, err error) {
	req, err := lastResults.variableListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policy.VariablesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policy.VariablesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VariablesClient) ListComplete(ctx context.Context) (result VariableListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListForManagementGroup this operation retrieves the list of all variables applicable to the management group.
// Parameters:
// managementGroupID - the ID of the management group.
func (client VariablesClient) ListForManagementGroup(ctx context.Context, managementGroupID string) (result VariableListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.vlr.Response.Response != nil {
				sc = result.vlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForManagementGroupNextResults
	req, err := client.ListForManagementGroupPreparer(ctx, managementGroupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "ListForManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.vlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "ListForManagementGroup", resp, "Failure sending request")
		return
	}

	result.vlr, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "ListForManagementGroup", resp, "Failure responding to request")
		return
	}
	if result.vlr.hasNextLink() && result.vlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForManagementGroupPreparer prepares the ListForManagementGroup request.
func (client VariablesClient) ListForManagementGroupPreparer(ctx context.Context, managementGroupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForManagementGroupSender sends the ListForManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariablesClient) ListForManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForManagementGroupResponder handles the response to the ListForManagementGroup request. The method always
// closes the http.Response Body.
func (client VariablesClient) ListForManagementGroupResponder(resp *http.Response) (result VariableListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForManagementGroupNextResults retrieves the next set of results, if any.
func (client VariablesClient) listForManagementGroupNextResults(ctx context.Context, lastResults VariableListResult) (result VariableListResult, err error) {
	req, err := lastResults.variableListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policy.VariablesClient", "listForManagementGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policy.VariablesClient", "listForManagementGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariablesClient", "listForManagementGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForManagementGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client VariablesClient) ListForManagementGroupComplete(ctx context.Context, managementGroupID string) (result VariableListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariablesClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForManagementGroup(ctx, managementGroupID)
	return
}
