/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright 2012- The GROMACS Authors
 * and the project initiators Erik Lindahl, Berk Hess and David van der Spoel.
 * Consult the AUTHORS/COPYING files and https://www.gromacs.org for details.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * https://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at https://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out https://www.gromacs.org.
 */
/*
 * Note: this file was generated by the Verlet kernel generator for
 * kernel type 4xm.
 */


#include "gromacs/nbnxm/kernel_common.h"
#include "gromacs/nbnxm/simd_coulomb_functions.h"

namespace gmx
{
enum class KernelCoulombType;

template<KernelLayout         kernelLayout,
         KernelCoulombType    coulombType,
         VdwCutoffCheck       vdwCutoffCheck,
         LJCombinationRule    ljCombinationRule,
         InteractionModifiers vdwModifier,
         LJEwald              ljEwald,
         EnergyOutput         energyOutput>
void nbnxmKernelSimd(const NbnxnPairlistCpu&    pairlist,
                     const nbnxn_atomdata_t&    nbat,
                     const interaction_const_t& ic,
                     const rvec*                shift_vec,
                     nbnxn_atomdata_output_t*   out);

/* Declare all the different kernel functions.
 */
extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::None>(const NbnxnPairlistCpu&    pairlist,
                                                         const nbnxn_atomdata_t&    nbat,
                                                         const interaction_const_t& ic,
                                                         const rvec*                shift_vec,
                                                         nbnxn_atomdata_output_t*   out);


extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::System>(const NbnxnPairlistCpu&    pairlist,
                                                           const nbnxn_atomdata_t&    nbat,
                                                           const interaction_const_t& ic,
                                                           const rvec*                shift_vec,
                                                           nbnxn_atomdata_output_t*   out);


extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::RF,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldTabulated,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::No,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::EwaldAnalytical,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::Geometric,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::LorentzBerthelot,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::ForceSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotSwitch,
                                     LJEwald::None,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);

extern template void nbnxmKernelSimd<KernelLayout::r4xM,
                                     KernelCoulombType::None,
                                     VdwCutoffCheck::Yes,
                                     LJCombinationRule::None,
                                     InteractionModifiers::PotShift,
                                     LJEwald::CombGeometric,
                                     EnergyOutput::GroupPairs>(const NbnxnPairlistCpu&    pairlist,
                                                               const nbnxn_atomdata_t&    nbat,
                                                               const interaction_const_t& ic,
                                                               const rvec*                shift_vec,
                                                               nbnxn_atomdata_output_t*   out);


#ifdef INCLUDE_KERNELFUNCTION_TABLES

/* Declare and define the kernel function pointer lookup tables.
 * The minor index of the array goes over both the LJ combination rules,
 * which is only supported by plain cut-off, and the LJ switch/PME functions.
 */
static NbnxmKernelFunc* const nbnxmKernelNoenerSimd4xm[static_cast<int>(CoulombKernelType::Count)][vdwktNR] = {
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::None, EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::ForceSwitch, LJEwald::None, EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotSwitch, LJEwald::None, EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::CombGeometric, EnergyOutput::None>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::None>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::None>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::None>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::None>,
    },
#    if GMX_USE_EXT_FMM
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::None, VdwCutoffCheck::Yes, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::None, EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::None, VdwCutoffCheck::Yes, LJCombinationRule::None, InteractionModifiers::PotSwitch, LJEwald::None, EnergyOutput::None>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::None>,
    },

#    else
    { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr }
#    endif
};

static NbnxmKernelFunc* const nbnxmKernelEnerSimd4xm[static_cast<int>(CoulombKernelType::Count)][vdwktNR] = {
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::None, EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::ForceSwitch, LJEwald::None, EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotSwitch, LJEwald::None, EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },
#    if GMX_USE_EXT_FMM
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::None, VdwCutoffCheck::Yes, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::None, EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::System>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::System>,
    },

#    else
    { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr }
#    endif
};

static NbnxmKernelFunc* const nbnxmKernelEnergrpSimd4xm[static_cast<int>(CoulombKernelType::Count)][vdwktNR] = {
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotShift, LJEwald::None, EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::ForceSwitch, LJEwald::None, EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM, KernelCoulombType::RF, VdwCutoffCheck::No, LJCombinationRule::None, InteractionModifiers::PotSwitch, LJEwald::None, EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::RF,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldTabulated,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::No,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::EwaldAnalytical,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },
#    if GMX_USE_EXT_FMM
    {
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::Geometric,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::LorentzBerthelot,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::ForceSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotSwitch,
                            LJEwald::None,
                            EnergyOutput::GroupPairs>,
            nbnxmKernelSimd<KernelLayout::r4xM,
                            KernelCoulombType::None,
                            VdwCutoffCheck::Yes,
                            LJCombinationRule::None,
                            InteractionModifiers::PotShift,
                            LJEwald::CombGeometric,
                            EnergyOutput::GroupPairs>,
    },

#    else
    { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr }
#    endif
};

#endif /* INCLUDE_KERNELFUNCTION_TABLES */

} // namespace gmx
