/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.io.monitor.MeterRegistryProvider;
import org.openhab.core.io.monitor.internal.metrics.BundleStateMetric;
import org.openhab.core.io.monitor.internal.metrics.EventCountMetric;
import org.openhab.core.io.monitor.internal.metrics.JVMMetric;
import org.openhab.core.io.monitor.internal.metrics.OpenhabCoreMeterBinder;
import org.openhab.core.io.monitor.internal.metrics.RuleMetric;
import org.openhab.core.io.monitor.internal.metrics.ThingStateMetric;
import org.openhab.core.io.monitor.internal.metrics.ThreadPoolMetric;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.openhab.core.thing.ThingRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MeterRegistryProvider.class})
@NonNullByDefault
public class DefaultMetricsRegistration
implements ReadyService.ReadyTracker,
MeterRegistryProvider {
    private final Logger logger = LoggerFactory.getLogger(DefaultMetricsRegistration.class);
    public static final Tag OH_CORE_METRIC_TAG = Tag.of("openhab_core_metric", "true");
    private final BundleContext bundleContext;
    private final Set<OpenhabCoreMeterBinder> meters = new HashSet<OpenhabCoreMeterBinder>();
    private final CompositeMeterRegistry registry = Metrics.globalRegistry;
    private final ReadyService readyService;
    private final ThingRegistry thingRegistry;
    private final RuleRegistry ruleRegistry;

    @Activate
    public DefaultMetricsRegistration(BundleContext bundleContext, @Reference ReadyService readyService, @Reference ThingRegistry thingRegistry, @Reference RuleRegistry ruleRegistry) {
        this.bundleContext = bundleContext;
        this.readyService = readyService;
        this.thingRegistry = thingRegistry;
        this.ruleRegistry = ruleRegistry;
    }

    @Activate
    protected void activate() {
        this.logger.trace("Activating DefaultMetricsRegistration...");
        this.readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(40)));
    }

    @Deactivate
    public void deactivate() {
        this.unregisterMeters();
        this.readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    private void registerMeters() {
        this.logger.debug("Registering meters...");
        Set<Tag> tags = Set.of(OH_CORE_METRIC_TAG);
        this.meters.add(new JVMMetric(tags));
        this.meters.add(new ThreadPoolMetric(tags));
        this.meters.add(new BundleStateMetric(this.bundleContext, tags));
        this.meters.add(new ThingStateMetric(this.bundleContext, this.thingRegistry, tags));
        this.meters.add(new EventCountMetric(this.bundleContext, tags));
        this.meters.add(new RuleMetric(this.bundleContext, tags, this.ruleRegistry));
        this.meters.forEach(m -> m.bindTo(this.registry));
    }

    private void unregisterMeters() {
        this.meters.forEach(OpenhabCoreMeterBinder::unbind);
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        this.registerMeters();
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.unregisterMeters();
    }

    @Override
    public CompositeMeterRegistry getOHMeterRegistry() {
        return this.registry;
    }
}

