//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include <clc/opencl/workitem/get_group_id.h>

_CLC_DEF _CLC_OVERLOAD uint get_group_id(uint dim) {
  switch (dim) {
  case 0:
    return __builtin_r600_read_tgid_x();
  case 1:
    return __builtin_r600_read_tgid_y();
  case 2:
    return __builtin_r600_read_tgid_z();
  default:
    return 1;
  }
}
