/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gf-screensaver-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_summary,
        const gchar *arg_body,
        const gchar *arg_icon,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.ScreenSaver
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GfScreensaverGen
 * @title: GfScreensaverGen
 * @short_description: Generated C code for the org.gnome.ScreenSaver D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link> D-Bus interface in C.
 */

enum
{
  GF__SCREENSAVER_GEN_ACTIVE_CHANGED,
  GF__SCREENSAVER_GEN_WAKE_UP_SCREEN,
};

static unsigned GF__SCREENSAVER_GEN_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.ScreenSaver ---- */

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_get_active_OUT_ARG_active =
{
  {
    -1,
    (gchar *) "active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_screensaver_gen_method_info_get_active_OUT_ARG_pointers[] =
{
  &_gf_screensaver_gen_method_info_get_active_OUT_ARG_active.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_get_active =
{
  {
    -1,
    (gchar *) "GetActive",
    NULL,
    (GDBusArgInfo **) &_gf_screensaver_gen_method_info_get_active_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_get_active_time_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_screensaver_gen_method_info_get_active_time_OUT_ARG_pointers[] =
{
  &_gf_screensaver_gen_method_info_get_active_time_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_get_active_time =
{
  {
    -1,
    (gchar *) "GetActiveTime",
    NULL,
    (GDBusArgInfo **) &_gf_screensaver_gen_method_info_get_active_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_set_active_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_screensaver_gen_method_info_set_active_IN_ARG_pointers[] =
{
  &_gf_screensaver_gen_method_info_set_active_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_set_active =
{
  {
    -1,
    (gchar *) "SetActive",
    (GDBusArgInfo **) &_gf_screensaver_gen_method_info_set_active_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-active",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_show_message_IN_ARG_summary =
{
  {
    -1,
    (gchar *) "summary",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_show_message_IN_ARG_body =
{
  {
    -1,
    (gchar *) "body",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_method_info_show_message_IN_ARG_icon =
{
  {
    -1,
    (gchar *) "icon",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_screensaver_gen_method_info_show_message_IN_ARG_pointers[] =
{
  &_gf_screensaver_gen_method_info_show_message_IN_ARG_summary.parent_struct,
  &_gf_screensaver_gen_method_info_show_message_IN_ARG_body.parent_struct,
  &_gf_screensaver_gen_method_info_show_message_IN_ARG_icon.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_show_message =
{
  {
    -1,
    (gchar *) "ShowMessage",
    (GDBusArgInfo **) &_gf_screensaver_gen_method_info_show_message_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-message",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gf_screensaver_gen_method_info_simulate_user_activity =
{
  {
    -1,
    (gchar *) "SimulateUserActivity",
    NULL,
    NULL,
    NULL
  },
  "handle-simulate-user-activity",
  FALSE
};

static const GDBusMethodInfo * const _gf_screensaver_gen_method_info_pointers[] =
{
  &_gf_screensaver_gen_method_info_lock.parent_struct,
  &_gf_screensaver_gen_method_info_get_active.parent_struct,
  &_gf_screensaver_gen_method_info_get_active_time.parent_struct,
  &_gf_screensaver_gen_method_info_set_active.parent_struct,
  &_gf_screensaver_gen_method_info_show_message.parent_struct,
  &_gf_screensaver_gen_method_info_simulate_user_activity.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_screensaver_gen_signal_info_active_changed_ARG_new_value =
{
  {
    -1,
    (gchar *) "new_value",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_screensaver_gen_signal_info_active_changed_ARG_pointers[] =
{
  &_gf_screensaver_gen_signal_info_active_changed_ARG_new_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gf_screensaver_gen_signal_info_active_changed =
{
  {
    -1,
    (gchar *) "ActiveChanged",
    (GDBusArgInfo **) &_gf_screensaver_gen_signal_info_active_changed_ARG_pointers,
    NULL
  },
  "active-changed"
};

static const _ExtendedGDBusSignalInfo _gf_screensaver_gen_signal_info_wake_up_screen =
{
  {
    -1,
    (gchar *) "WakeUpScreen",
    NULL,
    NULL
  },
  "wake-up-screen"
};

static const GDBusSignalInfo * const _gf_screensaver_gen_signal_info_pointers[] =
{
  &_gf_screensaver_gen_signal_info_active_changed.parent_struct,
  &_gf_screensaver_gen_signal_info_wake_up_screen.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gf_screensaver_gen_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.ScreenSaver",
    (GDBusMethodInfo **) &_gf_screensaver_gen_method_info_pointers,
    (GDBusSignalInfo **) &_gf_screensaver_gen_signal_info_pointers,
    NULL,
    NULL
  },
  "screensaver-gen",
};


/**
 * gf_screensaver_gen_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gf_screensaver_gen_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct;
}

/**
 * gf_screensaver_gen_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GfScreensaverGen interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gf_screensaver_gen_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gf_screensaver_gen_signal_marshal_active_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_signal_marshal_wake_up_screen (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_get_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_get_active_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_set_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_show_message (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gf_screensaver_gen_method_marshal_simulate_user_activity (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GfScreensaverGen:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 */

/**
 * GfScreensaverGenIface:
 * @parent_iface: The parent interface.
 * @handle_get_active: Handler for the #GfScreensaverGen::handle-get-active signal.
 * @handle_get_active_time: Handler for the #GfScreensaverGen::handle-get-active-time signal.
 * @handle_lock: Handler for the #GfScreensaverGen::handle-lock signal.
 * @handle_set_active: Handler for the #GfScreensaverGen::handle-set-active signal.
 * @handle_show_message: Handler for the #GfScreensaverGen::handle-show-message signal.
 * @handle_simulate_user_activity: Handler for the #GfScreensaverGen::handle-simulate-user-activity signal.
 * @active_changed: Handler for the #GfScreensaverGen::active-changed signal.
 * @wake_up_screen: Handler for the #GfScreensaverGen::wake-up-screen signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 */

typedef GfScreensaverGenIface GfScreensaverGenInterface;
G_DEFINE_INTERFACE (GfScreensaverGen, gf_screensaver_gen, G_TYPE_OBJECT)

static void
gf_screensaver_gen_default_init (GfScreensaverGenIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GfScreensaverGen::handle-lock:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_lock,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfScreensaverGen::handle-get-active:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_get_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_get_active),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_get_active,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfScreensaverGen::handle-get-active-time:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_get_active_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_get_active_time),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_get_active_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfScreensaverGen::handle-set-active:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_set_active() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_set_active),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_set_active,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * GfScreensaverGen::handle-show-message:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_summary: Argument passed by remote caller.
   * @arg_body: Argument passed by remote caller.
   * @arg_icon: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.ShowMessage">ShowMessage()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_show_message() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-message",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_show_message),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_show_message,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GfScreensaverGen::handle-simulate-user-activity:
   * @object: A #GfScreensaverGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_screensaver_gen_complete_simulate_user_activity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-simulate-user-activity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfScreensaverGenIface, handle_simulate_user_activity),
    g_signal_accumulator_true_handled,
    NULL,
      gf_screensaver_gen_method_marshal_simulate_user_activity,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GfScreensaverGen::active-changed:
   * @object: A #GfScreensaverGen.
   * @arg_new_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-ScreenSaver.ActiveChanged">"ActiveChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GF__SCREENSAVER_GEN_SIGNALS[GF__SCREENSAVER_GEN_ACTIVE_CHANGED] =
    g_signal_new ("active-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GfScreensaverGenIface, active_changed),
      NULL,
      NULL,
      gf_screensaver_gen_signal_marshal_active_changed,
      G_TYPE_NONE,
      1, G_TYPE_BOOLEAN);

  /**
   * GfScreensaverGen::wake-up-screen:
   * @object: A #GfScreensaverGen.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-ScreenSaver.WakeUpScreen">"WakeUpScreen"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GF__SCREENSAVER_GEN_SIGNALS[GF__SCREENSAVER_GEN_WAKE_UP_SCREEN] =
    g_signal_new ("wake-up-screen",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GfScreensaverGenIface, wake_up_screen),
      NULL,
      NULL,
      gf_screensaver_gen_signal_marshal_wake_up_screen,
      G_TYPE_NONE,
      0);

}

/**
 * gf_screensaver_gen_emit_active_changed:
 * @object: A #GfScreensaverGen.
 * @arg_new_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-ScreenSaver.ActiveChanged">"ActiveChanged"</link> D-Bus signal.
 */
void
gf_screensaver_gen_emit_active_changed (
    GfScreensaverGen *object,
    gboolean arg_new_value)
{
  g_signal_emit (object, GF__SCREENSAVER_GEN_SIGNALS[GF__SCREENSAVER_GEN_ACTIVE_CHANGED], 0, arg_new_value);
}

/**
 * gf_screensaver_gen_emit_wake_up_screen:
 * @object: A #GfScreensaverGen.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-ScreenSaver.WakeUpScreen">"WakeUpScreen"</link> D-Bus signal.
 */
void
gf_screensaver_gen_emit_wake_up_screen (
    GfScreensaverGen *object)
{
  g_signal_emit (object, GF__SCREENSAVER_GEN_SIGNALS[GF__SCREENSAVER_GEN_WAKE_UP_SCREEN], 0);
}

/**
 * gf_screensaver_gen_call_lock:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_lock_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_lock (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_lock_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_lock_finish (
    GfScreensaverGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_lock_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_lock_sync (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_get_active:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_get_active_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_get_active_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_get_active (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_get_active_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @out_active: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_get_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_get_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_get_active_finish (
    GfScreensaverGen *proxy,
    gboolean *out_active,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_active);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_get_active_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @out_active: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_get_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_get_active_sync (
    GfScreensaverGen *proxy,
    gboolean *out_active,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActive",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_active);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_get_active_time:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_get_active_time_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_get_active_time_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_get_active_time (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_get_active_time_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_get_active_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_get_active_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_get_active_time_finish (
    GfScreensaverGen *proxy,
    guint *out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_get_active_time_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_get_active_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_get_active_time_sync (
    GfScreensaverGen *proxy,
    guint *out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActiveTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_set_active:
 * @proxy: A #GfScreensaverGenProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_set_active_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_set_active_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_set_active (
    GfScreensaverGen *proxy,
    gboolean arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_set_active_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_set_active().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_set_active().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_set_active_finish (
    GfScreensaverGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_set_active_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_set_active() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_set_active_sync (
    GfScreensaverGen *proxy,
    gboolean arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActive",
    g_variant_new ("(b)",
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_show_message:
 * @proxy: A #GfScreensaverGenProxy.
 * @arg_summary: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_icon: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.ShowMessage">ShowMessage()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_show_message_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_show_message_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_show_message (
    GfScreensaverGen *proxy,
    const gchar *arg_summary,
    const gchar *arg_body,
    const gchar *arg_icon,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowMessage",
    g_variant_new ("(sss)",
                   arg_summary,
                   arg_body,
                   arg_icon),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_show_message_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_show_message().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_show_message().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_show_message_finish (
    GfScreensaverGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_show_message_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @arg_summary: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_icon: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.ShowMessage">ShowMessage()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_show_message() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_show_message_sync (
    GfScreensaverGen *proxy,
    const gchar *arg_summary,
    const gchar *arg_body,
    const gchar *arg_icon,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowMessage",
    g_variant_new ("(sss)",
                   arg_summary,
                   arg_body,
                   arg_icon),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_simulate_user_activity:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_call_simulate_user_activity_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_call_simulate_user_activity_sync() for the synchronous, blocking version of this method.
 */
void
gf_screensaver_gen_call_simulate_user_activity (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_screensaver_gen_call_simulate_user_activity_finish:
 * @proxy: A #GfScreensaverGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_call_simulate_user_activity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_screensaver_gen_call_simulate_user_activity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_simulate_user_activity_finish (
    GfScreensaverGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_call_simulate_user_activity_sync:
 * @proxy: A #GfScreensaverGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_call_simulate_user_activity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_screensaver_gen_call_simulate_user_activity_sync (
    GfScreensaverGen *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SimulateUserActivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_screensaver_gen_complete_lock:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_lock (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_screensaver_gen_complete_get_active:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @active: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActive">GetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_get_active (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean active)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   active));
}

/**
 * gf_screensaver_gen_complete_get_active_time:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.GetActiveTime">GetActiveTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_get_active_time (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   value));
}

/**
 * gf_screensaver_gen_complete_set_active:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.SetActive">SetActive()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_set_active (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_screensaver_gen_complete_show_message:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.ShowMessage">ShowMessage()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_show_message (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_screensaver_gen_complete_simulate_user_activity:
 * @object: A #GfScreensaverGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-ScreenSaver.SimulateUserActivity">SimulateUserActivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_screensaver_gen_complete_simulate_user_activity (
    GfScreensaverGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GfScreensaverGenProxy:
 *
 * The #GfScreensaverGenProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfScreensaverGenProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfScreensaverGenProxy.
 */

struct _GfScreensaverGenProxyPrivate
{
  GData *qdata;
};

static void gf_screensaver_gen_proxy_iface_init (GfScreensaverGenIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfScreensaverGenProxy, gf_screensaver_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GfScreensaverGenProxy)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SCREENSAVER_GEN, gf_screensaver_gen_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfScreensaverGenProxy, gf_screensaver_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SCREENSAVER_GEN, gf_screensaver_gen_proxy_iface_init))

#endif
static void
gf_screensaver_gen_proxy_finalize (GObject *object)
{
  GfScreensaverGenProxy *proxy = GF_SCREENSAVER_GEN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gf_screensaver_gen_proxy_parent_class)->finalize (object);
}

static void
gf_screensaver_gen_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gf_screensaver_gen_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gf_screensaver_gen_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GF_TYPE_SCREENSAVER_GEN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SCREENSAVER_GEN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gf_screensaver_gen_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GfScreensaverGenProxy *proxy = GF_SCREENSAVER_GEN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gf_screensaver_gen_proxy_init (GfScreensaverGenProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gf_screensaver_gen_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GF_TYPE_SCREENSAVER_GEN_PROXY, GfScreensaverGenProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gf_screensaver_gen_interface_info ());
}

static void
gf_screensaver_gen_proxy_class_init (GfScreensaverGenProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gf_screensaver_gen_proxy_finalize;
  gobject_class->get_property = gf_screensaver_gen_proxy_get_property;
  gobject_class->set_property = gf_screensaver_gen_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gf_screensaver_gen_proxy_g_signal;
  proxy_class->g_properties_changed = gf_screensaver_gen_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfScreensaverGenProxyPrivate));
#endif
}

static void
gf_screensaver_gen_proxy_iface_init (GfScreensaverGenIface *iface G_GNUC_UNUSED)
{
}

/**
 * gf_screensaver_gen_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_proxy_new_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_screensaver_gen_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SCREENSAVER_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
}

/**
 * gf_screensaver_gen_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_screensaver_gen_proxy_new().
 *
 * Returns: (transfer full) (type GfScreensaverGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfScreensaverGen *
gf_screensaver_gen_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SCREENSAVER_GEN (ret);
  else
    return NULL;
}

/**
 * gf_screensaver_gen_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfScreensaverGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfScreensaverGen *
gf_screensaver_gen_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SCREENSAVER_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
  if (ret != NULL)
    return GF_SCREENSAVER_GEN (ret);
  else
    return NULL;
}


/**
 * gf_screensaver_gen_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gf_screensaver_gen_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_screensaver_gen_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gf_screensaver_gen_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_screensaver_gen_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SCREENSAVER_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
}

/**
 * gf_screensaver_gen_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_screensaver_gen_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_screensaver_gen_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GfScreensaverGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfScreensaverGen *
gf_screensaver_gen_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SCREENSAVER_GEN (ret);
  else
    return NULL;
}

/**
 * gf_screensaver_gen_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gf_screensaver_gen_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_screensaver_gen_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfScreensaverGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfScreensaverGen *
gf_screensaver_gen_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SCREENSAVER_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.ScreenSaver", NULL);
  if (ret != NULL)
    return GF_SCREENSAVER_GEN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GfScreensaverGenSkeleton:
 *
 * The #GfScreensaverGenSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfScreensaverGenSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfScreensaverGenSkeleton.
 */

struct _GfScreensaverGenSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gf_screensaver_gen_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GF_TYPE_SCREENSAVER_GEN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SCREENSAVER_GEN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gf_screensaver_gen_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gf_screensaver_gen_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_screensaver_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gf_screensaver_gen_skeleton_vtable =
{
  _gf_screensaver_gen_skeleton_handle_method_call,
  _gf_screensaver_gen_skeleton_handle_get_property,
  _gf_screensaver_gen_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gf_screensaver_gen_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gf_screensaver_gen_interface_info ();
}

static GDBusInterfaceVTable *
gf_screensaver_gen_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gf_screensaver_gen_skeleton_vtable;
}

static GVariant *
gf_screensaver_gen_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gf_screensaver_gen_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gf_screensaver_gen_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gf_screensaver_gen_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gf_screensaver_gen_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ScreenSaver", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gf_screensaver_gen_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gf_screensaver_gen_on_signal_active_changed (
    GfScreensaverGen *object,
    gboolean arg_new_value)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b)",
                   arg_new_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ScreenSaver", "ActiveChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gf_screensaver_gen_on_signal_wake_up_screen (
    GfScreensaverGen *object)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.ScreenSaver", "WakeUpScreen",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gf_screensaver_gen_skeleton_iface_init (GfScreensaverGenIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfScreensaverGenSkeleton, gf_screensaver_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GfScreensaverGenSkeleton)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SCREENSAVER_GEN, gf_screensaver_gen_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfScreensaverGenSkeleton, gf_screensaver_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SCREENSAVER_GEN, gf_screensaver_gen_skeleton_iface_init))

#endif
static void
gf_screensaver_gen_skeleton_finalize (GObject *object)
{
  GfScreensaverGenSkeleton *skeleton = GF_SCREENSAVER_GEN_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gf_screensaver_gen_skeleton_parent_class)->finalize (object);
}

static void
gf_screensaver_gen_skeleton_init (GfScreensaverGenSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gf_screensaver_gen_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GF_TYPE_SCREENSAVER_GEN_SKELETON, GfScreensaverGenSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gf_screensaver_gen_skeleton_class_init (GfScreensaverGenSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gf_screensaver_gen_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gf_screensaver_gen_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gf_screensaver_gen_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gf_screensaver_gen_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gf_screensaver_gen_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfScreensaverGenSkeletonPrivate));
#endif
}

static void
gf_screensaver_gen_skeleton_iface_init (GfScreensaverGenIface *iface)
{
  iface->active_changed = _gf_screensaver_gen_on_signal_active_changed;
  iface->wake_up_screen = _gf_screensaver_gen_on_signal_wake_up_screen;
}

/**
 * gf_screensaver_gen_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-ScreenSaver.top_of_page">org.gnome.ScreenSaver</link>.
 *
 * Returns: (transfer full) (type GfScreensaverGenSkeleton): The skeleton object.
 */
GfScreensaverGen *
gf_screensaver_gen_skeleton_new (void)
{
  return GF_SCREENSAVER_GEN (g_object_new (GF_TYPE_SCREENSAVER_GEN_SKELETON, NULL));
}

