/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Catch;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Group;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Step;
import java.util.HashSet;
import java.util.Hashtable;
import net.sf.saxon.s9api.XdmNode;

public class Try
extends DeclareStep {
    public Try(XProcRuntime xproc, XdmNode node, String name) {
        super(xproc, node, name);
        this.declaration = this;
        this.stepType = XProcConstants.p_try;
    }

    @Override
    public boolean isPipeline() {
        return false;
    }

    @Override
    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    @Override
    public HashSet<String> getExcludeInlineNamespaces() {
        return ((DeclareStep)this.parent).getExcludeInlineNamespaces();
    }

    @Override
    protected void augmentIO() {
        if (this.subpipeline.size() > 0) {
            Step step = (Step)this.subpipeline.get(0);
            for (Input input : step.inputs()) {
                Input cinput = new Input(this.runtime, step.getNode());
                cinput.setPort(input.getPort());
                cinput.setPrimary(input.getPrimary());
                this.addInput(cinput);
            }
            for (Output output : step.outputs()) {
                Output coutput = new Output(this.runtime, step.getNode());
                coutput.setPort(output.getPort());
                coutput.setPrimary(output.getPrimary());
                this.addOutput(coutput);
            }
        }
        super.augmentIO();
    }

    @Override
    protected void setEnvironment(Environment newEnvironment) {
        Environment env = new Environment(newEnvironment);
        for (Step step : this.subpipeline) {
            env.addStep(step);
        }
        this.patchEnvironment(env);
        super.setEnvironment(env);
        for (Step step : this.subpipeline()) {
            Environment senv = new Environment(env);
            step.setEnvironment(senv);
        }
    }

    @Override
    protected boolean validBindings() {
        boolean valid = true;
        Hashtable<String, Input> inputs = new Hashtable<String, Input>();
        Hashtable<String, Output> outputs = new Hashtable<String, Output>();
        if (this.subpipeline.size() == 2) {
            Group p_group = (Group)this.subpipeline.get(0);
            for (Input input : p_group.inputs()) {
                inputs.put(input.getPort(), input);
            }
            for (Output output : p_group.outputs()) {
                outputs.put(output.getPort(), output);
            }
            Catch p_catch = (Catch)this.subpipeline.get(1);
            if (p_catch.outputs().size() != outputs.size()) {
                valid = false;
                this.runtime.error(null, p_group.getNode(), "The p:group and p:catch in a p:try must declare the same outputs", XProcConstants.staticError(9));
            }
            for (Output output : p_catch.outputs()) {
                if (outputs.containsKey(output.getPort())) {
                    Output s1output = (Output)outputs.get(output.getPort());
                    if (output.getPort().endsWith("|") || output.getPort().startsWith("!") || s1output.getPrimary() == output.getPrimary()) continue;
                    valid = false;
                    this.runtime.error(null, p_group.getNode(), "Output port " + output.getPort() + " has different primary status.", XProcConstants.staticError(9));
                    continue;
                }
                valid = false;
                this.runtime.error(null, p_group.getNode(), "Output port " + output.getPort() + " is extra.", XProcConstants.staticError(9));
            }
            for (String port : outputs.keySet()) {
                if (port.endsWith("|") || p_group.getOutput(port) != null) continue;
                valid = false;
                this.runtime.error(null, p_group.getNode(), "Output port " + port + " missing.", XProcConstants.staticError(9));
            }
        } else {
            this.error("Try must contain a group and a catch", XProcConstants.staticError(27));
        }
        return valid;
    }

    @Override
    protected boolean validOutputBinding() {
        return true;
    }
}

