/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NVDL
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private ReadablePipe source = null;
    private ReadablePipe nvdlSource = null;
    private ReadablePipe schemaSource = null;
    private WritablePipe result = null;

    public NVDL(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("nvdl".equals(string)) {
            this.nvdlSource = readablePipe;
        } else if ("schemas".equals(string)) {
            this.schemaSource = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode xdmNode;
        super.run();
        boolean bl = this.getOption(_assert_valid, false);
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl((OutputStream)System.out);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)errorHandlerImpl);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        propertyMapBuilder.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.runtime.getResolver());
        XdmNode xdmNode2 = this.source.read();
        XdmNode xdmNode3 = this.nvdlSource.read();
        while (this.schemaSource.moreDocuments()) {
            xdmNode = this.schemaSource.read();
            this.runtime.getResolver().cache(xdmNode, xdmNode.getBaseURI());
        }
        xdmNode = new ValidationDriver(propertyMapBuilder.toPropertyMap());
        InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode3);
        InputSource inputSource2 = S9apiUtils.xdmToInputSource(this.runtime, xdmNode2);
        try {
            xdmNode.loadSchema(inputSource);
            if (!xdmNode.validate(inputSource2) && bl) {
                throw XProcException.stepError(53);
            }
        }
        catch (SAXException sAXException) {
            throw new XProcException("SAX Exception", (Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new XProcException("IO Exception", (Throwable)iOException);
        }
        this.result.write(xdmNode2);
    }
}

