# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.1.1.9999

CABAL_PN="Glob"
CABAL_P="${CABAL_PN}-${PV}"

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
CABAL_HACKAGE_REVISION="3"
inherit haskell-cabal

S="${WORKDIR}/${CABAL_P}"
CABAL_FILE="${S}/${CABAL_PN}.cabal"
CABAL_DISTFILE="${CABAL_P}-rev${CABAL_HACKAGE_REVISION}.cabal"

DESCRIPTION="Globbing library"
HOMEPAGE="https://iki.fi/matti.niemenmaa/glob/"
SRC_URI="https://hackage.haskell.org/package/${CABAL_P}/${CABAL_P}.tar.gz
	https://hackage.haskell.org/package/${CABAL_P}/revision/${CABAL_HACKAGE_REVISION}.cabal
		-> ${CABAL_DISTFILE}"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

RDEPEND=">=dev-haskell/dlist-0.4:=[profile?]
	>=dev-haskell/transformers-compat-0.3:=[profile?]
	>=dev-lang/ghc-8.4.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.2.0.1
	test? ( >=dev-haskell/hunit-1.2
		>=dev-haskell/quickcheck-2
		>=dev-haskell/test-framework-0.2
		>=dev-haskell/test-framework-hunit-0.2
		>=dev-haskell/test-framework-quickcheck2-0.3 )
"
BDEPEND="app-text/dos2unix"

src_prepare() {
	# pull revised cabal from upstream
	cp "${DISTDIR}/${CABAL_DISTFILE}" "${CABAL_FILE}" || die

	# Convert to unix line endings
	dos2unix "${CABAL_FILE}" || die

	# Apply patches *after* pulling the revised cabal
	default
}
