﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/docdb/DocDB_EXPORTS.h>
#include <aws/docdb/model/DBCluster.h>
#include <aws/docdb/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace DocDB {
namespace Model {
class RestoreDBClusterToPointInTimeResult {
 public:
  AWS_DOCDB_API RestoreDBClusterToPointInTimeResult() = default;
  AWS_DOCDB_API RestoreDBClusterToPointInTimeResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_DOCDB_API RestoreDBClusterToPointInTimeResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{

  inline const DBCluster& GetDBCluster() const { return m_dBCluster; }
  template <typename DBClusterT = DBCluster>
  void SetDBCluster(DBClusterT&& value) {
    m_dBClusterHasBeenSet = true;
    m_dBCluster = std::forward<DBClusterT>(value);
  }
  template <typename DBClusterT = DBCluster>
  RestoreDBClusterToPointInTimeResult& WithDBCluster(DBClusterT&& value) {
    SetDBCluster(std::forward<DBClusterT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  RestoreDBClusterToPointInTimeResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  DBCluster m_dBCluster;

  ResponseMetadata m_responseMetadata;
  bool m_dBClusterHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace DocDB
}  // namespace Aws
